/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.seller.config.client.constant.enums.AbleStatus;
import com.xforceplus.seller.config.client.constant.enums.TenantConfigSwitch;
import com.xforceplus.seller.config.client.model.MsConfigPlatformAdaptorRequest;
import com.xforceplus.seller.config.client.model.MsPlatformAdaptorResponse;
import com.xforceplus.seller.config.repository.dao.CfgPlatformAdaptorDao;
import com.xforceplus.seller.config.repository.dao.CfgPlatformAdaptorItemDao;
import com.xforceplus.seller.config.repository.model.CfgPlatformAdaptorEntity;
import com.xforceplus.seller.config.repository.model.CfgPlatformAdaptorExample;
import com.xforceplus.seller.config.repository.model.CfgPlatformAdaptorItemExample;
import com.xforceplus.xplatframework.model.Response;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ConfigPlatformAdaptorService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigPlatformAdaptorService.class);
    private final CfgPlatformAdaptorDao cfgPlatformAdaptorDao;
    private final CfgPlatformAdaptorItemDao cfgPlatformAdaptorItemDao;

    public Response<MsPlatformAdaptorResponse> queryPlatformAdaptorConfig(MsConfigPlatformAdaptorRequest request) {
        CfgPlatformAdaptorExample example = new CfgPlatformAdaptorExample();
        CfgPlatformAdaptorExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((CharSequence)request.getTenantCode()) && Objects.isNull(request.getTenantId())) {
            return Response.failed((String)"3.0\u79df\u6237\u7f16\u7801[tenantCode]\u6216\u80054.0\u79df\u6237id[tenantId]\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)request.getAdapterMode())) {
            return Response.failed((String)"\u9002\u914d\u6a21\u5f0f[adapterMode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)request.getTenantCode())) {
            criteria.andTenantCodeEqualTo(request.getTenantCode());
        }
        if (Objects.nonNull(request.getTenantId())) {
            criteria.andTenantIdEqualTo(request.getTenantId());
        }
        criteria.andStatusEqualTo(AbleStatus.ENABLE.getValue());
        criteria.andAdaptorModeEqualTo(request.getAdapterMode());
        List cfgPlatformAdaptors = this.cfgPlatformAdaptorDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)cfgPlatformAdaptors)) {
            return Response.ok((String)"\u6210\u529f", (Object)this.buildResponse(null));
        }
        CfgPlatformAdaptorEntity cfgPlatformAdaptor = (CfgPlatformAdaptorEntity)cfgPlatformAdaptors.get(0);
        if (TenantConfigSwitch.ENABLE.getValue().equals(cfgPlatformAdaptor.getTenantSwitch())) {
            return Response.ok((String)"\u6210\u529f", (Object)this.buildResponse(cfgPlatformAdaptor));
        }
        if (StringUtils.isBlank((CharSequence)request.getCompanyNo()) && StringUtils.isBlank((CharSequence)request.getCompanyTaxNo())) {
            return Response.ok((String)"\u6210\u529f", (Object)this.buildResponse(cfgPlatformAdaptor));
        }
        CfgPlatformAdaptorItemExample itemExample = new CfgPlatformAdaptorItemExample();
        CfgPlatformAdaptorItemExample.Criteria itemCriteria = itemExample.createCriteria();
        itemCriteria.andTenantCodeEqualTo(cfgPlatformAdaptor.getTenantCode());
        itemCriteria.andBusinessBillTypeEqualTo(request.getBusinessBillType());
        if (StringUtils.isNotBlank((CharSequence)request.getCompanyTaxNo())) {
            itemCriteria.andCompanyTaxNoEqualTo(request.getCompanyTaxNo());
        }
        if (StringUtils.isNotBlank((CharSequence)request.getCompanyNo())) {
            itemCriteria.andCompanyNoEqualTo(request.getCompanyNo());
        }
        itemCriteria.andStatusEqualTo(AbleStatus.ENABLE.getValue());
        List cfgPlatformAdaptorItems = this.cfgPlatformAdaptorItemDao.selectByExample(itemExample);
        MsPlatformAdaptorResponse response2 = CollectionUtils.isEmpty((Collection)cfgPlatformAdaptorItems) ? this.buildResponse(null) : this.buildResponse(cfgPlatformAdaptor);
        return Response.ok((String)"\u6210\u529f", (Object)response2);
    }

    public Response<MsPlatformAdaptorResponse> queryAdaptorConfig(MsConfigPlatformAdaptorRequest request) {
        CfgPlatformAdaptorExample example = new CfgPlatformAdaptorExample();
        CfgPlatformAdaptorExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((CharSequence)request.getTenantCode()) && Objects.isNull(request.getTenantId())) {
            return Response.failed((String)"3.0\u79df\u6237\u7f16\u7801[tenantCode]\u6216\u80054.0\u79df\u6237id[tenantId]\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)request.getTenantCode())) {
            criteria.andTenantCodeEqualTo(request.getTenantCode());
        }
        if (Objects.nonNull(request.getTenantId())) {
            criteria.andTenantIdEqualTo(request.getTenantId());
        }
        criteria.andStatusEqualTo(AbleStatus.ENABLE.getValue());
        List cfgPlatformAdaptors = this.cfgPlatformAdaptorDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)cfgPlatformAdaptors)) {
            return Response.ok((String)"\u6210\u529f", (Object)this.buildResponse(null));
        }
        CfgPlatformAdaptorEntity cfgPlatformAdaptor = (CfgPlatformAdaptorEntity)cfgPlatformAdaptors.get(0);
        MsPlatformAdaptorResponse response2 = this.buildResponse(cfgPlatformAdaptor);
        return Response.ok((String)"\u6210\u529f", (Object)response2);
    }

    private MsPlatformAdaptorResponse buildResponse(CfgPlatformAdaptorEntity platformAdaptor) {
        MsPlatformAdaptorResponse response2 = new MsPlatformAdaptorResponse();
        if (Objects.isNull(platformAdaptor)) {
            return response2;
        }
        response2.setAccessUsername(platformAdaptor.getAccessUsername());
        response2.setAccessPassword(platformAdaptor.getAccessPassword());
        response2.setTenantCode(platformAdaptor.getTenantCode());
        response2.setTenantId(platformAdaptor.getTenantId());
        response2.setBizOrderCategory(platformAdaptor.getBizOrderCategory());
        response2.setAdaptorStatus(Boolean.TRUE);
        return response2;
    }

    public ConfigPlatformAdaptorService(CfgPlatformAdaptorDao cfgPlatformAdaptorDao, CfgPlatformAdaptorItemDao cfgPlatformAdaptorItemDao) {
        this.cfgPlatformAdaptorDao = cfgPlatformAdaptorDao;
        this.cfgPlatformAdaptorItemDao = cfgPlatformAdaptorItemDao;
    }
}

