/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.micro.tax.device.contract.model.AddTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.AddTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.OperateInfo;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.QueryTerminalResult;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalResponse;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalStatusRequest;
import com.xforceplus.micro.tax.device.contract.model.UpdateTerminalStatusResponse;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterList;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.seller.config.client.model.MsAddTerminalResponse;
import com.xforceplus.seller.config.client.model.MsAddTerminalResult;
import com.xforceplus.seller.config.client.model.MsCompanyInfo;
import com.xforceplus.seller.config.client.model.MsCompanyModel;
import com.xforceplus.seller.config.client.model.MsConfigAddTerminalRequest;
import com.xforceplus.seller.config.client.model.MsConfigDeviceGetCompanyListResponse;
import com.xforceplus.seller.config.client.model.MsConfigTemialAuthQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigTemialQueryMakeOutRequest;
import com.xforceplus.seller.config.client.model.MsConfigTemialQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigUpdateTerminalRequest;
import com.xforceplus.seller.config.client.model.MsConfigUpdateTerminalStatusRequest;
import com.xforceplus.seller.config.client.model.MsQueryMakeOutTerminalResponse;
import com.xforceplus.seller.config.client.model.MsQueryTerminalResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.MsResponsePageInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryMakeOutResult;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResponseInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResult;
import com.xforceplus.seller.config.common.BaseConfigService;
import com.xforceplus.seller.config.config.ConfigTerminalProperties;
import com.xforceplus.seller.config.core.enums.SupperServiceType;
import com.xforceplus.seller.config.core.enums.TerminalType;
import com.xforceplus.seller.config.facade.TerminalDeviceFacade;
import com.xforceplus.seller.config.infrastructure.helper.DeviceApiProxy;
import com.xforceplus.seller.config.models.RestDeviceInfo;
import com.xforceplus.seller.config.models.RestDeviceQueryInfo;
import com.xforceplus.seller.config.models.RestGetDeviceResult;
import com.xforceplus.seller.config.models.RestQueryDeviceResponse;
import com.xforceplus.seller.config.services.ConfigTerminalService;
import com.xforceplus.seller.config.services.ConfigTerminalServiceImplKt;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConfigTerminalServiceImpl
extends BaseConfigService
implements ConfigTerminalService {
    private final DeviceApiProxy deviceApiProxy;
    private final ConfigTerminalServiceImplKt configTerminalServiceImplKt;
    private final TerminalDeviceFacade terminalDeviceFacade;
    private final ConfigTerminalProperties configTerminalProperties;

    public ConfigTerminalServiceImpl(ConfigTerminalServiceImplKt configTerminalServiceImplKt, TerminalDeviceFacade terminalDeviceFacade, ConfigTerminalProperties configTerminalProperties, DeviceApiProxy deviceApiProxy) {
        this.configTerminalServiceImplKt = configTerminalServiceImplKt;
        this.terminalDeviceFacade = terminalDeviceFacade;
        this.configTerminalProperties = configTerminalProperties;
        this.deviceApiProxy = deviceApiProxy;
    }

    public MsQueryTerminalResponse getTerminalList(MsConfigTemialQueryRequest request, UserInfo userInfo) {
        QueryTerminalRequest destinationRequest = new QueryTerminalRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        destinationRequest.setTerminalInfo(this.generateTerminalQueryInfo(destinationRequest.getTerminalInfo()));
        destinationRequest.setQueryServiceState(Boolean.valueOf(true));
        List userCompanyTaxNos = null;
        if (Objects.isNull(userInfo)) {
            userInfo = new UserInfo();
            userInfo.setUserId(-1L);
            userInfo.setGroupId(-1L);
        }
        if ((userCompanyTaxNos = this.getUserCompanyTaxNos(Long.valueOf(userInfo.getUserId()), Long.valueOf(userInfo.getGroupId()))) != null && userCompanyTaxNos.size() > 0) {
            this.logger.info("\u5f53\u524d\u7528\u6237\u6240\u5728\u516c\u53f8\u7684\u7a0e\u53f7\uff1a" + userCompanyTaxNos.toString());
            if (request.getTerminalInfo() != null && request.getTerminalInfo().getCompanyInfo() != null && StringUtils.isNotBlank((CharSequence)request.getTerminalInfo().getCompanyInfo().getTaxNo()) && !userCompanyTaxNos.contains(request.getTerminalInfo().getCompanyInfo().getTaxNo())) {
                MsQueryTerminalResponse emptyResponse = new MsQueryTerminalResponse();
                MsTerminalQueryResult emptyResult = new MsTerminalQueryResult();
                MsResponsePageInfo pageInfo = new MsResponsePageInfo();
                pageInfo.setPageNo(request.getPageInfo().getPageNo());
                pageInfo.setTotal(Integer.valueOf(0));
                emptyResult.setPageInfo(pageInfo);
                emptyResponse.setResult(emptyResult);
                emptyResponse.setCode(Response.OK);
                emptyResponse.setMessage("\u67e5\u8be2\u6210\u529f");
                return emptyResponse;
            }
        } else {
            return new MsQueryTerminalResponse().code(Response.Fail).message("\u83b7\u53d6\u7528\u6237\u516c\u53f8\u4fe1\u606f\u5931\u8d25");
        }
        QueryTerminalResponse sourceResponse = this.deviceApiProxy.deviceTerminalQueryPost(destinationRequest, destinationRequest.getTerminalInfo().getCompanyInfo().getTenantId(), userCompanyTaxNos);
        this.logger.info("getTerminalList\u65b9\u6cd5\u83b7\u53d6\u5230\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)sourceResponse));
        MsQueryTerminalResponse response2 = new MsQueryTerminalResponse();
        QueryTerminalResult queryTerminalResult = sourceResponse.getResult();
        MsTerminalQueryResult msTerminalQueryResult = (MsTerminalQueryResult)JSON.parseObject((String)JSON.toJSONString((Object)queryTerminalResult), MsTerminalQueryResult.class);
        response2.setResult(msTerminalQueryResult);
        response2.setCode(Integer.valueOf(sourceResponse.getCode() != null ? Integer.valueOf(sourceResponse.getCode()) : -1));
        response2.setMessage(sourceResponse.getMessage());
        return response2;
    }

    public MsResponse updateStatus(MsConfigUpdateTerminalStatusRequest request) {
        UserCenterResponse reply2;
        UpdateTerminalStatusRequest destinationRequest = new UpdateTerminalStatusRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        if (null != request.getStatus() && request.getStatus() == 11 && request.getCompanyId() != null && (!"1".equals((reply2 = this.getCompanyServiceInfo(1L, request.getCompanyId().longValue())).getCode()) || reply2.getResult() == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)((UserCenterList)reply2.getResult()).getContent()))) {
            return new MsResponse().code(BaseResponse.Fail).message("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u670d\u52a1\u5305");
        }
        destinationRequest.setOperateInfo(this.getUpdateOperateInfo());
        UpdateTerminalStatusResponse sourceResponse = this.deviceApiProxy.deviceTerminalUpdateStatusPost(destinationRequest);
        MsResponse response2 = new MsResponse();
        response2.setCode(sourceResponse.getHead().getCode());
        response2.setMessage(sourceResponse.getHead().getMessage());
        return response2;
    }

    public MsResponse update(MsConfigUpdateTerminalRequest request) {
        return this.update(request, this.getCurrentUserInfo().getUserId(), this.getCurrentUserInfo().getGroupId());
    }

    public MsResponse update(MsConfigUpdateTerminalRequest request, long userId, long groupId) {
        UpdateTerminalRequest destinationRequest = new UpdateTerminalRequest();
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        OperateInfo operateInfo = new OperateInfo();
        operateInfo.setUpdatedBy(userId + "");
        destinationRequest.getTerminalInfo().setOperateInfo(operateInfo);
        if (Objects.isNull(destinationRequest.getTerminalInfo().getTerminalType())) {
            destinationRequest.getTerminalInfo().setTerminalType(Integer.valueOf(TerminalType.CLIENT.getValue()));
        }
        UpdateTerminalResponse sourceResponse = this.deviceApiProxy.deviceTerminalUpdatePost(destinationRequest, Long.valueOf(groupId));
        MsResponse response2 = new MsResponse();
        response2.setCode(sourceResponse.getHead().getCode());
        response2.setMessage(sourceResponse.getHead().getMessage());
        return response2;
    }

    public MsAddTerminalResponse addTerminal(MsConfigAddTerminalRequest request) {
        return this.addTerminal(request, this.getCurrentUserInfo().getGroupId(), this.getCurrentUserInfo().getGroupName(), this.getCurrentUserInfo().getUserId());
    }

    public MsAddTerminalResponse addTerminal(MsConfigAddTerminalRequest request, long groupId, String groupName, long userId) {
        UserCenterResponse reply2;
        AddTerminalRequest destinationRequest = new AddTerminalRequest();
        MsConfigDeviceGetCompanyListResponse msConfigDeviceGetCompanyListResponse = this.configDeviceGetCompanyList(groupId);
        if (!msConfigDeviceGetCompanyListResponse.getCode().equals(BaseResponse.OK)) {
            return new MsAddTerminalResponse().code(msConfigDeviceGetCompanyListResponse.getCode()).message(msConfigDeviceGetCompanyListResponse.getMessage());
        }
        List companyModelList = msConfigDeviceGetCompanyListResponse.getResult();
        MsCompanyInfo msCompanyInfo = request.getTerminalInfo().getCompanyInfo();
        if (msCompanyInfo == null) {
            return new MsAddTerminalResponse().code(BaseResponse.Fail).message("\u6ca1\u6709\u586b\u5199\u516c\u53f8\u4fe1\u606f");
        }
        Optional<MsCompanyModel> optionalMsCompanyModel = companyModelList.stream().filter(msCompanyModel -> msCompanyModel.getCompanyId().equals(msCompanyInfo.getCompanyId())).findFirst();
        if (!optionalMsCompanyModel.isPresent()) {
            return new MsAddTerminalResponse().code(BaseResponse.Fail).message("\u4f60\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\u8be5\u4fe1\u606f");
        }
        MsCompanyModel msCompanyModel2 = optionalMsCompanyModel.get();
        long companyId = msCompanyModel2.getCompanyId();
        UserCenterList orgDataList = this.getOrgModel(groupId, companyId);
        if (orgDataList == null || CollectionUtils.isEmpty((Collection)orgDataList.getContent())) {
            return new MsAddTerminalResponse().code(BaseResponse.Fail).message("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7");
        }
        OrgData orgData = (OrgData)orgDataList.getContent().get(0);
        if (null != request.getTerminalInfo().getStatus() && request.getTerminalInfo().getStatus() == 11 && (!"1".equals((reply2 = this.getCompanyServiceInfo(1L, companyId)).getCode()) || reply2.getResult() == null || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)((UserCenterList)reply2.getResult()).getContent()))) {
            return new MsAddTerminalResponse().code(BaseResponse.Fail).message("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u670d\u52a1\u5305");
        }
        msCompanyInfo.setCompanyId(Long.valueOf(companyId));
        msCompanyInfo.setCompanyName(msCompanyModel2.getCompanyName());
        msCompanyInfo.setTaxNo(msCompanyModel2.getTaxNum());
        msCompanyInfo.setTenantId(Long.valueOf(groupId));
        msCompanyInfo.setTenantName(groupName);
        msCompanyInfo.setOrganizationId(orgData.getOrgId());
        msCompanyInfo.setOrganizationName(orgData.getOrgName());
        BeanMapper.copy((Object)request, (Object)destinationRequest);
        OperateInfo operateInfo = new OperateInfo();
        operateInfo.setCreatedBy(userId + "");
        destinationRequest.getTerminalInfo().setOperateInfo(operateInfo);
        List supportServices = destinationRequest.getTerminalInfo().getSupportService();
        if (null != supportServices && supportServices.size() == 1 && StringUtils.equals((CharSequence)((CharSequence)supportServices.get(0)), (CharSequence)"print")) {
            destinationRequest.getTerminalInfo().setTerminalType(Integer.valueOf(1));
        }
        AddTerminalResponse sourceResponse = this.deviceApiProxy.deviceTerminalAddPost(destinationRequest, Long.valueOf(groupId));
        destinationRequest.getTerminalInfo().setFromSystem("4.0");
        MsAddTerminalResponse response2 = new MsAddTerminalResponse();
        MsAddTerminalResult destinationResponse = new MsAddTerminalResult();
        BeanMapper.copy((Object)sourceResponse, (Object)destinationResponse);
        response2.setResult(destinationResponse);
        response2.setCode(sourceResponse.getHead().getCode());
        response2.setMessage(sourceResponse.getHead().getMessage());
        return response2;
    }

    public MsQueryMakeOutTerminalResponse getMakeOutTerminalList(MsConfigTemialQueryMakeOutRequest request) {
        MsQueryMakeOutTerminalResponse response2 = new MsQueryMakeOutTerminalResponse();
        List terminalList = this.configTerminalServiceImplKt.getAuthTerminals(request.getTerminalInfo());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)terminalList)) {
            response2.setCode(Integer.valueOf(0));
            response2.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230\u7ec8\u7aef\u5217\u8868");
            return response2;
        }
        if (!this.configTerminalProperties.getTerminalDeviceInfoSwitch().booleanValue()) {
            this.setDeviceInfo(terminalList);
        }
        ArrayList makeOutTerminals = Lists.newArrayList();
        ArrayList printTerminals = Lists.newArrayList();
        for (MsTerminalQueryResponseInfo terminal : terminalList) {
            List supperServiceList = terminal.getSupportService();
            if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)supperServiceList)) continue;
            if (supperServiceList.contains(SupperServiceType.PRINT.getCode())) {
                printTerminals.add(terminal);
            }
            if (!supperServiceList.contains(SupperServiceType.MAKE.getCode())) continue;
            makeOutTerminals.add(terminal);
        }
        this.sortTerminal((List)makeOutTerminals, 1);
        this.sortTerminal((List)printTerminals, 2);
        MsTerminalQueryMakeOutResult result = new MsTerminalQueryMakeOutResult();
        result.setMakeOutTerminals((List)makeOutTerminals);
        result.setPrintTerminals((List)printTerminals);
        response2.setCode(Integer.valueOf(1));
        response2.message("\u83b7\u53d6\u6210\u529f");
        response2.setResult(result);
        return response2;
    }

    @Deprecated
    public MsQueryTerminalResponse getAuthTerminalList(MsConfigTemialAuthQueryRequest request) {
        List terminalList;
        MsCompanyInfo msCompanyInfo;
        MsQueryTerminalResponse response2 = new MsQueryTerminalResponse();
        MsTerminalQueryInfo msTerminalQueryInfo = new MsTerminalQueryInfo();
        msTerminalQueryInfo.setInvoiceType(request.getInvoiceType());
        msTerminalQueryInfo.setSupportService(request.getSupportService());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)request.getTaxNos())) {
            msCompanyInfo = new MsCompanyInfo();
            msCompanyInfo.setTaxNo(request.getSellerTaxNo());
            msTerminalQueryInfo.setCompanyInfo(msCompanyInfo);
            terminalList = this.configTerminalServiceImplKt.getAuthTerminals(msTerminalQueryInfo);
        } else {
            msCompanyInfo = new MsCompanyInfo();
            msCompanyInfo.setTaxNos(request.getTaxNos());
            msTerminalQueryInfo.setCompanyInfo(msCompanyInfo);
            terminalList = this.configTerminalServiceImplKt.getAuthTerminalsWithTaxNos(msTerminalQueryInfo);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)terminalList)) {
            response2.setCode(Integer.valueOf(0));
            response2.setMessage("\u6ca1\u6709\u83b7\u53d6\u5230\u7ec8\u7aef\u5217\u8868");
            return response2;
        }
        if (!this.configTerminalProperties.getTerminalDeviceInfoSwitch().booleanValue()) {
            this.setDeviceInfo(terminalList);
        }
        this.sortTerminal(terminalList, 3);
        MsTerminalQueryResult result = new MsTerminalQueryResult();
        result.setTerminals(terminalList);
        response2.setCode(Integer.valueOf(1));
        response2.message("\u83b7\u53d6\u6210\u529f");
        response2.setResult(result);
        return response2;
    }

    public void setDeviceInfo(List<MsTerminalQueryResponseInfo> terminalList) {
        List deviceUnList = terminalList.stream().map(MsTerminalQueryResponseInfo::getDeviceUn).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(deviceUnList)) {
            RestDeviceQueryInfo queryInfo = new RestDeviceQueryInfo();
            queryInfo.setDeviceUns(deviceUnList);
            RestQueryDeviceResponse deviceListByQueryInfo = this.terminalDeviceFacade.getDeviceListByQueryInfo(deviceUnList, true);
            if ("1".equals(deviceListByQueryInfo.getCode())) {
                Map deviceMap = Optional.ofNullable(deviceListByQueryInfo.getResult()).map(RestGetDeviceResult::getDevices).map(r -> r.stream().collect(Collectors.toMap(RestDeviceInfo::getDeviceUn, t -> t))).orElse(Maps.newHashMap());
                terminalList.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getDeviceUn())).forEach(r -> Optional.ofNullable(deviceMap.get(r.getDeviceUn())).ifPresent(deviceInfo -> {
                    Optional.of(deviceInfo).map(RestDeviceInfo::getTaxDeviceInfo).ifPresent(taxDeviceInfo -> {
                        r.setTaxDeviceType(taxDeviceInfo.getTaxDeviceType());
                        r.setTaxDeviceMachineNo(taxDeviceInfo.getTaxDeviceMachineNo());
                        r.setDeployType(taxDeviceInfo.getDeployType());
                    });
                    r.setDeviceNo(deviceInfo.getDeviceNo());
                }));
            }
        }
    }

    public void sortTerminal(List<MsTerminalQueryResponseInfo> terminalList, int sortType) {
        if (1 == sortType) {
            terminalList.sort((o1, o2) -> o2.getDirectOnlineFlag().compareTo(o1.getDirectOnlineFlag()));
        } else if (2 == sortType) {
            terminalList.sort((o1, o2) -> o2.getPrinterOnlineFlag().compareTo(o1.getPrinterOnlineFlag()));
        } else {
            terminalList.sort((o1, o2) -> {
                int directOnlineFlagResult = o1.getDirectOnlineFlag().compareTo(o2.getDirectOnlineFlag());
                int printerOnlineFlagResult = o1.getPrinterOnlineFlag().compareTo(o2.getPrinterOnlineFlag());
                int onlineResult = 10 * directOnlineFlagResult + printerOnlineFlagResult;
                return Integer.compare(0, onlineResult);
            });
        }
    }
}

