/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.InvoiceTitleDTO;
import com.xforceplus.seller.config.client.model.MsConfigTitleSummaryDTO;
import com.xforceplus.seller.config.client.model.MsConfigTitleSummaryResponse;
import com.xforceplus.seller.config.client.model.MsQueryInvoiceTitleRequest;
import com.xforceplus.seller.config.client.model.MsQueryInvoiceTitleResponse;
import com.xforceplus.seller.config.common.BaseConfigService;
import com.xforceplus.seller.config.converters.ConfigTitleEntityTranslater;
import com.xforceplus.seller.config.core.constants.ConstantValue;
import com.xforceplus.seller.config.repository.dao.CfgConfigInvoiceTitleDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInvoiceTitleExtDao;
import com.xforceplus.seller.config.repository.model.CfgConfigInvoiceTitleEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigInvoiceTitleExample;
import com.xforceplus.seller.config.repository.model.modelext.CfgConfigTitleCountExample;
import com.xforceplus.seller.config.repository.model.modelext.CfgConfigTitleDeleteExample;
import com.xforceplus.seller.config.services.ConfigTitleService;
import com.xforceplus.seller.config.util.BeanMapper;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConfigTitleServiceImpl
extends BaseConfigService
implements ConfigTitleService {
    private CfgConfigInvoiceTitleDao invoiceTitleDao;
    private CfgConfigInvoiceTitleExtDao invoiceTitleExtDao;
    private IDGenerator idGenerator;
    private static final Logger logger = LoggerFactory.getLogger(ConfigTitleServiceImpl.class);

    @Autowired
    public ConfigTitleServiceImpl(CfgConfigInvoiceTitleDao invoiceTitleDao, CfgConfigInvoiceTitleExtDao invoiceTitleExtDao, IDGenerator idGenerator) {
        this.invoiceTitleDao = invoiceTitleDao;
        this.invoiceTitleExtDao = invoiceTitleExtDao;
        this.idGenerator = idGenerator;
    }

    public MsQueryInvoiceTitleResponse queryInvoiceTitle(MsQueryInvoiceTitleRequest titleRequest, UserInfo userInfo) {
        logger.info("queryInvoiceTitle Request:{}, {}", (Object)titleRequest.toString(), (Object)userInfo.toString());
        MsQueryInvoiceTitleResponse response2 = new MsQueryInvoiceTitleResponse();
        response2.setCode(Response.OK);
        response2.setMessage("\u67e5\u8be2\u6210\u529f");
        ArrayList<InvoiceTitleDTO> result = new ArrayList<InvoiceTitleDTO>();
        List taxNumList = this.getUserCompanyTaxNos(Long.valueOf(userInfo.getUserId()), Long.valueOf(userInfo.getGroupId()));
        logger.info("queryInvoiceTitle taxNumList:{}", (Object)taxNumList);
        if (CollectionUtils.isEmpty((Collection)taxNumList)) {
            response2.setResult(result);
            return response2;
        }
        CfgConfigInvoiceTitleEntity queryEntity = new CfgConfigInvoiceTitleEntity();
        BeanMapper.copy((Object)titleRequest, (Object)queryEntity);
        CfgConfigInvoiceTitleExample titleExample = this.createExample(queryEntity, taxNumList);
        titleExample.setLimit(Integer.valueOf(titleRequest.getPageSize() == null || titleRequest.getPageSize() == 0 ? 10 : titleRequest.getPageSize()));
        titleExample.setOffset(this.getOffset(titleRequest.getPageNo(), titleRequest.getPageSize()));
        List titleEntityList = this.invoiceTitleDao.selectByExample(titleExample);
        for (CfgConfigInvoiceTitleEntity tmp : titleEntityList) {
            InvoiceTitleDTO invoiceTitleDTO = ConfigTitleEntityTranslater.convertFromConfigEntity((CfgConfigInvoiceTitleEntity)tmp);
            result.add(invoiceTitleDTO);
        }
        response2.setResult(result);
        return response2;
    }

    public MsQueryInvoiceTitleResponse queryInvoiceTitle(MsQueryInvoiceTitleRequest titleRequest) {
        MsQueryInvoiceTitleResponse response2 = new MsQueryInvoiceTitleResponse();
        response2.setCode(Response.OK);
        response2.setMessage("\u67e5\u8be2\u6210\u529f");
        ArrayList<InvoiceTitleDTO> result = new ArrayList<InvoiceTitleDTO>();
        CfgConfigInvoiceTitleEntity queryEntity = new CfgConfigInvoiceTitleEntity();
        BeanMapper.copy((Object)titleRequest, (Object)queryEntity);
        CfgConfigInvoiceTitleExample titleExample = this.createExample(queryEntity, null);
        titleExample.setLimit(titleRequest.getPageSize());
        List titleEntityList = this.invoiceTitleDao.selectByExample(titleExample);
        for (CfgConfigInvoiceTitleEntity tmp : titleEntityList) {
            InvoiceTitleDTO invoiceTitleDTO = ConfigTitleEntityTranslater.convertFromConfigEntity((CfgConfigInvoiceTitleEntity)tmp);
            result.add(invoiceTitleDTO);
        }
        response2.setResult(result);
        return response2;
    }

    private Integer getOffset(Integer pageNo, Integer pageSize) {
        if (pageNo == null || pageNo == 0) {
            pageNo = 1;
        }
        if (pageSize == null || pageSize == 0) {
            pageSize = 10;
        }
        return (pageNo - 1) * pageSize;
    }

    private CfgConfigInvoiceTitleExample createExample(CfgConfigInvoiceTitleEntity queryEntity, List<String> taxNumList) {
        CfgConfigInvoiceTitleExample example = new CfgConfigInvoiceTitleExample();
        CfgConfigInvoiceTitleExample.Criteria criteria = example.createCriteria();
        if (queryEntity.getSellerGroupId() != null && queryEntity.getSellerGroupId() > 0L) {
            criteria.andSellerGroupIdEqualTo(queryEntity.getSellerGroupId());
        }
        if (queryEntity.getStatus() != null) {
            criteria.andStatusEqualTo(queryEntity.getStatus());
        }
        if (!StringUtils.isEmpty((CharSequence)queryEntity.getSellerName())) {
            criteria.andSellerNameEqualTo(queryEntity.getSellerName());
        }
        if (!StringUtils.isEmpty((CharSequence)queryEntity.getSellerTaxNo())) {
            criteria.andSellerTaxNoEqualTo(queryEntity.getSellerTaxNo());
        }
        if (!StringUtils.isEmpty((CharSequence)queryEntity.getSellerTel())) {
            criteria.andSellerTelEqualTo(queryEntity.getSellerTel());
        }
        if (!StringUtils.isEmpty((CharSequence)queryEntity.getSellerBankName())) {
            criteria.andSellerBankNameEqualTo(queryEntity.getSellerBankName());
        }
        if (!StringUtils.isEmpty((CharSequence)queryEntity.getSellerBankAccount())) {
            criteria.andSellerBankAccountEqualTo(queryEntity.getSellerBankAccount());
        }
        if (!StringUtils.isEmpty((CharSequence)queryEntity.getSellerAddress())) {
            criteria.andSellerAddressEqualTo(queryEntity.getSellerAddress());
        }
        if (!CollectionUtils.isEmpty(taxNumList)) {
            criteria.andSellerTaxNoIn(taxNumList);
        }
        return example;
    }

    public MsConfigTitleSummaryResponse queryTitleSummary(MsQueryInvoiceTitleRequest titleRequest, UserInfo userInfo) {
        logger.info("queryTitleSummary Request:{}, {}", (Object)titleRequest.toString(), (Object)userInfo.toString());
        MsConfigTitleSummaryResponse msConfigTitleSummaryResponse = new MsConfigTitleSummaryResponse();
        StatusEnum[] configStatusEnums = StatusEnum.values();
        ArrayList<MsConfigTitleSummaryDTO> result = new ArrayList<MsConfigTitleSummaryDTO>();
        List taxNumList = this.getUserCompanyTaxNos(Long.valueOf(userInfo.getUserId()), Long.valueOf(userInfo.getGroupId()));
        for (StatusEnum configStatusEnum : configStatusEnums) {
            titleRequest.setStatus(configStatusEnum.getStatus());
            int count = 0;
            if (!CollectionUtils.isEmpty((Collection)taxNumList)) {
                count = this.queryConfigCount(titleRequest, taxNumList);
            }
            MsConfigTitleSummaryDTO msConfigSummaryDTO = new MsConfigTitleSummaryDTO();
            msConfigSummaryDTO.setCode(configStatusEnum.getStatus());
            msConfigSummaryDTO.setCount(Integer.valueOf(count));
            msConfigSummaryDTO.setName(configStatusEnum.getStatusDesc());
            result.add(msConfigSummaryDTO);
        }
        msConfigTitleSummaryResponse.setCode(Response.OK);
        msConfigTitleSummaryResponse.setMessage("\u67e5\u8be2\u6210\u529f");
        msConfigTitleSummaryResponse.setResult(result);
        return msConfigTitleSummaryResponse;
    }

    private Integer queryConfigCount(MsQueryInvoiceTitleRequest titleRequest, List<String> taxNumList) {
        CfgConfigInvoiceTitleEntity queryEntity = new CfgConfigInvoiceTitleEntity();
        BeanMapper.copy((Object)titleRequest, (Object)queryEntity);
        CfgConfigInvoiceTitleExample example = this.createExample(queryEntity, taxNumList);
        Long count = this.invoiceTitleDao.countByExample(example);
        return count.intValue();
    }

    public Response saveInvoiceTitle(InvoiceTitleDTO invoiceTitleDTO, UserInfo userInfo) {
        Response checkResponse = this.checkInvoiceTitleRequestInfo(invoiceTitleDTO);
        if (checkResponse != null) {
            return checkResponse;
        }
        if (invoiceTitleDTO.getTitleId() != null && invoiceTitleDTO.getTitleId() > 0L) {
            return this.updateInvoiceTitle(invoiceTitleDTO, userInfo);
        }
        CfgConfigInvoiceTitleEntity titleEntity = new CfgConfigInvoiceTitleEntity();
        ConfigTitleEntityTranslater.dtoConvertEntity((InvoiceTitleDTO)invoiceTitleDTO, (CfgConfigInvoiceTitleEntity)titleEntity);
        titleEntity.setTitleId(Long.valueOf(this.idGenerator.nextId()));
        titleEntity.setStatus(ConstantValue.STATUS_ACTIVE);
        long count = this.checkRepeatTitle(titleEntity);
        if (count > 0L) {
            return Response.failed((String)"\u8be5\u62ac\u5934\u5e93\u4fe1\u606f\u5df2\u88ab\u521b\u5efa\uff01");
        }
        titleEntity.setCreateTime(new Date());
        titleEntity.setCreateUser(Long.valueOf(userInfo.getUserId()));
        titleEntity.setUpdateTime(new Date());
        titleEntity.setUpdateUser(Long.valueOf(userInfo.getUserId()));
        this.invoiceTitleDao.insert(titleEntity);
        return Response.ok((String)"\u65b0\u5efa\u6210\u529f");
    }

    private Response checkInvoiceTitleRequestInfo(InvoiceTitleDTO invoiceTitleDTO) {
        if (StringUtils.isEmpty((CharSequence)invoiceTitleDTO.getSellerTaxNo())) {
            return Response.failed((String)"\u9500\u65b9\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)invoiceTitleDTO.getSellerName())) {
            return Response.failed((String)"\u9500\u65b9\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)invoiceTitleDTO.getSellerAddress()) && StringUtils.isEmpty((CharSequence)invoiceTitleDTO.getSellerTel()) && StringUtils.isEmpty((CharSequence)invoiceTitleDTO.getSellerBankAccount()) && StringUtils.isEmpty((CharSequence)invoiceTitleDTO.getSellerBankName())) {
            return Response.failed((String)"\u9500\u65b9\u5730\u5740\u3001\u9500\u65b9\u7535\u8bdd\u3001\u94f6\u884c\u540d\u79f0\u3001\u94f6\u884c\u8d26\u53f7\u56db\u4e2a\u5b57\u6bb5\u9700\u5fc5\u586b\u4e00\u4e2a");
        }
        if (CommonTools.getStringCharLength((String)invoiceTitleDTO.getSellerBankAccount()) > 30) {
            return Response.failed((String)"\u9500\u65b9\u94f6\u884c\u8d26\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26");
        }
        if (CommonTools.getStringCharLength((String)invoiceTitleDTO.getSellerTel()) > 30) {
            return Response.failed((String)"\u9500\u65b9\u7535\u8bdd\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26");
        }
        if (CommonTools.getStringCharLength((String)invoiceTitleDTO.getSellerAddress()) + CommonTools.getStringCharLength((String)invoiceTitleDTO.getSellerTel()) > 100) {
            return Response.failed((String)"\u9500\u65b9\u5730\u5740+\u9500\u65b9\u7535\u8bdd\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26");
        }
        if (CommonTools.getStringCharLength((String)invoiceTitleDTO.getSellerBankAccount()) + CommonTools.getStringCharLength((String)invoiceTitleDTO.getSellerBankName()) > 100) {
            return Response.failed((String)"\u94f6\u884c\u540d\u79f0+\u94f6\u884c\u8d26\u53f7\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26");
        }
        return null;
    }

    private Response updateInvoiceTitle(InvoiceTitleDTO invoiceTitleDTO, UserInfo userInfo) {
        CfgConfigInvoiceTitleEntity titleEntity = this.invoiceTitleDao.selectByPrimaryKey(invoiceTitleDTO.getTitleId());
        if (titleEntity == null) {
            return Response.failed((String)"\u62ac\u5934\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        ConfigTitleEntityTranslater.dtoConvertEntity((InvoiceTitleDTO)invoiceTitleDTO, (CfgConfigInvoiceTitleEntity)titleEntity);
        long count = this.checkRepeatTitle(titleEntity);
        if (count > 0L) {
            return Response.failed((String)"\u8be5\u62ac\u5934\u5e93\u4fe1\u606f\u5df2\u88ab\u521b\u5efa\uff01");
        }
        titleEntity.setUpdateTime(new Date());
        titleEntity.setUpdateUser(Long.valueOf(userInfo.getUserId()));
        this.invoiceTitleDao.updateByPrimaryKey(titleEntity);
        return Response.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    public long checkRepeatTitle(CfgConfigInvoiceTitleEntity titleEntity) {
        CfgConfigTitleCountExample example = new CfgConfigTitleCountExample();
        example.setSellerAddress(titleEntity.getSellerAddress() == null ? "" : titleEntity.getSellerAddress());
        example.setSellerBankAccount(titleEntity.getSellerBankAccount() == null ? "" : titleEntity.getSellerBankAccount());
        example.setSellerBankName(titleEntity.getSellerBankName() == null ? "" : titleEntity.getSellerBankName());
        example.setSellerTel(titleEntity.getSellerTel() == null ? "" : titleEntity.getSellerTel());
        example.setSellerTaxNo(titleEntity.getSellerTaxNo());
        example.setStatus(titleEntity.getStatus());
        return this.invoiceTitleExtDao.countByExample(example);
    }

    public Response deleteInvoiceTitle(List<Long> titleId, Long groupId, UserInfo userInfo) {
        logger.info("deleteInvoiceTitle Request:{}", titleId);
        CfgConfigTitleDeleteExample titleDeleteExample = new CfgConfigTitleDeleteExample();
        titleDeleteExample.setTitleIdList(titleId);
        titleDeleteExample.setPreStatus(StatusEnum.NORMAL.getStatus());
        titleDeleteExample.setAfterStatus(StatusEnum.DELETE.getStatus());
        titleDeleteExample.setUpdateUser(Long.valueOf(userInfo.getUserId()));
        titleDeleteExample.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        this.invoiceTitleExtDao.deleteCfgConfigTitleByIds(titleDeleteExample);
        return Response.ok((String)"\u5220\u9664\u6210\u529f");
    }
}

