/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.MsCfgBusinessObjMetaInfo;
import com.xforceplus.seller.config.client.model.MsExportCustomFieldResponse;
import com.xforceplus.seller.config.client.model.MsImportField;
import com.xforceplus.seller.config.client.model.MsImportFieldResponse;
import com.xforceplus.seller.config.exception.CustomDefinitionException;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjDao;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjMetadataDao;
import com.xforceplus.seller.config.repository.dao.CfgUserCustomDefinitionDao;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjEntity;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjExample;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataExample;
import com.xforceplus.seller.config.repository.model.CfgUserCustomDefinitionEntity;
import com.xforceplus.seller.config.repository.model.CfgUserCustomDefinitionExample;
import com.xforceplus.seller.config.services.CustomDefinitionService;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.json.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomDefinitionServiceImpl
implements CustomDefinitionService {
    private static final Logger logger = LoggerFactory.getLogger(CustomDefinitionServiceImpl.class);
    private CfgUserCustomDefinitionDao cfgUserCustomDefinitionDao;
    private CfgBusinessObjDao cfgBusinessObjDao;
    private CfgBusinessObjMetadataDao cfgBusinessObjMetadataDao;

    @Autowired
    public CustomDefinitionServiceImpl(CfgUserCustomDefinitionDao cfgUserCustomDefinitionDao, CfgBusinessObjDao cfgBusinessObjDao, CfgBusinessObjMetadataDao cfgBusinessObjMetadataDao) {
        this.cfgUserCustomDefinitionDao = cfgUserCustomDefinitionDao;
        this.cfgBusinessObjDao = cfgBusinessObjDao;
        this.cfgBusinessObjMetadataDao = cfgBusinessObjMetadataDao;
    }

    public Response getUserCustomDefinition(long tenantId, String pageCode, String functionPoint) {
        return Response.ok(null, (Object)this.getCfgUserCustomDefinitionEntity(tenantId, pageCode, functionPoint));
    }

    public CfgUserCustomDefinitionEntity getCfgUserCustomDefinitionEntity(long tenantId, String pageCode, String functionPoint) {
        CfgUserCustomDefinitionExample example = new CfgUserCustomDefinitionExample();
        CfgUserCustomDefinitionExample.Criteria criteria = example.createCriteria().andTenantIdEqualTo(Long.valueOf(tenantId)).andPageCodeEqualTo(pageCode);
        if (StringUtils.isNotBlank((CharSequence)functionPoint)) {
            criteria.andFunctionPointEqualTo(functionPoint);
        }
        return this.cfgUserCustomDefinitionDao.selectOneByExample(example);
    }

    public MsImportFieldResponse getCustomImportFields(Long userId, Long tenantId, String pageCode, String functionPoint) {
        MsImportFieldResponse response2 = new MsImportFieldResponse();
        if (CommonTools.isEmpty((String)pageCode)) {
            throw new CustomDefinitionException("\u8bf7\u8f93\u5165\u9875\u9762\u4ee3\u7801");
        }
        if (CommonTools.isEmpty((String)functionPoint)) {
            throw new CustomDefinitionException("\u8bf7\u8f93\u5165\u529f\u80fd\u70b9");
        }
        CfgUserCustomDefinitionEntity entity = this.queryEntity(userId, tenantId, pageCode, functionPoint);
        if (entity == null) {
            entity = this.queryEntity(Long.valueOf(0L), Long.valueOf(0L), pageCode, functionPoint);
        }
        if (entity == null) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u914d\u7f6e");
            return response2;
        }
        Map specialAdditionsMap = Maps.newHashMap();
        if ("billImport".equals(pageCode)) {
            CfgUserCustomDefinitionEntity specialAdditionsEntity = this.queryEntity(Long.valueOf(0L), Long.valueOf(0L), pageCode, "specialAdditions");
            specialAdditionsMap = JsonUtils.writeJsonToMap((String)specialAdditionsEntity.getCustomContent());
        }
        String context = entity.getCustomContent();
        Map map = JsonUtils.writeJsonToMap((String)context);
        ArrayList list = Lists.newArrayList();
        map.putAll(specialAdditionsMap);
        map.forEach((key, value) -> {
            MsImportField field = new MsImportField();
            field.setFieldCode(key);
            field.setFieldName(value);
            list.add(field);
        });
        response2.setResult((List)list);
        response2.setCode(Response.OK);
        return response2;
    }

    private CfgUserCustomDefinitionEntity queryEntity(Long userId, Long tenantId, String pageCode, String functionPoint) {
        CfgUserCustomDefinitionExample example = new CfgUserCustomDefinitionExample();
        CfgUserCustomDefinitionExample.Criteria criteria = example.createCriteria().andUserIdEqualTo(userId).andTenantIdEqualTo(tenantId).andPageCodeEqualTo(pageCode);
        if (!CommonTools.isEmpty((String)functionPoint)) {
            criteria.andFunctionPointEqualTo(functionPoint);
        }
        return this.cfgUserCustomDefinitionDao.selectOneByExample(example);
    }

    public MsExportCustomFieldResponse queryCustomCfgBusinessObjMetadata4Export(Long groupId, String objCode, String objType) {
        logger.info("queryCustomCfgBusinessObjMetadata4Export--->groupId:{},objCode:{},objType:{}", new Object[]{groupId, objCode, objType});
        MsExportCustomFieldResponse msExportCustomFieldResponse = new MsExportCustomFieldResponse();
        msExportCustomFieldResponse.setCode(Response.OK);
        ArrayList msCfgBusinessObjMetaInfoList = Lists.newArrayList();
        if (Objects.isNull(groupId) || Objects.isNull(objCode) || Objects.isNull(objType)) {
            msExportCustomFieldResponse.setResult((List)msCfgBusinessObjMetaInfoList);
            return msExportCustomFieldResponse;
        }
        CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
        CfgBusinessObjExample.Criteria criteria = cfgBusinessObjExample.createCriteria();
        criteria.andGroupIdEqualTo(groupId).andObjCodeEqualTo(objCode).andObjTypeEqualTo(objType).andObjStatusEqualTo(StatusEnum.NORMAL.getStatus());
        CfgBusinessObjEntity cfgBusinessObjEntity = this.cfgBusinessObjDao.selectOneByExample(cfgBusinessObjExample);
        List cfgBusinessObjMetadataEntityList = Lists.newArrayList();
        if (Objects.nonNull(cfgBusinessObjEntity)) {
            CfgBusinessObjMetadataExample cfgBusinessObjMetadataExample = new CfgBusinessObjMetadataExample();
            CfgBusinessObjMetadataExample.Criteria metadataCriteria = cfgBusinessObjMetadataExample.createCriteria();
            metadataCriteria.andBusinessObjIdEqualTo(cfgBusinessObjEntity.getBusinessObjId());
            metadataCriteria.andFixedEqualTo(Integer.valueOf(0));
            cfgBusinessObjMetadataEntityList = this.cfgBusinessObjMetadataDao.selectByExample(cfgBusinessObjMetadataExample);
        }
        if (!CollectionUtils.isEmpty((Collection)cfgBusinessObjMetadataEntityList)) {
            cfgBusinessObjMetadataEntityList.forEach(item -> {
                MsCfgBusinessObjMetaInfo msCfgBusinessObjMetaInfo = new MsCfgBusinessObjMetaInfo();
                BeanUtils.copyProperties((Object)item, (Object)msCfgBusinessObjMetaInfo);
                msCfgBusinessObjMetaInfoList.add(msCfgBusinessObjMetaInfo);
            });
        }
        logger.info("queryCustomCfgBusinessObjMetadata4Expor---msCfgBusinessObjMetaInfoList:{}", (Object)JsonUtils.writeObjectToJson((Object)msCfgBusinessObjMetaInfoList));
        msExportCustomFieldResponse.setResult((List)msCfgBusinessObjMetaInfoList);
        return msExportCustomFieldResponse;
    }
}

