/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.google.common.collect.Lists;
import com.xforceplus.seller.config.client.model.CustomSorter;
import com.xforceplus.seller.config.repository.dao.CfgCustomFiltersDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjMetadataDao;
import com.xforceplus.seller.config.repository.model.CfgCustomFiltersEntity;
import com.xforceplus.seller.config.repository.model.CfgCustomFiltersExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjMetadataEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjMetadataExample;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CustomFieldManager {
    @Autowired
    private CfgCustomFiltersDao filtersDao;
    @Autowired
    private CfgTemplateObjDao cfgTemplateObjDao;
    @Autowired
    private CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao;

    public CfgCustomFiltersEntity queryCustomerFilters(Long userId, Long groupId, String functionPoint, List<String> subPointList) {
        CfgCustomFiltersExample example = new CfgCustomFiltersExample();
        CfgCustomFiltersExample.Criteria criteria = example.createCriteria();
        criteria = criteria.andUserIdEqualTo(userId).andGroupIdEqualTo(groupId).andFunctionPointEqualTo(functionPoint);
        String subPoint = this.subPoint(subPointList);
        if (StringUtils.isNotBlank((CharSequence)subPoint)) {
            criteria.andSubPointEqualTo(subPoint);
        }
        return this.filtersDao.selectOneByExample(example);
    }

    public CfgCustomFiltersEntity queryCustomerSorters(Long userId, Long groupId, String functionPoint, List<String> subPointList) {
        return this.queryCustomerFilters(userId, groupId, functionPoint, subPointList);
    }

    public String subPoint(List<String> subPointList) {
        if (!CollectionUtils.isEmpty(subPointList)) {
            StringBuffer buf = new StringBuffer();
            subPointList.forEach(subPoint -> {
                if (StringUtils.isNotBlank((CharSequence)subPoint)) {
                    buf.append(subPoint.trim());
                }
            });
            return buf.toString();
        }
        return "";
    }

    public List<CustomSorter> queryTemplateCustomSortersBy(String templateObjCode) {
        ArrayList templateSorterList = Lists.newArrayList();
        CfgTemplateObjExample cfgTemplateObjExample = new CfgTemplateObjExample();
        CfgTemplateObjExample.Criteria cfgTemplateObjCriteria = cfgTemplateObjExample.createCriteria();
        cfgTemplateObjCriteria.andTemplateObjCodeEqualTo(templateObjCode);
        CfgTemplateObjEntity cfgTemplateObjEntity = this.cfgTemplateObjDao.selectOneByExample(cfgTemplateObjExample);
        if (Objects.isNull(cfgTemplateObjEntity)) {
            return templateSorterList;
        }
        CfgTemplateObjMetadataExample cfgTemplateObjMetadataExample = new CfgTemplateObjMetadataExample();
        CfgTemplateObjMetadataExample.Criteria cfgTemplateObjMetadataCriteria = cfgTemplateObjMetadataExample.createCriteria();
        cfgTemplateObjMetadataCriteria.andBusinessObjIdEqualTo(cfgTemplateObjEntity.getTemplateObjId());
        cfgTemplateObjMetadataExample.setOrderByClause("business_obj_metadata_id ASC");
        List cfgTemplateObjMetadataEntityList = this.cfgTemplateObjMetadataDao.selectByExample(cfgTemplateObjMetadataExample);
        for (CfgTemplateObjMetadataEntity metadataBean : cfgTemplateObjMetadataEntityList) {
            CustomSorter customSorter = new CustomSorter();
            customSorter.setFieldName(metadataBean.getFieldName());
            customSorter.setFieldDescription(metadataBean.getFieldDisplayName());
            templateSorterList.add(customSorter);
        }
        return templateSorterList;
    }
}

