/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.model.CustomFilterList;
import com.xforceplus.seller.config.client.model.QueryCustomFiltersRequest;
import com.xforceplus.seller.config.client.model.QueryCustomFiltersResponse;
import com.xforceplus.seller.config.client.model.SaveCustomFiltersRequest;
import com.xforceplus.seller.config.repository.dao.CfgCustomFiltersDao;
import com.xforceplus.seller.config.repository.model.CfgCustomFiltersEntity;
import com.xforceplus.seller.config.services.CustomFieldManager;
import com.xforceplus.seller.config.services.CustomFiltersService;
import com.xforceplus.seller.config.util.DslJsonUtil;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomFiltersServiceImpl
implements CustomFiltersService {
    private static final Logger logger = LoggerFactory.getLogger(CustomFiltersServiceImpl.class);
    @Autowired
    private CfgCustomFiltersDao filtersDao;
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    private CustomFieldManager customFieldManager;

    public QueryCustomFiltersResponse queryCustomerFilters(QueryCustomFiltersRequest queryRequest) {
        UserInfo userInfo = queryRequest.getUserInfo();
        QueryCustomFiltersResponse response2 = new QueryCustomFiltersResponse();
        response2.setCode(Response.Fail);
        if (userInfo == null) {
            response2.setMessage("\u8bf7\u767b\u5f55\u540e\u67e5\u8be2");
        } else if (queryRequest == null) {
            response2.setMessage("\u8bf7\u8f93\u5165\u67e5\u8be2\u53c2\u6570");
        } else if (StringUtils.isBlank((CharSequence)queryRequest.getFunctionPoint())) {
            response2.setMessage("\u8bf7\u8f93\u5165\u67e5\u8be2\u53c2\u6570");
        } else {
            CfgCustomFiltersEntity entity = this.customFieldManager.queryCustomerFilters(Long.valueOf(userInfo.getUserId()), Long.valueOf(userInfo.getGroupId()), queryRequest.getFunctionPoint(), queryRequest.getSubPointList());
            if (entity == null) {
                entity = this.customFieldManager.queryCustomerFilters(Long.valueOf(0L), Long.valueOf(0L), queryRequest.getFunctionPoint(), queryRequest.getSubPointList());
            }
            try {
                if (entity == null || StringUtils.isBlank((CharSequence)entity.getFilterGroups())) {
                    response2.setMessage("\u672a\u67e5\u8be2\u5230\u81ea\u5b9a\u4e49\u914d\u7f6e");
                } else {
                    response2.setCode(Response.OK);
                    List filterLists = DslJsonUtil.deserializeList(CustomFilterList.class, (String)entity.getFilterGroups());
                    response2.setResult(filterLists);
                }
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u81ea\u5b9a\u4e49\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                response2.setMessage("\u67e5\u8be2\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u5668\u9519\u8bef");
            }
        }
        return response2;
    }

    public Response saveCustomerFilters(SaveCustomFiltersRequest saveCustomFiltersRequest) {
        UserInfo userInfo = saveCustomFiltersRequest.getUserInfo();
        if (userInfo == null) {
            return Response.failed((String)"\u8bf7\u5148\u767b\u5f55");
        }
        String functionPoint = saveCustomFiltersRequest.getFunctionPoint();
        List subPointList = saveCustomFiltersRequest.getSubPointList();
        if (StringUtils.isBlank((CharSequence)functionPoint)) {
            return Response.failed((String)"\u8bf7\u8f93\u5165\u529f\u80fd\u70b9");
        }
        CfgCustomFiltersEntity entity = this.customFieldManager.queryCustomerFilters(Long.valueOf(userInfo.getUserId()), Long.valueOf(userInfo.getGroupId()), functionPoint, subPointList);
        ArrayList groupList = Lists.newArrayList();
        saveCustomFiltersRequest.getGroups().forEach(item -> {
            CustomFilterList cf = new CustomFilterList();
            cf.setFilterList(item);
            groupList.add(cf);
        });
        String groups = DslJsonUtil.serialize((Object)groupList);
        if (entity != null) {
            entity.setFilterGroups(groups);
            this.filtersDao.updateByPrimaryKeySelective(entity);
        } else {
            entity = new CfgCustomFiltersEntity();
            entity.setFilterId(Long.valueOf(this.idGenerator.nextId()));
            entity.setFunctionPoint(functionPoint);
            entity.setSubPoint(this.customFieldManager.subPoint(subPointList));
            entity.setUserId(Long.valueOf(userInfo.getUserId()));
            entity.setGroupId(Long.valueOf(userInfo.getGroupId()));
            entity.setFilterGroups(groups);
            this.filtersDao.insertSelective(entity);
        }
        return Response.ok((String)"\u4fdd\u5b58\u6210\u529f");
    }
}

