/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.model.CustomSorter;
import com.xforceplus.seller.config.infrastructure.cache.LocalCacheManager;
import com.xforceplus.seller.config.models.QueryCustomSortersRequest;
import com.xforceplus.seller.config.models.QueryCustomSortersResponse;
import com.xforceplus.seller.config.models.SaveCustomSortersRequest;
import com.xforceplus.seller.config.repository.dao.CfgCustomFiltersDao;
import com.xforceplus.seller.config.repository.model.CfgCustomFiltersEntity;
import com.xforceplus.seller.config.services.CustomFieldManager;
import com.xforceplus.seller.config.services.CustomSorterService;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomSorterServiceImpl
implements CustomSorterService {
    private static final Logger logger = LoggerFactory.getLogger(CustomSorterServiceImpl.class);
    private CfgCustomFiltersDao filtersDao;
    private IDGenerator idGenerator;
    private CustomFieldManager customFieldManager;
    private LocalCacheManager localCacheManager;

    @Autowired
    public CustomSorterServiceImpl(CfgCustomFiltersDao filtersDao, IDGenerator idGenerator, CustomFieldManager customFieldManager, LocalCacheManager localCacheManager) {
        this.filtersDao = filtersDao;
        this.idGenerator = idGenerator;
        this.customFieldManager = customFieldManager;
        this.localCacheManager = localCacheManager;
    }

    public QueryCustomSortersResponse queryCustomSorters(UserInfo userInfo, QueryCustomSortersRequest queryRequest) {
        QueryCustomSortersResponse response2 = new QueryCustomSortersResponse();
        if (Objects.isNull(userInfo) || Objects.isNull(queryRequest)) {
            response2.setCode(Response.Fail);
            response2.setMessage("\u8bf7\u8f93\u5165\u67e5\u8be2\u53c2\u6570");
            return response2;
        }
        response2.setCode(Response.OK);
        List customSorterList = null;
        CfgCustomFiltersEntity entity = this.customFieldManager.queryCustomerSorters(Long.valueOf(userInfo.getUserId()), Long.valueOf(userInfo.getGroupId()), queryRequest.getFunctionPoint(), queryRequest.getSubPointList());
        if (Objects.nonNull(entity) && StringUtils.isNotBlank((CharSequence)entity.getFilterGroups())) {
            customSorterList = JsonUtils.writeJsonToListObject((String)entity.getFilterGroups(), CustomSorter.class);
        }
        response2.setCustomSorterList(customSorterList);
        List templateSorterList = this.localCacheManager.queryTemplateMetadataBy(queryRequest.getFunctionPoint());
        this.replaceFieldDescription(userInfo.getGroupId(), queryRequest.getObjName(), templateSorterList);
        response2.setTemplateSorterList(templateSorterList);
        return response2;
    }

    public Response saveCustomSorters(UserInfo userInfo, SaveCustomSortersRequest saveRequest) {
        String functionPoint = saveRequest.getFunctionPoint();
        List subPointList = saveRequest.getSubPointList();
        CfgCustomFiltersEntity entity = this.customFieldManager.queryCustomerSorters(Long.valueOf(userInfo.getUserId()), Long.valueOf(userInfo.getGroupId()), functionPoint, subPointList);
        String sorterJson = JsonUtils.writeObjectToFastJson((Object)saveRequest.getGroups());
        if (entity != null) {
            entity.setFilterGroups(sorterJson);
            this.filtersDao.updateByPrimaryKeySelective(entity);
        } else {
            entity = new CfgCustomFiltersEntity();
            entity.setFilterId(Long.valueOf(this.idGenerator.nextId()));
            entity.setUserId(Long.valueOf(userInfo.getUserId()));
            entity.setGroupId(Long.valueOf(userInfo.getGroupId()));
            entity.setFunctionPoint(functionPoint);
            entity.setSubPoint("");
            entity.setFilterGroups(sorterJson);
            this.filtersDao.insertSelective(entity);
        }
        return Response.ok((String)"\u4fdd\u5b58\u6210\u529f");
    }

    private void replaceFieldDescription(long groupId, String objName, List<CustomSorter> templateSorterList) {
        if (StringUtils.isEmpty((CharSequence)objName)) {
            return;
        }
        this.localCacheManager.queryFiledNameAndDisplayName(Long.valueOf(groupId), objName).ifPresent(filedNameAndDisplayNameMap -> templateSorterList.stream().forEach(customSorter -> {
            String filedDisplayName;
            if (customSorter.getFieldName().startsWith("ext") && StringUtils.isNotEmpty((CharSequence)(filedDisplayName = (String)filedNameAndDisplayNameMap.get(customSorter.getFieldName())))) {
                customSorter.setFieldDescription(filedDisplayName);
            }
        }));
    }
}

