/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.seller.config.converters.CommonConverter;
import com.xforceplus.seller.config.infrastructure.client.UserCenterService;
import com.xforceplus.seller.config.models.CompanyData;
import com.xforceplus.seller.config.models.DeviceData;
import com.xforceplus.seller.config.services.ConfigDeviceService;
import com.xforceplus.seller.config.services.GeneralService;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import io.vavr.control.Either;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010H\u0016J\"\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00120\u00102\u0006\u0010\u0016\u001a\u00020\u0011H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/xforceplus/seller/config/services/GeneralServiceImpl;", "Lcom/xforceplus/seller/config/services/GeneralService;", "userCenterService", "Lcom/xforceplus/seller/config/infrastructure/client/UserCenterService;", "userInfoHolder", "Lcom/xforceplus/xplatframework/spring/domain/UserInfoHolder;", "Lcom/xforceplus/xplatframework/apimodel/UserInfo;", "commonConverter", "Lcom/xforceplus/seller/config/converters/CommonConverter;", "configDeviceService", "Lcom/xforceplus/seller/config/services/ConfigDeviceService;", "contextHolder", "Lcom/xforceplus/xplatsecurity/domain/ContextHolder;", "Lcom/xforceplus/xplatsecurity/domain/UserContext;", "(Lcom/xforceplus/seller/config/infrastructure/client/UserCenterService;Lcom/xforceplus/xplatframework/spring/domain/UserInfoHolder;Lcom/xforceplus/seller/config/converters/CommonConverter;Lcom/xforceplus/seller/config/services/ConfigDeviceService;Lcom/xforceplus/xplatsecurity/domain/ContextHolder;)V", "queryPermittedCompanies", "Lio/vavr/control/Either;", "", "", "Lcom/xforceplus/seller/config/models/CompanyData;", "queryPermittedDevices", "Lcom/xforceplus/seller/config/models/DeviceData;", "taxNo", "seller-config-service"})
public class GeneralServiceImpl
implements GeneralService {
    @NotNull
    private final UserCenterService userCenterService;
    @NotNull
    private final UserInfoHolder<UserInfo> userInfoHolder;
    @NotNull
    private final CommonConverter commonConverter;
    @NotNull
    private final ConfigDeviceService configDeviceService;
    @NotNull
    private final ContextHolder<UserContext> contextHolder;

    public GeneralServiceImpl(@NotNull UserCenterService userCenterService, @NotNull UserInfoHolder<UserInfo> userInfoHolder, @NotNull CommonConverter commonConverter, @NotNull ConfigDeviceService configDeviceService, @NotNull ContextHolder<UserContext> contextHolder) {
        Intrinsics.checkNotNullParameter((Object)userCenterService, (String)"userCenterService");
        Intrinsics.checkNotNullParameter(userInfoHolder, (String)"userInfoHolder");
        Intrinsics.checkNotNullParameter((Object)commonConverter, (String)"commonConverter");
        Intrinsics.checkNotNullParameter((Object)configDeviceService, (String)"configDeviceService");
        Intrinsics.checkNotNullParameter(contextHolder, (String)"contextHolder");
        this.userCenterService = userCenterService;
        this.userInfoHolder = userInfoHolder;
        this.commonConverter = commonConverter;
        this.configDeviceService = configDeviceService;
        this.contextHolder = contextHolder;
    }

    @NotNull
    public Either<String, List<CompanyData>> queryPermittedCompanies() {
        Either either;
        String modules;
        long userId = ((UserInfo)this.userInfoHolder.get()).getUserId();
        long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        UserContext userContext = (UserContext)this.contextHolder.get();
        String token = userContext != null ? userContext.getAccessToken() : null;
        Either result = this.userCenterService.getCompanyList(tenantId, userId, token, modules = ((UserInfo)this.userInfoHolder.get()).getModules());
        if (result.isLeft()) {
            Either either2 = Either.left((Object)result.getLeft());
            either = either2;
            Intrinsics.checkNotNullExpressionValue((Object)either2, (String)"{\n            Either.left(result.left)\n        }");
        } else {
            Either either3 = Either.right((Object)this.commonConverter.convert((List)result.get()));
            either = either3;
            Intrinsics.checkNotNullExpressionValue((Object)either3, (String)"{\n            Either.rig\u2026(result.get()))\n        }");
        }
        return either;
    }

    @NotNull
    public Either<String, List<DeviceData>> queryPermittedDevices(@NotNull String taxNo) {
        Either either;
        Intrinsics.checkNotNullParameter((Object)taxNo, (String)"taxNo");
        Either response2 = this.configDeviceService.queryDeviceByTaxNo(taxNo);
        if (response2.isLeft()) {
            Either either2 = Either.left((Object)"\u83b7\u53d6\u8bbe\u5907\u5931\u8d25");
            either = either2;
            Intrinsics.checkNotNullExpressionValue((Object)either2, (String)"{\n            Either.left(\"\u83b7\u53d6\u8bbe\u5907\u5931\u8d25\")\n        }");
        } else {
            Object object = response2.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.get()");
            Either either3 = Either.right((Object)this.commonConverter.convertDevice(CollectionsKt.filterNotNull((Iterable)((Iterable)object))));
            Intrinsics.checkNotNullExpressionValue((Object)either3, (String)"{\n            Either.rig\u2026lterNotNull()))\n        }");
            either = either3;
        }
        return either;
    }
}

