/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.infrastructure.usercenter.controllers.UserCenterController;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import com.xforceplus.seller.config.client.constant.SellerOrgTypeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.MsAddTerminalResponse;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsCompanyInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddTerminalRequest;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigBizBillAttribute;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigTemialQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigUpdateTerminalRequest;
import com.xforceplus.seller.config.client.model.MsDeviceInfo;
import com.xforceplus.seller.config.client.model.MsGroupTypeBean;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.MsPageInfo;
import com.xforceplus.seller.config.client.model.MsQueryDeviceResponse;
import com.xforceplus.seller.config.client.model.MsQueryTerminalResponse;
import com.xforceplus.seller.config.client.model.MsResponse;
import com.xforceplus.seller.config.client.model.MsTerminalInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryInfo;
import com.xforceplus.seller.config.client.model.MsTerminalQueryResponseInfo;
import com.xforceplus.seller.config.client.model.MsUpdateTerminalInfo;
import com.xforceplus.seller.config.common.BaseConfigService;
import com.xforceplus.seller.config.converters.BusinessConfigConverter;
import com.xforceplus.seller.config.core.constants.ConstantValue;
import com.xforceplus.seller.config.core.enums.FieldGroupIndex;
import com.xforceplus.seller.config.core.enums.SplitRuleItemSort;
import com.xforceplus.seller.config.core.enums.TaxWareRemarkDeviceType;
import com.xforceplus.seller.config.core.enums.TerminalType;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import com.xforceplus.seller.config.infrastructure.cache.LocalCacheManager;
import com.xforceplus.seller.config.models.CheckTerminalResponseVo;
import com.xforceplus.seller.config.models.ConfigBase;
import com.xforceplus.seller.config.models.PersonConfig;
import com.xforceplus.seller.config.models.SellerBusinessConfig;
import com.xforceplus.seller.config.models.SplitConfig;
import com.xforceplus.seller.config.models.TerminalConfig;
import com.xforceplus.seller.config.models.TitleConfig;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigBillAttributeDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigInterfaceDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigInvoiceTitleDao;
import com.xforceplus.seller.config.repository.dao.CfgConfigItemDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInterfaceExtDao;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjExample;
import com.xforceplus.seller.config.repository.model.CfgConfigBillAttributeEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigBillAttributeExample;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgConfigInterfaceEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigInvoiceTitleEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemExample;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.ConfigDeviceService;
import com.xforceplus.seller.config.services.ConfigTerminalService;
import com.xforceplus.seller.config.services.ConfigTitleServiceImpl;
import com.xforceplus.seller.config.services.ImportFailConfigServiceImpl;
import com.xforceplus.seller.config.services.adapter.AdapterConfig;
import com.xforceplus.seller.config.services.adapter.AdapterService;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.seller.config.util.DingDingUtils;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.vavr.Lazy;
import io.vavr.Tuple;
import io.vavr.Tuple5;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Service;

@Service
public class ImportConfigServiceImpl
extends BaseConfigService {
    private static final Logger logger = LoggerFactory.getLogger(ImportConfigServiceImpl.class);
    private List<String> billFields = Arrays.asList("invoiceRemarkFiledList");
    private List<String> billItemFields = Arrays.asList("splitFiledList");
    private String mainExtFields = "mainExtFields";
    private String mainExtFieldValues = "mainExtFieldValues";
    private String mainPropertyKeys = "mainPropertyKeys";
    private String mainPropertyValues = "mainPropertyValues";
    private List<String> joinCharList = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8");
    @Value(value="${config.import.split.replace:\u8d26@\u5e10}")
    private String splitReplace;
    @Autowired
    ConfigBizConfigService configBizConfigService;
    @Autowired
    CfgConfigInterfaceDao cfgConfigInterfaceDao;
    @Autowired
    CfgConfigInterfaceExtDao cfgConfigInterfaceExtDao;
    @Autowired
    CfgConfigDao cfgConfigDao;
    @Autowired
    CfgConfigItemDao cfgConfigItemDao;
    @Autowired
    DingDingUtils dingDingUtils;
    @Autowired
    private CfgConfigBillAttributeDao cfgConfigBillAttributeDao;
    @Autowired
    LocalCacheManager localCacheManager;
    @Autowired
    CfgBusinessObjDao cfgBusinessObjDao;
    @Autowired
    ConfigDeviceService configDeviceService;
    @Autowired
    private ConfigTerminalService configTerminalService;
    @Autowired
    private ImportFailConfigServiceImpl importFailConfigServiceImpl;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private ConfigTitleServiceImpl configTitleService;
    @Autowired
    private CfgConfigInvoiceTitleDao invoiceTitleDao;
    @Autowired
    private IDGenerator idGenerator;
    private final UserCenterController userCenterController;
    @Autowired
    private BusinessConfigConverter businessConfigConverter;
    @Autowired
    AdapterConfig adapterConfig;
    @Autowired
    AdapterService adapterService;
    private final Lazy<List<Tuple5<String, List<String>, String, Function<SplitConfig, String>, BiConsumer<SplitConfig, String>>>> checkSplitConfigItemList = Lazy.of(() -> Lists.newArrayList((Object[])new Tuple5[]{Tuple.of((Object)"\u53d1\u7968\u7c7b\u578b", Arrays.asList("c", "s", "ce", "ju", "v", "se"), (Object)"c,s,ce,ju,v\u4e2d\u7684\u4e00\u9879", ConfigBase::getInvoiceType, ConfigBase::setInvoiceType), Tuple.of((Object)"\u91d1\u989d\u62c6\u5206\u89c4\u5219", Arrays.asList("1", "2", "3"), (Object)"1\u6309\u5355\u4ef7\uff0c 2\u6309\u6570\u91cf(\u53d6\u6574)\u62c6 3\u6309\u6570\u91cf(\u4e0d\u53d6\u6574)\u62c6", SplitConfig::getAmountSplitRule, SplitConfig::setAmountSplitRule), Tuple.of((Object)"\u660e\u7ec6\u987a\u5e8f", (Object)this.appendEnumCheckList(SplitRuleItemSort.class, ValueEnum::getValue), (Object)this.appendEnumErrorMsg(SplitRuleItemSort.class, r -> (String)r.getValue() + r.getDescription()), SplitConfig::getItemSort, SplitConfig::setItemSort), Tuple.of((Object)"\u9500\u8d27\u6e05\u5355\u9009\u9879", Arrays.asList("1", "2"), (Object)"1\u662f\uff0c2\u5426", SplitConfig::getSaleListOption, SplitConfig::setSaleListOption), Tuple.of((Object)"\u7a0e\u63a7\u8bbe\u5907", (Object)this.appendEnumCheckList(TaxWareRemarkDeviceType.class, r -> String.valueOf(r.ordinal())), (Object)this.appendEnumErrorMsg(TaxWareRemarkDeviceType.class, r -> r.ordinal() + r.getDescription()), SplitConfig::getTaxDeviceType, SplitConfig::setTaxDeviceType), Tuple.of((Object)"\u5355\u4ef7\u6570\u91cf\u9009\u9879", Arrays.asList("0", "1"), (Object)"0\u6253\u5370\u5355\u4ef7\u6570\u91cf\uff0c1\u4e0d\u6253\u5370\u5355\u4ef7\u6570\u91cf", SplitConfig::getUnitPriceAmountOps, SplitConfig::setUnitPriceAmountOps), Tuple.of((Object)"\u9500\u65b9\u7ec4\u7ec7\u7c7b\u578b", Arrays.asList("1", "2", "3"), (Object)"1\u516c\u53f8\uff0c2\u96c6\u56e2\uff0c3\u7ec4\u7ec7", ConfigBase::getSellerOrgType, ConfigBase::setSellerOrgType)}));

    public ImportConfigServiceImpl(UserCenterController userCenterController) {
        this.userCenterController = userCenterController;
    }

    public void importSplitConfig(List<SplitConfig> list, Map<String, Object> headers) {
        logger.info("=========\u5f00\u59cb\u5bfc\u5165\u62c6\u7968\u89c4\u5219============");
        MsCommonUserInfo userInfo = this.getUserInfo(headers);
        Long importBatchNo = Long.parseLong(String.valueOf(headers.get("importBatchNo")));
        for (int i = 0; i < list.size(); ++i) {
            MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = new MsConfigAddRequestWithUserInfo();
            SplitConfig splitConfig = list.get(i);
            splitConfig.setBatchNo(importBatchNo);
            splitConfig.setConfigType((String)headers.get("configType"));
            ArrayList configList = Lists.newArrayList();
            MsConfigBean msConfigBean = new MsConfigBean();
            StringBuilder msg = new StringBuilder();
            this.checkSplitConfigData(splitConfig, msg);
            String sellerOrgType = StringUtils.isBlank((CharSequence)splitConfig.getSellerOrgType()) ? SellerOrgTypeEnum.COMPANY.getValue() : splitConfig.getSellerOrgType();
            msConfigBean.businessBillType(splitConfig.getBusinessBillType());
            msConfigBean.setSellerName(splitConfig.getSellerName());
            msConfigBean.setSellerTaxNo(splitConfig.getSellerTaxNo());
            msConfigBean.setPurchaserName(splitConfig.getPurchaserName());
            msConfigBean.setPurchaserTaxNo(splitConfig.getPurchaserTaxNo());
            msConfigBean.setConfigType(Integer.valueOf(Integer.parseInt(String.valueOf(headers.get("configType")))));
            msConfigBean.setSalesbillType(splitConfig.getSalesbillType());
            msConfigBean.setConfigName(splitConfig.getConfigName());
            msConfigBean.setInvoiceType(splitConfig.getInvoiceType());
            msConfigBean.setTaxInvoiceSource(splitConfig.getTaxInvoiceSource());
            String result = this.commonValid(msConfigBean, userInfo);
            msg.append(result);
            if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(splitConfig.getBusinessBillType())) {
                msg.append(this.validateSellerOrgValue((ConfigBase)splitConfig, sellerOrgType, msConfigBean));
            }
            BeanMap beanMap = BeanMap.create((Object)splitConfig);
            Field[] declaredFields = splitConfig.getClass().getDeclaredFields();
            ArrayList attributeEntityList = Lists.newArrayList();
            try {
                List itemBeanList = this.getBeanItemList(beanMap, declaredFields, splitConfig.getSalesbillType(), userInfo.getGroupId(), (List)attributeEntityList);
                msConfigBean.setItemList(itemBeanList);
            }
            catch (IllegalArgumentException e) {
                logger.error("\u5bfc\u5165\u62c6\u7968\u89c4\u5219\u5931\u8d25,\u539f\u56e0:{}", (Object)e.getMessage());
                msg.append(e.getMessage());
            }
            catch (Exception e) {
                logger.error("\u5bfc\u5165\u62c6\u7968\u89c4\u5219\u5931\u8d25,\u539f\u56e0:{}", (Object)e.getMessage());
                msg.append(e.getMessage());
            }
            msConfigBean.setAttributes((List)attributeEntityList);
            configList.add(msConfigBean);
            msConfigAddRequestWithUserInfo.setUserInfo(userInfo);
            msConfigAddRequestWithUserInfo.setItemDTOList((List)configList);
            logger.info("\u8bf7\u6c42\u62c6\u7968\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigAddRequestWithUserInfo));
            if (CommonTools.isEmpty((String)msg.toString())) {
                try {
                    Response response2 = this.configBizConfigService.addCfgConfig(msConfigAddRequestWithUserInfo, new String[0]);
                    logger.info("\u8bf7\u6c42\u62c6\u7968\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:" + JsonUtils.writeObjectToFastJson((Object)response2));
                    if (response2.getCode() != 1) {
                        msg.append(response2.getMessage());
                    }
                }
                catch (Exception e) {
                    logger.error("add config exception", (Throwable)e);
                    msg.append(e.getMessage() == null ? "\u7cfb\u7edf\u9519\u8bef" : e.getMessage());
                }
            }
            this.insertInterFace((ConfigBase)splitConfig, msg.toString());
        }
    }

    private <E extends Enum<E>, R> List<R> appendEnumCheckList(Class<E> enumClass, Function<E, R> mapFunc) {
        return EnumUtils.getEnumList(enumClass).stream().map(mapFunc).collect(Collectors.toList());
    }

    private <E extends Enum<E>> String appendEnumErrorMsg(Class<E> enumClass, Function<E, String> mapFunc) {
        return EnumUtils.getEnumList(enumClass).stream().map(mapFunc).collect(Collectors.joining("\uff0c"));
    }

    private void checkSplitConfigData(SplitConfig splitConfig, StringBuilder msg) {
        ((List)this.checkSplitConfigItemList.get()).forEach(r -> {
            String value = StringUtils.trim((String)((String)((Function)r._4()).apply(splitConfig)));
            if (StringUtils.isBlank((CharSequence)value)) {
                msg.append(String.format("---%s\uff0c\u5fc5\u586b\u9879", r._1()));
            } else if (((List)r._2()).contains(value)) {
                ((BiConsumer)r._5()).accept(splitConfig, value);
            } else {
                msg.append(String.format("---%s \u5fc5\u987b\u662f %s", r._1(), r._3()));
            }
        });
    }

    public void importTitleConfig(List<TitleConfig> list, Map<String, Object> headers) {
        logger.info("=========\u5f00\u59cb\u5bfc\u5165\u62ac\u5934\u89c4\u5219============");
        MsCommonUserInfo userInfo = this.getUserInfo(headers);
        Long importBatchNo = Long.parseLong(String.valueOf(headers.get("importBatchNo")));
        for (int i = 0; i < list.size(); ++i) {
            MsConfigItemBean valuesellerTel;
            ArrayList tel;
            MsConfigItemBean valuebankName;
            ArrayList bankName;
            MsConfigItemBean valuebankAccount;
            ArrayList bankAccount;
            MsConfigItemBean valueAddress;
            ArrayList address;
            MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = new MsConfigAddRequestWithUserInfo();
            TitleConfig titleConfig = list.get(i);
            titleConfig.setBatchNo(importBatchNo);
            titleConfig.setConfigType((String)headers.get("configType"));
            String sellerOrgType = StringUtils.isBlank((CharSequence)titleConfig.getSellerOrgType()) ? SellerOrgTypeEnum.COMPANY.getValue() : titleConfig.getSellerOrgType();
            ArrayList configList = Lists.newArrayList();
            MsConfigBean msConfigBean = new MsConfigBean();
            msConfigBean.businessBillType(titleConfig.getBusinessBillType());
            msConfigBean.setSellerName(titleConfig.getSellerName());
            msConfigBean.setSellerTaxNo(titleConfig.getSellerTaxNo());
            msConfigBean.setPurchaserName(titleConfig.getPurchaserName());
            msConfigBean.setPurchaserTaxNo(titleConfig.getPurchaserTaxNo());
            msConfigBean.setConfigType(Integer.valueOf(Integer.parseInt(titleConfig.getConfigType())));
            msConfigBean.setSalesbillType(titleConfig.getSalesbillType());
            msConfigBean.setConfigName(titleConfig.getConfigName());
            StringBuilder msg = new StringBuilder();
            String result = this.commonValid(msConfigBean, userInfo);
            msg.append(result);
            if (CommonTools.isEmpty((String)titleConfig.getSellerAddress())) {
                msg.append("--\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (CommonTools.isEmpty((String)titleConfig.getSellerBankAccount())) {
                msg.append("--\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (CommonTools.isEmpty((String)titleConfig.getSellerBankName())) {
                msg.append("--\u94f6\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (CommonTools.isEmpty((String)titleConfig.getSellerTel())) {
                msg.append("--\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            ArrayList configItemList = Lists.newArrayList();
            if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
                if (StringUtils.isBlank((CharSequence)titleConfig.getSellerOrgType())) {
                    msg.append("\u9500\u65b9\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                address = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerAddress()});
                valueAddress = new MsConfigItemBean("sellerAddress", (List)address);
                bankAccount = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerBankAccount()});
                valuebankAccount = new MsConfigItemBean("sellerBankAccount", (List)bankAccount);
                bankName = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerBankName()});
                valuebankName = new MsConfigItemBean("sellerBankName", (List)bankName);
                tel = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerTel()});
                valuesellerTel = new MsConfigItemBean("sellerTel", (List)tel);
                configItemList.add(valueAddress);
                configItemList.add(valuebankAccount);
                configItemList.add(valuebankName);
                configItemList.add(valuesellerTel);
                msg.append(this.validateSellerOrgValue((ConfigBase)titleConfig, sellerOrgType, msConfigBean));
            } else {
                address = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerAddress()});
                valueAddress = new MsConfigItemBean("purchaserAddress", (List)address);
                bankAccount = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerBankAccount()});
                valuebankAccount = new MsConfigItemBean("purchaserBankAccount", (List)bankAccount);
                bankName = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerBankName()});
                valuebankName = new MsConfigItemBean("purchaserBankName", (List)bankName);
                tel = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerTel()});
                valuesellerTel = new MsConfigItemBean("purchaserTel", (List)tel);
                configItemList.add(valueAddress);
                configItemList.add(valuebankAccount);
                configItemList.add(valuebankName);
                configItemList.add(valuesellerTel);
            }
            msConfigBean.setItemList((List)configItemList);
            configList.add(msConfigBean);
            msConfigAddRequestWithUserInfo.setUserInfo(userInfo);
            msConfigAddRequestWithUserInfo.setItemDTOList((List)configList);
            logger.info("\u8bf7\u6c42\u62ac\u5934\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigAddRequestWithUserInfo));
            Long configId = this.checkExist(msConfigBean);
            if (configId != null) {
                logger.info("\u66f4\u65b0\u660e\u7ec6configId:{}", (Object)configId);
                msConfigBean.setConfigId(configId);
            }
            if (CommonTools.isEmpty((String)msg.toString())) {
                try {
                    Response response2 = this.configBizConfigService.addCfgConfig(msConfigAddRequestWithUserInfo, new String[0]);
                    logger.info("\u8bf7\u6c42\u62ac\u5934\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:" + JsonUtils.writeObjectToFastJson((Object)response2));
                    if (response2.getCode() != 1) {
                        msg.append(response2.getMessage());
                    }
                }
                catch (Exception e) {
                    msg.append(e.getMessage() == null ? "\u7cfb\u7edf\u9519\u8bef" : e.getMessage());
                }
            }
            this.insertInterFace((ConfigBase)titleConfig, msg.toString());
        }
    }

    public void importMultiTitleConfig(List<TitleConfig> list, Map<String, Object> headers) {
        logger.info("=========\u5f00\u59cb\u5bfc\u5165\u4e00\u5bf9\u591a\u62ac\u5934\u89c4\u5219============{}", (Object)list.size());
        MsCommonUserInfo userInfo = this.getUserInfo(headers);
        Long groupId = userInfo.getGroupId();
        Long importBatchNo = Long.parseLong(String.valueOf(headers.get("importBatchNo")));
        List taxNumList = this.getUserCompanyTaxNos(userInfo.getUserId(), groupId);
        for (int i = 0; i < list.size(); ++i) {
            TitleConfig titleConfig = list.get(i);
            StringBuilder msg = new StringBuilder();
            titleConfig.setBatchNo(importBatchNo);
            titleConfig.setConfigType(String.valueOf(headers.get("configType")));
            String checkResult = this.checkMultiTitleImportParam(titleConfig, taxNumList, groupId.longValue());
            if (!CommonTools.isEmpty((String)checkResult)) {
                this.insertInterFace((ConfigBase)titleConfig, checkResult);
                continue;
            }
            CfgConfigInvoiceTitleEntity titleEntity = new CfgConfigInvoiceTitleEntity();
            titleEntity.setSellerName(titleConfig.getSellerName());
            titleEntity.setSellerTaxNo(titleConfig.getSellerTaxNo());
            titleEntity.setSellerAddress(titleConfig.getSellerAddress());
            titleEntity.setSellerBankAccount(titleConfig.getSellerBankAccount());
            titleEntity.setSellerBankName(titleConfig.getSellerBankName());
            titleEntity.setSellerTel(titleConfig.getSellerTel());
            titleEntity.setStatus(ConstantValue.STATUS_ACTIVE);
            titleEntity.setSellerGroupId(groupId);
            long count = this.configTitleService.checkRepeatTitle(titleEntity);
            if (count > 0L) {
                msg.append("\u8be5\u62ac\u5934\u5e93\u4fe1\u606f\u5df2\u88ab\u521b\u5efa\uff01");
            }
            if (CommonTools.isEmpty((String)msg.toString())) {
                titleEntity.setTitleId(Long.valueOf(this.idGenerator.nextId()));
                titleEntity.setCreateTime(new Date());
                titleEntity.setCreateUser(userInfo.getUserId());
                titleEntity.setUpdateTime(new Date());
                titleEntity.setUpdateUser(userInfo.getUserId());
                this.invoiceTitleDao.insert(titleEntity);
            }
            this.insertInterFace((ConfigBase)titleConfig, msg.toString());
        }
    }

    private String checkMultiTitleImportParam(TitleConfig titleConfig, List<String> taxNumList, long groupId) {
        StringBuilder checkMsg = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)titleConfig.getSellerTaxNo())) {
            checkMsg.append("\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        } else if (!taxNumList.stream().anyMatch(f -> titleConfig.getSellerTaxNo().equals(f))) {
            checkMsg.append(titleConfig.getSellerTaxNo() + "\u6ca1\u6709\u8be5\u516c\u53f8\u6743\u9650\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)titleConfig.getSellerName())) {
            checkMsg.append("\u9500\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        } else {
            UserCenterResponse companyReply = this.userCenterController.getCompanyByTaxNo(groupId, titleConfig.getSellerTaxNo());
            if ("1".equals(companyReply.getCode()) && !Optional.ofNullable(companyReply.getResult()).map(CompanyData::getCompanyName).filter(r -> r.equals(titleConfig.getSellerName())).isPresent()) {
                checkMsg.append("\u9500\u65b9\u7a0e\u53f7\u4e0e\u9500\u65b9\u540d\u79f0\u4e0d\u5bf9\u5e94\uff01");
            }
        }
        if (StringUtils.isEmpty((CharSequence)titleConfig.getSellerAddress()) && StringUtils.isEmpty((CharSequence)titleConfig.getSellerTel()) && StringUtils.isEmpty((CharSequence)titleConfig.getSellerBankAccount()) && StringUtils.isEmpty((CharSequence)titleConfig.getSellerBankName())) {
            checkMsg.append("\u9500\u65b9\u5730\u5740\u3001\u9500\u65b9\u7535\u8bdd\u3001\u94f6\u884c\u540d\u79f0\u3001\u94f6\u884c\u8d26\u53f7\u56db\u4e2a\u5b57\u6bb5\u9700\u5fc5\u586b\u4e00\u4e2a\uff01");
        }
        if (CommonTools.getStringCharLength((String)titleConfig.getSellerBankAccount()) > 30) {
            checkMsg.append("\u9500\u65b9\u94f6\u884c\u8d26\u53f7\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26");
        }
        if (CommonTools.getStringCharLength((String)titleConfig.getSellerTel()) > 30) {
            checkMsg.append("\u9500\u65b9\u7535\u8bdd\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26");
        }
        if (CommonTools.getStringCharLength((String)titleConfig.getSellerAddress()) + CommonTools.getStringCharLength((String)titleConfig.getSellerTel()) > 100) {
            checkMsg.append("\u9500\u65b9\u5730\u5740+\u9500\u65b9\u7535\u8bdd\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26\uff01");
        }
        if (CommonTools.getStringCharLength((String)titleConfig.getSellerBankAccount()) + CommonTools.getStringCharLength((String)titleConfig.getSellerBankName()) > 100) {
            checkMsg.append("\u94f6\u884c\u540d\u79f0+\u94f6\u884c\u8d26\u53f7\u603b\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u4e2a\u5b57\u7b26\uff01");
        }
        return checkMsg.toString();
    }

    public void importPersonConfig(List<PersonConfig> list, Map<String, Object> headers) {
        logger.info("=========\u5f00\u59cb\u5bfc\u5165\u7968\u9762\u89c4\u5219============");
        MsCommonUserInfo userInfo = this.getUserInfo(headers);
        Long importBatchNo = Long.parseLong(String.valueOf(headers.get("importBatchNo")));
        for (int i = 0; i < list.size(); ++i) {
            MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = new MsConfigAddRequestWithUserInfo();
            PersonConfig personConfig = list.get(i);
            personConfig.setBatchNo(importBatchNo);
            personConfig.setConfigType((String)headers.get("configType"));
            String sellerOrgType = StringUtils.isBlank((CharSequence)personConfig.getSellerOrgType()) ? SellerOrgTypeEnum.COMPANY.getValue() : personConfig.getSellerOrgType();
            ArrayList configList = Lists.newArrayList();
            MsConfigBean msConfigBean = new MsConfigBean();
            msConfigBean.businessBillType(personConfig.getBusinessBillType());
            msConfigBean.setSellerName(personConfig.getSellerName());
            msConfigBean.setSellerTaxNo(personConfig.getSellerTaxNo());
            msConfigBean.setPurchaserName(personConfig.getPurchaserName());
            msConfigBean.setPurchaserTaxNo(personConfig.getPurchaserTaxNo());
            msConfigBean.setConfigType(Integer.valueOf(Integer.parseInt(personConfig.getConfigType())));
            msConfigBean.setSalesbillType(personConfig.getSalesbillType());
            msConfigBean.setConfigName(personConfig.getConfigName());
            StringBuilder msg = new StringBuilder();
            String result = this.commonValid(msConfigBean, userInfo);
            msg.append(result);
            if (CommonTools.isEmpty((String)personConfig.getSellerName())) {
                msg.append("--\u9500\u65b9\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (CommonTools.isEmpty((String)personConfig.getSellerTaxNo())) {
                msg.append("--\u9500\u65b9\u7a0e\u53f7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a--");
            }
            if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType())) {
                msg.append(this.validateSellerOrgValue((ConfigBase)personConfig, sellerOrgType, msConfigBean));
            }
            BeanMap beanMap = BeanMap.create((Object)personConfig);
            Field[] declaredFields = personConfig.getClass().getDeclaredFields();
            msConfigBean.setItemList(this.getBeanItemList(beanMap, declaredFields, null, null, null));
            configList.add(msConfigBean);
            msConfigAddRequestWithUserInfo.setUserInfo(userInfo);
            msConfigAddRequestWithUserInfo.setItemDTOList((List)configList);
            logger.info("\u8bf7\u6c42\u7968\u9762\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigAddRequestWithUserInfo));
            Long configId = this.checkExist(msConfigBean);
            if (configId != null) {
                logger.info("\u66f4\u65b0\u660e\u7ec6configId:{}", (Object)configId);
                msConfigBean.setConfigId(configId);
            }
            if (CommonTools.isEmpty((String)msg.toString())) {
                try {
                    Response response2 = this.configBizConfigService.addCfgConfig(msConfigAddRequestWithUserInfo, new String[0]);
                    logger.info("\u8bf7\u6c42\u7968\u9762\u4eba\u5458\u89c4\u5219\u6dfb\u52a0\u53c2\u6570:" + JsonUtils.writeObjectToFastJson((Object)response2));
                    if (response2.getCode() != 1) {
                        msg.append(response2.getMessage());
                    }
                }
                catch (Exception e) {
                    msg.append(e.getMessage() == null ? "\u7cfb\u7edf\u9519\u8bef" : e.getMessage());
                }
            }
            this.insertInterFace((ConfigBase)personConfig, msg.toString());
        }
    }

    public List<MsConfigItemBean> getBeanItemList(BeanMap beanMap, Field[] declaredFields, String salesBillType, Long groupId, List<MsConfigBizBillAttribute> outAttributeEntityList) {
        ArrayList mainExtFieldList = Lists.newArrayList();
        ArrayList mainExtFieldValueList = Lists.newArrayList();
        ArrayList mainPropertyKeyList = Lists.newArrayList();
        ArrayList mainPropertyValueList = Lists.newArrayList();
        ArrayList configItemList = Lists.newArrayList();
        for (int j = 0; j < declaredFields.length; ++j) {
            String keys;
            String val;
            String fieldName = declaredFields[j].getName();
            if (fieldName.contains("$")) continue;
            ArrayList<String> value = new ArrayList<String>(1);
            if (this.billItemFields.contains(fieldName) && salesBillType != null) {
                val = String.valueOf(beanMap.get((Object)fieldName));
                value.addAll(this.getFieldEnName(salesBillType, groupId, val));
            } else if (this.billFields.contains(fieldName) && salesBillType != null) {
                val = String.valueOf(beanMap.get((Object)fieldName));
                if (CommonTools.isEmpty((String)val)) continue;
                value.addAll(this.getFieldEnNameForBill(salesBillType, groupId, val));
            } else if (this.mainExtFields.equals(fieldName)) {
                keys = Optional.ofNullable(beanMap.get((Object)fieldName)).map(String::valueOf).orElse("");
                if (!StringUtils.isEmpty((CharSequence)keys)) {
                    Collections.addAll(mainExtFieldList, keys.split(";"));
                }
            } else if (this.mainExtFieldValues.equals(fieldName)) {
                keys = Optional.ofNullable(beanMap.get((Object)fieldName)).map(String::valueOf).orElse("");
                if (!StringUtils.isEmpty((CharSequence)keys)) {
                    Collections.addAll(mainExtFieldValueList, keys.split(";"));
                }
            } else if (this.mainPropertyKeys.equals(fieldName)) {
                keys = Optional.ofNullable(beanMap.get((Object)fieldName)).map(String::valueOf).orElse("");
                if (!StringUtils.isEmpty((CharSequence)keys)) {
                    Collections.addAll(mainPropertyKeyList, keys.split(";"));
                }
            } else if (this.mainPropertyValues.equals(fieldName)) {
                String values = Optional.ofNullable(beanMap.get((Object)fieldName)).map(String::valueOf).orElse("");
                if (!StringUtils.isEmpty((CharSequence)values)) {
                    Collections.addAll(mainPropertyValueList, values.split(";"));
                }
            } else {
                Object itemValue;
                if (fieldName.equals("mainRemarkFiledList")) {
                    itemValue = beanMap.get((Object)fieldName);
                    if (itemValue == null) continue;
                    String mainRemarkFieldOperator = Optional.ofNullable(beanMap.get((Object)"mainRemarkFiledOperator")).map(String::valueOf).orElse("");
                    this.handleRemarkFields(beanMap, fieldName, value, mainRemarkFieldOperator, groupId, FieldGroupIndex.FIELD_GROUP_INDEX_MAIN.value());
                    configItemList.add(new MsConfigItemBean("invoiceRemarkFiledList", value));
                    continue;
                }
                if (fieldName.equals("itemRemarkFiledList")) {
                    itemValue = beanMap.get((Object)fieldName);
                    if (itemValue == null) continue;
                    String itemRemarkFiledOperator = Optional.ofNullable(beanMap.get((Object)"itemRemarkFiledOperator")).map(String::valueOf).orElse("");
                    this.handleRemarkFields(beanMap, fieldName, value, itemRemarkFiledOperator, groupId, FieldGroupIndex.FIELD_GROUP_INDEX_ITEM.value());
                    configItemList.add(new MsConfigItemBean("invoiceItemRemarkFiledList", value));
                    continue;
                }
                if (fieldName.equals("taxAmountAllowMax")) {
                    String taxAmountAllowMax = Optional.ofNullable(beanMap.get((Object)"taxAmountAllowMax")).map(String::valueOf).orElse("1.26");
                    try {
                        BigDecimal bigDecimal = new BigDecimal(taxAmountAllowMax);
                        value.add(taxAmountAllowMax);
                        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0 || bigDecimal.compareTo(new BigDecimal("1.26")) > 0) {
                            value.add("1.26");
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u7a0e\u989d\u6700\u5927\u5bb9\u5dee\u8f6c\u6362\u5f02\u5e38:{}", (Object)taxAmountAllowMax, (Object)e);
                        value.add("1.26");
                    }
                } else if (fieldName.equals("taxDeviceType")) {
                    itemValue = beanMap.get((Object)fieldName);
                    if (itemValue == null) {
                        value.add("0");
                    } else {
                        value.add(String.valueOf(itemValue));
                    }
                } else {
                    itemValue = beanMap.get((Object)fieldName);
                    if (itemValue == null) {
                        value.add("");
                    } else {
                        value.add(String.valueOf(itemValue));
                    }
                }
            }
            configItemList.add(new MsConfigItemBean(fieldName, value));
        }
        logger.info("mainExtFieldList {} mainExtFieldValueList {} mainPropertyKeyList:{} mainPropertyValueList:{}", new Object[]{JsonUtils.writeObjectToFastJson((Object)mainExtFieldList), JsonUtils.writeObjectToFastJson((Object)mainExtFieldValueList), JsonUtils.writeObjectToFastJson((Object)mainPropertyKeyList), JsonUtils.writeObjectToFastJson((Object)mainPropertyValueList)});
        if (Objects.nonNull(outAttributeEntityList) && mainExtFieldList.size() == mainExtFieldValueList.size() && mainExtFieldValueList.size() == mainPropertyKeyList.size() && mainPropertyKeyList.size() == mainPropertyValueList.size() && mainPropertyValueList.size() > 0) {
            for (int i = 0; i < mainExtFieldList.size(); ++i) {
                MsConfigBizBillAttribute msConfigBizBillAttribute = new MsConfigBizBillAttribute();
                msConfigBizBillAttribute.setFieldName((String)mainExtFieldList.get(i));
                msConfigBizBillAttribute.setFieldValue((String)mainExtFieldValueList.get(i));
                msConfigBizBillAttribute.setAttrName((String)mainPropertyKeyList.get(i));
                msConfigBizBillAttribute.setValue((String)mainPropertyValueList.get(i));
                outAttributeEntityList.add(msConfigBizBillAttribute);
            }
        }
        return configItemList;
    }

    private boolean handleRemarkFields(BeanMap beanMap, String fieldName, ArrayList<String> value, String fieldOperator, Long groupId, Integer fieldGroupIndex) {
        this.checkJoinChar(StringUtils.isEmpty((CharSequence)fieldOperator) || !this.joinCharList.contains(fieldOperator), beanMap, "\u5206\u9694\u7b26\u679a\u4e3e\u503c\u9519\u8bef\uff0c\u679a\u4e3e\u503c\u8303\u56f4\uff1a1->\uff0c, 2->\u30013->\uff1a 4->\uff1b 5-> - 6->| 7->\u7a7a\u683c 8->\u6362\u884c,\u8bf7\u68c0\u67e5");
        String values = Optional.ofNullable(beanMap.get((Object)fieldName)).map(String::valueOf).orElse("");
        if (StringUtils.isEmpty((CharSequence)values)) {
            return true;
        }
        String[] lines = values.split("\n");
        logger.info("handleRemarkFields.remarkFieldList:{},splitResult:{}", (Object)values, (Object)JsonUtils.writeObjectToFastJson((Object)lines));
        for (int j = 0; j < lines.length; ++j) {
            String[] split;
            String line = lines[j];
            if (StringUtils.isNotEmpty((CharSequence)line) && !line.contains("\u56fa\u5b9a\u503c") && !line.contains("\u5b57\u6bb5\u503c")) {
                this.checkJoinChar(true, beanMap, "\u5907\u6ce8\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef\uff0c\u9519\u8bef\u884c\u5185\u5bb9\u3010" + line + "\u3011\uff0c\u6bcf\u884c\u5907\u6ce8\u5fc5\u987b\u5305\u542b\u56fa\u5b9a\u503c,\u5b57\u6bb5\u503c,\u8bf7\u68c0\u67e5");
            }
            this.checkJoinChar((split = line.split(":")).length < 2, beanMap, "\u5907\u6ce8\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef\uff0c\u3010" + line + "\u3011\u6309\u5192\u53f7\u5206\u9694\u5206\u9694\u65e0\u7ed3\u679c,\u8bf7\u68c0\u67e5");
            String content = "";
            for (int i = 1; i < split.length; ++i) {
                content = content + split[i];
            }
            if (split[0].equals("\u5b57\u6bb5\u503c")) {
                String fieldEnName = this.getFieldEnName(content, String.valueOf(beanMap.get((Object)"salesbillType")), groupId, fieldGroupIndex);
                String disPlayName = fieldGroupIndex == 0 ? "\u5355\u636e\u5934\u5b57\u6bb5" : "\u5355\u636e\u660e\u7ec6\u5b57\u6bb5";
                this.checkJoinChar(content.equals(fieldEnName), beanMap, "\u5907\u6ce8\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef\uff0c\u5b57\u6bb5\u503c\u540d\u79f0\u3010" + content + "\u3011\u65e0\u6cd5\u8f6c\u6362\u4e3a" + disPlayName + ",\u8bf7\u53c2\u8003\u4e1a\u52a1\u5355\u7c7b\u578b\u5b9a\u4e49\u7684\u4e2d\u6587\u540d\u79f0\u6838\u5bf9\u68c0\u67e5");
                content = fieldEnName;
            }
            String remarkItem = fieldOperator + "_#_" + (split[0].equals("\u56fa\u5b9a\u503c") ? "1" : "0") + "_#_" + content;
            value.add(remarkItem);
        }
        return false;
    }

    private void checkJoinChar(boolean mainRemarkFiledOperator, BeanMap beanMap, String text) {
        if (mainRemarkFiledOperator) {
            this.dingDingUtils.sendMsgMarkDownWarn("\u62c6\u7968\u89c4\u5219\u5bfc\u5165\u5931\u8d25", "", String.valueOf(beanMap.get((Object)"configName")), text, null);
            throw new IllegalArgumentException(text);
        }
    }

    private ArrayList<String> getFieldEnName(String salesBillType, Long groupId, String value) {
        Map map = this.localCacheManager.queryEffectiveMetaData(groupId, ObjCodeEnum.BILL.getObjCode(), salesBillType);
        ArrayList dataValues = Lists.newArrayList();
        value = value.replace("\uff0c", ",");
        String[] splitfields = value.split(",");
        for (int i = 0; i < splitfields.length; ++i) {
            String disPlayName = splitfields[i];
            String key = disPlayName + "#1";
            MsBusinessObjMetadataBean msBusinessObjMetadataBean = (MsBusinessObjMetadataBean)map.get(key);
            if (msBusinessObjMetadataBean != null) {
                dataValues.add(msBusinessObjMetadataBean.getFieldName());
                continue;
            }
            logger.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u660e\u7ec6\u5b57\u6bb5:{},\u4e1a\u52a1\u5355\u7c7b\u578b:{},\u96c6\u56e2id:{}, key:{}", new Object[]{disPlayName, salesBillType, groupId, key});
        }
        return dataValues;
    }

    private ArrayList<String> getFieldEnNameForBill(String salesBillType, Long groupId, String value) {
        Map map = this.localCacheManager.queryEffectiveMetaData(groupId, ObjCodeEnum.BILL.getObjCode(), salesBillType);
        ArrayList dataValues = Lists.newArrayList();
        String[] splitfields = value.split(",");
        for (int i = 0; i < splitfields.length; ++i) {
            String disPlayName = splitfields[i];
            String key = disPlayName + "#0";
            MsBusinessObjMetadataBean msBusinessObjMetadataBean = (MsBusinessObjMetadataBean)map.get(key);
            if (msBusinessObjMetadataBean != null) {
                dataValues.add(msBusinessObjMetadataBean.getFieldName());
                continue;
            }
            logger.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u5b57\u6bb5:{},\u4e1a\u52a1\u5355\u7c7b\u578b{},\u96c6\u56e2id:{}", new Object[]{disPlayName, salesBillType, groupId});
        }
        return dataValues;
    }

    private String getFieldEnName(String dispalyName, String salesBillType, Long groupId, Integer fieldGroupIndex) {
        String key;
        Map map = this.localCacheManager.queryEffectiveMetaData(groupId, ObjCodeEnum.BILL.getObjCode(), salesBillType);
        MsBusinessObjMetadataBean msBusinessObjMetadataBean = (MsBusinessObjMetadataBean)map.get(key = this.replace(dispalyName) + "#" + fieldGroupIndex);
        if (msBusinessObjMetadataBean != null) {
            return msBusinessObjMetadataBean.getFieldName();
        }
        if (dispalyName.equals("\u95e8\u5e97\u53f7")) {
            return "sysOrgCode";
        }
        if (dispalyName.equals("\u7ec4\u7ec7\u540d\u79f0")) {
            return "sysOrgName";
        }
        logger.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5:{},\u4e1a\u52a1\u5355\u7c7b\u578b{},\u96c6\u56e2id:{}", new Object[]{dispalyName, salesBillType, groupId});
        return dispalyName;
    }

    private String replace(String input) {
        int n = 0;
        String[] stringArray = this.splitReplace.split("#");
        int n2 = stringArray.length;
        if (n < n2) {
            String s = stringArray[n];
            String[] split = s.split("@");
            return input.replace(split[0], split[1]);
        }
        return input;
    }

    private MsCommonUserInfo getUserInfo(Map<String, Object> headers) {
        MsCommonUserInfo userInfo = new MsCommonUserInfo();
        userInfo.setUserId(Long.valueOf(Long.parseLong(String.valueOf(headers.get("userId")))));
        userInfo.setUserName(String.valueOf(headers.get("userName")));
        userInfo.setGroupId(Long.valueOf(Long.parseLong(String.valueOf(headers.get("groupId")))));
        userInfo.setGroupCode(String.valueOf(headers.get("groupCode")));
        userInfo.setGroupName(String.valueOf(headers.get("groupName")));
        this.setContextUserInfo(headers);
        return userInfo;
    }

    private void setContextUserInfo(Map<String, Object> headers) {
        UserInfo userInfo = new UserInfo();
        if (headers.get("groupId") != null) {
            userInfo.setGroupId(Long.parseLong(String.valueOf(headers.get("groupId"))));
        }
        this.userInfoHolder.put((Object)userInfo);
    }

    private String commonValid(MsConfigBean msConfigBean, MsCommonUserInfo userInfo) {
        StringBuilder msg = new StringBuilder();
        if (ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType().intValue() == msConfigBean.getConfigType().intValue()) {
            msConfigBean.setBusinessBillType(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType());
        } else {
            if (CommonTools.isEmpty((String)msConfigBean.getSalesbillType())) {
                msg.append("--").append("\u521b\u5efa\u65b9\u5fc5\u987b\u586b\u5199").append("--");
            } else if (!BusinessSalesBillTypeEnum.checkIsExist((String)msConfigBean.getBusinessBillType())) {
                msg.append("--").append("\u521b\u5efa\u65b9\u5fc5\u987b\u662fAR \u6216\u8005 AP").append("--");
            }
            if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType()) && CommonTools.isEmpty((String)msConfigBean.getSellerTaxNo())) {
                msg.append("--").append("\u521b\u5efa\u65b9\u662fAR,\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a").append("--");
            }
            if (BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType().equals(msConfigBean.getBusinessBillType()) && CommonTools.isEmpty((String)msConfigBean.getPurchaserTaxNo())) {
                msg.append("--").append("\u521b\u5efa\u65b9\u662fAP,\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a").append("--");
            }
        }
        if (CommonTools.isEmpty((String)msConfigBean.getSellerTaxNo()) && !CommonTools.isEmpty((String)msConfigBean.getSellerName())) {
            msg.append("--").append("\u9500\u65b9\u7a0e\u53f7\u4e3a\u7a7a,\u9500\u65b9\u516c\u53f8\u540d\u79f0\u5fc5\u987b\u4e3a\u7a7a").append("--");
        } else if (!CommonTools.isEmpty((String)msConfigBean.getSellerTaxNo()) && CommonTools.isEmpty((String)msConfigBean.getSellerName())) {
            msg.append("--").append("\u9500\u65b9\u516c\u53f8\u4e3a\u7a7a,\u9500\u65b9\u540d\u79f0\u5fc5\u987b\u4e3a\u7a7a").append("--");
        }
        if (CommonTools.isEmpty((String)msConfigBean.getPurchaserTaxNo()) && !CommonTools.isEmpty((String)msConfigBean.getPurchaserName())) {
            msg.append("--").append("\u8d2d\u65b9\u7a0e\u53f7\u4e3a\u7a7a,\u8d2d\u65b9\u516c\u53f8\u540d\u79f0\u5fc5\u987b\u4e3a\u7a7a").append("--");
        } else if (CommonTools.isEmpty((String)msConfigBean.getPurchaserName()) && !CommonTools.isEmpty((String)msConfigBean.getPurchaserTaxNo())) {
            msg.append("--").append("\u8d2d\u65b9\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a,\u8d2d\u65b9\u7a0e\u53f7\u5fc5\u987b\u4e3a\u7a7a").append("--");
        }
        if (CommonTools.isEmpty((String)msConfigBean.getSalesbillType())) {
            msg.append("--").append("\u4e1a\u52a1\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a").append("--");
        } else {
            CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
            cfgBusinessObjExample.createCriteria().andGroupIdEqualTo(userInfo.getGroupId()).andObjNameEqualTo(msConfigBean.getSalesbillType().trim()).andObjStatusEqualTo(Integer.valueOf(1));
            long l = this.cfgBusinessObjDao.countByExample(cfgBusinessObjExample);
            if (l == 0L) {
                if (this.adapterConfig.isAdapterOpen(userInfo.getGroupId()).booleanValue()) {
                    MsMataDataQueryRequest msMataDataQueryRequest = new MsMataDataQueryRequest();
                    msMataDataQueryRequest.setGroupId(userInfo.getGroupId());
                    List msGroupTypeBeans = this.adapterService.queryGroupObjType(msMataDataQueryRequest);
                    MsGroupTypeBean temp = msGroupTypeBeans.stream().filter(msGroupTypeBean -> msGroupTypeBean.getObjType().equals(msConfigBean.getSalesbillType())).findFirst().orElse(null);
                    if (temp == null) {
                        msg.append("--").append("\u4e1a\u52a1\u5355\u7c7b\u578b\u5728\u8be5\u96c6\u56e2\u4e0d\u5b58\u5728").append("--");
                    }
                } else {
                    msg.append("--").append("\u4e1a\u52a1\u5355\u7c7b\u578b\u5728\u8be5\u96c6\u56e2\u4e0d\u5b58\u5728").append("--");
                }
            }
        }
        if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().intValue() == msConfigBean.getConfigType().intValue() && CommonTools.isEmpty((String)msConfigBean.getInvoiceType())) {
            msg.append("--").append("\u62c6\u7968\u89c4\u5219\u7684\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a").append("--");
        }
        if (CommonTools.isEmpty((String)msConfigBean.getConfigName())) {
            msg.append("--").append("\u914d\u7f6e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a").append("--");
        }
        return msg.toString();
    }

    private void insertInterFace(ConfigBase config, String msg) {
        CfgConfigInterfaceEntity entity = new CfgConfigInterfaceEntity();
        entity.setBatchNo(config.getBatchNo());
        entity.setSalesbillType(config.getSalesbillType());
        entity.setBusinessBillType(config.getBusinessBillType() == null ? "" : config.getBusinessBillType());
        entity.setSellerName(config.getSellerName() == null ? "" : config.getSellerName());
        entity.setSellerTaxNo(config.getSellerTaxNo() == null ? "" : config.getSellerTaxNo());
        entity.setPurchaserName(config.getPurchaserName() == null ? "" : config.getPurchaserName());
        entity.setPurchaserTaxNo(config.getPurchaserTaxNo() == null ? "" : config.getPurchaserTaxNo());
        entity.setConfigType(Integer.valueOf(config.getConfigType()));
        entity.setInvoiceType(config.getInvoiceType() == null ? "" : config.getInvoiceType());
        entity.setConfigName(config.getConfigName() == null ? "" : config.getConfigName());
        String json = JsonUtils.writeObjectToFastJson((Object)config);
        entity.setOrigData(json);
        if (!CommonTools.isEmpty((String)msg)) {
            entity.setProcessFlag("F");
            entity.setProcessRemark(msg);
        } else {
            entity.setProcessFlag("S");
            entity.setProcessRemark("");
        }
        entity.setStatus(Integer.valueOf(1));
        entity.setCreateTime(new Date());
        this.cfgConfigInterfaceExtDao.insertWithDefaultValue(entity);
    }

    private Long checkExist(MsConfigBean msConfigBean) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = cfgConfigExample.createCriteria();
        criteria.andConfigTypeEqualTo(Byte.valueOf(msConfigBean.getConfigType().byteValue()));
        if (msConfigBean.getConfigType().equals(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType())) {
            String invoiceType = msConfigBean.getInvoiceType();
            criteria.andInvoiceTypeEqualTo(invoiceType);
        }
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        String salesbillType = StringUtils.isEmpty((CharSequence)msConfigBean.getSalesbillType()) ? "" : msConfigBean.getSalesbillType();
        criteria.andSalesbillTypeEqualTo(salesbillType);
        criteria.andBusinessBillTypeEqualTo(msConfigBean.getBusinessBillType());
        String sellerTaxNo = msConfigBean.getSellerTaxNo();
        criteria.andSellerTaxNoEqualTo(StringUtils.isBlank((CharSequence)sellerTaxNo) ? "" : sellerTaxNo);
        String purchaserTaxNo = msConfigBean.getPurchaserTaxNo();
        criteria.andPurchaserTaxNoEqualTo(StringUtils.isBlank((CharSequence)purchaserTaxNo) ? "" : purchaserTaxNo);
        criteria.andSysOrgIdEqualTo(Optional.ofNullable(msConfigBean.getSysOrgId()).orElse(0L));
        List cfgConfigEntities = this.cfgConfigDao.selectByExample(cfgConfigExample);
        if (cfgConfigEntities.size() == 1) {
            Long configId = ((CfgConfigEntity)cfgConfigEntities.get(0)).getConfigId();
            List paramAttributeList = msConfigBean.getAttributes();
            CfgConfigBillAttributeExample cfgConfigBillAttributeExample = new CfgConfigBillAttributeExample();
            cfgConfigBillAttributeExample.createCriteria().andConfigIdEqualTo(configId).andStatusEqualTo(Integer.valueOf(1));
            List dbAttributeList = this.cfgConfigBillAttributeDao.selectByExample(cfgConfigBillAttributeExample);
            boolean compareRet = this.compareAttributeList(paramAttributeList, dbAttributeList);
            if (compareRet) {
                return configId;
            }
            return null;
        }
        if (cfgConfigEntities.size() > 1) {
            logger.warn("==========\u914d\u7f6e\u8868\u5b58\u5728\u91cd\u590d\u6570\u636e==================================");
            return null;
        }
        return null;
    }

    private boolean compareAttributeList(List<MsConfigBizBillAttribute> paramAttributeList, List<CfgConfigBillAttributeEntity> dbAttributeList) {
        int dbSize;
        int paramSize;
        Map<Object, Object> paramAttributeMap = Maps.newHashMap();
        Map<Object, Object> dbAttributeMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(paramAttributeList)) {
            paramAttributeMap = paramAttributeList.stream().collect(Collectors.toMap(MsConfigBizBillAttribute::getFieldName, item -> item));
        }
        if (!CollectionUtils.isEmpty(dbAttributeList)) {
            dbAttributeMap = dbAttributeList.stream().collect(Collectors.toMap(CfgConfigBillAttributeEntity::getFieldName, item -> item));
        }
        if ((paramSize = paramAttributeMap.size()) == (dbSize = dbAttributeMap.size()) && dbSize == 0) {
            return true;
        }
        if (paramSize == dbSize && dbSize > 0) {
            for (Map.Entry<Object, Object> entry : paramAttributeMap.entrySet()) {
                String paramKey = (String)entry.getKey();
                MsConfigBizBillAttribute paramAttribute = (MsConfigBizBillAttribute)entry.getValue();
                CfgConfigBillAttributeEntity dbAttribute = (CfgConfigBillAttributeEntity)dbAttributeMap.get(paramKey);
                if (!Objects.isNull(dbAttribute) && paramAttribute.getValue().equals(dbAttribute.getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void updateConfigItem(MsConfigBean msConfigBean, Long configId) {
        msConfigBean.getItemList().forEach(item -> {
            List configItemValue = item.getConfigItemValue();
            if (!CollectionUtils.isEmpty((Collection)configItemValue) && !CommonTools.isEmpty((String)((String)configItemValue.get(0)))) {
                CfgConfigItemEntity cfgConfigItemEntity = new CfgConfigItemEntity();
                cfgConfigItemEntity.setConfigItemValue(JsonUtils.writeObjectToFastJson((Object)configItemValue));
                CfgConfigItemExample cfgConfigItemExample = new CfgConfigItemExample();
                cfgConfigItemExample.createCriteria().andConfigIdEqualTo(configId).andConfigItemNameEqualTo(item.getConfigItemName());
                this.cfgConfigItemDao.updateByExampleSelective(cfgConfigItemEntity, cfgConfigItemExample);
            } else {
                logger.info("\u5b57\u6bb5\u503c\u4e3a\u7a7a\uff0c\u4e0d\u66f4\u8be5\u5b57\u6bb5:{}", (Object)item.getConfigItemName());
            }
        });
    }

    public void importTerminal(List<TerminalConfig> list, Map<String, Object> headers) {
        this.setContextUserInfo(headers);
        if (list == null || list.size() == 0) {
            logger.warn("\u65e0\u6570\u636e...");
            return;
        }
        ArrayList<TerminalConfig> errorList = new ArrayList<TerminalConfig>();
        int insertTotal = 0;
        int updateTotal = 0;
        long groupId = headers.get("groupId") == null ? -1L : Long.parseLong(headers.get("groupId").toString());
        String groupName = headers.get("groupName") == null ? "" : headers.get("groupName").toString();
        long userId = headers.get("userId") == null ? -1L : Long.parseLong(headers.get("userId").toString());
        UserInfo userInfo = new UserInfo();
        userInfo.setUserId(userId);
        userInfo.setGroupId(groupId);
        List userCompanyTaxNos = this.getUserCompanyTaxNos(Long.valueOf(userId), Long.valueOf(groupId));
        for (TerminalConfig terminalConfig : list) {
            StringBuilder sb = new StringBuilder();
            CheckTerminalResponseVo checkTerminalResponseVo = new CheckTerminalResponseVo();
            this.checkTerminal(terminalConfig, groupId, sb, checkTerminalResponseVo, userCompanyTaxNos, userInfo);
            if (sb.length() > 0) {
                terminalConfig.setErrorMsg(sb.toString());
                errorList.add(terminalConfig);
                continue;
            }
            try {
                String terminalNo = terminalConfig.getTerminalNo();
                MsTerminalQueryResponseInfo msTerminalQueryResponseInfo = this.getTerminalList(terminalNo, groupId, userInfo);
                if (msTerminalQueryResponseInfo != null) {
                    MsConfigUpdateTerminalRequest msConfigUpdateTerminalRequest = this.buildMsConfigUpdateTerminalRequest(msTerminalQueryResponseInfo.getId().longValue(), msTerminalQueryResponseInfo.getDeviceId(), msTerminalQueryResponseInfo.getDeviceUn(), terminalConfig, checkTerminalResponseVo);
                    MsResponse msResponse = this.configTerminalService.update(msConfigUpdateTerminalRequest, userId, groupId);
                    logger.info("terminal update params:{},response:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigUpdateTerminalRequest), (Object)JsonUtils.writeObjectToFastJson((Object)msResponse));
                    if (msResponse.getCode().equals(-1)) {
                        terminalConfig.setErrorMsg(msResponse.getMessage());
                        errorList.add(terminalConfig);
                        continue;
                    }
                    ++updateTotal;
                    continue;
                }
                MsConfigAddTerminalRequest msConfigAddTerminalRequest = this.buildMsConfigAddTerminalRequest(terminalConfig, checkTerminalResponseVo);
                MsAddTerminalResponse msAddTerminalResponse = this.configTerminalService.addTerminal(msConfigAddTerminalRequest, groupId, groupName, userId);
                logger.info("terminal insert params:{},response:{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigAddTerminalRequest), (Object)JsonUtils.writeObjectToFastJson((Object)msAddTerminalResponse));
                if (msAddTerminalResponse.getCode().equals(Response.Fail) || msAddTerminalResponse.getCode().equals(-1)) {
                    terminalConfig.setErrorMsg(msAddTerminalResponse.getMessage());
                    errorList.add(terminalConfig);
                    continue;
                }
                ++insertTotal;
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u7ec8\u7aef\u5f02\u5e38.{}", (Throwable)e);
                terminalConfig.setErrorMsg(e.getMessage() == null ? "\u5904\u7406\u7ec8\u7aef\u5f02\u5e38" : e.getMessage().substring(0, 200));
            }
        }
        this.importFailConfigServiceImpl.dealFailTerminalImport(errorList, headers, insertTotal, updateTotal);
    }

    public void importSellerBusinessConfig(List<SellerBusinessConfig> sellerBusinessConfigs, Map<String, Object> headers) {
        this.setContextUserInfo(headers);
        if (CollectionUtils.isEmpty(sellerBusinessConfigs)) {
            logger.warn("\u6279\u91cf\u5bfc\u5165\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u65e0\u6570\u636e...");
            return;
        }
        Long importBatchNo = Optional.ofNullable(headers.get("importBatchNo")).map(String::valueOf).map(Long::valueOf).orElse(0L);
        String configType = Optional.ofNullable(headers).map(header -> header.get("configType")).map(String::valueOf).orElse("6");
        ArrayList cfgConfigInterfaceEntities = Lists.newArrayList();
        sellerBusinessConfigs.stream().forEach(sellerBusinessConfig -> {
            sellerBusinessConfig.setConfigType(configType);
            CfgConfigInterfaceEntity cfgConfigInterfaceEntity = this.businessConfigConverter.toEntity(sellerBusinessConfig);
            cfgConfigInterfaceEntity.setStatus(Integer.valueOf(1));
            cfgConfigInterfaceEntity.setProcessFlag("S");
            cfgConfigInterfaceEntity.setBatchNo(importBatchNo);
            cfgConfigInterfaceEntities.add(cfgConfigInterfaceEntity);
        });
        this.cfgConfigInterfaceExtDao.batchInsertWithDefaultValue((List)cfgConfigInterfaceEntities);
    }

    public List<SellerBusinessConfig> queryConfigByBatchNo(Long batchNo) {
        List cfgConfigInterfaceEntities = this.cfgConfigInterfaceExtDao.queryByBatchNo(batchNo);
        List<SellerBusinessConfig> collect = cfgConfigInterfaceEntities.stream().map(cfgConfigInterfaceEntity -> (SellerBusinessConfig)JsonUtils.writeFastJsonToObject((String)cfgConfigInterfaceEntity.getOrigData(), SellerBusinessConfig.class)).collect(Collectors.toList());
        return collect;
    }

    private void checkTerminal(TerminalConfig terminalConfig, long groupId, StringBuilder sb, CheckTerminalResponseVo checkTerminalResponseVo, List<String> userCompanyTaxNos, UserInfo userInfo) {
        String terminalNo = terminalConfig.getTerminalNo();
        String terminalName = terminalConfig.getTerminalName();
        String companyName = terminalConfig.getCompanyName();
        String companyTaxNo = terminalConfig.getCompanyTaxNo();
        String supportService = terminalConfig.getSupportService();
        String terminalType = terminalConfig.getTerminalType();
        String deviceNo = terminalConfig.getDeviceNo();
        String invoiceType = terminalConfig.getInvoiceType();
        if (StringUtils.isEmpty((CharSequence)terminalName)) {
            sb.append("\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StringUtils.isEmpty((CharSequence)companyName)) {
            sb.append("\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StringUtils.isEmpty((CharSequence)companyTaxNo)) {
            sb.append("\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a;");
        } else {
            UserCenterResponse companyReply;
            if (CollectionUtils.isEmpty(userCompanyTaxNos) || !userCompanyTaxNos.contains(companyTaxNo)) {
                sb.append("\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u8be5\u516c\u53f8;");
            }
            if (!"1".equals((companyReply = this.userCenterController.getCompanyByTaxNo(groupId, companyTaxNo)).getCode()) || !Optional.ofNullable(companyReply.getResult()).map(CompanyData::getCompanyName).filter(r -> r.equals(companyName)).isPresent()) {
                sb.append("\u516c\u53f8\u540d\u79f0\u4e0d\u5408\u6cd5;");
            } else {
                checkTerminalResponseVo.setCompanyId(((CompanyData)companyReply.getResult()).getCompanyId().longValue());
            }
        }
        if (StringUtils.isEmpty((CharSequence)supportService)) {
            sb.append("\u670d\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;");
        } else {
            String[] supportServiceArr;
            ArrayList<String> supportServiceList = new ArrayList<String>();
            for (String str : supportServiceArr = supportService.split(",")) {
                if ("1".equals(str)) {
                    supportServiceList.add("make");
                    continue;
                }
                if ("2".equals(str)) {
                    supportServiceList.add("print");
                    continue;
                }
                if ("3".equals(str)) {
                    supportServiceList.add("originAccount");
                    continue;
                }
                if ("4".equals(str)) {
                    supportServiceList.add("assistant");
                    continue;
                }
                sb.append("\u670d\u52a1\u7c7b\u578b\u586b\u5199\u4e0d\u6b63\u786e;");
                break;
            }
            checkTerminalResponseVo.setSupportServiceList(supportServiceList);
        }
        if (StringUtils.isEmpty((CharSequence)terminalType)) {
            sb.append("\u7ec8\u7aef\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;");
        } else if (!TerminalType.getValues().contains(terminalType)) {
            sb.append("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7ec8\u7aef\u7c7b\u578b;");
        } else if (terminalType.equals(String.valueOf(TerminalType.SERVER.getValue()))) {
            if (StringUtils.isEmpty((CharSequence)deviceNo)) {
                sb.append("\u7a0e\u63a7\u8bbe\u5907\u4e0d\u80fd\u4e3a\u7a7a;");
            } else {
                ArrayList taxDeviceTypes = Lists.newArrayList((Object[])new Integer[]{2, 4});
                MsQueryDeviceResponse msQueryDeviceResponse = this.configDeviceService.queryAllTaxDeviceByTaxDeviceTypes((List)taxDeviceTypes, groupId, userInfo);
                if (msQueryDeviceResponse == null || msQueryDeviceResponse.getCode().equals(BaseResponse.Fail)) {
                    sb.append("\u7a0e\u63a7\u8bbe\u5907\u4e0d\u5b58\u5728;");
                } else {
                    boolean isLegal = false;
                    for (MsDeviceInfo msDeviceInfo : msQueryDeviceResponse.getResult().getDevices()) {
                        if (!deviceNo.equals(msDeviceInfo.getDeviceNo())) continue;
                        checkTerminalResponseVo.setDeviceId(msDeviceInfo.getId());
                        isLegal = true;
                        break;
                    }
                    if (!isLegal) {
                        sb.append("\u7a0e\u63a7\u8bbe\u5907\u4e0d\u5b58\u5728;");
                    }
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)invoiceType)) {
            sb.append("\u5f00\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;");
        }
    }

    private MsConfigUpdateTerminalRequest buildMsConfigUpdateTerminalRequest(long id, Long deviceId, String deviceUn, TerminalConfig terminalConfig, CheckTerminalResponseVo checkTerminalResponseVo) {
        MsUpdateTerminalInfo updateTerminalInfo = new MsUpdateTerminalInfo();
        updateTerminalInfo.setId(Long.valueOf(id));
        updateTerminalInfo.setDeviceId(deviceId);
        updateTerminalInfo.setDeviceUn(deviceUn);
        updateTerminalInfo.setInvoiceType(Arrays.asList(terminalConfig.getInvoiceType().split(",")));
        updateTerminalInfo.setSupportService(checkTerminalResponseVo.getSupportServiceList());
        updateTerminalInfo.setTerminalName(terminalConfig.getTerminalName());
        updateTerminalInfo.setTerminalNo(terminalConfig.getTerminalNo());
        updateTerminalInfo.setTerminalType(Integer.valueOf(Integer.parseInt(terminalConfig.getTerminalType())));
        MsConfigUpdateTerminalRequest msConfigUpdateTerminalRequest = new MsConfigUpdateTerminalRequest();
        msConfigUpdateTerminalRequest.setTerminalInfo(updateTerminalInfo);
        return msConfigUpdateTerminalRequest;
    }

    private MsConfigAddTerminalRequest buildMsConfigAddTerminalRequest(TerminalConfig terminalConfig, CheckTerminalResponseVo checkTerminalResponseVo) {
        MsTerminalInfo insertTerminalInfo = new MsTerminalInfo();
        insertTerminalInfo.setInvoiceType(Arrays.asList(terminalConfig.getInvoiceType().split(",")));
        insertTerminalInfo.setDeviceId(checkTerminalResponseVo.getDeviceId());
        insertTerminalInfo.setSupportService(checkTerminalResponseVo.getSupportServiceList());
        insertTerminalInfo.setTerminalName(terminalConfig.getTerminalName());
        insertTerminalInfo.setTerminalNo(terminalConfig.getTerminalNo());
        insertTerminalInfo.setTerminalType(Integer.valueOf(Integer.parseInt(terminalConfig.getTerminalType())));
        insertTerminalInfo.setStatus(Integer.valueOf(11));
        MsCompanyInfo companyInfo = new MsCompanyInfo();
        companyInfo.setCompanyId(Long.valueOf(checkTerminalResponseVo.getCompanyId()));
        insertTerminalInfo.setCompanyInfo(companyInfo);
        MsConfigAddTerminalRequest msConfigAddTerminalRequest = new MsConfigAddTerminalRequest();
        msConfigAddTerminalRequest.setTerminalInfo(insertTerminalInfo);
        return msConfigAddTerminalRequest;
    }

    private MsTerminalQueryResponseInfo getTerminalList(String terminalNo, long groupId, UserInfo userInfo) {
        MsConfigTemialQueryRequest msConfigTemialQueryRequest = new MsConfigTemialQueryRequest();
        MsTerminalQueryInfo terminalInfo = new MsTerminalQueryInfo();
        terminalInfo.setTerminalNo(terminalNo);
        MsCompanyInfo msCompanyInfo = new MsCompanyInfo();
        msCompanyInfo.setTenantId(Long.valueOf(groupId));
        terminalInfo.setCompanyInfo(msCompanyInfo);
        msConfigTemialQueryRequest.setTerminalInfo(terminalInfo);
        MsPageInfo pageInfo = new MsPageInfo();
        pageInfo.setPageNo(Integer.valueOf(1));
        pageInfo.setPageSize(Integer.valueOf(50));
        msConfigTemialQueryRequest.setPageInfo(pageInfo);
        MsQueryTerminalResponse response2 = this.configTerminalService.getTerminalList(msConfigTemialQueryRequest, userInfo);
        for (MsTerminalQueryResponseInfo msTerminalQueryResponseInfo : response2.getResult().getTerminals()) {
            if (!terminalNo.equals(msTerminalQueryResponseInfo.getTerminalNo())) continue;
            return msTerminalQueryResponseInfo;
        }
        return null;
    }
}

