/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.alibaba.excel.EasyExcel;
import com.google.common.collect.Lists;
import com.xforceplus.notice.client.model.MsDoBase;
import com.xforceplus.notice.client.model.MsOperateMessageRequest;
import com.xforceplus.notice.client.model.MsOperateMessageResponse;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.oss.Module;
import com.xforceplus.phoenix.oss.OssUtil;
import com.xforceplus.seller.config.infrastructure.client.MessageClient;
import com.xforceplus.seller.config.models.InventoryConfigImportData;
import com.xforceplus.seller.config.models.TerminalConfig;
import com.xforceplus.seller.config.services.MessageHelper;
import com.xforceplus.seller.config.util.DateTools;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ImportFailConfigServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(ImportFailConfigServiceImpl.class);
    @Value(value="${send.message.flag}")
    private int sendFlag;
    static final List<String> templateTerminalList = Lists.newArrayList((Object[])new String[]{"\u9519\u8bef\u4fe1\u606f", "\u7ec8\u7aef\u4ee3\u7801", "\u7ec8\u7aef\u540d\u79f0", "\u516c\u53f8\u540d\u79f0", "\u516c\u53f8\u7a0e\u53f7", "\u670d\u52a1\u7c7b\u578b", "\u7ec8\u7aef\u7c7b\u578b", "\u7a0e\u63a7\u8bbe\u5907", "\u5f00\u7968\u7c7b\u578b"});
    @Autowired
    private OssUtil ossUtil;
    @Autowired
    private MessageClient messageClient;
    @Autowired
    private IDGenerator iDGenerator;
    @Autowired
    private MessageHelper messageHelper;

    public void dealFailTerminalImport(List<TerminalConfig> errorList, Map<String, Object> headers, int insertTotal, int updateTotal) {
        try {
            String fileOriginName = headers.get("fileOriginName") == null ? "" : headers.get("fileOriginName").toString();
            long groupId = headers.get("groupId") == null ? -1L : Long.parseLong(headers.get("groupId").toString());
            long userId = headers.get("userId") == null ? -1L : Long.parseLong(headers.get("userId").toString());
            UserInfo userInfo = new UserInfo();
            userInfo.setGroupId(groupId);
            userInfo.setUserId(userId);
            String userName = headers.get("userName") == null ? "" : headers.get("userName").toString();
            String key = null;
            if (errorList.size() > 0) {
                HSSFWorkbook workbook = new HSSFWorkbook();
                Sheet sheet = workbook.createSheet("\u5355\u636e\u5bfc\u5165\u5931\u8d25\u539f\u56e0");
                sheet.setDefaultColumnWidth(15);
                sheet.setForceFormulaRecalculation(true);
                ImportFailConfigServiceImpl.buildTerminalHeader((Sheet)sheet);
                ImportFailConfigServiceImpl.buildTerminalBody((Sheet)sheet, errorList);
                String filepath = "file/import-fail/" + Module.SELLER.value() + "/" + DateTools.day() + "/" + this.iDGenerator.nextId() + ".xls";
                key = this.putFile((Workbook)workbook, filepath);
                logger.info("\u4e0a\u4f20\u7ec8\u7aef\u5bfc\u5165\u6587\u4ef6\u6210\u529foss key:{}", (Object)key);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String title = sdf.format(new Date()) + ",\u7ec8\u7aef\u5bfc\u5165excel\u6587\u4ef6\u3010" + fileOriginName + "\u3011\u5bfc\u5165";
            String url = "";
            if (StringUtils.isNotBlank(key)) {
                url = this.ossUtil.fileKeyToDownloadUrlViaPlatform(key);
                logger.info("download url is : {}", (Object)url);
            }
            String content = "\u65b0\u589e" + insertTotal + "\u6761,\u4fee\u6539" + updateTotal + "\u6761,\u5bfc\u5165\u5931\u8d25" + errorList.size() + "\u6761\uff0c\u8be6\u89c1\u4e0b\u8f7d\u6587\u4ef6";
            if (1 == this.sendFlag || 2 == this.sendFlag) {
                this.messageHelper.sendMessageMiddle(userInfo, title, content, url);
                if (1 == this.sendFlag) {
                    return;
                }
            }
            MsOperateMessageRequest request = new MsOperateMessageRequest();
            request.setMessageUrl(url);
            request.setMessageTitle(title);
            request.setGroupId(Long.valueOf(groupId));
            request.setMessageContent(content);
            request.setMessageId(Long.valueOf(this.iDGenerator.nextId()));
            request.setMessageType(Integer.valueOf(1));
            request.setMessageValue(Long.valueOf(1L));
            request.setUserId(Long.valueOf(userId));
            request.setAppid("config-service");
            request.setDoType(MsDoBase.DoTypeEnum.I);
            request.setOperater(userName);
            request.setOperaterid(String.valueOf(userId));
            request.setRid(String.valueOf(this.iDGenerator.nextId()));
            MsOperateMessageResponse reponse = this.messageClient.operateMessage(request);
            logger.info("reponse:{}", (Object)JsonUtils.writeObjectToFastJson((Object)reponse));
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u7ec8\u7aef\u5b58\u50a8\u5931\u8d25\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putFile(Workbook workbook, String filePath) throws IOException {
        OutputStream out = null;
        File localFile = null;
        try {
            localFile = new File(filePath);
            if (!localFile.getParentFile().exists()) {
                localFile.getParentFile().mkdirs();
            }
            out = new FileOutputStream(localFile);
            workbook.write(out);
            String key = this.ossUtil.uploadFileInternal(filePath, Module.SELLER, true);
            localFile.delete();
            String string = key;
            return string;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5230oss\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (localFile != null) {
                localFile.delete();
            }
        }
    }

    private static void buildTerminalHeader(Sheet sheet) {
        Row row = sheet.createRow(0);
        CellStyle cellStyle = ImportFailConfigServiceImpl.getCellStyle((Workbook)row.getSheet().getWorkbook());
        for (int columnIndex = 0; columnIndex < templateTerminalList.size(); ++columnIndex) {
            Cell cell = row.createCell(columnIndex);
            String val = (String)templateTerminalList.get(columnIndex);
            cell.setCellValue(val == null ? "" : val.toString());
            cell.setCellStyle(cellStyle);
        }
    }

    private static void buildTerminalBody(Sheet sheet, List<TerminalConfig> errorList) throws IllegalArgumentException, IllegalAccessException {
        CellStyle cellStyle = ImportFailConfigServiceImpl.getBodyCellStyle((Workbook)sheet.getWorkbook());
        for (int rowNum = 0; rowNum < errorList.size(); ++rowNum) {
            int tmpRowNum = rowNum + 1;
            Row row = sheet.createRow(tmpRowNum);
            TerminalConfig terminalConfig = errorList.get(tmpRowNum - 1);
            Field[] fields = terminalConfig.getClass().getDeclaredFields();
            for (int columnIndex = 0; columnIndex < fields.length; ++columnIndex) {
                Field field = fields[columnIndex];
                field.setAccessible(true);
                Object val = field.get(terminalConfig);
                Cell cell = row.createCell(columnIndex);
                cell.setCellValue(val == null ? "" : val.toString());
                cell.setCellStyle(cellStyle);
            }
        }
    }

    public static CellStyle getCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static CellStyle getBodyCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public void dealFailInventoryConfigImport(List<InventoryConfigImportData> list, Map<String, Object> headers, Integer successCount) {
        try {
            long groupId = headers.get("groupId") == null ? -1L : Long.parseLong(headers.get("groupId").toString());
            long userId = headers.get("userId") == null ? -1L : Long.parseLong(headers.get("userId").toString());
            UserInfo userInfo = new UserInfo();
            userInfo.setGroupId(groupId);
            userInfo.setUserId(userId);
            String url = "";
            if (CollectionUtils.isNotEmpty(list)) {
                String filepath = "file/import-fail/" + Module.SELLER.value() + "/" + DateTools.day() + "/" + this.iDGenerator.nextId() + ".xls";
                File file = new File(filepath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                EasyExcel.write((String)filepath, InventoryConfigImportData.class).sheet("\u5e93\u5b58\u9884\u8b66\u914d\u7f6e\u5bfc\u5165\u5931\u8d25\u7ed3\u679c").doWrite(list);
                String key = this.ossUtil.uploadFileInternal(filepath, Module.SELLER, true);
                url = this.ossUtil.fileKeyToDownloadUrlViaPlatform(key);
                FileUtils.deleteQuietly((File)file);
            }
            String title = "\u5e93\u5b58\u9884\u8b66\u89c4\u5219\u5bfc\u5165\u7ed3\u679c";
            String content = "\u6210\u529f" + successCount + "\u6761\uff0c\u5931\u8d25" + list.size() + "\u6761";
            this.messageHelper.sendMessageMiddle(userInfo, title, content, url);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u7ec8\u7aef\u5b58\u50a8\u5931\u8d25\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    public <T> void dealFailBusinessConfigImport(List<T> list, Long userId, Long groupId, Integer successCount, Class<T> tClass) {
        try {
            UserInfo userInfo = new UserInfo();
            userInfo.setGroupId(groupId.longValue());
            userInfo.setUserId(userId.longValue());
            String url = "";
            if (CollectionUtils.isNotEmpty(list)) {
                String filepath = "file/import-fail/" + Module.SELLER.value() + "/" + DateTools.day() + "/" + this.iDGenerator.nextId() + ".xls";
                File file = new File(filepath);
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                EasyExcel.write((String)filepath, tClass).sheet("\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e\u5bfc\u5165\u5931\u8d25\u7ed3\u679c").doWrite(list);
                String key = this.ossUtil.uploadFileInternal(filepath, Module.SELLER, true);
                url = this.ossUtil.fileKeyToDownloadUrlViaPlatform(key);
                FileUtils.deleteQuietly((File)file);
            }
            String title = "\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e\u5bfc\u5165\u7ed3\u679c";
            String content = "\u6210\u529f" + successCount + "\u6761\uff0c\u5931\u8d25" + list.size() + "\u6761";
            this.messageHelper.sendMessageMiddle(userInfo, title, content, url);
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u7ec8\u7aef\u5b58\u50a8\u5931\u8d25\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }
}

