/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.google.common.collect.Lists;
import com.xforceplus.notice.client.model.MsDoBase;
import com.xforceplus.notice.client.model.MsOperateMessageRequest;
import com.xforceplus.notice.client.model.MsOperateMessageResponse;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.oss.Module;
import com.xforceplus.phoenix.oss.OssUtil;
import com.xforceplus.seller.config.client.model.UserRelationData;
import com.xforceplus.seller.config.config.ConfigTerminalProperties;
import com.xforceplus.seller.config.infrastructure.client.MessageClient;
import com.xforceplus.seller.config.services.MessageHelper;
import com.xforceplus.seller.config.util.DateTools;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ImportFailRelationIssueServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ImportFailRelationIssueServiceImpl.class);
    private static final List<String> userRelationList = Lists.newArrayList((Object[])new String[]{"\u9519\u8bef\u4fe1\u606f", "\u5173\u7cfb\u7c7b\u578b", "\u7528\u6237Id", "\u6240\u5c5e\u7a0e\u53f7", "\u516c\u53f8\u7a0e\u53f7", "\u6240\u5c5e\u79df\u6237id", "\u72b6\u6001", "\u5f00\u7968\u4eba\u552f\u4e00\u6807\u8bc6", "\u5f00\u7968\u4eba"});
    private final OssUtil ossUtil;
    private final MessageClient messageClient;
    private final IDGenerator iDGenerator;
    private final MessageHelper messageHelper;
    private final ConfigTerminalProperties configTerminalProperties;

    public void dealFailImportUserRelationList(List<UserRelationData.UserRelationErrorInfo> errorList, Map<String, Object> headers, int insertTotal, int updateTotal) {
        try {
            String fileOriginName = headers.get("fileOriginName") == null ? "" : headers.get("fileOriginName").toString();
            long groupId = headers.get("groupId") == null ? -1L : Long.parseLong(headers.get("groupId").toString());
            long userId = headers.get("userId") == null ? -1L : Long.parseLong(headers.get("userId").toString());
            UserInfo userInfo = new UserInfo();
            userInfo.setGroupId(groupId);
            userInfo.setUserId(userId);
            String userName = headers.get("userName") == null ? "" : headers.get("userName").toString();
            String key = null;
            if (errorList.size() > 0) {
                HSSFWorkbook workbook = new HSSFWorkbook();
                Sheet sheet = workbook.createSheet("\u4eba\u5458\u5f00\u7968\u4fe1\u606f\u5173\u7cfb\u5165\u5931\u8d25\u539f\u56e0");
                sheet.setDefaultColumnWidth(15);
                sheet.setForceFormulaRecalculation(true);
                this.buildTerminalHeader(sheet);
                this.buildUserRelationBody(sheet, errorList);
                String filepath = "file/import-fail/" + Module.SELLER.value() + "/" + DateTools.day() + "/" + this.iDGenerator.nextId() + ".xls";
                key = this.putFile((Workbook)workbook, filepath);
                log.info("\u4e0a\u4f20\u7ec8\u7aef\u5bfc\u5165\u6587\u4ef6\u6210\u529foss key:{}", (Object)key);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String title = sdf.format(new Date()) + ",\u7ec8\u7aef\u5bfc\u5165excel\u6587\u4ef6\u3010" + fileOriginName + "\u3011\u5bfc\u5165";
            String url = "";
            if (StringUtils.isNotBlank(key)) {
                url = this.ossUtil.fileKeyToDownloadUrlViaPlatform(key);
                log.info("download url is : {}", (Object)url);
            }
            String content = "\u65b0\u589e" + insertTotal + "\u6761,\u4fee\u6539" + updateTotal + "\u6761,\u5bfc\u5165\u5931\u8d25" + errorList.size() + "\u6761\uff0c\u8be6\u89c1\u4e0b\u8f7d\u6587\u4ef6";
            if (1 == this.configTerminalProperties.getSendFlag() || 2 == this.configTerminalProperties.getSendFlag()) {
                this.messageHelper.sendMessageMiddle(userInfo, title, content, url);
                if (1 == this.configTerminalProperties.getSendFlag()) {
                    return;
                }
            }
            MsOperateMessageRequest request = new MsOperateMessageRequest();
            request.setMessageUrl(url);
            request.setMessageTitle(title);
            request.setGroupId(Long.valueOf(groupId));
            request.setMessageContent(content);
            request.setMessageId(Long.valueOf(this.iDGenerator.nextId()));
            request.setMessageType(Integer.valueOf(1));
            request.setMessageValue(Long.valueOf(1L));
            request.setUserId(Long.valueOf(userId));
            request.setAppid("config-service");
            request.setDoType(MsDoBase.DoTypeEnum.I);
            request.setOperater(userName);
            request.setOperaterid(String.valueOf(userId));
            request.setRid(String.valueOf(this.iDGenerator.nextId()));
            MsOperateMessageResponse reponse = this.messageClient.operateMessage(request);
            log.info("\u4eba\u5458\u5f00\u7968\u4fe1\u606f\u5173\u7cfb reponse:{}", (Object)JsonUtils.writeObjectToFastJson((Object)reponse));
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u7ec8\u7aef\u5b58\u50a8\u5931\u8d25\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putFile(Workbook workbook, String filePath) throws IOException {
        OutputStream out = null;
        File localFile = null;
        try {
            localFile = new File(filePath);
            if (!localFile.getParentFile().exists()) {
                localFile.getParentFile().mkdirs();
            }
            out = new FileOutputStream(localFile);
            workbook.write(out);
            String key = this.ossUtil.uploadFileInternal(filePath, Module.SELLER, true);
            localFile.delete();
            String string = key;
            return string;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230oss\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (localFile != null) {
                localFile.delete();
            }
        }
    }

    private void buildTerminalHeader(Sheet sheet) {
        Row row = sheet.createRow(0);
        CellStyle cellStyle = ImportFailRelationIssueServiceImpl.getCellStyle((Workbook)row.getSheet().getWorkbook());
        for (int columnIndex = 0; columnIndex < userRelationList.size(); ++columnIndex) {
            Cell cell = row.createCell(columnIndex);
            String val = (String)userRelationList.get(columnIndex);
            cell.setCellValue(val == null ? "" : val.toString());
            cell.setCellStyle(cellStyle);
        }
    }

    private void buildUserRelationBody(Sheet sheet, List<UserRelationData.UserRelationErrorInfo> errorList) throws IllegalArgumentException, IllegalAccessException {
        CellStyle cellStyle = ImportFailRelationIssueServiceImpl.getBodyCellStyle((Workbook)sheet.getWorkbook());
        for (int rowNum = 0; rowNum < errorList.size(); ++rowNum) {
            int tmpRowNum = rowNum + 1;
            Row row = sheet.createRow(tmpRowNum);
            UserRelationData.UserRelationInfo userRelationInfo = (UserRelationData.UserRelationInfo)errorList.get(tmpRowNum - 1);
            Field[] fields = userRelationInfo.getClass().getDeclaredFields();
            for (int columnIndex = 0; columnIndex < fields.length; ++columnIndex) {
                Field field = fields[columnIndex];
                field.setAccessible(true);
                Object val = field.get(userRelationInfo);
                Cell cell = row.createCell(columnIndex);
                cell.setCellValue(val == null ? "" : val.toString());
                cell.setCellStyle(cellStyle);
            }
        }
    }

    public static CellStyle getCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static CellStyle getBodyCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public ImportFailRelationIssueServiceImpl(OssUtil ossUtil, MessageClient messageClient, IDGenerator iDGenerator, MessageHelper messageHelper, ConfigTerminalProperties configTerminalProperties) {
        this.ossUtil = ossUtil;
        this.messageClient = messageClient;
        this.iDGenerator = iDGenerator;
        this.messageHelper = messageHelper;
        this.configTerminalProperties = configTerminalProperties;
    }
}

