/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.alibaba.excel.EasyExcel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.notice.client.model.MsDoBase;
import com.xforceplus.notice.client.model.MsOperateMessageRequest;
import com.xforceplus.notice.client.model.MsOperateMessageResponse;
import com.xforceplus.phoenix.file.utils.CommonTools;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.phoenix.oss.Module;
import com.xforceplus.phoenix.oss.OssUtil;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.InvoiceType;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigPageDTO;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequestWithUserInfo;
import com.xforceplus.seller.config.client.translater.MsConfigQueryRequestTranslater;
import com.xforceplus.seller.config.converters.CommonConverter;
import com.xforceplus.seller.config.infrastructure.client.MessageClient;
import com.xforceplus.seller.config.models.ExportConfigModel;
import com.xforceplus.seller.config.models.ExportErrorModel;
import com.xforceplus.seller.config.models.ExportInvoiceAgentModel;
import com.xforceplus.seller.config.models.ExportSplitModel;
import com.xforceplus.seller.config.repository.dao.CfgConfigInterfaceDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInterfaceExtDao;
import com.xforceplus.seller.config.repository.model.CfgConfigInterfaceEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigInterfaceExample;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.ImportReasonTools;
import com.xforceplus.seller.config.services.MessageHelper;
import com.xforceplus.seller.config.util.ConvertUtils;
import com.xforceplus.seller.config.util.DateTools;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.apimodel.file.ImportResponse;
import com.xforceplus.xplatframework.apimodel.file.ImportResult;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ImportReasonTools {
    @Autowired
    CfgConfigInterfaceDao cfgConfigInterfaceDao;
    @Autowired
    private OssUtil ossUtil;
    @Autowired
    private MessageHelper messageHelper;
    @Autowired
    IDGenerator iDGenerator;
    @Autowired
    MessageClient messageClient;
    @Autowired
    CfgConfigInterfaceExtDao cfgConfigInterfaceExtDao;
    @Autowired
    CommonConverter commonConverter;
    @Autowired
    UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    ConfigBizConfigService configBizConfigService;
    @Autowired
    ConvertUtils convertUtils;
    @Value(value="${send.message.flag}")
    private int sendFlag;
    private static final Logger logger = LoggerFactory.getLogger(ImportReasonTools.class);
    public static SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    public static final List<String> splitTemplateList = Lists.newArrayList((Object[])new String[]{"\u521b\u5efa\u65b9", "\u9500\u65b9\u540d\u79f0", "\u9500\u65b9\u7a0e\u53f7", "\u8d2d\u65b9\u540d\u79f0", "\u8d2d\u65b9\u7a0e\u53f7", "\u89c4\u5219\u540d\u79f0", "\u4e1a\u52a1\u5355\u7c7b\u578b", "\u53d1\u7968\u7c7b\u578b", "\u91d1\u989d\u62c6\u5206\u89c4\u5219", "\u7968\u9762\u6700\u5927\u884c\u6570", "\u5f00\u7968\u9650\u989d", "\u660e\u7ec6\u987a\u5e8f", "\u9500\u8d27\u6e05\u5355\u9009\u9879", "\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570", "\u7a0e\u63a7\u8bbe\u5907\u7c7b\u578b", "\u5355\u4ef7\u6570\u91cf\u9009\u9879", "\u62c6\u5206\u5b57\u6bb5", "\u5907\u6ce8\u5b57\u6bb5"});
    public static final List<String> titleTemplateList = Lists.newArrayList((Object[])new String[]{"\u521b\u5efa\u65b9", "\u9500\u65b9\u540d\u79f0", "\u9500\u65b9\u7a0e\u53f7", "\u8d2d\u65b9\u540d\u79f0", "\u8d2d\u65b9\u7a0e\u53f7", "\u9500\u65b9\u7a0e\u53f7", "\u89c4\u5219\u540d\u79f0", "\u4e1a\u52a1\u5355\u7c7b\u578b", "\u9500\u65b9\u5730\u5740", "\u9500\u65b9\u94f6\u884c\u8d26\u53f7", "\u9500\u65b9\u5f00\u6237\u884c", "\u9500\u65b9\u7535\u8bdd"});
    public static final List<String> firstIssuerTemplateList = Lists.newArrayList((Object[])new String[]{"\u521b\u5efa\u65b9", "\u9500\u65b9\u540d\u79f0", "\u9500\u65b9\u7a0e\u53f7", "\u8d2d\u65b9\u540d\u79f0", "\u8d2d\u65b9\u7a0e\u53f7", "\u9500\u65b9\u7a0e\u53f7", "\u89c4\u5219\u540d\u79f0", "\u4e1a\u52a1\u5355\u7c7b\u578b", "\u4f18\u5148\u5f00\u7968\u4eba", "\u5168\u7535\u5f00\u7968\u65b9\u5f0f"});
    public static final List<String> multiTitleTemplateList = Lists.newArrayList((Object[])new String[]{"\u9500\u65b9\u540d\u79f0", "\u9500\u65b9\u7a0e\u53f7", "\u9500\u65b9\u5730\u5740", "\u9500\u65b9\u94f6\u884c\u8d26\u53f7", "\u9500\u65b9\u5f00\u6237\u884c", "\u9500\u65b9\u7535\u8bdd"});
    public static final List<String> personTemplateList = Lists.newArrayList((Object[])new String[]{"\u521b\u5efa\u65b9", "\u9500\u65b9\u540d\u79f0", "\u9500\u65b9\u7a0e\u53f7", "\u8d2d\u65b9\u540d\u79f0", "\u8d2d\u65b9\u7a0e\u53f7", "\u9500\u65b9\u7a0e\u53f7", "\u89c4\u5219\u540d\u79f0", "\u4e1a\u52a1\u5355\u7c7b\u578b", "\u5f00\u7968\u4eba", "\u590d\u6838\u4eba", "\u6536\u6b3e\u4eba"});
    public static Map<String, String> templateMap = Maps.newHashMap();

    public Response handleUploadMsg(Map<String, Object> headers) {
        if (headers.get("importBatchNo") != null) {
            Long importBatchNo = (Long)headers.get("importBatchNo");
            String fileOriginName = (String)headers.get("fileOriginName");
            int configType = (Integer)headers.get("configType");
            UserInfo userInfo = (UserInfo)JsonUtils.writeFastJsonToObject((String)((String)headers.get("userInfo")), UserInfo.class);
            logger.info("importBatchNo:{}", (Object)importBatchNo);
            logger.info("fileOriginName:{}", (Object)fileOriginName);
            try {
                CfgConfigInterfaceExample example = new CfgConfigInterfaceExample();
                example.createCriteria().andBatchNoEqualTo(importBatchNo).andProcessFlagEqualTo("F");
                List cfgConfigInterfaceEntities = this.cfgConfigInterfaceDao.selectByExampleWithBLOBs(example);
                if (CollectionUtils.isEmpty((Collection)cfgConfigInterfaceEntities)) {
                    return Response.failed((String)"\u751f\u6210\u5931\u8d25");
                }
                HashMap descMap = Maps.newHashMap();
                ArrayList headList = Lists.newArrayList();
                ArrayList headDescList = Lists.newArrayList();
                headDescList.add("\u5931\u8d25\u539f\u56e0");
                descMap.put("\u5931\u8d25\u539f\u56e0", "mainReason");
                descMap.putAll(templateMap);
                if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType() == configType) {
                    headDescList.addAll(splitTemplateList);
                } else if (ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType() == configType) {
                    headDescList.addAll(titleTemplateList);
                } else if (ConfigTypeEnum.FIRST_INVOICER.getConfigType() == configType) {
                    headDescList.addAll(firstIssuerTemplateList);
                } else if (ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType() == configType) {
                    headDescList.addAll(personTemplateList);
                } else if (ConfigTypeEnum.MULTI_INVOICE_TITLE_CONFIG_TYPE.getConfigType() == configType) {
                    headDescList.addAll(multiTitleTemplateList);
                } else {
                    throw new RuntimeException("\u751f\u6210\u5bfc\u5165\u5931\u8d25\u539f\u56e0EXCl\u5931\u8d25");
                }
                headList.addAll(headDescList.stream().map(descMap::get).collect(Collectors.toList()));
                ArrayList dataList2 = Lists.newArrayList();
                for (CfgConfigInterfaceEntity entity : cfgConfigInterfaceEntities) {
                    String origData = entity.getOrigData();
                    Map data = JsonUtils.writeFastJsonToMap((String)origData);
                    data.put("mainReason", entity.getProcessRemark());
                    dataList2.add(data);
                }
                logger.info("dataList size:{}", (Object)dataList2.size());
                HSSFWorkbook workbook = new HSSFWorkbook();
                Sheet sheet = workbook.createSheet("\u914d\u7f6e\u89c4\u5219\u5bfc\u5165\u5931\u8d25\u539f\u56e0");
                sheet.setDefaultColumnWidth(15);
                sheet.setForceFormulaRecalculation(true);
                ImportReasonTools.buildHeader((Sheet)sheet, (List)headList, (List)headDescList);
                ImportReasonTools.buildBody((Sheet)sheet, (List)headList, (List)dataList2);
                String filepath = "file/import-fail/" + Module.SELLER.value() + "/" + DateTools.day() + "/" + importBatchNo + ".xls";
                String key = this.putFile((Workbook)workbook, filepath);
                logger.info("\u4e0a\u4f20\u5355\u636e\u5931\u8d25\u6587\u4ef6\u6210\u529foss key:{}", (Object)key);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String title = sdf.format(new Date()) + ",\u914d\u7f6e\u89c4\u5219excel\u6587\u4ef6\u3010" + fileOriginName + "\u3011\u5bfc\u5165";
                String url = this.ossUtil.fileKeyToDownloadUrlViaPlatform(key);
                String content = "\u5bfc\u5165\u5931\u8d25" + cfgConfigInterfaceEntities.size() + "\u6761\uff0c\u8be6\u89c1\u4e0b\u8f7d\u6587\u4ef6";
                if (1 == this.sendFlag || 2 == this.sendFlag) {
                    this.messageHelper.sendMessageMiddle(userInfo, title, content, url);
                    if (1 == this.sendFlag) {
                        return Response.ok((String)"\u751f\u6210\u6210\u529f");
                    }
                }
                MsOperateMessageRequest request = new MsOperateMessageRequest();
                request.setMessageTitle(title);
                request.setMessageUrl(url);
                logger.info("download url is : {}", (Object)request.getMessageUrl());
                request.setGroupId(Long.valueOf(userInfo.getGroupId()));
                request.setMessageContent(content);
                request.setMessageId(Long.valueOf(this.iDGenerator.nextId()));
                request.setMessageType(Integer.valueOf(1));
                request.setMessageValue(Long.valueOf(1L));
                request.setUserId(Long.valueOf(userInfo.getUserId()));
                request.setAppid("config-service");
                request.setDoType(MsDoBase.DoTypeEnum.I);
                request.setOperater(userInfo.getUserName());
                request.setOperaterid(String.valueOf(userInfo.getUserId()));
                request.setRid(String.valueOf(this.iDGenerator.nextId()));
                MsOperateMessageResponse reponse = this.messageClient.operateMessage(request);
                logger.info("reponse:{}", (Object)JsonUtils.writeObjectToFastJson((Object)reponse));
            }
            catch (Exception e) {
                logger.error("\u751f\u6210\u5355\u636e\u5bfc\u5165\u5931\u8d25\u539f\u56e0\u5f02\u5e38", (Throwable)e);
            }
        }
        return Response.ok((String)"\u751f\u6210\u6210\u529f");
    }

    private static void buildHeader(Sheet sheet, List<String> headList, List<String> headDescList) {
        Row row = sheet.createRow(0);
        CellStyle cellStyle = ImportReasonTools.getCellStyle((Workbook)row.getSheet().getWorkbook());
        for (int columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
            Cell cell = row.createCell(columnIndex);
            String val = headDescList.get(columnIndex);
            cell.setCellValue(val == null ? "" : val.toString());
            cell.setCellStyle(cellStyle);
        }
    }

    private static void buildBody(Sheet sheet, List<String> headList, List<Map<String, Object>> dataList2) {
        CellStyle cellStyle = ImportReasonTools.getBodyCellStyle((Workbook)sheet.getWorkbook());
        for (int rowNum = 1; rowNum <= dataList2.size(); ++rowNum) {
            Map<String, Object> map = dataList2.get(rowNum - 1);
            Row row = sheet.createRow(rowNum);
            for (int columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
                Cell cell = row.createCell(columnIndex);
                Object val = map.get(headList.get(columnIndex));
                cell.setCellValue(val == null ? "" : val.toString());
                cell.setCellStyle(cellStyle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String putFile(Workbook workbook, String filePath) throws IOException {
        OutputStream out = null;
        File localFile = null;
        try {
            String key;
            localFile = new File(filePath);
            if (!localFile.getParentFile().exists()) {
                localFile.getParentFile().mkdirs();
            }
            out = new FileOutputStream(localFile);
            workbook.write(out);
            String string = key = this.ossUtil.uploadFileInternal(filePath, Module.SELLER, true);
            return string;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u6587\u4ef6\u5230oss\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (localFile != null) {
                localFile.delete();
            }
        }
    }

    public static CellStyle getCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static CellStyle getBodyCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public ImportResponse queryResult(Long importBatchNo) {
        ImportResponse importResponse = new ImportResponse();
        ImportResult importResult = new ImportResult();
        List list = this.cfgConfigInterfaceExtDao.queryGroupByProcessFlagAndBatchNo(importBatchNo);
        list.forEach(item -> {
            if ("F".equals(item.get("processFlag"))) {
                importResult.setFail(Integer.valueOf(Integer.parseInt(String.valueOf(item.get("total")))));
            } else if ("S".equals(item.get("processFlag"))) {
                importResult.setSuccess(Integer.valueOf(Integer.parseInt(String.valueOf(item.get("total")))));
            }
        });
        importResponse.setResult(importResult);
        importResponse.setCode(Response.OK);
        return importResponse;
    }

    public ImportResponse queryBusinessConfigResult(Long importBatchNo) {
        logger.info("\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u5bfc\u5165\u7ed3\u679c\u8bf7\u6c42:importBatchNo:{}", (Object)importBatchNo);
        ImportResponse importResponse = new ImportResponse();
        importResponse.setCode(Response.OK);
        ImportResult importResult = new ImportResult();
        List list = this.cfgConfigInterfaceExtDao.queryGroupByProcessFlagAndBatchNo(importBatchNo);
        if (CollectionUtils.isEmpty((Collection)list)) {
            importResult.setIsDone(Boolean.valueOf(false));
            importResponse.setResult(importResult);
            return importResponse;
        }
        list.stream().forEach(item -> {
            if ("F".equals(item.get("processFlag"))) {
                importResult.setFail(Optional.ofNullable(item.get("total")).map(String::valueOf).map(Integer::parseInt).orElse(0));
            } else if ("S".equals(item.get("processFlag"))) {
                importResult.setSuccess(Optional.ofNullable(item.get("total")).map(String::valueOf).map(Integer::parseInt).orElse(0));
            }
        });
        importResult.setIsDone(Boolean.valueOf(true));
        importResponse.setResult(importResult);
        importResponse.setCode(Response.OK);
        logger.info("\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u5bfc\u5165\u7ed3\u679c importResponse:{}", (Object)JsonUtils.writeObjectToFastJson((Object)importResponse));
        return importResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Async
    public void exportConfig(MsConfigQueryRequestWithUserInfo request, UserInfo userInfo) {
        File file = null;
        try {
            Long groupId = userInfo.getGroupId();
            MsConfigPageDTO msConfigPageDTO = null;
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)request.getExportConfigIds())) {
                msConfigPageDTO = this.configBizConfigService.queryConfigListByIds(request.getExportConfigIds(), groupId);
            } else {
                request.pageSize(Integer.valueOf(1000));
                MsConfigQueryRequest msConfigQueryRequest = MsConfigQueryRequestTranslater.MsConfigQueryRequestWithUser2MsConfigQueryRequest((MsConfigQueryRequestWithUserInfo)request);
                msConfigPageDTO = this.configBizConfigService.queryConfigList(msConfigQueryRequest, groupId);
            }
            List configIds = msConfigPageDTO.getItemDTOList().stream().map(it -> it.getConfigId()).collect(Collectors.toList());
            MsConfigItemBatchQueryRequest cfgConfigItemRequest = new MsConfigItemBatchQueryRequest();
            cfgConfigItemRequest.setConfigIds(configIds);
            Map<Long, List<MsConfigItemBean>> itemMap = this.configBizConfigService.batchQueryConfigItemList(cfgConfigItemRequest).stream().collect(Collectors.groupingBy(MsConfigItemBean::getConfigId));
            ConfigTypeEnum configType = ConfigTypeEnum.of((Integer)request.getConfigType());
            switch (1.$SwitchMap$com$xforceplus$seller$config$client$constant$ConfigTypeEnum[configType.ordinal()]) {
                case 1: {
                    this.exportInvoiceConfig(itemMap, msConfigPageDTO, file, userInfo);
                    return;
                }
                case 2: {
                    this.exportInvoiceUser(itemMap, msConfigPageDTO, file, userInfo);
                    return;
                }
                case 3: {
                    this.exportSplitConfig(itemMap, msConfigPageDTO, file, userInfo);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            logger.error("exportConfig errors:{}", (Object)e.getMessage());
            e.printStackTrace();
            if (this.sendFlag != 1) return;
            this.sendMessage(userInfo, "\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u5bfc\u51fa", "\u5bfc\u51fa\u5931\u8d25", null);
            return;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    private void exportSplitConfig(Map<Long, List<MsConfigItemBean>> itemMap, MsConfigPageDTO msConfigPageDTO, File file, UserInfo userInfo) throws Exception {
        List result = this.commonConverter.convertToExportSplitModel(msConfigPageDTO.getItemDTOList());
        Map map = this.convertUtils.queryMetaData(result.stream().map(it -> it.getSalesbillType()).collect(Collectors.toList()), userInfo.getGroupId(), userInfo.getUserId());
        MsConfigPageDTO finalMsConfigPageDTO = msConfigPageDTO;
        IntStream.range(0, result.size()).forEach(index -> {
            List configItem;
            ExportSplitModel model = (ExportSplitModel)result.get(index);
            MsConfigBean msConfig = (MsConfigBean)finalMsConfigPageDTO.getItemDTOList().get(index);
            model.setBusinessBillType(msConfig.getBusinessBillType().equals("AP") ? "\u8d2d\u65b9" : "\u9500\u65b9");
            if (StringUtils.isBlank((CharSequence)model.getPurchaserName())) {
                model.setPurchaserName("\u5168\u90e8");
            }
            if (StringUtils.isBlank((CharSequence)model.getSellerName())) {
                model.setSellerName("\u5168\u90e8");
            }
            model.setTaxInvoiceSource("qd".equals(model.getTaxInvoiceSource()) ? "\u6570\u7535" : "\u7a0e\u63a7");
            if (InvoiceType.isValidInvoiceType((String)model.getInvoiceType())) {
                model.setInvoiceType(InvoiceType.fromValue((String)model.getInvoiceType()).description());
            }
            if (CollectionUtils.isEmpty((Collection)(configItem = (List)itemMap.get(msConfig.getConfigId())))) {
                return;
            }
            configItem.stream().forEach(it -> this.convertUtils.fillExportSplitModel(model, it, (List)map.get(model.getSalesbillType())));
        });
        this.sendExportMessage(file, result, ExportSplitModel.class, "\u62c6\u7968\u89c4\u5219\u4fe1\u606f", "\u62c6\u7968\u89c4\u5219\u4fe1\u606f\u5bfc\u51fa", userInfo);
    }

    private void exportInvoiceUser(Map<Long, List<MsConfigItemBean>> itemMap, MsConfigPageDTO msConfigPageDTO, File file, UserInfo userInfo) throws Exception {
        List result = this.commonConverter.convertToExportInvoiceAgentModel(msConfigPageDTO.getItemDTOList());
        MsConfigPageDTO finalMsConfigPageDTO = msConfigPageDTO;
        IntStream.range(0, result.size()).forEach(index -> {
            List configItem;
            ExportInvoiceAgentModel model = (ExportInvoiceAgentModel)result.get(index);
            MsConfigBean msConfig = (MsConfigBean)finalMsConfigPageDTO.getItemDTOList().get(index);
            if (StringUtils.isBlank((CharSequence)model.getPurchaserName())) {
                model.setPurchaserName("\u5168\u90e8");
            }
            if (StringUtils.isBlank((CharSequence)model.getSellerName())) {
                model.setSellerName("\u5168\u90e8");
            }
            if (CollectionUtils.isEmpty((Collection)(configItem = (List)itemMap.get(msConfig.getConfigId())))) {
                return;
            }
            configItem.stream().forEach(it -> {
                if (CollectionUtils.isEmpty((Collection)it.getConfigItemValue())) {
                    return;
                }
                String value = (String)it.getConfigItemValue().get(0);
                switch (it.getConfigItemName()) {
                    case "invoicerName": {
                        model.setInvoicerName(value);
                        break;
                    }
                    case "checkerName": {
                        model.setCheckerName(value);
                        break;
                    }
                    case "cashierName": {
                        model.setCashierName(value);
                    }
                }
            });
        });
        this.sendExportMessage(file, result, ExportInvoiceAgentModel.class, "\u7968\u9762\u4eba\u5458\u4fe1\u606f", "\u7968\u9762\u4eba\u5458\u4fe1\u606f\u5bfc\u51fa", userInfo);
    }

    private void exportInvoiceConfig(Map<Long, List<MsConfigItemBean>> itemMap, MsConfigPageDTO msConfigPageDTO, File file, UserInfo userInfo) throws Exception {
        List result = this.commonConverter.convertToExportConfigModel(msConfigPageDTO.getItemDTOList());
        StringBuilder sb = new StringBuilder();
        MsConfigPageDTO finalMsConfigPageDTO = msConfigPageDTO;
        IntStream.range(0, result.size()).forEach(index -> {
            List configItem;
            ExportConfigModel model = (ExportConfigModel)result.get(index);
            MsConfigBean msConfig = (MsConfigBean)finalMsConfigPageDTO.getItemDTOList().get(index);
            msConfig.getAttributes().stream().forEach(it -> {
                sb.append(it.getAttrName());
                sb.append(":");
                sb.append(it.getFieldValue());
                sb.append(",");
            });
            model.setExtension(sb.toString());
            sb.setLength(0);
            model.setBusinessBillType(msConfig.getBusinessBillType().equals("AP") ? "\u8d2d\u65b9" : "\u9500\u65b9");
            if (StringUtils.isBlank((CharSequence)model.getPurchaserName())) {
                model.setPurchaserName("\u5168\u90e8");
            }
            if (StringUtils.isBlank((CharSequence)model.getSellerName())) {
                model.setSellerName("\u5168\u90e8");
            }
            if (CollectionUtils.isEmpty((Collection)(configItem = (List)itemMap.get(msConfig.getConfigId())))) {
                return;
            }
            configItem.stream().forEach(it -> this.setConfigItem(model, it));
        });
        this.sendExportMessage(file, result, ExportConfigModel.class, "\u5f00\u7968\u62ac\u5934\u89c4\u5219\u4fe1\u606f", "\u5f00\u7968\u62ac\u5934\u4fe1\u606f\u5bfc\u51fa", userInfo);
    }

    private <T> void sendExportMessage(File file, List<T> result, Class<T> clazz, String sheetName, String caution, UserInfo userInfo) throws Exception {
        String fileName = CommonTools.format((String)"/tmp/config/{}.{}", (Object[])new Object[]{sheetName + format.format(new Date()), "xlsx"});
        String dir = "/tmp/config";
        file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
        EasyExcel.write((String)fileName, clazz).sheet(sheetName).doWrite(result);
        String downloadUrl = "";
        String uploadOssKey = this.ossUtil.uploadFile(fileName, Module.PURCHASER, true);
        downloadUrl = this.ossUtil.fileKeyToDownloadUrlViaPlatform(uploadOssKey);
        this.sendMessage(userInfo, caution, "", downloadUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportErrorMsg(UserInfo userInfo, List<ExportErrorModel> result) {
        File file = null;
        try {
            String fileName = CommonTools.format((String)"/tmp/config/import/{}.{}", (Object[])new Object[]{format.format(new Date()), "xlsx"});
            String dir = "/tmp/config/import";
            file = new File(dir);
            if (!file.exists()) {
                file.mkdirs();
            }
            EasyExcel.write((String)fileName, ExportErrorModel.class).sheet("\u6298\u6263\u7387\u89c4\u5219\u5bfc\u5165\u5931\u8d25\u539f\u56e0").doWrite(result);
            String downloadUrl = "";
            String uploadOssKey = this.ossUtil.uploadFile(fileName, Module.PURCHASER, true);
            downloadUrl = this.ossUtil.fileKeyToDownloadUrlViaPlatform(uploadOssKey);
            this.sendMessage(userInfo, "\u6298\u6263\u7387\u89c4\u5219\u5931\u8d25\u4fe1\u606f\u5bfc\u51fa", "\u8be6\u60c5\u89c1\u4e0b\u8f7d\u6587\u4ef6", downloadUrl);
        }
        catch (Exception e) {
            logger.error("exportErrorMsg errors:{}", (Object)e.getMessage());
            e.printStackTrace();
            if (this.sendFlag == 1) {
                this.sendMessage(userInfo, "\u6298\u6263\u7387\u89c4\u5219\u5931\u8d25\u4fe1\u606f\u5bfc\u51fa", "\u5bfc\u51fa\u5931\u8d25", null);
            }
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public void sendMessage(UserInfo userInfo, String title, String content, String url) {
        if (1 == this.sendFlag || 2 == this.sendFlag) {
            this.messageHelper.sendMessageMiddle(userInfo, title, content, url);
            if (1 == this.sendFlag) {
                return;
            }
        }
        MsOperateMessageRequest request = new MsOperateMessageRequest();
        request.setMessageTitle(title);
        request.setMessageUrl(url);
        logger.info("download url is : {}", (Object)request.getMessageUrl());
        request.setGroupId(Long.valueOf(userInfo.getGroupId()));
        request.setMessageContent(content);
        request.setMessageId(Long.valueOf(this.iDGenerator.nextId()));
        request.setMessageType(Integer.valueOf(1));
        request.setMessageValue(Long.valueOf(1L));
        request.setUserId(Long.valueOf(userInfo.getUserId()));
        request.setAppid("config-service");
        request.setDoType(MsDoBase.DoTypeEnum.I);
        request.setOperater(userInfo.getUserName());
        request.setOperaterid(String.valueOf(userInfo.getUserId()));
        request.setRid(String.valueOf(this.iDGenerator.nextId()));
        this.messageClient.operateMessage(request);
    }

    private void setConfigItem(ExportConfigModel model, MsConfigItemBean item) {
        if (CollectionUtils.isEmpty((Collection)item.getConfigItemValue())) {
            return;
        }
        String value = (String)item.getConfigItemValue().get(0);
        switch (item.getConfigItemName()) {
            case "sellerBankAccount": {
                model.setSellerBankAccount(value);
                break;
            }
            case "sellerTel": {
                model.setSellerTel(value);
                break;
            }
            case "sellerAddress": {
                model.setSellerAddress(value);
                break;
            }
            case "sellerBankName": {
                model.setSellerBankName(value);
                break;
            }
            case "purchaserBankAccount": {
                model.setBuyerBankAccount(value);
                break;
            }
            case "purchaserTel": {
                model.setBuyerTel(value);
                break;
            }
            case "purchaserAddress": {
                model.setBuyerAddress(value);
                break;
            }
            case "purchaserBankName": {
                model.setBuyerBankName(value);
            }
        }
    }

    static {
        templateMap.put("\u521b\u5efa\u65b9", "businessBillType");
        templateMap.put("\u9500\u65b9\u540d\u79f0", "sellerName");
        templateMap.put("\u9500\u65b9\u7a0e\u53f7", "sellerTaxNo");
        templateMap.put("\u8d2d\u65b9\u540d\u79f0", "purchaserName");
        templateMap.put("\u8d2d\u65b9\u7a0e\u53f7", "purchaserTaxNo");
        templateMap.put("\u89c4\u5219\u540d\u79f0", "configName");
        templateMap.put("\u4e1a\u52a1\u5355\u7c7b\u578b", "salesbillType");
        templateMap.put("\u53d1\u7968\u7c7b\u578b", "invoiceType");
        templateMap.put("\u91d1\u989d\u62c6\u5206\u89c4\u5219", "amountSplitRule");
        templateMap.put("\u7968\u9762\u6700\u5927\u884c\u6570", "invoiceItemMaxRow");
        templateMap.put("\u5f00\u7968\u9650\u989d", "invoiceLimit");
        templateMap.put("\u660e\u7ec6\u987a\u5e8f", "itemSort");
        templateMap.put("\u9500\u8d27\u6e05\u5355\u9009\u9879", "saleListOption");
        templateMap.put("\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570", "salesListMaxRow");
        templateMap.put("\u7a0e\u63a7\u8bbe\u5907\u7c7b\u578b", "taxDeviceType");
        templateMap.put("\u5355\u4ef7\u6570\u91cf\u9009\u9879", "unitPriceAmountOps");
        templateMap.put("\u62c6\u5206\u5b57\u6bb5", "splitFiledList");
        templateMap.put("\u5907\u6ce8\u5b57\u6bb5", "invoiceRemarkFiledList");
        templateMap.put("\u9500\u65b9\u5730\u5740", "sellerAddress");
        templateMap.put("\u9500\u65b9\u94f6\u884c\u8d26\u53f7", "sellerBankAccount");
        templateMap.put("\u9500\u65b9\u5f00\u6237\u884c", "sellerBankName");
        templateMap.put("\u9500\u65b9\u7535\u8bdd", "sellerTel");
        templateMap.put("\u4f18\u5148\u5f00\u7968\u4eba", "firstIssuer");
        templateMap.put("\u5168\u7535\u5f00\u7968\u65b9\u5f0f", "issueType");
        templateMap.put("\u5f00\u7968\u4eba", "invoicerName");
        templateMap.put("\u590d\u6838\u4eba", "checkerName");
        templateMap.put("\u6536\u6b3e\u4eba", "cashierName");
    }
}

