/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.seller.config.config.GatewayProperties;
import com.xforceplus.seller.config.infrastructure.helper.RestTemplateRetryHelper;
import com.xforceplus.seller.config.models.MessageMiddleRequest;
import com.xforceplus.seller.config.models.MessageMiddleResponse;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class MessageHelper {
    private static final Logger log = LoggerFactory.getLogger(MessageHelper.class);
    private final RestTemplateRetryHelper restTemplateRetryHelper;
    private final GatewayProperties gatewayProperties;

    public MessageHelper(RestTemplateRetryHelper restTemplateRetryHelper, GatewayProperties gatewayProperties) {
        this.restTemplateRetryHelper = restTemplateRetryHelper;
        this.gatewayProperties = gatewayProperties;
    }

    public void sendMessageMiddle(UserInfo userInfo, String title, String content, String url) {
        try {
            MessageMiddleRequest request = new MessageMiddleRequest();
            request.setTitle(title);
            request.setContent(content);
            ArrayList<Long> receiverIdList = new ArrayList<Long>();
            receiverIdList.add(userInfo.getUserId());
            request.setReceiverIds(receiverIdList);
            ArrayList<Long> receiverAppIdList = new ArrayList<Long>();
            receiverAppIdList.add(this.gatewayProperties.getAppId());
            request.setReceiverAppIds(receiverAppIdList);
            if (!StringUtils.isEmpty((Object)url)) {
                HashMap<String, String> extendParam = new HashMap<String, String>();
                extendParam.put("url", url);
                request.setExtendParam(extendParam);
            }
            log.info("sendMessageMiddle request:{}", (Object)JsonUtils.writeObjectToFastJson((Object)request));
            String subUrl = "/{tenantId}/message/v1/mkm/inbox?appId={appId}";
            MessageMiddleResponse response2 = (MessageMiddleResponse)this.restTemplateRetryHelper.postWithUserCenterToken(subUrl, (Object)request, MessageMiddleResponse.class, new Object[]{userInfo.getGroupId(), this.gatewayProperties.getAppId()});
            log.info("sendMessageMiddle reponse:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
        }
        catch (Exception e) {
            log.error("sendMessage(UserInfo userInfo, String fileName, String key,Date date) err! :{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

