/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.seller.config.client.model.MsGroupTypeDTO;
import com.xforceplus.seller.config.client.model.MsGroupTypeMetaDataDTO;
import com.xforceplus.seller.config.converters.MsBusinessObjMetadataConverter;
import com.xforceplus.seller.config.services.ConfigMetaDataService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class MetaDataQueryBusiness {
    private final ConfigMetaDataService configMetaDataService;
    private final MsBusinessObjMetadataConverter msBusinessObjMetadataConverter;

    public MetaDataQueryBusiness(ConfigMetaDataService configMetaDataService, MsBusinessObjMetadataConverter msBusinessObjMetadataConverter) {
        this.configMetaDataService = configMetaDataService;
        this.msBusinessObjMetadataConverter = msBusinessObjMetadataConverter;
    }

    public List<MsGroupTypeDTO> getMetaDataList(Long tenantId, boolean needDetailExt, boolean needNotEnumExt) {
        return this.setGroupTypeDTOList(this.configMetaDataService.queryBillTemplateObj(tenantId), needDetailExt, needNotEnumExt);
    }

    private List<MsGroupTypeDTO> setGroupTypeDTOList(List<MsGroupTypeMetaDataDTO> result, boolean needDetailExt, boolean needNotEnumExt) {
        return result.stream().map(msGroupTypeMetaDataDTO -> {
            MsGroupTypeDTO msGroupTypeDTO = new MsGroupTypeDTO();
            msGroupTypeDTO.setObjType(msGroupTypeMetaDataDTO.getObjType());
            List businessObjDTOList = needDetailExt ? msGroupTypeMetaDataDTO.getMetaList().stream().filter(r -> needNotEnumExt || CollectionUtils.isNotEmpty((Collection)r.getFieldEnumValue())).map(arg_0 -> ((MsBusinessObjMetadataConverter)this.msBusinessObjMetadataConverter).convert(arg_0)).collect(Collectors.toList()) : msGroupTypeMetaDataDTO.getMetaList().stream().filter(r -> needNotEnumExt || CollectionUtils.isNotEmpty((Collection)r.getFieldEnumValue()) && r.getFieldGroupIndex() == 0).map(arg_0 -> ((MsBusinessObjMetadataConverter)this.msBusinessObjMetadataConverter).convert(arg_0)).collect(Collectors.toList());
            businessObjDTOList = businessObjDTOList.stream().filter(r -> r.getFieldName().startsWith("ext")).collect(Collectors.toList());
            msGroupTypeDTO.setMetaList(businessObjDTOList);
            return msGroupTypeDTO;
        }).collect(Collectors.toList());
    }
}

