/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.seller.config.client.model.EnumValue;
import com.xforceplus.seller.config.client.model.ErrorData;
import com.xforceplus.seller.config.client.model.ObjectFieldAddEnumValueResult;
import com.xforceplus.seller.config.client.model.ObjectFieldEnumValueDTO;
import com.xforceplus.seller.config.core.enums.ErrorCodeEnum;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjDao;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjMetadataDao;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjMetadataExtDao;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjEntity;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjExample;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataEntity;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataExample;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataExtEntity;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjMetadataExtExample;
import com.xforceplus.seller.config.services.MetadataService;
import com.xforceplus.seller.config.util.AssertUtil;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MetadataServiceImpl
implements MetadataService {
    private static final Logger log = LoggerFactory.getLogger(MetadataServiceImpl.class);
    private CfgBusinessObjDao cfgBusinessObjDao;
    private CfgBusinessObjMetadataDao cfgBusinessObjMetadataDao;
    private CfgBusinessObjMetadataExtDao cfgBusinessObjMetadataExtDao;

    public Either<Tuple2<String, String>, Void> checkObjectFieldEnumValueDTO(ObjectFieldEnumValueDTO dto) {
        if (dto.getFieldName().length() > 50) {
            return Either.left((Object)Tuple.of((Object)(dto.getObjectConfigName() + dto.getFieldName()), (Object)"fieldName\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u5b57\u7b26"));
        }
        if (dto.getObjectType().length() > 30) {
            return Either.left((Object)Tuple.of((Object)(dto.getObjectConfigName() + dto.getFieldName()), (Object)"objectType\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u5b57\u7b26"));
        }
        if (dto.getFieldDisplayName().length() > 100) {
            return Either.left((Object)Tuple.of((Object)(dto.getObjectConfigName() + dto.getFieldName()), (Object)"fieldDisplayName\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u5b57\u7b26"));
        }
        if (dto.getObjectConfigName().length() > 50) {
            return Either.left((Object)Tuple.of((Object)(dto.getObjectConfigName() + dto.getFieldName()), (Object)"objectConfigName\u5b57\u6bb5\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u5b57\u7b26"));
        }
        return Either.right(null);
    }

    public Either<Tuple2<ObjectFieldAddEnumValueResult, List<ErrorData>>, String> addObjectFieldEnumValue(Long groupId, List<ObjectFieldEnumValueDTO> objectFieldEnumValues) {
        ObjectFieldAddEnumValueResult objectFieldAddEnumValueResult = new ObjectFieldAddEnumValueResult();
        HashMap errorDataMap = Maps.newHashMap();
        Optional<Either> any = objectFieldEnumValues.stream().map(arg_0 -> this.checkObjectFieldEnumValueDTO(arg_0)).filter(Either::isLeft).findAny();
        if (any.isPresent()) {
            Tuple2 left = (Tuple2)any.get().getLeft();
            errorDataMap.put(ErrorCodeEnum.SYSTEM1005.getValue(), new ErrorData(ErrorCodeEnum.SYSTEM1005.getValue(), AssertUtil.formatMsg((String)ErrorCodeEnum.SYSTEM1005.getDescription(), (Object[])new Object[]{left._2})));
            objectFieldAddEnumValueResult.getFailResult().put(left._1, Lists.newArrayList((Object[])new String[]{ErrorCodeEnum.SYSTEM1005.getValue()}));
            return Either.left((Object)Tuple.of((Object)objectFieldAddEnumValueResult, (Object)Lists.newArrayList(errorDataMap.values())));
        }
        objectFieldEnumValues.forEach(x -> {
            CfgBusinessObjEntity cfgBusinessObjEntity = this.getBusinessObj(groupId, x);
            if (cfgBusinessObjEntity != null) {
                CfgBusinessObjMetadataEntity cfgBusinessObjMetadataEntity = this.getBusinessObjMetadata(cfgBusinessObjEntity, x.getFieldName(), x.getFieldDisplayName());
                if (cfgBusinessObjMetadataEntity != null) {
                    CfgBusinessObjMetadataExtEntity cfgBusinessObjMetadataExtEntity = this.getBusinessObjMetadataExt(cfgBusinessObjEntity.getBusinessObjId(), cfgBusinessObjMetadataEntity.getBusinessObjMetadataId());
                    if (cfgBusinessObjMetadataExtEntity != null) {
                        String err = this.updateBusinessObjExtFieldEnumValue(cfgBusinessObjMetadataExtEntity, x.getValues());
                        if (StringUtils.isNotBlank((CharSequence)err)) {
                            objectFieldAddEnumValueResult.getFailResult().put(x.getObjectConfigName() + x.getFieldName(), Lists.newArrayList((Object[])new String[]{ErrorCodeEnum.CNFGMD0013.getValue()}));
                            errorDataMap.put(ErrorCodeEnum.CNFGMD0013.getValue(), new ErrorData(ErrorCodeEnum.CNFGMD0013.getValue(), err));
                        } else {
                            objectFieldAddEnumValueResult.getSuccessResult().add(x.getObjectConfigName() + x.getFieldName());
                        }
                    } else {
                        objectFieldAddEnumValueResult.getFailResult().put(x.getObjectConfigName() + x.getFieldName(), Lists.newArrayList((Object[])new String[]{ErrorCodeEnum.CNFGMD0012.getValue()}));
                        errorDataMap.put(ErrorCodeEnum.CNFGMD0012.getValue(), new ErrorData(ErrorCodeEnum.CNFGMD0012.getValue(), ErrorCodeEnum.CNFGMD0012.getDescription()));
                    }
                } else {
                    objectFieldAddEnumValueResult.getFailResult().put(x.getObjectConfigName() + x.getFieldName(), Lists.newArrayList((Object[])new String[]{ErrorCodeEnum.CNFGMD0011.getValue()}));
                    errorDataMap.put(ErrorCodeEnum.CNFGMD0011.getValue(), new ErrorData(ErrorCodeEnum.CNFGMD0011.getValue(), ErrorCodeEnum.CNFGMD0011.getDescription()));
                }
            } else {
                objectFieldAddEnumValueResult.getFailResult().put(x.getObjectConfigName() + x.getFieldName(), Lists.newArrayList((Object[])new String[]{ErrorCodeEnum.CNFGMD0010.getValue()}));
                errorDataMap.put(ErrorCodeEnum.CNFGMD0010.getValue(), new ErrorData(ErrorCodeEnum.CNFGMD0010.getValue(), ErrorCodeEnum.CNFGMD0010.getDescription()));
            }
        });
        if (objectFieldAddEnumValueResult.getFailResult().size() == 0) {
            return Either.right((Object)"\u64cd\u4f5c\u6210\u529f");
        }
        return Either.left((Object)Tuple.of((Object)objectFieldAddEnumValueResult, (Object)Lists.newArrayList(errorDataMap.values())));
    }

    private String updateBusinessObjExtFieldEnumValue(CfgBusinessObjMetadataExtEntity cfgBusinessObjMetadataExtEntity, List<EnumValue> newEnumValues) {
        CfgBusinessObjMetadataExtExample updateExample = new CfgBusinessObjMetadataExtExample();
        updateExample.createCriteria().andBusinessObjMetadataIdEqualTo(cfgBusinessObjMetadataExtEntity.getBusinessObjMetadataId());
        CfgBusinessObjMetadataExtEntity updateEntity = new CfgBusinessObjMetadataExtEntity();
        updateEntity.setBusinessObjMetadataId(cfgBusinessObjMetadataExtEntity.getBusinessObjMetadataId());
        String originalEnumValueText = cfgBusinessObjMetadataExtEntity.getFieldEnumValue();
        JSONArray jsonArray = JSONObject.parseArray((String)originalEnumValueText);
        StringBuilder err = new StringBuilder();
        newEnumValues.forEach(v -> {
            boolean existed = this.isEnumValueExisted(jsonArray, v.getValue());
            if (!existed) {
                JSONObject map = new JSONObject();
                map.put("defaultflag", (Object)0);
                map.put("text", (Object)v.getText());
                map.put("value", (Object)v.getValue());
                jsonArray.add((Object)map);
            } else {
                err.append(v.getValue()).append("\u679a\u4e3e\u5df2\u5b58\u5728\u65e0\u6cd5\u66f4\u65b0;");
            }
        });
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{err.toString()})) {
            return err.toString();
        }
        updateEntity.setFieldEnumValue(jsonArray.toJSONString());
        return this.cfgBusinessObjMetadataExtDao.updateByPrimaryKeySelective(updateEntity) > 0 ? "" : "\u66f4\u65b0\u5931\u8d25";
    }

    private boolean isEnumValueExisted(JSONArray jsonArray, String enumValue) {
        return jsonArray.stream().anyMatch(x -> {
            JSONObject map = (JSONObject)x;
            String v = String.valueOf(map.get((Object)"value"));
            return enumValue.equals(v);
        });
    }

    private CfgBusinessObjMetadataExtEntity getBusinessObjMetadataExt(Long businessObjId, Long businessObjMetadataId) {
        CfgBusinessObjMetadataExtExample cfgBusinessObjMetadataExtExample = new CfgBusinessObjMetadataExtExample();
        cfgBusinessObjMetadataExtExample.createCriteria().andBusinessObjIdEqualTo(businessObjId).andBusinessObjMetadataIdEqualTo(businessObjMetadataId);
        return this.cfgBusinessObjMetadataExtDao.selectOneByExample(cfgBusinessObjMetadataExtExample);
    }

    private CfgBusinessObjMetadataEntity getBusinessObjMetadata(CfgBusinessObjEntity cfgBusinessObjEntity, String fieldName, String fieldDisplayName) {
        CfgBusinessObjMetadataExample cfgBusinessObjMetadataExample = new CfgBusinessObjMetadataExample();
        cfgBusinessObjMetadataExample.createCriteria().andBusinessObjIdEqualTo(cfgBusinessObjEntity.getBusinessObjId()).andFieldNameEqualTo(fieldName).andFieldDisplayNameEqualTo(fieldDisplayName);
        return this.cfgBusinessObjMetadataDao.selectOneByExample(cfgBusinessObjMetadataExample);
    }

    private CfgBusinessObjEntity getBusinessObj(Long groupId, ObjectFieldEnumValueDTO x) {
        CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
        cfgBusinessObjExample.createCriteria().andGroupIdEqualTo(groupId).andObjStatusEqualTo(Integer.valueOf(1)).andObjCodeEqualTo(x.getObjectType()).andObjNameEqualTo(x.getObjectConfigName());
        return this.cfgBusinessObjDao.selectOneByExample(cfgBusinessObjExample);
    }

    public MetadataServiceImpl(CfgBusinessObjDao cfgBusinessObjDao, CfgBusinessObjMetadataDao cfgBusinessObjMetadataDao, CfgBusinessObjMetadataExtDao cfgBusinessObjMetadataExtDao) {
        this.cfgBusinessObjDao = cfgBusinessObjDao;
        this.cfgBusinessObjMetadataDao = cfgBusinessObjMetadataDao;
        this.cfgBusinessObjMetadataExtDao = cfgBusinessObjMetadataExtDao;
    }
}

