/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.phoenix.infrastructure.usercenter.helper.UserCenterHelper;
import com.xforceplus.seller.config.client.model.TaxNationalCode;
import com.xforceplus.seller.config.config.GatewayProperties;
import com.xforceplus.seller.config.infrastructure.helper.RestTemplateRetryHelper;
import com.xforceplus.seller.config.infrastructure.helper.RestTemplateTools;
import com.xforceplus.seller.config.models.MidGoodsQueryRequest;
import com.xforceplus.seller.config.models.MidGoodsQueryResult;
import com.xforceplus.seller.config.models.MidNationalTaxCodeResponse;
import com.xforceplus.seller.config.models.MidPlatformResponse;
import com.xforceplus.seller.config.models.SyncTaxWareGoodRequest;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class MidPlateFormService {
    private static final Logger log = LoggerFactory.getLogger(MidPlateFormService.class);
    private final RestTemplateTools restTemplateTools;
    private final RestTemplateRetryHelper restTemplateRetryHelper;
    private final GatewayProperties gatewayProperties;
    private final UserInfoHolder<UserInfo> userInfoHolder;

    public MidPlateFormService(RestTemplateTools restTemplateTools, RestTemplateRetryHelper restTemplateRetryHelper, GatewayProperties gatewayProperties, UserInfoHolder<UserInfo> userInfoHolder) {
        this.restTemplateTools = restTemplateTools;
        this.restTemplateRetryHelper = restTemplateRetryHelper;
        this.gatewayProperties = gatewayProperties;
        this.userInfoHolder = userInfoHolder;
    }

    public List<TaxNationalCode> getNationalTaxCode(String goodsTaxNo, String groupId, String taxName) {
        ArrayList resultList = Lists.newArrayList();
        String subUrl = groupId + "/invoice/v1/tax-codes";
        HashMap params = Maps.newHashMap();
        params.put("appId", String.valueOf(this.gatewayProperties.getAppId()));
        if (!CommonTools.isEmpty((String)goodsTaxNo)) {
            params.put("code", goodsTaxNo);
        } else {
            params.put("name", taxName);
        }
        try {
            UriComponentsBuilder builder = UriComponentsBuilder.fromPath((String)subUrl);
            UserCenterHelper.Companion.dealParam((Map)params, builder);
            String requestUrl = this.restTemplateTools.getTaxCodeUrl(builder.build().toString());
            MidNationalTaxCodeResponse midQueryNationalResponse = (MidNationalTaxCodeResponse)this.restTemplateRetryHelper.getWithPaasToken(requestUrl, MidNationalTaxCodeResponse.class, new Object[0]);
            log.info("\u4e2d\u53f0\u67e5\u8be2\u56fd\u7a0e\u7a0e\u7f16\u8fd4\u56de\u7ed3\u679c{}\uff1a{}", (Object)goodsTaxNo, (Object)JsonUtils.writeObjectToFastJson((Object)midQueryNationalResponse));
            if (!"TWTXZZ100".equals(midQueryNationalResponse.getCode()) || CollectionUtils.isEmpty((Collection)midQueryNationalResponse.getResult())) {
                return resultList;
            }
            List result = midQueryNationalResponse.getResult();
            for (MidNationalTaxCodeResponse.ResultBean resultBean : result) {
                if (CommonTools.isEmpty((String)resultBean.getErrorCode())) {
                    MidNationalTaxCodeResponse.ResultBean.DataBean data = resultBean.getData();
                    TaxNationalCode taxNationalCode = new TaxNationalCode();
                    taxNationalCode.setVersion(data.getTaxCodeVersion());
                    taxNationalCode.setEndFlag(Integer.valueOf(data.getIsNode() != false ? 1 : 0));
                    taxNationalCode.setGoodsTaxNo(data.getTaxCode());
                    taxNationalCode.setTaxcodeName(data.getTaxName());
                    taxNationalCode.setItemTypeCode(CommonTools.isEmpty((String)data.getItemTypeCode()) ? "" : data.getItemTypeCode());
                    taxNationalCode.setTaxcodeShortName(data.getTaxShortName());
                    taxNationalCode.setSplitCode(data.getSplitCode() == null || data.getSplitCode() != false ? "1" : "0");
                    ArrayList rateItemList = Lists.newArrayList();
                    if (!CollectionUtils.isEmpty((Collection)data.getPolicyGroups())) {
                        for (MidNationalTaxCodeResponse.ResultBean.taxRateItem midtaxRateItem : data.getPolicyGroups()) {
                            TaxNationalCode.taxRateItem taxRateItem2 = new TaxNationalCode.taxRateItem();
                            taxRateItem2.setZeroTax(CommonTools.isEmpty((String)midtaxRateItem.getZeroTax()) ? "" : midtaxRateItem.getZeroTax());
                            taxRateItem2.setTaxPre(midtaxRateItem.getHasPromotion() == null || midtaxRateItem.getHasPromotion() == false ? "0" : "1");
                            taxRateItem2.setTaxPreCon(CommonTools.isEmpty((String)midtaxRateItem.getTaxPolicy()) ? "" : midtaxRateItem.getTaxPolicy());
                            taxRateItem2.setTaxRate(midtaxRateItem.getTaxRate());
                            rateItemList.add(taxRateItem2);
                        }
                    }
                    taxNationalCode.setPreferentialTaxList((List)rateItemList);
                    taxNationalCode.setTaxRate(CollectionUtils.isEmpty((Collection)data.getTaxRateList()) ? Lists.newArrayList() : data.getTaxRateList());
                    resultList.add(taxNationalCode);
                    continue;
                }
                log.info("\u4e2d\u53f0\u67e5\u8be2\u56fd\u7a0e\u5931\u8d25{},\u5931\u8d25\u539f\u56e0:{}", (Object)goodsTaxNo, (Object)resultBean.getMsg());
            }
        }
        catch (Exception e) {
            log.error("\u4e2d\u53f0\u67e5\u8be2\u56fd\u7a0e\u5931\u8d25" + goodsTaxNo, (Throwable)e);
        }
        return resultList;
    }

    public MidPlatformResponse<Object> syncGoodsFromTaxPlate(SyncTaxWareGoodRequest request) {
        Long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        String subUrl = "/{tenantId}/commodity/v2/spu/sync-tax-ware?appId={appId}";
        String url = this.restTemplateTools.getTaxCodeUrl(subUrl);
        return (MidPlatformResponse)this.restTemplateRetryHelper.postWithPaasToken(url, (Object)request, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{tenantId, this.gatewayProperties.getAppId()});
    }

    public MidPlatformResponse<MidGoodsQueryResult> queryGoods(MidGoodsQueryRequest request) {
        Long tenantId = ((UserInfo)this.userInfoHolder.get()).getGroupId();
        String subUrl = "/{tenantId}/commodity/v1/spu";
        UriComponentsBuilder builder = UriComponentsBuilder.fromPath((String)subUrl);
        Map goodsQueryMap = this.getGoodsQueryMap(request);
        goodsQueryMap.put("appId", this.gatewayProperties.getAppId());
        UserCenterHelper.Companion.dealParam(goodsQueryMap, builder);
        String url = this.restTemplateTools.getTaxCodeUrl(builder.build().toString());
        return (MidPlatformResponse)this.restTemplateRetryHelper.getWithPaasToken(url, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{tenantId});
    }

    private Map<String, Object> getGoodsQueryMap(MidGoodsQueryRequest request) {
        HashMap map = Maps.newHashMap();
        map.put("tenantId", request.getTenantId());
        map.put("pageNo", request.getPageNo());
        map.put("pageSize", request.getPageSize());
        return map;
    }
}

