/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xforceplus.seller.config.models.IndustryCodeDTO;
import com.xforceplus.seller.config.models.RegistryCodeDTO;
import com.xforceplus.seller.config.repository.dao.BaseIndustryCodeDao;
import com.xforceplus.seller.config.repository.dao.BaseRegistryCodeDao;
import com.xforceplus.seller.config.repository.model.BaseIndustryCodeEntity;
import com.xforceplus.seller.config.repository.model.BaseIndustryCodeExample;
import com.xforceplus.seller.config.repository.model.BaseRegistryCodeEntity;
import com.xforceplus.seller.config.repository.model.BaseRegistryCodeExample;
import com.xforceplus.seller.config.services.PurchaseTaxBaseInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseTaxBaseInfoServiceImpl
implements PurchaseTaxBaseInfoService {
    private static final Logger logger = LoggerFactory.getLogger(PurchaseTaxBaseInfoServiceImpl.class);
    @Autowired
    private BaseIndustryCodeDao baseIndustryCodeDao;
    @Autowired
    private BaseRegistryCodeDao baseRegistryCodeDao;
    private static final String INDUSTRY_CACHE_KEY = "industry_cache_key";
    private static final String REGISTRY_CACHE_KEY = "registry_cache_key";
    private final LoadingCache<String, List<BaseIndustryCodeEntity>> industryCache = CacheBuilder.newBuilder().refreshAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    private final LoadingCache<String, List<BaseRegistryCodeEntity>> registryCache = CacheBuilder.newBuilder().refreshAfterWrite(1L, TimeUnit.HOURS).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);

    public List<IndustryCodeDTO> getIndustryCode() {
        List datas;
        try {
            datas = (List)this.industryCache.get((Object)INDUSTRY_CACHE_KEY);
        }
        catch (ExecutionException e) {
            logger.error("get industry code error", (Throwable)e);
            return new ArrayList<IndustryCodeDTO>();
        }
        List<IndustryCodeDTO> root = datas.stream().filter(it -> it.getParentCode() == null).map(it -> {
            IndustryCodeDTO dto = new IndustryCodeDTO();
            dto.setCode(it.getCode());
            dto.setName(it.getName());
            return dto;
        }).collect(Collectors.toList());
        this.recursiveGetChild(root, datas);
        return root;
    }

    public List<RegistryCodeDTO> getRegistryCode() {
        List datas;
        try {
            datas = (List)this.registryCache.get((Object)REGISTRY_CACHE_KEY);
        }
        catch (ExecutionException e) {
            logger.error("get industry code error", (Throwable)e);
            return new ArrayList<RegistryCodeDTO>();
        }
        List<RegistryCodeDTO> results = datas.stream().map(it -> {
            RegistryCodeDTO dto = new RegistryCodeDTO();
            dto.setCode(it.getCode());
            dto.setName(it.getName());
            return dto;
        }).collect(Collectors.toList());
        return results;
    }

    private void recursiveGetChild(List<IndustryCodeDTO> parents, List<BaseIndustryCodeEntity> datas) {
        parents.forEach(parent -> {
            List child = datas.stream().filter(it -> parent.getCode().equals(it.getParentCode())).map(it -> {
                IndustryCodeDTO dto = new IndustryCodeDTO();
                dto.setCode(it.getCode());
                dto.setName(it.getName());
                return dto;
            }).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(child)) {
                parent.setChild(child);
                this.recursiveGetChild(child, datas);
            }
        });
    }

    public List<BaseIndustryCodeEntity> getIndustryCodeInfo() {
        BaseIndustryCodeExample example = new BaseIndustryCodeExample();
        example.createCriteria().andIsDeletedEqualTo(Boolean.valueOf(false));
        List list = this.baseIndustryCodeDao.selectByExample(example);
        return list;
    }

    public List<BaseRegistryCodeEntity> getRegistryCodeInfo() {
        BaseRegistryCodeExample example = new BaseRegistryCodeExample();
        example.createCriteria().andIsDeletedEqualTo(Boolean.valueOf(false));
        List list = this.baseRegistryCodeDao.selectByExample(example);
        return list;
    }
}

