/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.infrastructure.helper.DeviceApiProxy;
import com.xforceplus.seller.config.models.RestCancelDeviceStockRequest;
import com.xforceplus.seller.config.models.RestCancelDeviceStockResponse;
import com.xforceplus.seller.config.models.RestCancelExtractRequest;
import com.xforceplus.seller.config.models.RestCancelExtractResponse;
import com.xforceplus.seller.config.models.RestGetSubscribeDeviceStockResponse;
import com.xforceplus.seller.config.models.RestGetSubscribeResponse;
import com.xforceplus.seller.config.models.RestSubscribeDeviceStockRequest;
import com.xforceplus.seller.config.models.RestSubscribeDeviceStockResponse;
import com.xforceplus.seller.config.models.RestSubscribeExtract;
import com.xforceplus.seller.config.models.RestSubscribeExtractRequest;
import com.xforceplus.seller.config.models.RestSubscribeExtractResponse;
import com.xforceplus.seller.config.repository.dao.CfgSubscribeLogDao;
import com.xforceplus.seller.config.repository.model.CfgSubscribeLogEntity;
import com.xforceplus.seller.config.services.SubscribeDeviceService;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SubscribeDeviceServiceImpl
implements SubscribeDeviceService {
    private static final Logger logger = LoggerFactory.getLogger(SubscribeDeviceServiceImpl.class);
    @Autowired
    private DeviceApiProxy deviceApiProxy;
    @Autowired
    private UserInfoHolder<UserInfo> userInfoHolder;
    @Autowired
    private CfgSubscribeLogDao logDao;
    @Autowired
    private IDGenerator iDGenerator;
    @Value(value="${xplat.aws.sqs.receiver.queueName.prefix}")
    String queuePrefix;

    public String batchAddSubscribe(List<String> services, String taxNo, String deviceUn) {
        String errorMessage;
        StringBuilder errorMessageBuilder = new StringBuilder();
        if (!CollectionUtils.isEmpty(services)) {
            Iterator<String> iterator = services.iterator();
            while (iterator.hasNext()) {
                String service;
                switch (service = iterator.next()) {
                    case "originAccount": {
                        RestGetSubscribeResponse response1 = this.getExtractSubscribe(1, taxNo);
                        if ("1".equals(response1.getCode()) && response1.getResult() != null && !CollectionUtils.isEmpty((Collection)response1.getResult().getSubscribeExtractList()) || this.originalAccountSubscribe(taxNo, deviceUn)) break;
                        errorMessageBuilder.append("\u5e95\u8d26\u8ba2\u9605\u5931\u8d25\uff0c");
                        break;
                    }
                    case "assistant": {
                        RestGetSubscribeResponse response1 = this.getExtractSubscribe(2, deviceUn);
                        if ("1".equals(response1.getCode()) && response1.getResult() != null && !CollectionUtils.isEmpty((Collection)response1.getResult().getSubscribeExtractList()) || this.assistantSubscribe(taxNo, deviceUn)) break;
                        errorMessageBuilder.append("\u8f85\u52a9\u8ba2\u9605\u5931\u8d25\uff0c");
                        break;
                    }
                    case "inventory": {
                        RestGetSubscribeDeviceStockResponse response2 = this.getInventorySubscribe(deviceUn);
                        if ("1".equals(response2.getCode()) && response2.getResult() != null && !CollectionUtils.isEmpty((Collection)response2.getResult().getSubscribeDeviceStockList()) || this.inventorySubscribe(taxNo, deviceUn)) break;
                        errorMessageBuilder.append("\u5e93\u5b58\u8ba2\u9605\u5931\u8d25\uff0c");
                        break;
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(errorMessage = errorMessageBuilder.toString()))) {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 1);
        }
        return errorMessage;
    }

    public String batchCancelSubscribe(List<String> services, String taxNo, String deviceUn) {
        String errorMessage;
        StringBuilder errorMessageBuilder = new StringBuilder();
        if (!CollectionUtils.isEmpty(services)) {
            Iterator<String> iterator = services.iterator();
            while (iterator.hasNext()) {
                String service;
                switch (service = iterator.next()) {
                    case "originAccount": {
                        if (this.cancelOriginalAccountSubscribe(taxNo, deviceUn)) break;
                        errorMessageBuilder.append("\u53d6\u6d88\u5e95\u8d26\u8ba2\u9605\u5931\u8d25\uff0c");
                        break;
                    }
                    case "assistant": {
                        if (this.cancelAssistantSubscribe(taxNo, deviceUn)) break;
                        errorMessageBuilder.append("\u53d6\u6d88\u8f85\u52a9\u8ba2\u9605\u5931\u8d25\uff0c");
                        break;
                    }
                    case "inventory": {
                        if (this.cancelInventorySubscribe(taxNo, deviceUn)) break;
                        errorMessageBuilder.append("\u53d6\u6d88\u5e93\u5b58\u8ba2\u9605\u5931\u8d25\uff0c");
                        break;
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(errorMessage = errorMessageBuilder.toString()))) {
            errorMessage = errorMessage.substring(0, errorMessage.length() - 1);
        }
        return errorMessage;
    }

    public RestGetSubscribeDeviceStockResponse getInventorySubscribe(String deviceUn) {
        RestGetSubscribeDeviceStockResponse response2 = this.deviceApiProxy.getDeviceStockSubscribeInfo(deviceUn);
        if (logger.isDebugEnabled()) {
            logger.debug("\u83b7\u53d6\u5e93\u5b58\u8ba2\u9605\u7ed3\u679c:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
        }
        return response2;
    }

    private RestSubscribeExtractResponse extractSubscribe(Integer extractType, String extractValue, String subscribeValue) {
        RestSubscribeExtractRequest request = new RestSubscribeExtractRequest();
        RestSubscribeExtract restSubscribeExtract = new RestSubscribeExtract();
        request.setSubscribeExtract(restSubscribeExtract);
        restSubscribeExtract.setCreatedBy(((UserInfo)this.userInfoHolder.get()).getUserName());
        restSubscribeExtract.setExtractType(extractType);
        restSubscribeExtract.setExtractValue(extractValue);
        restSubscribeExtract.setSubscribeType(Integer.valueOf(1));
        restSubscribeExtract.setSubscribeValue(subscribeValue);
        return this.deviceApiProxy.extractSubscribe(request);
    }

    private boolean originalAccountSubscribe(String taxNo, String deviceUn) {
        if (StringUtils.isNotBlank((CharSequence)taxNo)) {
            RestSubscribeExtractResponse response2 = this.extractSubscribe(Integer.valueOf(1), taxNo, this.queuePrefix + "purchaser-tax-elsync-invoice-queue");
            logger.debug("\u5e95\u8d26\u8ba2\u9605\u7ed3\u679c:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            if ("1".equals(response2.getCode())) {
                this.logSubscribeResult(taxNo, deviceUn, "\u5e95\u8d26\u8ba2\u9605", 1, 1, response2.getTraceId(), "");
                return true;
            }
            this.logSubscribeResult(taxNo, deviceUn, "\u5e95\u8d26\u8ba2\u9605", 1, 0, response2.getTraceId(), response2.getMessage());
        }
        return false;
    }

    private boolean assistantSubscribe(String taxNo, String deviceUn) {
        if (StringUtils.isNotBlank((CharSequence)deviceUn)) {
            RestSubscribeExtractResponse response2 = this.extractSubscribe(Integer.valueOf(2), deviceUn, this.queuePrefix + "phoenix-invoice-draw-out");
            logger.debug("\u62bd\u53d6\u8ba2\u9605\u7ed3\u679c:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            if ("1".equals(response2.getCode())) {
                this.logSubscribeResult(taxNo, deviceUn, "\u8f85\u52a9\uff08\u62bd\u53d6\uff09\u8ba2\u9605", 1, 1, response2.getTraceId(), "");
                return true;
            }
            this.logSubscribeResult(taxNo, deviceUn, "\u8f85\u52a9\uff08\u62bd\u53d6\uff09\u8ba2\u9605", 1, 0, response2.getTraceId(), response2.getMessage());
        }
        return false;
    }

    private RestCancelExtractResponse cancelExtractSubscribe(Integer extractType, String extractValue) {
        RestCancelExtractRequest request = new RestCancelExtractRequest();
        request.setExtractType(extractType);
        request.setExtractValue(extractValue);
        return this.deviceApiProxy.cancelExtractSubscribe(request);
    }

    private boolean cancelOriginalAccountSubscribe(String taxNo, String deviceUn) {
        if (StringUtils.isNotBlank((CharSequence)taxNo)) {
            RestCancelExtractResponse response2 = this.cancelExtractSubscribe(Integer.valueOf(1), taxNo);
            logger.debug("\u5e95\u8d26\u53d6\u6d88\u8ba2\u9605\u7ed3\u679c:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            if ("1".equals(response2.getCode())) {
                this.logSubscribeResult(taxNo, deviceUn, "\u5e95\u8d26\u53d6\u6d88\u8ba2\u9605", 2, 1, response2.getTraceId(), "");
                return true;
            }
            this.logSubscribeResult(taxNo, deviceUn, "\u5e95\u8d26\u53d6\u6d88\u8ba2\u9605", 2, 0, response2.getTraceId(), response2.getMessage());
        }
        return false;
    }

    private boolean cancelAssistantSubscribe(String taxNo, String deviceUn) {
        if (StringUtils.isNotBlank((CharSequence)deviceUn)) {
            RestCancelExtractResponse response2 = this.cancelExtractSubscribe(Integer.valueOf(2), deviceUn);
            logger.debug("\u8f85\u52a9\uff08\u62bd\u53d6\uff09\u53d6\u6d88\u8ba2\u9605\u7ed3\u679c:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            if ("1".equals(response2.getCode())) {
                this.logSubscribeResult(taxNo, deviceUn, "\u8f85\u52a9\uff08\u62bd\u53d6\uff09\u53d6\u6d88\u8ba2\u9605", 2, 1, response2.getTraceId(), "");
                return true;
            }
            this.logSubscribeResult(taxNo, deviceUn, "\u8f85\u52a9\uff08\u62bd\u53d6\uff09\u53d6\u6d88\u8ba2\u9605", 2, 0, response2.getTraceId(), response2.getMessage());
        }
        return false;
    }

    private boolean inventorySubscribe(String taxNo, String deviceUn) {
        if (StringUtils.isNotBlank((CharSequence)deviceUn)) {
            RestSubscribeDeviceStockRequest request = new RestSubscribeDeviceStockRequest();
            request.setCreatedBy(((UserInfo)this.userInfoHolder.get()).getUserName());
            request.setDeviceUn(deviceUn);
            request.setSubscribeType(Integer.valueOf(1));
            request.setSubscribeValue(this.queuePrefix + "phoenix-sycn-invoice-inventory");
            RestSubscribeDeviceStockResponse response2 = this.deviceApiProxy.deviceStockSubscribe(request);
            logger.debug("\u7a0e\u76d8\u5e93\u5b58\u8ba2\u9605\u7ed3\u679c:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            if ("1".equals(response2.getCode())) {
                this.logSubscribeResult(taxNo, deviceUn, "\u5e93\u5b58\u8ba2\u9605", 1, 1, response2.getResult().getTraceId(), "");
                return true;
            }
            this.logSubscribeResult(taxNo, deviceUn, "\u5e93\u5b58\u8ba2\u9605", 1, 0, response2.getTraceId(), response2.getMessage());
        }
        return false;
    }

    private boolean cancelInventorySubscribe(String taxNo, String deviceUn) {
        if (StringUtils.isNotBlank((CharSequence)deviceUn)) {
            RestCancelDeviceStockRequest request = new RestCancelDeviceStockRequest();
            request.setUpdatedBy(((UserInfo)this.userInfoHolder.get()).getUserName());
            request.setDeviceUn(deviceUn);
            request.setSubscribeType(Integer.valueOf(1));
            request.setSubscribeValue(this.queuePrefix + "phoenix-sycn-invoice-inventory");
            RestCancelDeviceStockResponse response2 = this.deviceApiProxy.cancelInventorySubscribe(request);
            logger.debug("\u53d6\u6d88\u7a0e\u76d8\u5e93\u5b58\u8ba2\u9605\u7ed3\u679c:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            if ("1".equals(response2.getCode())) {
                this.logSubscribeResult(taxNo, deviceUn, "\u53d6\u6d88\u5e93\u5b58\u8ba2\u9605", 2, 1, response2.getResult().getTraceId(), "");
                return true;
            }
            this.logSubscribeResult(taxNo, deviceUn, "\u53d6\u6d88\u5e93\u5b58\u8ba2\u9605", 2, 0, response2.getTraceId(), response2.getMessage());
        }
        return false;
    }

    public RestGetSubscribeResponse getExtractSubscribe(int extractType, String extractValue) {
        RestGetSubscribeResponse response2 = new RestGetSubscribeResponse();
        if (extractType != 1 && extractType != 2) {
            response2.setCode("-1");
            response2.setMessage("\u67e5\u8be2\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (StringUtils.isBlank((CharSequence)extractValue)) {
            response2.setCode("-1");
            response2.setMessage("\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        response2 = this.deviceApiProxy.getGetSubscribeInfo(extractType, extractValue);
        logger.debug("\u7a0e\u76d8\u67e5\u8be2\u8f85\u52a9\u8ba2\u9605\u7ed3\u679c:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
        return response2;
    }

    private void logSubscribeResult(String taxNo, String deviceUn, String subscribeType, int operationType, int status, String traceId, String errorMessage) {
        try {
            CfgSubscribeLogEntity logEntity = new CfgSubscribeLogEntity();
            logEntity.setId(Long.valueOf(this.iDGenerator.nextId()));
            logEntity.setSellerTaxNo(taxNo);
            logEntity.setDeviceUn(deviceUn);
            logEntity.setSubscribeType(subscribeType);
            logEntity.setOperationType(Integer.valueOf(operationType));
            logEntity.setStatus(Integer.valueOf(status));
            logEntity.setTraceid(traceId);
            logEntity.setErrorMessage(errorMessage);
            UserInfo userInfo = (UserInfo)this.userInfoHolder.get();
            logEntity.setOperationUserId(Long.valueOf(userInfo.getUserId()));
            logEntity.setOperationUserName(userInfo.getUserName());
            logEntity.setSellerGroupId(Long.valueOf(userInfo.getGroupId()));
            logEntity.setSellerGroupName(userInfo.getGroupName());
            logEntity.setOperationTime(new Date());
            logger.debug("\u8ba2\u9605\u7ed3\u679c\u8bb0\u5f55\u65e5\u5fd7:{}", (Object)JsonUtils.writeObjectToFastJson((Object)logEntity));
            this.logDao.insert(logEntity);
        }
        catch (Exception e) {
            logger.error("\u8ba2\u9605\u7ed3\u679c\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }
}

