/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.micro.tax.device.contract.model.LimitInfo;
import com.xforceplus.micro.tax.device.contract.model.QualificationInfo;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.repository.dao.TaxInvoiceQuotaInfoDao;
import com.xforceplus.seller.config.repository.model.TaxInvoiceQuotaInfoEntity;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatframework.utils.date.DateUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaxInvoiceQuotaInfoServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(TaxInvoiceQuotaInfoServiceHelper.class);
    private final IDGenerator idGenerator;
    private final TaxInvoiceQuotaInfoDao taxInvoiceQuotaInfoDao;

    public TaxInvoiceQuotaInfoServiceHelper(IDGenerator idGenerator, TaxInvoiceQuotaInfoDao taxInvoiceQuotaInfoDao) {
        this.idGenerator = idGenerator;
        this.taxInvoiceQuotaInfoDao = taxInvoiceQuotaInfoDao;
    }

    public Map<String, TaxInvoiceQuotaInfoEntity> parseTaxLimit(List<QualificationInfo> qualificationInfos) {
        HashMap<String, TaxInvoiceQuotaInfoEntity> limitMap = new HashMap<String, TaxInvoiceQuotaInfoEntity>();
        log.info("taxware qualificationInfos,{}", (Object)JsonUtils.writeObjectToJson(qualificationInfos));
        for (QualificationInfo qualificationInfo : qualificationInfos) {
            List limitInfoList = qualificationInfo.getLimitInfoList();
            if (limitInfoList == null) continue;
            for (LimitInfo limitInfo : limitInfoList) {
                TaxInvoiceQuotaInfoEntity taxInvoiceQuotaInfoEntity = new TaxInvoiceQuotaInfoEntity();
                taxInvoiceQuotaInfoEntity.setId(Long.valueOf(this.idGenerator.nextId()));
                String taxNo = qualificationInfo.getTaxCode();
                taxInvoiceQuotaInfoEntity.setTaxNo(taxNo);
                taxInvoiceQuotaInfoEntity.setRefreshedAt(DateUtil.convertDate((String)qualificationInfo.getLastUpdatedAt(), (String)"yyyyMMddHHmmss"));
                taxInvoiceQuotaInfoEntity.setCreatedAt(new Date());
                taxInvoiceQuotaInfoEntity.setInvoiceType(limitInfo.getInvoiceType());
                taxInvoiceQuotaInfoEntity.setQuota(limitInfo.getSingleAmountLimit());
                taxInvoiceQuotaInfoEntity.setModifiedAt(new Date());
                limitMap.put(limitInfo.getInvoiceType(), taxInvoiceQuotaInfoEntity);
            }
        }
        return limitMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveAndUpdateEntity(Map<String, TaxInvoiceQuotaInfoEntity> limitMap, List<TaxInvoiceQuotaInfoEntity> loadTaxInvoiceQuotaInfoEntityList) {
        if (CollectionUtils.isNotEmpty(loadTaxInvoiceQuotaInfoEntityList)) {
            for (TaxInvoiceQuotaInfoEntity taxInvoiceQuotaInfoEntity : loadTaxInvoiceQuotaInfoEntityList) {
                TaxInvoiceQuotaInfoEntity taxwareInvoiceQuotaInfoEntity;
                if (!limitMap.containsKey(taxInvoiceQuotaInfoEntity.getInvoiceType()) || (taxwareInvoiceQuotaInfoEntity = limitMap.get(taxInvoiceQuotaInfoEntity.getInvoiceType())).getQuota() == null || taxwareInvoiceQuotaInfoEntity.getQuota().compareTo(BigDecimal.ZERO) <= 0) continue;
                taxInvoiceQuotaInfoEntity.setQuota(limitMap.get(taxInvoiceQuotaInfoEntity.getInvoiceType()).getQuota());
                taxInvoiceQuotaInfoEntity.setRefreshedAt(taxwareInvoiceQuotaInfoEntity.getRefreshedAt());
                taxInvoiceQuotaInfoEntity.setModifiedAt(new Date());
                this.taxInvoiceQuotaInfoDao.updateByPrimaryKeySelective(taxInvoiceQuotaInfoEntity);
            }
        }
        limitMap.forEach((key, value) -> {
            if (loadTaxInvoiceQuotaInfoEntityList.stream().noneMatch(item -> item.getInvoiceType().equals(key))) {
                value.setCreatedAt(new Date());
                value.setModifiedAt(new Date());
                this.taxInvoiceQuotaInfoDao.insertSelective(value);
            }
        });
    }
}

