/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.xforceplus.micro.tax.device.contract.model.DeviceQualificationsResult;
import com.xforceplus.seller.config.infrastructure.taxware.InvoiceLimitQueryParam;
import com.xforceplus.seller.config.infrastructure.taxware.TaxWareModel;
import com.xforceplus.seller.config.infrastructure.taxware.TaxWareService;
import com.xforceplus.seller.config.repository.dao.TaxInvoiceQuotaInfoDao;
import com.xforceplus.seller.config.repository.model.TaxInvoiceQuotaInfoEntity;
import com.xforceplus.seller.config.repository.model.TaxInvoiceQuotaInfoExample;
import com.xforceplus.seller.config.services.TaxInvoiceQuotaInfoService;
import com.xforceplus.seller.config.services.TaxInvoiceQuotaInfoServiceHelper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaxInvoiceQuotaInfoServiceImpl
implements TaxInvoiceQuotaInfoService {
    private static final Logger log = LoggerFactory.getLogger(TaxInvoiceQuotaInfoServiceImpl.class);
    private final TaxInvoiceQuotaInfoDao taxInvoiceQuotaInfoDao;
    private final TaxWareService taxWareService;
    private final TaxInvoiceQuotaInfoServiceHelper taxInvoiceQuotaInfoServiceHelper;

    public TaxInvoiceQuotaInfoServiceImpl(TaxInvoiceQuotaInfoDao taxInvoiceQuotaInfoDao, TaxWareService taxWareService, TaxInvoiceQuotaInfoServiceHelper taxInvoiceQuotaInfoServiceHelper) {
        this.taxInvoiceQuotaInfoDao = taxInvoiceQuotaInfoDao;
        this.taxWareService = taxWareService;
        this.taxInvoiceQuotaInfoServiceHelper = taxInvoiceQuotaInfoServiceHelper;
    }

    public TaxInvoiceQuotaInfoEntity getEntityByTaxNoAndType(String taxNo, String invoiceType) {
        if (StringUtils.isNotEmpty((String)taxNo)) {
            TaxInvoiceQuotaInfoExample example = new TaxInvoiceQuotaInfoExample();
            example.createCriteria().andTaxNoEqualTo(taxNo).andInvoiceTypeEqualTo(invoiceType);
            return this.taxInvoiceQuotaInfoDao.selectOneByExample(example);
        }
        return null;
    }

    public List<TaxInvoiceQuotaInfoEntity> getEntityByTaxNo(String taxNo) {
        if (StringUtils.isNotEmpty((String)taxNo)) {
            TaxInvoiceQuotaInfoExample example = new TaxInvoiceQuotaInfoExample();
            example.createCriteria().andTaxNoEqualTo(taxNo);
            return this.taxInvoiceQuotaInfoDao.selectByExample(example);
        }
        return null;
    }

    public BigDecimal getAndFillTaxRateLimitByTaxNo(String taxNo, String invoiceType) {
        BigDecimal taxRateLimit = null;
        try {
            Optional<TaxInvoiceQuotaInfoEntity> taxInvoiceQuotaInfoEntity;
            List loadTaxInvoiceQuotaInfoEntityList = this.getEntityByTaxNo(taxNo);
            taxRateLimit = CollectionUtils.isNotEmpty((Collection)loadTaxInvoiceQuotaInfoEntityList) ? ((taxInvoiceQuotaInfoEntity = loadTaxInvoiceQuotaInfoEntityList.stream().filter(item -> item.getInvoiceType().equals(invoiceType)).findFirst()).isPresent() ? taxInvoiceQuotaInfoEntity.get().getQuota() : this.getRemoteLimitByInvoiceType(taxNo, invoiceType, loadTaxInvoiceQuotaInfoEntityList)) : this.getRemoteLimitByInvoiceType(taxNo, invoiceType, loadTaxInvoiceQuotaInfoEntityList);
        }
        catch (Exception e) {
            log.error("getAndFillTaxRateLimitByTaxNo error", (Throwable)e);
        }
        return taxRateLimit;
    }

    private Map<String, TaxInvoiceQuotaInfoEntity> getInvoiceLimitFromTaxWare(String taxNo, String invoiceType, List<TaxInvoiceQuotaInfoEntity> loadTaxInvoiceQuotaInfoEntityList) {
        InvoiceLimitQueryParam invoiceLimitQueryParam = new InvoiceLimitQueryParam();
        invoiceLimitQueryParam.setTaxCodes(Arrays.asList(taxNo));
        String tenantCode = "183";
        TaxWareModel.TaxWareResponse taxWareResponse = this.taxWareService.getInvoiceLimit(tenantCode, invoiceLimitQueryParam);
        HashMap<String, TaxInvoiceQuotaInfoEntity> limitMap = new HashMap();
        if (taxWareResponse.getCode().equals("TXWR000000") && taxWareResponse.getResult() != null) {
            limitMap = this.taxInvoiceQuotaInfoServiceHelper.parseTaxLimit(((DeviceQualificationsResult)taxWareResponse.getResult()).getQualificationList());
        } else {
            log.warn("get taxware InvoiceLimit error,taxNumber is {},code is {},message is {}", new Object[]{taxNo, taxWareResponse.getCode(), taxWareResponse.getMessage()});
        }
        return limitMap;
    }

    private BigDecimal getRemoteLimitByInvoiceType(String taxNo, String invoiceType, List<TaxInvoiceQuotaInfoEntity> loadTaxInvoiceQuotaInfoEntityList) {
        BigDecimal taxRateLimit = null;
        Map map = this.getInvoiceLimitFromTaxWare(taxNo, invoiceType, loadTaxInvoiceQuotaInfoEntityList);
        this.taxInvoiceQuotaInfoServiceHelper.saveAndUpdateEntity(map, loadTaxInvoiceQuotaInfoEntityList);
        if (map.containsKey(invoiceType) && ((TaxInvoiceQuotaInfoEntity)map.get(invoiceType)).getQuota() != null && ((TaxInvoiceQuotaInfoEntity)map.get(invoiceType)).getQuota().compareTo(BigDecimal.ZERO) > 0) {
            taxRateLimit = ((TaxInvoiceQuotaInfoEntity)map.get(invoiceType)).getQuota();
        }
        return taxRateLimit;
    }
}

