/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.CreateSettledTemplateConfigRequest;
import com.xforceplus.seller.config.client.model.InitSettledTemplateConfigRequest;
import com.xforceplus.seller.config.client.model.SettledTemplateConifgVo;
import com.xforceplus.seller.config.client.model.SettledTemplateEditRequest;
import com.xforceplus.seller.config.converters.TemplateObjMetadataConverter;
import com.xforceplus.seller.config.core.enums.TaxInvoiceSource;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateObjMetadataDao;
import com.xforceplus.seller.config.repository.dao.CfgTemplateSettledObjDao;
import com.xforceplus.seller.config.repository.daoext.CfgTemplateObjExtDao;
import com.xforceplus.seller.config.repository.daoext.CfgTemplateObjMetadataExtDao;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjMetadataEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateObjMetadataExample;
import com.xforceplus.seller.config.repository.model.CfgTemplateSettledObjEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateSettledObjExample;
import com.xforceplus.seller.config.services.TemplateObjMetadataService;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.vavr.Lazy;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.Tuple5;
import io.vavr.control.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateObjMetadataServiceImpl
implements TemplateObjMetadataService {
    private static final Logger log = LoggerFactory.getLogger(TemplateObjMetadataServiceImpl.class);
    private final TemplateObjMetadataConverter templateObjMetadataConverter;
    private final CfgTemplateSettledObjDao cfgTemplateSettledObjDao;
    private final CfgTemplateObjDao cfgTemplateObjDao;
    private final CfgTemplateObjExtDao cfgTemplateObjExtDao;
    private final CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao;
    private final CfgTemplateObjMetadataExtDao cfgTemplateObjMetadataExtDao;
    private final IDGenerator idGenerator;
    private final UserInfoHolder<UserInfo> userInfoHolder;
    public static final Lazy<Set<String>> AUTO_INSTANTIATE_SETTLED_TEMPLATE_CODE = Lazy.of(() -> {
        HashSet set = Sets.newHashSet();
        set.add("bill");
        set.add("systermConfig");
        set.add("invoiceSplitConfig");
        set.add("mergeRule");
        set.add("invoiceMatchConfig");
        set.add("deliveryInvoiceConfig");
        return set;
    });
    public static final Lazy<Set<String>> MANUAL_INSTANTIATE_SETTLED_TEMPLATE_CODE = Lazy.of(() -> {
        HashSet set = Sets.newHashSet();
        set.add("invoiceInfoConfig");
        set.add("invoiceMemberInfoConfig");
        set.add("goodsConfig");
        return set;
    });
    public static final Lazy<Set<String>> TEMPLATE_CODE_WITH_INVOICE_SET = Lazy.of(() -> {
        HashSet set = Sets.newHashSet();
        set.add("invoiceSplitConfig");
        set.add("invoiceMatchConfig");
        set.add("deliveryInvoiceConfig");
        return set;
    });

    public List<CfgTemplateObjEntity> queryTemplateObjBySettledId(Long settledId, Boolean isManual) {
        CfgTemplateObjExample example = new CfgTemplateObjExample();
        CfgTemplateObjExample.Criteria criteria = example.createCriteria();
        criteria.andTemplateObjCodeLike(settledId + "%").andStatusEqualTo(Integer.valueOf(1));
        return this.cfgTemplateObjDao.selectByExample(example).stream().filter(r -> this.filterTemplateCodeObj(r, isManual)).collect(Collectors.toList());
    }

    public List<CfgTemplateObjEntity> queryTemplateObjByCondition(Consumer<CfgTemplateObjExample.Criteria> condition) {
        CfgTemplateObjExample example = new CfgTemplateObjExample();
        CfgTemplateObjExample.Criteria criteria = example.createCriteria();
        condition.accept(criteria);
        return this.cfgTemplateObjDao.selectByExample(example);
    }

    @Transactional(rollbackFor={Exception.class})
    public Either<String, Boolean> initSettledTemplateConfig(CfgTemplateSettledObjEntity settledObjEntity, List<CfgTemplateObjEntity> objEntityList, List<CfgTemplateObjMetadataEntity> metadataEntityList) {
        if (CollectionUtils.isEmpty(objEntityList) || CollectionUtils.isEmpty(metadataEntityList)) {
            return Either.left((Object)"\u521d\u59cb\u5316\u6a21\u7248\u914d\u7f6e\u3001\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.cfgTemplateSettledObjDao.insert(settledObjEntity);
        this.cfgTemplateObjExtDao.batchInsert(objEntityList);
        this.cfgTemplateObjMetadataExtDao.batchInsert(metadataEntityList);
        return Either.right((Object)true);
    }

    @Transactional(rollbackFor={Exception.class})
    public Either<String, Boolean> createSettledTemplateConfig(List<CfgTemplateObjEntity> objEntityList, List<CfgTemplateObjMetadataEntity> metadataEntityList) {
        if (CollectionUtils.isEmpty(objEntityList) || CollectionUtils.isEmpty(metadataEntityList)) {
            return Either.left((Object)"\u521d\u59cb\u5316\u6a21\u7248\u914d\u7f6e\u3001\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.cfgTemplateObjExtDao.batchInsert(objEntityList);
        this.cfgTemplateObjMetadataExtDao.batchInsert(metadataEntityList);
        return Either.right((Object)true);
    }

    public CfgTemplateSettledObjEntity convertSettledObjEntity(InitSettledTemplateConfigRequest initSettledTemplateConfigRequest, UserInfo userInfo) {
        return this.templateObjMetadataConverter.convertSettledObjEntity(initSettledTemplateConfigRequest, this.idGenerator, userInfo);
    }

    public List<CfgTemplateSettledObjEntity> queryPageByCondition(Consumer<CfgTemplateSettledObjExample.Criteria> condition, Integer pageNo, Integer pageSize) {
        CfgTemplateSettledObjExample example = new CfgTemplateSettledObjExample();
        CfgTemplateSettledObjExample.Criteria criteria = example.createCriteria();
        condition.accept(criteria);
        example.setOffset(Integer.valueOf((pageNo - 1) * pageSize));
        example.setLimit(pageSize);
        return this.cfgTemplateSettledObjDao.selectByExample(example);
    }

    public Long countTotalByCondition(Consumer<CfgTemplateSettledObjExample.Criteria> condition) {
        CfgTemplateSettledObjExample example = new CfgTemplateSettledObjExample();
        CfgTemplateSettledObjExample.Criteria criteria = example.createCriteria();
        condition.accept(criteria);
        return this.cfgTemplateSettledObjDao.countByExample(example);
    }

    public CfgTemplateSettledObjEntity queryOneSettledTemplate(Integer settledType, Long tenantId, String productCode) {
        CfgTemplateSettledObjExample example = new CfgTemplateSettledObjExample();
        CfgTemplateSettledObjExample.Criteria criteria = example.createCriteria();
        if (null != settledType) {
            criteria.andSettledTypeEqualTo(settledType);
        }
        criteria.andTenantIdEqualTo(tenantId).andProductCodeEqualTo(productCode).andStatusEqualTo(StatusEnum.NORMAL.getStatus());
        return this.cfgTemplateSettledObjDao.selectOneByExample(example);
    }

    public Either<String, SettledTemplateConifgVo> querySettledTemplateConfigItem(Long settledObjId, Boolean isManual) {
        if (null == settledObjId || settledObjId <= 0L) {
            return Either.left((Object)"\u5165\u9a7b\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List objEntityList = this.queryTemplateObjBySettledId(settledObjId, isManual);
        if (CollectionUtils.isEmpty((Collection)objEntityList)) {
            SettledTemplateConifgVo settledTemplateConifgVo = new SettledTemplateConifgVo();
            settledTemplateConifgVo.setCfgTemplateObjVoList(new ArrayList());
            return Either.right((Object)settledTemplateConifgVo);
        }
        List templateObjIdList = objEntityList.stream().map(CfgTemplateObjEntity::getTemplateObjId).collect(Collectors.toList());
        CfgTemplateObjMetadataExample metadataExample = new CfgTemplateObjMetadataExample();
        metadataExample.createCriteria().andBusinessObjIdIn(templateObjIdList);
        List metadataEntityList = this.cfgTemplateObjMetadataDao.selectByExample(metadataExample);
        Map<Long, List<CfgTemplateObjMetadataEntity>> metadataGroupMap = metadataEntityList.stream().collect(Collectors.groupingBy(CfgTemplateObjMetadataEntity::getBusinessObjId));
        SettledTemplateConifgVo settledTemplateConifgVo = new SettledTemplateConifgVo();
        ArrayList cfgTemplateObjVoList = Lists.newArrayList();
        for (CfgTemplateObjEntity templateObjEntity : objEntityList) {
            List<CfgTemplateObjMetadataEntity> metadataGroup = metadataGroupMap.getOrDefault(templateObjEntity.getTemplateObjId(), Lists.newArrayList());
            if (CollectionUtils.isEmpty(metadataGroup)) continue;
            SettledTemplateConifgVo.CfgTemplateObjVo convertTemplateObjVo = this.templateObjMetadataConverter.convertTemplateObj(templateObjEntity);
            convertTemplateObjVo.setCfgTemplateObjMetadataList(this.templateObjMetadataConverter.convertTemplateObjMetadata(metadataGroup));
            cfgTemplateObjVoList.add(convertTemplateObjVo);
        }
        settledTemplateConifgVo.setCfgTemplateObjVoList((List)cfgTemplateObjVoList);
        return Either.right((Object)settledTemplateConifgVo);
    }

    private boolean filterTemplateCodeObj(CfgTemplateObjEntity objEntity, Boolean isManual) {
        if (null == isManual) {
            return true;
        }
        if (isManual.booleanValue()) {
            return ((Set)MANUAL_INSTANTIATE_SETTLED_TEMPLATE_CODE.get()).stream().anyMatch(r -> objEntity.getTemplateObjCode().contains((CharSequence)r));
        }
        return ((Set)AUTO_INSTANTIATE_SETTLED_TEMPLATE_CODE.get()).stream().anyMatch(r -> objEntity.getTemplateObjCode().contains((CharSequence)r));
    }

    public List<CfgTemplateSettledObjEntity> queryByCondition(Consumer<CfgTemplateSettledObjExample.Criteria> condition) {
        CfgTemplateSettledObjExample example = new CfgTemplateSettledObjExample();
        CfgTemplateSettledObjExample.Criteria criteria = example.createCriteria();
        condition.accept(criteria);
        return this.cfgTemplateSettledObjDao.selectByExample(example);
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteByCondition(List<Long> settledObjIdList, Long userId, String userName) {
        CfgTemplateSettledObjExample example = new CfgTemplateSettledObjExample();
        example.createCriteria().andSettledObjIdIn(settledObjIdList);
        CfgTemplateSettledObjEntity update2 = new CfgTemplateSettledObjEntity();
        update2.setStatus(StatusEnum.DELETE.getStatus());
        update2.setDeleteToken(Long.valueOf(System.currentTimeMillis()));
        update2.setUpdateUserId(userId);
        update2.setUpdateUserName(userName);
        update2.setUpdateTime(new Date());
        return this.cfgTemplateSettledObjDao.updateByExampleSelective(update2, example);
    }

    public Tuple2<List<CfgTemplateObjEntity>, List<CfgTemplateObjMetadataEntity>> convertSettledTemplateInfo(List<List<InitSettledTemplateConfigRequest.CfgTemplateObj>> cfgTemplateObjGroupList, Long settledObjId) {
        if (CollectionUtils.isEmpty(cfgTemplateObjGroupList)) {
            return Tuple.of((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        }
        ArrayList templateCodeList = Lists.newArrayList();
        cfgTemplateObjGroupList.forEach(r -> r.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getTemplateObjCode())).findFirst().ifPresent(obj -> templateCodeList.add(obj.getTemplateObjCode())));
        Map<String, CfgTemplateObjEntity> templateObjMap = this.queryTemplateObjByCondition(r -> r.andTemplateObjCodeIn(templateCodeList).andStatusEqualTo(Integer.valueOf(1))).stream().collect(Collectors.toMap(CfgTemplateObjEntity::getTemplateObjCode, v -> v, (a, b) -> a));
        ArrayList objEntityList = Lists.newArrayList();
        ArrayList metadataEntityList = Lists.newArrayList();
        for (List<InitSettledTemplateConfigRequest.CfgTemplateObj> cfgTemplateObjList : cfgTemplateObjGroupList) {
            for (InitSettledTemplateConfigRequest.CfgTemplateObj cfgTemplateObj : cfgTemplateObjList) {
                CfgTemplateObjEntity templateObjEntity = templateObjMap.getOrDefault(cfgTemplateObj.getTemplateObjCode(), null);
                if (Objects.isNull(templateObjEntity)) continue;
                CfgTemplateObjEntity copied = this.templateObjMetadataConverter.copy(templateObjEntity);
                this.initCfgTemplateObjEntity(copied, cfgTemplateObj, settledObjId);
                List convertedMetadataList = this.templateObjMetadataConverter.convert(cfgTemplateObj.getCfgTemplateObjMetadataList(), copied, this.idGenerator);
                objEntityList.add(copied);
                metadataEntityList.addAll(convertedMetadataList);
            }
        }
        return Tuple.of((Object)objEntityList, (Object)metadataEntityList);
    }

    private void initCfgTemplateObjEntity(CfgTemplateObjEntity templateObjEntity, InitSettledTemplateConfigRequest.CfgTemplateObj cfgTemplateObj, Long settledObjId) {
        templateObjEntity.setTemplateObjId(Long.valueOf(this.idGenerator.nextId()));
        templateObjEntity.setTemplateObjCode(this.joinTemplateCode(cfgTemplateObj, settledObjId));
        Date date = new Date();
        templateObjEntity.setCreateTime(date);
        templateObjEntity.setUpdateTime(date);
        templateObjEntity.setCreateUser(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getUserId()));
        templateObjEntity.setUpdateUser(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getUserId()));
    }

    private String joinTemplateCode(InitSettledTemplateConfigRequest.CfgTemplateObj cfgTemplateObj, Long settledObjId) {
        return this.joinTemplateCode(cfgTemplateObj.getTemplateObjCode(), cfgTemplateObj.getObjCodeExt(), cfgTemplateObj.getTaxInvoiceSource(), settledObjId);
    }

    private String joinTemplateCode(String templateObjCode, String objCodeExt, String taxInvoiceSource, Long settledObjId) {
        StringBuilder templateCodeBuilder = new StringBuilder();
        templateCodeBuilder.append(settledObjId);
        templateCodeBuilder.append("-").append(templateObjCode);
        if (((Set)TEMPLATE_CODE_WITH_INVOICE_SET.get()).contains(templateObjCode)) {
            templateCodeBuilder.append("-").append(objCodeExt);
            templateCodeBuilder.append("-").append(Optional.ofNullable(taxInvoiceSource).orElse(TaxInvoiceSource.SK.getValue()));
        }
        return templateCodeBuilder.toString();
    }

    public int updateTemplateList(List<CfgTemplateObjEntity> cfgTemplateObjEntityList) {
        if (CollectionUtils.isEmpty(cfgTemplateObjEntityList)) {
            return 0;
        }
        return this.cfgTemplateObjExtDao.batchUpdateTemplateByPrimaryKeySelective(cfgTemplateObjEntityList);
    }

    public int updateTemplateItemList(List<CfgTemplateObjMetadataEntity> updateObjMetadataEnityList) {
        if (CollectionUtils.isEmpty(updateObjMetadataEnityList)) {
            return 0;
        }
        return this.cfgTemplateObjMetadataExtDao.batchUpdateObjMetadataByPrimaryKeySelective(updateObjMetadataEnityList);
    }

    public int deleteTemplateList(List<Long> templateObjIdList) {
        if (CollectionUtils.isEmpty(templateObjIdList)) {
            return 0;
        }
        CfgTemplateObjEntity update2 = new CfgTemplateObjEntity();
        update2.setStatus(Integer.valueOf(0));
        update2.setUpdateTime(new Date());
        CfgTemplateObjExample updateExample = new CfgTemplateObjExample();
        updateExample.createCriteria().andTemplateObjIdIn(templateObjIdList);
        return this.cfgTemplateObjDao.updateByExampleSelective(update2, updateExample);
    }

    public Either<String, Boolean> addTemplateList(List<CfgTemplateObjEntity> objEntityList, List<CfgTemplateObjMetadataEntity> metadataEntityList) {
        if (CollectionUtils.isEmpty(objEntityList) || CollectionUtils.isEmpty(metadataEntityList)) {
            return Either.left((Object)"\u65b0\u589e\u6a21\u7248\u914d\u7f6e\u3001\u914d\u7f6e\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.cfgTemplateObjExtDao.batchInsert(objEntityList);
        this.cfgTemplateObjMetadataExtDao.batchInsert(metadataEntityList);
        return Either.right((Object)true);
    }

    public Either<String, Tuple5<List<CfgTemplateObjEntity>, List<CfgTemplateObjMetadataEntity>, List<Long>, List<CfgTemplateObjEntity>, List<CfgTemplateObjMetadataEntity>>> checkEditTemplateInfoParam(SettledTemplateEditRequest request) {
        List updateObjMetadataEnityList = Lists.newArrayList();
        List updateTemplateEnityList = Lists.newArrayList();
        SettledTemplateEditRequest.UpdateTemplateInfo updateTemplateInfo = request.getUpdateTemplateInfo();
        if (Objects.nonNull(updateTemplateInfo)) {
            List updateTemplateList;
            List updateItemList = updateTemplateInfo.getUpdateMetadataList();
            if (CollectionUtils.isNotEmpty((Collection)updateItemList)) {
                if (updateItemList.stream().anyMatch(r -> null == r.getBusinessObjMetadataId() || r.getBusinessObjMetadataId() <= 0L)) {
                    return Either.left((Object)"\u66f4\u65b0\u7684\u6a21\u7248\u914d\u7f6e\u9879\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a.");
                }
                updateObjMetadataEnityList = this.templateObjMetadataConverter.convert(updateItemList);
            }
            if (CollectionUtils.isNotEmpty((Collection)(updateTemplateList = updateTemplateInfo.getUpdateTemplateList()))) {
                if (updateTemplateList.stream().anyMatch(r -> null == r.getTemplateObjId() || r.getTemplateObjId() <= 0L)) {
                    return Either.left((Object)"\u66f4\u65b0\u6a21\u7248\u4fe1\u606f\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a.");
                }
                CfgTemplateObjExample example = new CfgTemplateObjExample();
                List templateIdList = updateTemplateList.stream().map(SettledTemplateEditRequest.UpdateTemplate::getTemplateObjId).distinct().collect(Collectors.toList());
                example.createCriteria().andTemplateObjIdIn(templateIdList).andStatusEqualTo(Integer.valueOf(1));
                Map<Long, String> templateCodeMap = this.cfgTemplateObjDao.selectByExample(example).stream().collect(Collectors.toMap(CfgTemplateObjEntity::getTemplateObjId, CfgTemplateObjEntity::getTemplateObjCode, (oldValue, newValue) -> newValue));
                if (templateCodeMap.size() != templateIdList.size()) {
                    return Either.left((Object)"\u66f4\u65b0\u6a21\u7248\u4fe1\u606f\u4e3b\u952e\u4e0d\u5b58\u5728.");
                }
                updateTemplateEnityList = this.convertTemplateList(updateTemplateList, templateCodeMap);
            }
        }
        List deleteTemplateObjIdList = Lists.newArrayList();
        SettledTemplateEditRequest.DeleteTemplateInfo deleteTemplateInfo = request.getDeleteTemplateInfo();
        if (Objects.nonNull(deleteTemplateInfo) && CollectionUtils.isNotEmpty((Collection)deleteTemplateInfo.getTemplateObjIdList())) {
            deleteTemplateObjIdList = deleteTemplateInfo.getTemplateObjIdList();
            if (null == deleteTemplateInfo.getSettledObjId() || deleteTemplateInfo.getSettledObjId() <= 0L) {
                return Either.left((Object)"\u5220\u9664\u7684\u6a21\u7248\u5165\u9a7b\u8bb0\u5f55\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            Set templateIdSet = this.queryTemplateObjBySettledId(deleteTemplateInfo.getSettledObjId(), null).stream().map(CfgTemplateObjEntity::getTemplateObjId).collect(Collectors.toSet());
            if (deleteTemplateObjIdList.stream().anyMatch(r -> !templateIdSet.contains(r))) {
                return Either.left((Object)"\u5220\u9664\u7684\u6a21\u7248\u5165\u9a7b\u8bb0\u5f55\u4e3b\u952e\u4e0d\u5b58\u5728.");
            }
        }
        Tuple2 tupleResult = Tuple.of((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        SettledTemplateEditRequest.AddSettledTemplateInfo settledTemplateObj = request.getAddSettledTemplateInfo();
        if (Objects.nonNull(settledTemplateObj) && CollectionUtils.isNotEmpty((Collection)settledTemplateObj.getTemplateGroupList())) {
            if (null == settledTemplateObj.getSettledObjId() || settledTemplateObj.getSettledObjId() <= 0L) {
                return Either.left((Object)"\u65b0\u589e\u6a21\u7248\u5165\u9a7b\u8bb0\u5f55\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            tupleResult = this.convertSettledTemplateInfo(settledTemplateObj.getTemplateGroupList(), settledTemplateObj.getSettledObjId());
        }
        return Either.right((Object)Tuple.of((Object)updateTemplateEnityList, (Object)updateObjMetadataEnityList, (Object)deleteTemplateObjIdList, (Object)tupleResult._1, (Object)tupleResult._2));
    }

    private List<CfgTemplateObjEntity> convertTemplateList(List<SettledTemplateEditRequest.UpdateTemplate> updateTemplateList, Map<Long, String> templateCodeMap) {
        ArrayList templateObjEntityList = Lists.newArrayList();
        for (SettledTemplateEditRequest.UpdateTemplate template : updateTemplateList) {
            CfgTemplateObjEntity update2 = new CfgTemplateObjEntity();
            String originObjCode = templateCodeMap.getOrDefault(template.getTemplateObjId(), "");
            String[] arrayCodeStr = originObjCode.split("-");
            if (arrayCodeStr.length < 2) continue;
            Long settledObjId = Long.valueOf(arrayCodeStr[0]);
            String joinedObjCode = this.joinTemplateCode(template.getTemplateObjCode(), template.getObjCodeExt(), template.getTaxInvoiceSource(), settledObjId);
            update2.setTemplateObjId(template.getTemplateObjId());
            update2.setTemplateObjCode(joinedObjCode);
            update2.setUpdateTime(new Date());
            templateObjEntityList.add(update2);
        }
        return templateObjEntityList;
    }

    @Transactional(rollbackFor={Exception.class})
    public Either<String, Boolean> editTemplateInfo(List<CfgTemplateObjEntity> updateTemplateEnityList, List<CfgTemplateObjMetadataEntity> updateObjMetadataEnityList, List<Long> deleteTemplateObjIdList, Tuple2<List<CfgTemplateObjEntity>, List<CfgTemplateObjMetadataEntity>> addTemplateInfo) {
        if (CollectionUtils.isNotEmpty(updateTemplateEnityList)) {
            this.updateTemplateList(updateTemplateEnityList);
        }
        if (CollectionUtils.isNotEmpty(updateObjMetadataEnityList)) {
            this.updateTemplateItemList(updateObjMetadataEnityList);
        }
        if (CollectionUtils.isNotEmpty(deleteTemplateObjIdList)) {
            this.deleteTemplateList(deleteTemplateObjIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)addTemplateInfo._1)) && CollectionUtils.isNotEmpty((Collection)((Collection)addTemplateInfo._2))) {
            this.addTemplateList((List)addTemplateInfo._1, (List)addTemplateInfo._2);
        }
        return Either.right((Object)true);
    }

    public Tuple2<List<CfgTemplateObjEntity>, List<CfgTemplateObjMetadataEntity>> convertSettledTemplateConfig(List<List<CreateSettledTemplateConfigRequest.CfgTemplateObj>> cfgTemplateObjGroupList, Long settledObjId) {
        if (CollectionUtils.isEmpty(cfgTemplateObjGroupList)) {
            return Tuple.of((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        }
        ArrayList templateCodeList = Lists.newArrayList();
        cfgTemplateObjGroupList.forEach(r -> r.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getTemplateObjCode())).findFirst().ifPresent(obj -> templateCodeList.add(obj.getTemplateObjCode())));
        Map<String, CfgTemplateObjEntity> templateObjMap = this.queryTemplateObjByCondition(r -> r.andTemplateObjCodeIn(templateCodeList).andStatusEqualTo(Integer.valueOf(1))).stream().collect(Collectors.toMap(CfgTemplateObjEntity::getTemplateObjCode, v -> v, (a, b) -> a));
        ArrayList objEntityList = Lists.newArrayList();
        ArrayList metadataEntityList = Lists.newArrayList();
        for (List<CreateSettledTemplateConfigRequest.CfgTemplateObj> cfgTemplateObjList : cfgTemplateObjGroupList) {
            for (CreateSettledTemplateConfigRequest.CfgTemplateObj cfgTemplateObj : cfgTemplateObjList) {
                CfgTemplateObjEntity templateObjEntity = templateObjMap.getOrDefault(cfgTemplateObj.getTemplateObjCode(), null);
                if (Objects.isNull(templateObjEntity)) continue;
                CfgTemplateObjEntity copied = this.templateObjMetadataConverter.copy(templateObjEntity);
                this.initCfgTemplateObjEntity(copied, cfgTemplateObj, settledObjId);
                List convertedMetadataList = this.templateObjMetadataConverter.convertSettledTemplateConfig(cfgTemplateObj.getCfgTemplateObjMetadataList(), copied, this.idGenerator);
                objEntityList.add(copied);
                metadataEntityList.addAll(convertedMetadataList);
            }
        }
        return Tuple.of((Object)objEntityList, (Object)metadataEntityList);
    }

    private void initCfgTemplateObjEntity(CfgTemplateObjEntity templateObjEntity, CreateSettledTemplateConfigRequest.CfgTemplateObj cfgTemplateObj, Long settledObjId) {
        templateObjEntity.setTemplateObjId(Long.valueOf(this.idGenerator.nextId()));
        String templateCode = this.joinTemplateCode(cfgTemplateObj.getTemplateObjCode(), cfgTemplateObj.getObjCodeExt(), cfgTemplateObj.getTaxInvoiceSource(), settledObjId);
        templateObjEntity.setTemplateObjCode(templateCode);
        Date date = new Date();
        templateObjEntity.setCreateTime(date);
        templateObjEntity.setUpdateTime(date);
        templateObjEntity.setCreateUser(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getUserId()));
        templateObjEntity.setUpdateUser(Long.valueOf(((UserInfo)this.userInfoHolder.get()).getUserId()));
    }

    public TemplateObjMetadataServiceImpl(TemplateObjMetadataConverter templateObjMetadataConverter, CfgTemplateSettledObjDao cfgTemplateSettledObjDao, CfgTemplateObjDao cfgTemplateObjDao, CfgTemplateObjExtDao cfgTemplateObjExtDao, CfgTemplateObjMetadataDao cfgTemplateObjMetadataDao, CfgTemplateObjMetadataExtDao cfgTemplateObjMetadataExtDao, IDGenerator idGenerator, UserInfoHolder<UserInfo> userInfoHolder) {
        this.templateObjMetadataConverter = templateObjMetadataConverter;
        this.cfgTemplateSettledObjDao = cfgTemplateSettledObjDao;
        this.cfgTemplateObjDao = cfgTemplateObjDao;
        this.cfgTemplateObjExtDao = cfgTemplateObjExtDao;
        this.cfgTemplateObjMetadataDao = cfgTemplateObjMetadataDao;
        this.cfgTemplateObjMetadataExtDao = cfgTemplateObjMetadataExtDao;
        this.idGenerator = idGenerator;
        this.userInfoHolder = userInfoHolder;
    }
}

