/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.config.client.model.PersonTitleDto;
import com.xforceplus.seller.config.converters.PersonTitleConverter;
import com.xforceplus.seller.config.repository.dao.Cfg3rdPersonalTitleDao;
import com.xforceplus.seller.config.repository.model.Cfg3rdPersonalTitleEntity;
import com.xforceplus.seller.config.repository.model.Cfg3rdPersonalTitleExample;
import com.xforceplus.seller.config.services.ThirdPersonTitleService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdPersonTitleServiceImpl
implements ThirdPersonTitleService {
    @Autowired
    private Cfg3rdPersonalTitleDao cfg3rdPersonalTitleDao;
    @Autowired
    private IDGenerator idGenerator;
    @Autowired
    private PersonTitleConverter personTitleConverter;

    public int insertPerson(PersonTitleDto dto) {
        Cfg3rdPersonalTitleEntity entity = new Cfg3rdPersonalTitleEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        entity.setId(Long.valueOf(this.idGenerator.nextId()));
        entity.setCreateTime(new Date());
        entity.setUpdateTime(new Date());
        return this.cfg3rdPersonalTitleDao.insert(entity);
    }

    public int updatePerson(PersonTitleDto dto) {
        Cfg3rdPersonalTitleEntity entity = new Cfg3rdPersonalTitleEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        entity.setUpdateTime(new Date());
        return this.cfg3rdPersonalTitleDao.updateByPrimaryKeySelective(entity);
    }

    public int deletePerson(PersonTitleDto dto) {
        Cfg3rdPersonalTitleEntity entity = new Cfg3rdPersonalTitleEntity();
        entity.setUpdateTime(new Date());
        entity.setId(dto.getId());
        entity.setIsDeleted(Boolean.valueOf(true));
        return this.cfg3rdPersonalTitleDao.updateByPrimaryKeySelective(entity);
    }

    public int cancelDefaultByOpenIdOrUserId(String aliUserId, String wxOpenId) {
        Cfg3rdPersonalTitleExample example = new Cfg3rdPersonalTitleExample();
        Cfg3rdPersonalTitleExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank((String)aliUserId)) {
            criteria.andAliUserIdEqualTo(aliUserId);
        }
        if (StringUtils.isNotBlank((String)wxOpenId)) {
            criteria.andWxOpenIdEqualTo(wxOpenId);
        }
        Cfg3rdPersonalTitleEntity entity = new Cfg3rdPersonalTitleEntity();
        entity.setUpdateTime(new Date());
        entity.setIsDefault(Boolean.valueOf(false));
        return this.cfg3rdPersonalTitleDao.updateByExampleSelective(entity, example);
    }

    public List<PersonTitleDto> query(PersonTitleDto dto) {
        Cfg3rdPersonalTitleExample example = new Cfg3rdPersonalTitleExample();
        Cfg3rdPersonalTitleExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotEmpty((String)dto.getWxOpenId())) {
            criteria.andWxOpenIdEqualTo(dto.getWxOpenId());
        }
        if (StringUtils.isNotEmpty((String)dto.getAliUserId())) {
            criteria.andAliUserIdEqualTo(dto.getAliUserId());
        }
        if (StringUtils.isNotEmpty((String)dto.getBuyerCompanyName())) {
            criteria.andBuyerCompanyNameLike(dto.getBuyerCompanyName() + "%");
        }
        if (dto.getDefault() != null) {
            criteria.andIsDefaultEqualTo(dto.getDefault());
        }
        example.setOrderByClause("create_time desc");
        List list = this.cfg3rdPersonalTitleDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        List dtoList = this.personTitleConverter.convert(list);
        return dtoList;
    }
}

