/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services.importservice;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.infrastructure.usercenter.controllers.UserCenterController;
import com.xforceplus.phoenix.infrastructure.usercenter.model.CompanyData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.OrgData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.TenantData;
import com.xforceplus.phoenix.infrastructure.usercenter.model.UserCenterResponse;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import com.xforceplus.seller.config.client.constant.SellerOrgTypeEnum;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigBizBillAttribute;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsGroupTypeBean;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.core.enums.FieldGroupIndex;
import com.xforceplus.seller.config.infrastructure.cache.LocalCacheManager;
import com.xforceplus.seller.config.models.ConfigBase;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInterfaceExtDao;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjExample;
import com.xforceplus.seller.config.repository.model.CfgConfigInterfaceEntity;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.adapter.AdapterConfig;
import com.xforceplus.seller.config.services.adapter.AdapterService;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.seller.config.util.DingDingUtils;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cglib.beans.BeanMap;

public abstract class AbstractImportService<T extends ConfigBase> {
    private static final Logger log = LoggerFactory.getLogger(AbstractImportService.class);
    protected final List<String> billFields = Arrays.asList("invoiceRemarkFiledList");
    protected final List<String> billItemFields = Arrays.asList("splitFiledList");
    protected final List<String> joinCharList = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8");
    @Value(value="${config.import.split.replace:\u8d26@\u5e10}")
    protected String splitReplace;
    private final LocalCacheManager localCacheManager;
    private final DingDingUtils dingDingUtils;
    private final ConfigBizConfigService configBizConfigService;
    private final CfgConfigInterfaceExtDao cfgConfigInterfaceExtDao;
    private final UserInfoHolder<UserInfo> userInfoHolder;
    private final CfgBusinessObjDao cfgBusinessObjDao;
    private final AdapterConfig adapterConfig;
    private final AdapterService adapterService;
    private final UserCenterController userCenterController;

    @Autowired
    public AbstractImportService(LocalCacheManager localCacheManager, DingDingUtils dingDingUtils, ConfigBizConfigService configBizConfigService, CfgConfigInterfaceExtDao cfgConfigInterfaceExtDao, UserInfoHolder<UserInfo> userInfoHolder, CfgBusinessObjDao cfgBusinessObjDao, AdapterConfig adapterConfig, AdapterService adapterService, UserCenterController userCenterController) {
        this.localCacheManager = localCacheManager;
        this.dingDingUtils = dingDingUtils;
        this.configBizConfigService = configBizConfigService;
        this.cfgConfigInterfaceExtDao = cfgConfigInterfaceExtDao;
        this.userInfoHolder = userInfoHolder;
        this.cfgBusinessObjDao = cfgBusinessObjDao;
        this.adapterConfig = adapterConfig;
        this.adapterService = adapterService;
        this.userCenterController = userCenterController;
    }

    public final void doImport(List<T> list, Map<String, Object> headers) {
        MsCommonUserInfo userInfo = this.getUserInfo(headers);
        Long importBatchNo = Long.parseLong(String.valueOf(headers.get("importBatchNo")));
        for (ConfigBase importData : list) {
            String errorMessage = "";
            try {
                importData.setBatchNo(importBatchNo);
                importData.setConfigType((String)headers.get("configType"));
                MsConfigBean configBean = this.buildConfigBean(importData);
                errorMessage = this.doValidation(userInfo, configBean, importData);
                log.info("AbstractImportService.doImport.doValidation finish batchNo:{} errorMessage:{}", (Object)importBatchNo, (Object)errorMessage);
                this.buildAdditionalAttribute(userInfo.getGroupId(), configBean, importData);
                MsConfigAddRequestWithUserInfo request = this.buildConfigAddRequest(userInfo, configBean);
                if (StringUtils.isBlank((CharSequence)errorMessage)) {
                    Response response2 = this.addConfig(request);
                    log.info("AbstractImportService.doImport.addCfgConfig.finish batchNo:{}", (Object)importBatchNo);
                    if (response2.getCode() != 1) {
                        errorMessage = errorMessage + response2.getMessage();
                    }
                }
            }
            catch (Exception e) {
                log.error("AbstractImportService add config exception batchNo:" + importBatchNo + e.getMessage(), (Throwable)e);
                errorMessage = errorMessage + (e.getMessage() == null ? "\u7cfb\u7edf\u9519\u8bef" : e.getMessage());
            }
            this.insertConfigInterFace(importData, errorMessage);
        }
    }

    protected MsConfigAddRequestWithUserInfo buildConfigAddRequest(MsCommonUserInfo userInfo, MsConfigBean configBean) {
        MsConfigAddRequestWithUserInfo request = new MsConfigAddRequestWithUserInfo();
        request.setUserInfo(userInfo);
        request.setItemDTOList((List)Lists.newArrayList((Object[])new MsConfigBean[]{configBean}));
        return request;
    }

    protected Response addConfig(MsConfigAddRequestWithUserInfo request) {
        return this.configBizConfigService.addCfgConfig(request, new String[0]);
    }

    public String doValidation(MsCommonUserInfo userInfo, MsConfigBean configBean, T t) {
        String msgFmSV = this.doStandardValidation(configBean, userInfo);
        log.info("AbstractImportService.doStandardValidation.msgFmSV:{}", (Object)msgFmSV);
        String msgFmIV = this.doIndividualValidation(configBean, t, userInfo);
        log.info("AbstractImportService.doIndividualValidation.msgFmIV:{}", (Object)msgFmIV);
        return msgFmSV + msgFmIV;
    }

    protected abstract void buildAdditionalAttribute(Long var1, MsConfigBean var2, T var3);

    protected abstract MsConfigBean buildConfigBean(T var1);

    protected abstract String doIndividualValidation(MsConfigBean var1, T var2, MsCommonUserInfo var3);

    public String doStandardValidation(MsConfigBean configBean, MsCommonUserInfo userInfo) {
        StringBuilder msg = new StringBuilder();
        if (CommonTools.isEmpty((String)configBean.getSalesbillType())) {
            msg.append("--").append("\u521b\u5efa\u65b9\u5fc5\u987b\u586b\u5199").append("--");
        } else if (!BusinessSalesBillTypeEnum.checkIsExist((String)configBean.getBusinessBillType())) {
            msg.append("--").append("\u521b\u5efa\u65b9\u5fc5\u987b\u662fAR \u6216\u8005 AP").append("--");
        }
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(configBean.getBusinessBillType()) && CommonTools.isEmpty((String)configBean.getSellerTaxNo())) {
            msg.append("--").append("\u521b\u5efa\u65b9\u662fAR,\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a").append("--");
        }
        if (BusinessSalesBillTypeEnum.AP.getBusinessSalesBillType().equals(configBean.getBusinessBillType()) && CommonTools.isEmpty((String)configBean.getPurchaserTaxNo())) {
            msg.append("--").append("\u521b\u5efa\u65b9\u662fAP,\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a").append("--");
        }
        if (CommonTools.isEmpty((String)configBean.getSellerTaxNo()) && !CommonTools.isEmpty((String)configBean.getSellerName())) {
            msg.append("--").append("\u9500\u65b9\u7a0e\u53f7\u4e3a\u7a7a,\u9500\u65b9\u516c\u53f8\u540d\u79f0\u5fc5\u987b\u4e3a\u7a7a").append("--");
        } else if (!CommonTools.isEmpty((String)configBean.getSellerTaxNo()) && CommonTools.isEmpty((String)configBean.getSellerName())) {
            msg.append("--").append("\u9500\u65b9\u516c\u53f8\u4e3a\u7a7a,\u9500\u65b9\u540d\u79f0\u5fc5\u987b\u4e3a\u7a7a").append("--");
        }
        if (CommonTools.isEmpty((String)configBean.getPurchaserTaxNo()) && !CommonTools.isEmpty((String)configBean.getPurchaserName())) {
            msg.append("--").append("\u8d2d\u65b9\u7a0e\u53f7\u4e3a\u7a7a,\u8d2d\u65b9\u516c\u53f8\u540d\u79f0\u5fc5\u987b\u4e3a\u7a7a").append("--");
        } else if (CommonTools.isEmpty((String)configBean.getPurchaserName()) && !CommonTools.isEmpty((String)configBean.getPurchaserTaxNo())) {
            msg.append("--").append("\u8d2d\u65b9\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a,\u8d2d\u65b9\u7a0e\u53f7\u5fc5\u987b\u4e3a\u7a7a").append("--");
        }
        if (CommonTools.isEmpty((String)configBean.getSalesbillType())) {
            msg.append("--").append("\u4e1a\u52a1\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a").append("--");
        } else {
            CfgBusinessObjExample cfgBusinessObjExample = new CfgBusinessObjExample();
            cfgBusinessObjExample.createCriteria().andGroupIdEqualTo(userInfo.getGroupId()).andObjNameEqualTo(configBean.getSalesbillType().trim()).andObjStatusEqualTo(Integer.valueOf(1));
            long l = this.cfgBusinessObjDao.countByExample(cfgBusinessObjExample);
            if (l == 0L) {
                if (this.adapterConfig.isAdapterOpen(userInfo.getGroupId()).booleanValue()) {
                    MsMataDataQueryRequest msMataDataQueryRequest = new MsMataDataQueryRequest();
                    msMataDataQueryRequest.setGroupId(userInfo.getGroupId());
                    List msGroupTypeBeans = this.adapterService.queryGroupObjType(msMataDataQueryRequest);
                    MsGroupTypeBean temp = msGroupTypeBeans.stream().filter(msGroupTypeBean -> msGroupTypeBean.getObjType().equals(configBean.getSalesbillType())).findFirst().orElse(null);
                    if (temp == null) {
                        msg.append("--").append("\u4e1a\u52a1\u5355\u7c7b\u578b\u5728\u8be5\u96c6\u56e2\u4e0d\u5b58\u5728").append("--");
                    }
                } else {
                    msg.append("--").append("\u4e1a\u52a1\u5355\u7c7b\u578b\u5728\u8be5\u96c6\u56e2\u4e0d\u5b58\u5728").append("--");
                }
            }
        }
        if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().intValue() == configBean.getConfigType().intValue() && CommonTools.isEmpty((String)configBean.getInvoiceType())) {
            msg.append("--").append("\u62c6\u7968\u89c4\u5219\u7684\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a").append("--");
        }
        if (CommonTools.isEmpty((String)configBean.getConfigName())) {
            msg.append("--").append("\u914d\u7f6e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a").append("--");
        }
        return msg.toString();
    }

    protected UserCenterResponse<CompanyData> getCompanyInfo(Long sellerGroupId, String sellerTaxNo) {
        return this.userCenterController.getCompanyByTaxNo(sellerGroupId.longValue(), sellerTaxNo);
    }

    protected UserCenterResponse<TenantData> getTenantInfo(Long sellerGroupId) {
        return this.userCenterController.getTenantByTenantId(sellerGroupId.longValue());
    }

    protected UserCenterResponse<OrgData> getOrgInfo(Long sellerGroupId, String orgCode) {
        return this.userCenterController.getOrgByCode(sellerGroupId.longValue(), orgCode);
    }

    private boolean isValidResponse(UserCenterResponse result) {
        return result.getResult() != null && "1".equals(result.getCode());
    }

    protected String validateSellerOrgValue(MsCommonUserInfo userInfo, ConfigBase configBase, MsConfigBean configBean) {
        String sellerOrgType = StringUtils.isBlank((CharSequence)configBase.getSellerOrgType()) ? SellerOrgTypeEnum.COMPANY.getValue() : configBase.getSellerOrgType();
        StringBuilder sb = new StringBuilder();
        switch (sellerOrgType) {
            case "1": {
                if (StringUtils.isBlank((CharSequence)configBase.getSellerTaxNo())) {
                    String msgStr = "\u9500\u65b9\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7a0e\u53f7\u65f6\uff0c\u9500\u65b9\u516c\u53f8\u7a0e\u53f7" + configBase.getSellerTaxNo() + "\u9700\u8981\u586b\u5199\u4e3a\u516c\u53f8\u7a0e\u53f7";
                    log.error(msgStr);
                    sb.append(msgStr);
                    break;
                }
                UserCenterResponse result = this.getCompanyInfo(userInfo.getGroupId(), configBase.getSellerTaxNo());
                if (this.isValidResponse(result)) break;
                sb.append("--").append("\u67e5\u8be2\u4e0d\u5230\u8be5\u7a0e\u53f7").append("--");
                break;
            }
            case "2": {
                configBean.setSellerName("");
                configBean.setSellerTaxNo("");
                if (StringUtils.isNotBlank((CharSequence)configBase.getSellerTaxNo()) && !StringUtils.isNumeric((CharSequence)configBase.getSellerTaxNo())) {
                    String msgStr = "\u9500\u65b9\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u96c6\u56e2\u65f6\uff0c\u9500\u65b9\u516c\u53f8\u7a0e\u53f7" + configBase.getSellerTaxNo() + "\u9700\u8981\u586b\u5199\u4e3a\u79df\u6237ID";
                    log.error(msgStr);
                    sb.append(msgStr);
                }
                configBase.setSellerName("");
                configBase.setSellerTaxNo("");
                break;
            }
            case "3": {
                configBean.setSellerName("");
                configBean.setSellerTaxNo("");
                if (StringUtils.isBlank((CharSequence)configBase.getSellerTaxNo())) {
                    String msgStr = "\u9500\u65b9\u7ec4\u7ec7\u7c7b\u578b\u4e3a\u7ec4\u7ec7\u65f6\uff0c\u9500\u65b9\u516c\u53f8\u7a0e\u53f7" + configBase.getSellerTaxNo() + "\u9700\u8981\u586b\u5199\u4e3a\u7ec4\u7ec7\u4ee3\u7801";
                    log.error(msgStr);
                    sb.append(msgStr);
                } else {
                    configBean.setSysOrgCode(configBase.getSellerTaxNo());
                    UserCenterResponse result = this.getOrgInfo(userInfo.getGroupId(), configBean.getSysOrgCode());
                    if (!this.isValidResponse(result)) {
                        sb.append("--").append("\u67e5\u8be2\u4e0d\u5230\u8be5\u7ec4\u7ec7").append("--");
                    } else {
                        configBean.setSysOrgId((Long)Optional.ofNullable(result.getResult()).map(OrgData::getOrgId).orElse(null));
                    }
                }
                configBase.setSellerName("");
                configBase.setSellerTaxNo("");
                break;
            }
        }
        return sb.toString();
    }

    protected MsCommonUserInfo getUserInfo(Map<String, Object> headers) {
        MsCommonUserInfo userInfo = new MsCommonUserInfo();
        userInfo.setUserId(Long.valueOf(Long.parseLong(String.valueOf(headers.get("userId")))));
        userInfo.setUserName(String.valueOf(headers.get("userName")));
        userInfo.setGroupId(Long.valueOf(Long.parseLong(String.valueOf(headers.get("groupId")))));
        userInfo.setGroupCode(String.valueOf(headers.get("groupCode")));
        userInfo.setGroupName(String.valueOf(headers.get("groupName")));
        this.setContextUserInfo(headers);
        return userInfo;
    }

    protected void setContextUserInfo(Map<String, Object> headers) {
        UserInfo userInfo = new UserInfo();
        if (headers.get("groupId") != null) {
            userInfo.setGroupId(Long.parseLong(String.valueOf(headers.get("groupId"))));
        }
        this.userInfoHolder.put((Object)userInfo);
    }

    protected void insertConfigInterFace(ConfigBase config, String msg) {
        CfgConfigInterfaceEntity entity = new CfgConfigInterfaceEntity();
        entity.setBatchNo(config.getBatchNo());
        entity.setSalesbillType(config.getSalesbillType());
        entity.setBusinessBillType(config.getBusinessBillType() == null ? "" : config.getBusinessBillType());
        entity.setSellerName(config.getSellerName() == null ? "" : config.getSellerName());
        String sellerTaxNo = config.getSellerTaxNo() == null ? "" : (config.getSellerTaxNo().length() > 30 ? config.getSellerTaxNo().substring(0, 30) : config.getSellerTaxNo());
        entity.setSellerTaxNo(sellerTaxNo);
        entity.setPurchaserName(config.getPurchaserName() == null ? "" : config.getPurchaserName());
        entity.setPurchaserTaxNo(config.getPurchaserTaxNo() == null ? "" : config.getPurchaserTaxNo());
        entity.setConfigType(Integer.valueOf(config.getConfigType()));
        entity.setInvoiceType(config.getInvoiceType() == null ? "" : config.getInvoiceType());
        entity.setConfigName(config.getConfigName() == null ? "" : config.getConfigName());
        String json = JsonUtils.writeObjectToFastJson((Object)config);
        entity.setOrigData(json);
        if (!CommonTools.isEmpty((String)msg)) {
            entity.setProcessFlag("F");
            entity.setProcessRemark(msg);
        } else {
            entity.setProcessFlag("S");
            entity.setProcessRemark("");
        }
        entity.setStatus(Integer.valueOf(1));
        entity.setCreateTime(new Date());
        this.cfgConfigInterfaceExtDao.insertWithDefaultValue(entity);
    }

    public List<MsConfigItemBean> getBeanItemList(BeanMap beanMap, Field[] declaredFields, String salesBillType, Long groupId, List<MsConfigBizBillAttribute> outAttributeEntityList) {
        ArrayList mainExtFieldList = Lists.newArrayList();
        ArrayList mainExtFieldValueList = Lists.newArrayList();
        ArrayList mainPropertyKeyList = Lists.newArrayList();
        ArrayList mainPropertyValueList = Lists.newArrayList();
        ArrayList configItemList = Lists.newArrayList();
        for (int j = 0; j < declaredFields.length; ++j) {
            String keys;
            String val;
            String fieldName = declaredFields[j].getName();
            if (fieldName.contains("$")) continue;
            ArrayList<String> value = new ArrayList<String>(1);
            if (this.billItemFields.contains(fieldName) && salesBillType != null) {
                val = String.valueOf(beanMap.get((Object)fieldName));
                value.addAll(this.getFieldEnName(salesBillType, groupId, val));
            } else if (this.billFields.contains(fieldName) && salesBillType != null) {
                val = String.valueOf(beanMap.get((Object)fieldName));
                if (CommonTools.isEmpty((String)val)) continue;
                value.addAll(this.getFieldEnNameForBill(salesBillType, groupId, val));
            } else if ("mainExtFields".equals(fieldName)) {
                keys = Optional.ofNullable(beanMap.get((Object)fieldName)).map(String::valueOf).orElse("");
                if (!StringUtils.isEmpty((CharSequence)keys)) {
                    Collections.addAll(mainExtFieldList, keys.split(";"));
                }
            } else if ("mainExtFieldValues".equals(fieldName)) {
                keys = Optional.ofNullable(beanMap.get((Object)fieldName)).map(String::valueOf).orElse("");
                if (!StringUtils.isEmpty((CharSequence)keys)) {
                    Collections.addAll(mainExtFieldValueList, keys.split(";"));
                }
            } else if ("mainPropertyKeys".equals(fieldName)) {
                keys = Optional.ofNullable(beanMap.get((Object)fieldName)).map(String::valueOf).orElse("");
                if (!StringUtils.isEmpty((CharSequence)keys)) {
                    Collections.addAll(mainPropertyKeyList, keys.split(";"));
                }
            } else if ("mainPropertyValues".equals(fieldName)) {
                String values = Optional.ofNullable(beanMap.get((Object)fieldName)).map(String::valueOf).orElse("");
                if (!StringUtils.isEmpty((CharSequence)values)) {
                    Collections.addAll(mainPropertyValueList, values.split(";"));
                }
            } else {
                Object itemValue;
                if (fieldName.equals("mainRemarkFiledList")) {
                    itemValue = beanMap.get((Object)fieldName);
                    if (itemValue == null) continue;
                    String mainRemarkFiledOperator = Optional.ofNullable(beanMap.get((Object)"mainRemarkFiledOperator")).map(String::valueOf).orElse("");
                    this.handleRemarkFields(beanMap, fieldName, value, mainRemarkFiledOperator, groupId, FieldGroupIndex.FIELD_GROUP_INDEX_MAIN.value());
                    configItemList.add(new MsConfigItemBean("invoiceRemarkFiledList", value));
                    continue;
                }
                if (fieldName.equals("itemRemarkFiledList")) {
                    itemValue = beanMap.get((Object)fieldName);
                    if (itemValue == null) continue;
                    String itemRemarkFiledOperator = Optional.ofNullable(beanMap.get((Object)"itemRemarkFiledOperator")).map(String::valueOf).orElse("");
                    this.handleRemarkFields(beanMap, fieldName, value, itemRemarkFiledOperator, groupId, FieldGroupIndex.FIELD_GROUP_INDEX_ITEM.value());
                    configItemList.add(new MsConfigItemBean("invoiceItemRemarkFiledList", value));
                    continue;
                }
                if (fieldName.equals("taxAmountAllowMax")) {
                    String taxAmountAllowMax = Optional.ofNullable(beanMap.get((Object)"taxAmountAllowMax")).map(String::valueOf).orElse("1.26");
                    try {
                        BigDecimal bigDecimal = new BigDecimal(taxAmountAllowMax);
                        value.add(taxAmountAllowMax);
                        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0 || bigDecimal.compareTo(new BigDecimal("1.26")) > 0) {
                            value.add("1.26");
                        }
                    }
                    catch (Exception e) {
                        log.error("\u7a0e\u989d\u6700\u5927\u5bb9\u5dee\u8f6c\u6362\u5f02\u5e38:{}", (Object)taxAmountAllowMax, (Object)e);
                        value.add("1.26");
                    }
                } else if (fieldName.equals("taxDeviceType")) {
                    itemValue = beanMap.get((Object)fieldName);
                    if (itemValue == null) {
                        value.add("0");
                    } else {
                        value.add(String.valueOf(itemValue));
                    }
                } else {
                    itemValue = beanMap.get((Object)fieldName);
                    if (itemValue == null) {
                        value.add("");
                    } else {
                        value.add(String.valueOf(itemValue));
                    }
                }
            }
            configItemList.add(new MsConfigItemBean(fieldName, value));
        }
        log.info("mainExtFieldList {} mainExtFieldValueList {} mainPropertyKeyList:{} mainPropertyValueList:{}", new Object[]{JsonUtils.writeObjectToFastJson((Object)mainExtFieldList), JsonUtils.writeObjectToFastJson((Object)mainExtFieldValueList), JsonUtils.writeObjectToFastJson((Object)mainPropertyKeyList), JsonUtils.writeObjectToFastJson((Object)mainPropertyValueList)});
        if (Objects.nonNull(outAttributeEntityList) && mainExtFieldList.size() == mainExtFieldValueList.size() && mainExtFieldValueList.size() == mainPropertyKeyList.size() && mainPropertyKeyList.size() == mainPropertyValueList.size() && mainPropertyValueList.size() > 0) {
            for (int i = 0; i < mainExtFieldList.size(); ++i) {
                MsConfigBizBillAttribute msConfigBizBillAttribute = new MsConfigBizBillAttribute();
                msConfigBizBillAttribute.setFieldName((String)mainExtFieldList.get(i));
                msConfigBizBillAttribute.setFieldValue((String)mainExtFieldValueList.get(i));
                msConfigBizBillAttribute.setAttrName((String)mainPropertyKeyList.get(i));
                msConfigBizBillAttribute.setValue((String)mainPropertyValueList.get(i));
                outAttributeEntityList.add(msConfigBizBillAttribute);
            }
        }
        return configItemList;
    }

    protected ArrayList<String> getFieldEnNameForBill(String salesBillType, Long groupId, String value) {
        Map map = this.localCacheManager.queryEffectiveMetaData(groupId, ObjCodeEnum.BILL.getObjCode(), salesBillType);
        ArrayList dataValues = Lists.newArrayList();
        String[] splitfields = value.split(",");
        for (int i = 0; i < splitfields.length; ++i) {
            String disPlayName = splitfields[i];
            String key = disPlayName + "#0";
            MsBusinessObjMetadataBean msBusinessObjMetadataBean = (MsBusinessObjMetadataBean)map.get(key);
            if (msBusinessObjMetadataBean != null) {
                dataValues.add(msBusinessObjMetadataBean.getFieldName());
                continue;
            }
            log.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4e1a\u52a1\u5355\u5b57\u6bb5:{},\u4e1a\u52a1\u5355\u7c7b\u578b{},\u96c6\u56e2id:{}", new Object[]{disPlayName, salesBillType, groupId});
        }
        return dataValues;
    }

    protected String getFieldEnName(String displayName, String salesBillType, Long groupId, Integer fieldGroupIndex) {
        String key;
        Map map = this.localCacheManager.queryEffectiveMetaData(groupId, ObjCodeEnum.BILL.getObjCode(), salesBillType);
        MsBusinessObjMetadataBean msBusinessObjMetadataBean = (MsBusinessObjMetadataBean)map.get(key = this.replace(displayName) + "#" + fieldGroupIndex);
        if (msBusinessObjMetadataBean != null) {
            return msBusinessObjMetadataBean.getFieldName();
        }
        if (displayName.equals("\u95e8\u5e97\u53f7")) {
            return "sysOrgCode";
        }
        if (displayName.equals("\u7ec4\u7ec7\u540d\u79f0")) {
            return "sysOrgName";
        }
        log.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5b57\u6bb5:{},\u4e1a\u52a1\u5355\u7c7b\u578b{},\u96c6\u56e2id:{}", new Object[]{displayName, salesBillType, groupId});
        return displayName;
    }

    protected ArrayList<String> getFieldEnName(String salesBillType, Long groupId, String value) {
        Map map = this.localCacheManager.queryEffectiveMetaData(groupId, ObjCodeEnum.BILL.getObjCode(), salesBillType);
        ArrayList dataValues = Lists.newArrayList();
        value = value.replace("\uff0c", ",");
        String[] splitFields = value.split(",");
        for (int i = 0; i < splitFields.length; ++i) {
            String displayName = splitFields[i];
            String key = displayName + "#1";
            MsBusinessObjMetadataBean msBusinessObjMetadataBean = (MsBusinessObjMetadataBean)map.get(key);
            if (msBusinessObjMetadataBean != null) {
                dataValues.add(msBusinessObjMetadataBean.getFieldName());
                continue;
            }
            log.info("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u660e\u7ec6\u5b57\u6bb5:{},\u4e1a\u52a1\u5355\u7c7b\u578b:{},\u96c6\u56e2id:{}, key:{}", new Object[]{displayName, salesBillType, groupId, key});
        }
        return dataValues;
    }

    protected String replace(String input) {
        int n = 0;
        String[] stringArray = this.splitReplace.split("#");
        int n2 = stringArray.length;
        if (n < n2) {
            String s = stringArray[n];
            String[] split = s.split("@");
            return input.replace(split[0], split[1]);
        }
        return input;
    }

    protected boolean handleRemarkFields(BeanMap beanMap, String fieldName, ArrayList<String> value, String mainRemarkFiledOperator, Long groupId, Integer fieldGroupIndex) {
        this.checkJoinChar(StringUtils.isEmpty((CharSequence)mainRemarkFiledOperator) || !this.joinCharList.contains(mainRemarkFiledOperator), beanMap, "\u5206\u9694\u7b26\u679a\u4e3e\u503c\u9519\u8bef\uff0c\u679a\u4e3e\u503c\u8303\u56f4\uff1a1->\uff0c, 2->\u30013->\uff1a 4->\uff1b 5-> - 6->| 7->\u7a7a\u683c 8->\u6362\u884c,\u8bf7\u68c0\u67e5");
        String values = Optional.ofNullable(beanMap.get((Object)fieldName)).map(String::valueOf).orElse("");
        if (StringUtils.isEmpty((CharSequence)values)) {
            return true;
        }
        String[] lines = values.split("\n");
        log.info("mainRemarkFiledList:{},splitResult:{}", (Object)values, (Object)JsonUtils.writeObjectToFastJson((Object)lines));
        for (int j = 0; j < lines.length; ++j) {
            String[] split;
            String line = lines[j];
            if (StringUtils.isNotEmpty((CharSequence)line) && !line.contains("\u56fa\u5b9a\u503c") && !line.contains("\u5b57\u6bb5\u503c")) {
                this.checkJoinChar(true, beanMap, "\u5907\u6ce8\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef\uff0c\u9519\u8bef\u884c\u5185\u5bb9\u3010" + line + "\u3011\uff0c\u6bcf\u884c\u5907\u6ce8\u5fc5\u987b\u5305\u542b\u56fa\u5b9a\u503c,\u5b57\u6bb5\u503c,\u8bf7\u68c0\u67e5");
            }
            this.checkJoinChar((split = line.split(":")).length < 2, beanMap, "\u5907\u6ce8\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef\uff0c\u3010" + line + "\u3011\u6309\u5192\u53f7\u5206\u9694\u5206\u9694\u65e0\u7ed3\u679c,\u8bf7\u68c0\u67e5");
            String content = "";
            for (int i = 1; i < split.length; ++i) {
                content = content + split[i];
            }
            if (split[0].equals("\u5b57\u6bb5\u503c")) {
                String fieldEnName = this.getFieldEnName(content, String.valueOf(beanMap.get((Object)"salesbillType")), groupId, fieldGroupIndex);
                String disPlayName = fieldGroupIndex == 0 ? "\u5355\u636e\u5934\u5b57\u6bb5" : "\u5355\u636e\u660e\u7ec6\u5b57\u6bb5";
                this.checkJoinChar(content.equals(fieldEnName), beanMap, "\u5907\u6ce8\u5b57\u6bb5\u683c\u5f0f\u9519\u8bef\uff0c\u5b57\u6bb5\u503c\u540d\u79f0\u3010" + content + "\u3011\u65e0\u6cd5\u8f6c\u6362\u4e3a" + disPlayName + ",\u8bf7\u53c2\u8003\u4e1a\u52a1\u5355\u7c7b\u578b\u5b9a\u4e49\u7684\u4e2d\u6587\u540d\u79f0\u6838\u5bf9\u68c0\u67e5");
                content = fieldEnName;
            }
            String remarkItem = mainRemarkFiledOperator + "_#_" + (split[0].equals("\u56fa\u5b9a\u503c") ? "1" : "0") + "_#_" + content;
            value.add(remarkItem);
        }
        return false;
    }

    protected void checkJoinChar(boolean mainRemarkFiledOperator, BeanMap beanMap, String text) {
        if (mainRemarkFiledOperator) {
            this.dingDingUtils.sendMsgMarkDownWarn("\u62c6\u7968\u89c4\u5219\u5bfc\u5165\u5931\u8d25", "", String.valueOf(beanMap.get((Object)"configName")), text, null);
            throw new IllegalArgumentException(text);
        }
    }
}

