/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services.importservice;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.infrastructure.usercenter.controllers.UserCenterController;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.infrastructure.cache.LocalCacheManager;
import com.xforceplus.seller.config.models.FirstIssuerConfig;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInterfaceExtDao;
import com.xforceplus.seller.config.repository.daoext.CfgExtDaoService;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.adapter.AdapterConfig;
import com.xforceplus.seller.config.services.adapter.AdapterService;
import com.xforceplus.seller.config.services.importservice.AbstractImportService;
import com.xforceplus.seller.config.services.importservice.UserCenterHelper;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.seller.config.util.DingDingUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FirstIssuerImportService
extends AbstractImportService<FirstIssuerConfig> {
    private static final Logger log = LoggerFactory.getLogger(FirstIssuerImportService.class);
    @Autowired
    private CfgExtDaoService dao;

    @Autowired
    public FirstIssuerImportService(LocalCacheManager localCacheManager, DingDingUtils dingDingUtils, ConfigBizConfigService configBizConfigService, CfgConfigInterfaceExtDao cfgConfigInterfaceExtDao, UserInfoHolder<UserInfo> userInfoHolder, CfgBusinessObjDao cfgBusinessObjDao, AdapterConfig adapterConfig, AdapterService adapterService, UserCenterController userCenterController, UserCenterHelper userCenterService) {
        super(localCacheManager, dingDingUtils, configBizConfigService, cfgConfigInterfaceExtDao, userInfoHolder, cfgBusinessObjDao, adapterConfig, adapterService, userCenterController);
    }

    protected MsConfigBean buildConfigBean(FirstIssuerConfig firstIssuerConfig) {
        MsConfigBean configBean = new MsConfigBean();
        configBean.businessBillType("AR");
        configBean.setSellerName(firstIssuerConfig.getSellerName());
        configBean.setSellerTaxNo(firstIssuerConfig.getSellerTaxNo());
        configBean.setPurchaserName(firstIssuerConfig.getPurchaserName());
        configBean.setPurchaserTaxNo(firstIssuerConfig.getPurchaserTaxNo());
        configBean.setConfigType(Integer.valueOf(Integer.parseInt(firstIssuerConfig.getConfigType())));
        configBean.setSalesbillType(firstIssuerConfig.getSalesbillType());
        configBean.setConfigName(firstIssuerConfig.getConfigName());
        ArrayList configItemList = Lists.newArrayListWithCapacity((int)4);
        ArrayList firstIssuer = Lists.newArrayList((Object[])new String[]{firstIssuerConfig.getFirstIssuer()});
        MsConfigItemBean firstIssuerItem = new MsConfigItemBean("firstIssuer", (List)firstIssuer);
        ArrayList issuerType = Lists.newArrayList((Object[])new String[]{firstIssuerConfig.getIssueType()});
        MsConfigItemBean issuerTypeItem = new MsConfigItemBean("IssuerType", (List)issuerType);
        configItemList.add(firstIssuerItem);
        configItemList.add(issuerTypeItem);
        configBean.setItemList((List)configItemList);
        Long configId = this.dao.checkExist(configBean);
        if (configId != null) {
            log.info("buildAdditionalAttribute.\u66f4\u65b0\u660e\u7ec6configId:{}", (Object)configId);
            configBean.setConfigId(configId);
        }
        return configBean;
    }

    protected void buildAdditionalAttribute(Long groupId, MsConfigBean configBean, FirstIssuerConfig config) {
    }

    protected String doIndividualValidation(MsConfigBean configBean, FirstIssuerConfig firstIssuerConfig, MsCommonUserInfo userInfo) {
        StringBuilder msg = new StringBuilder();
        if (CommonTools.isEmpty((String)firstIssuerConfig.getFirstIssuer())) {
            msg.append("--\u4f18\u5148\u5f00\u7968\u4eba\u4e0d\u80fd\u4e3a\u7a7a--");
        }
        if (CommonTools.isEmpty((String)firstIssuerConfig.getIssueType())) {
            msg.append("--\u6570\u7535\u5f00\u7968\u4eba\u5f00\u7968\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a--");
        }
        return msg.toString();
    }
}

