/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services.importservice;

import com.xforceplus.phoenix.infrastructure.usercenter.controllers.UserCenterController;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.infrastructure.cache.LocalCacheManager;
import com.xforceplus.seller.config.models.ConfigBase;
import com.xforceplus.seller.config.models.PersonConfig;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInterfaceExtDao;
import com.xforceplus.seller.config.repository.daoext.CfgExtDaoService;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.adapter.AdapterConfig;
import com.xforceplus.seller.config.services.adapter.AdapterService;
import com.xforceplus.seller.config.services.importservice.AbstractImportService;
import com.xforceplus.seller.config.services.importservice.UserCenterHelper;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.seller.config.util.DingDingUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Component;

@Component
public class PersonImportService
extends AbstractImportService<PersonConfig> {
    private static final Logger log = LoggerFactory.getLogger(PersonImportService.class);
    @Autowired
    private CfgExtDaoService dao;

    public PersonImportService(LocalCacheManager localCacheManager, DingDingUtils dingDingUtils, ConfigBizConfigService configBizConfigService, CfgConfigInterfaceExtDao cfgConfigInterfaceExtDao, UserInfoHolder<UserInfo> userInfoHolder, CfgBusinessObjDao cfgBusinessObjDao, AdapterConfig adapterConfig, AdapterService adapterService, UserCenterController userCenterController, UserCenterHelper userCenterService) {
        super(localCacheManager, dingDingUtils, configBizConfigService, cfgConfigInterfaceExtDao, userInfoHolder, cfgBusinessObjDao, adapterConfig, adapterService, userCenterController);
    }

    protected MsConfigBean buildConfigBean(PersonConfig personConfig) {
        MsConfigBean configBean = new MsConfigBean();
        configBean.businessBillType(BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType());
        configBean.setSellerName(personConfig.getSellerName());
        configBean.setSellerTaxNo(personConfig.getSellerTaxNo());
        configBean.setPurchaserName(personConfig.getPurchaserName());
        configBean.setPurchaserTaxNo(personConfig.getPurchaserTaxNo());
        configBean.setConfigType(Integer.valueOf(Integer.parseInt(personConfig.getConfigType())));
        configBean.setSalesbillType(personConfig.getSalesbillType());
        configBean.setConfigName(personConfig.getConfigName());
        Long configId = this.dao.checkExist(configBean);
        if (configId != null) {
            log.info("\u66f4\u65b0\u660e\u7ec6configId:{}", (Object)configId);
            configBean.setConfigId(configId);
        }
        return configBean;
    }

    protected void buildAdditionalAttribute(Long groupId, MsConfigBean configBean, PersonConfig personConfig) {
        BeanMap beanMap = BeanMap.create((Object)personConfig);
        Field[] declaredFields = personConfig.getClass().getDeclaredFields();
        configBean.setItemList(this.getBeanItemList(beanMap, declaredFields, null, null, null));
    }

    protected String doIndividualValidation(MsConfigBean configBean, PersonConfig personConfig, MsCommonUserInfo userInfo) {
        StringBuilder msg = new StringBuilder();
        if (CommonTools.isEmpty((String)personConfig.getSellerName())) {
            msg.append("--\u9500\u65b9\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a--");
        }
        if (CommonTools.isEmpty((String)personConfig.getSellerTaxNo())) {
            msg.append("--\u9500\u65b9\u7a0e\u53f7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a--");
        }
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(configBean.getBusinessBillType())) {
            msg.append(this.validateSellerOrgValue(userInfo, (ConfigBase)personConfig, configBean));
        }
        return msg.toString();
    }
}

