/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services.importservice;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.infrastructure.usercenter.controllers.UserCenterController;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.core.enums.SplitRuleItemSort;
import com.xforceplus.seller.config.core.enums.TaxWareRemarkDeviceType;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import com.xforceplus.seller.config.infrastructure.cache.LocalCacheManager;
import com.xforceplus.seller.config.models.ConfigBase;
import com.xforceplus.seller.config.models.SplitConfig;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInterfaceExtDao;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.adapter.AdapterConfig;
import com.xforceplus.seller.config.services.adapter.AdapterService;
import com.xforceplus.seller.config.services.importservice.AbstractImportService;
import com.xforceplus.seller.config.services.importservice.UserCenterHelper;
import com.xforceplus.seller.config.util.DingDingUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import io.vavr.Lazy;
import io.vavr.Tuple;
import io.vavr.Tuple5;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.stereotype.Component;

@Component
public class SplitRuleImportService
extends AbstractImportService<SplitConfig> {
    private static final Logger log = LoggerFactory.getLogger(SplitRuleImportService.class);
    private final Lazy<List<Tuple5<String, List<String>, String, Function<SplitConfig, String>, BiConsumer<SplitConfig, String>>>> checkSplitConfigItemList = Lazy.of(() -> Lists.newArrayList((Object[])new Tuple5[]{Tuple.of((Object)"\u53d1\u7968\u7c7b\u578b", Arrays.asList("c", "s", "ce", "ju", "v", "se"), (Object)"c,s,ce,ju,v\u4e2d\u7684\u4e00\u9879", ConfigBase::getInvoiceType, ConfigBase::setInvoiceType), Tuple.of((Object)"\u91d1\u989d\u62c6\u5206\u89c4\u5219", Arrays.asList("1", "2", "3"), (Object)"1\u6309\u5355\u4ef7\uff0c 2\u6309\u6570\u91cf(\u53d6\u6574)\u62c6 3\u6309\u6570\u91cf(\u4e0d\u53d6\u6574)\u62c6", SplitConfig::getAmountSplitRule, SplitConfig::setAmountSplitRule), Tuple.of((Object)"\u660e\u7ec6\u987a\u5e8f", (Object)this.appendEnumCheckList(SplitRuleItemSort.class, ValueEnum::getValue), (Object)this.appendEnumErrorMsg(SplitRuleItemSort.class, r -> (String)r.getValue() + r.getDescription()), SplitConfig::getItemSort, SplitConfig::setItemSort), Tuple.of((Object)"\u9500\u8d27\u6e05\u5355\u9009\u9879", Arrays.asList("1", "2"), (Object)"1\u662f\uff0c2\u5426", SplitConfig::getSaleListOption, SplitConfig::setSaleListOption), Tuple.of((Object)"\u7a0e\u63a7\u8bbe\u5907", (Object)this.appendEnumCheckList(TaxWareRemarkDeviceType.class, r -> String.valueOf(r.ordinal())), (Object)this.appendEnumErrorMsg(TaxWareRemarkDeviceType.class, r -> r.ordinal() + r.getDescription()), SplitConfig::getTaxDeviceType, SplitConfig::setTaxDeviceType), Tuple.of((Object)"\u5355\u4ef7\u6570\u91cf\u9009\u9879", Arrays.asList("0", "1"), (Object)"0\u6253\u5370\u5355\u4ef7\u6570\u91cf\uff0c1\u4e0d\u6253\u5370\u5355\u4ef7\u6570\u91cf", SplitConfig::getUnitPriceAmountOps, SplitConfig::setUnitPriceAmountOps), Tuple.of((Object)"\u9500\u65b9\u7ec4\u7ec7\u7c7b\u578b", Arrays.asList("1", "2", "3"), (Object)"1\u516c\u53f8\uff0c2\u96c6\u56e2\uff0c3\u7ec4\u7ec7", ConfigBase::getSellerOrgType, ConfigBase::setSellerOrgType)}));

    public SplitRuleImportService(LocalCacheManager localCacheManager, DingDingUtils dingDingUtils, ConfigBizConfigService configBizConfigService, CfgConfigInterfaceExtDao cfgConfigInterfaceExtDao, UserInfoHolder<UserInfo> userInfoHolder, CfgBusinessObjDao cfgBusinessObjDao, AdapterConfig adapterConfig, AdapterService adapterService, UserCenterController userCenterController, UserCenterHelper userCenterService) {
        super(localCacheManager, dingDingUtils, configBizConfigService, cfgConfigInterfaceExtDao, userInfoHolder, cfgBusinessObjDao, adapterConfig, adapterService, userCenterController);
    }

    protected MsConfigBean buildConfigBean(SplitConfig splitConfig) {
        MsConfigBean configBean = new MsConfigBean();
        configBean.businessBillType(splitConfig.getBusinessBillType());
        configBean.setSellerName(splitConfig.getSellerName());
        configBean.setSellerTaxNo(splitConfig.getSellerTaxNo());
        configBean.setPurchaserName(splitConfig.getPurchaserName());
        configBean.setPurchaserTaxNo(splitConfig.getPurchaserTaxNo());
        configBean.setConfigType(Integer.valueOf(Integer.parseInt(splitConfig.getConfigType())));
        configBean.setSalesbillType(splitConfig.getSalesbillType());
        configBean.setConfigName(splitConfig.getConfigName());
        configBean.setInvoiceType(splitConfig.getInvoiceType());
        configBean.setTaxInvoiceSource(splitConfig.getTaxInvoiceSource());
        return configBean;
    }

    protected void buildAdditionalAttribute(Long groupId, MsConfigBean configBean, SplitConfig splitConfig) {
        BeanMap beanMap = BeanMap.create((Object)splitConfig);
        Field[] declaredFields = splitConfig.getClass().getDeclaredFields();
        ArrayList attributeEntityList = Lists.newArrayList();
        configBean.setItemList(this.getBeanItemList(beanMap, declaredFields, splitConfig.getSalesbillType(), groupId, (List)attributeEntityList));
        configBean.setAttributes((List)attributeEntityList);
    }

    protected String doIndividualValidation(MsConfigBean configBean, SplitConfig splitConfig, MsCommonUserInfo userInfo) {
        StringBuilder msg = new StringBuilder();
        this.checkSplitConfigData(splitConfig, msg);
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(splitConfig.getBusinessBillType())) {
            msg.append(this.validateSellerOrgValue(userInfo, (ConfigBase)splitConfig, configBean));
        }
        return msg.toString();
    }

    private void checkSplitConfigData(SplitConfig splitConfig, StringBuilder msg) {
        ((List)this.checkSplitConfigItemList.get()).forEach(r -> {
            String value = StringUtils.trim((String)((String)((Function)r._4()).apply(splitConfig)));
            if (StringUtils.isBlank((CharSequence)value)) {
                msg.append(String.format("---%s\uff0c\u5fc5\u586b\u9879", r._1()));
            } else if (((List)r._2()).contains(value)) {
                ((BiConsumer)r._5()).accept(splitConfig, value);
            } else {
                msg.append(String.format("---%s \u5fc5\u987b\u662f %s", r._1(), r._3()));
            }
        });
    }

    private <E extends Enum<E>, R> List<R> appendEnumCheckList(Class<E> enumClass, Function<E, R> mapFunc) {
        return EnumUtils.getEnumList(enumClass).stream().map(mapFunc).collect(Collectors.toList());
    }

    private <E extends Enum<E>> String appendEnumErrorMsg(Class<E> enumClass, Function<E, String> mapFunc) {
        return EnumUtils.getEnumList(enumClass).stream().map(mapFunc).collect(Collectors.joining("\uff0c"));
    }
}

