/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.services.importservice;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.infrastructure.usercenter.controllers.UserCenterController;
import com.xforceplus.seller.config.client.constant.BusinessSalesBillTypeEnum;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.infrastructure.cache.LocalCacheManager;
import com.xforceplus.seller.config.models.ConfigBase;
import com.xforceplus.seller.config.models.TitleConfig;
import com.xforceplus.seller.config.repository.dao.CfgBusinessObjDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigInterfaceExtDao;
import com.xforceplus.seller.config.repository.daoext.CfgExtDaoService;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.adapter.AdapterConfig;
import com.xforceplus.seller.config.services.adapter.AdapterService;
import com.xforceplus.seller.config.services.importservice.AbstractImportService;
import com.xforceplus.seller.config.services.importservice.UserCenterHelper;
import com.xforceplus.seller.config.util.CommonTools;
import com.xforceplus.seller.config.util.DingDingUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import com.xforceplus.xplatframework.spring.domain.UserInfoHolder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TitleImportService
extends AbstractImportService<TitleConfig> {
    private static final Logger log = LoggerFactory.getLogger(TitleImportService.class);
    @Autowired
    private CfgExtDaoService dao;

    @Autowired
    public TitleImportService(LocalCacheManager localCacheManager, DingDingUtils dingDingUtils, ConfigBizConfigService configBizConfigService, CfgConfigInterfaceExtDao cfgConfigInterfaceExtDao, UserInfoHolder<UserInfo> userInfoHolder, CfgBusinessObjDao cfgBusinessObjDao, AdapterConfig adapterConfig, AdapterService adapterService, UserCenterController userCenterController, UserCenterHelper userCenterService) {
        super(localCacheManager, dingDingUtils, configBizConfigService, cfgConfigInterfaceExtDao, userInfoHolder, cfgBusinessObjDao, adapterConfig, adapterService, userCenterController);
    }

    protected MsConfigBean buildConfigBean(TitleConfig titleConfig) {
        ArrayList address;
        MsConfigBean configBean = new MsConfigBean();
        configBean.businessBillType(titleConfig.getBusinessBillType());
        configBean.setSellerName(titleConfig.getSellerName());
        configBean.setSellerTaxNo(titleConfig.getSellerTaxNo());
        configBean.setPurchaserName(titleConfig.getPurchaserName());
        configBean.setPurchaserTaxNo(titleConfig.getPurchaserTaxNo());
        configBean.setConfigType(Integer.valueOf(Integer.parseInt(titleConfig.getConfigType())));
        configBean.setSalesbillType(titleConfig.getSalesbillType());
        configBean.setConfigName(titleConfig.getConfigName());
        ArrayList configItemList = Lists.newArrayListWithCapacity((int)4);
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(titleConfig.getBusinessBillType())) {
            address = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerAddress()});
            MsConfigItemBean addressItem = new MsConfigItemBean("sellerAddress", (List)address);
            ArrayList bankAccount = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerBankAccount()});
            MsConfigItemBean bankAccountItem = new MsConfigItemBean("sellerBankAccount", (List)bankAccount);
            ArrayList bankName = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerBankName()});
            MsConfigItemBean bankNameItem = new MsConfigItemBean("sellerBankName", (List)bankName);
            ArrayList tel = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerTel()});
            MsConfigItemBean sellerTelItem = new MsConfigItemBean("sellerTel", (List)tel);
            configItemList.add(addressItem);
            configItemList.add(bankAccountItem);
            configItemList.add(bankNameItem);
            configItemList.add(sellerTelItem);
        } else {
            address = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerAddress()});
            MsConfigItemBean addressItem = new MsConfigItemBean("purchaserAddress", (List)address);
            ArrayList bankAccount = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerBankAccount()});
            MsConfigItemBean bankAccountItem = new MsConfigItemBean("purchaserBankAccount", (List)bankAccount);
            ArrayList bankName = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerBankName()});
            MsConfigItemBean bankNameItem = new MsConfigItemBean("purchaserBankName", (List)bankName);
            ArrayList tel = Lists.newArrayList((Object[])new String[]{titleConfig.getSellerTel()});
            MsConfigItemBean sellerTelItem = new MsConfigItemBean("purchaserTel", (List)tel);
            configItemList.add(addressItem);
            configItemList.add(bankAccountItem);
            configItemList.add(bankNameItem);
            configItemList.add(sellerTelItem);
        }
        configBean.setItemList((List)configItemList);
        Long configId = this.dao.checkExist(configBean);
        if (configId != null) {
            log.info("buildAdditionalAttribute.\u66f4\u65b0\u660e\u7ec6configId:{}", (Object)configId);
            configBean.setConfigId(configId);
        }
        return configBean;
    }

    protected void buildAdditionalAttribute(Long groupId, MsConfigBean configBean, TitleConfig config) {
    }

    protected String doIndividualValidation(MsConfigBean configBean, TitleConfig titleConfig, MsCommonUserInfo userInfo) {
        StringBuilder msg = new StringBuilder();
        if (CommonTools.isEmpty((String)titleConfig.getSellerAddress())) {
            msg.append("--\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a--");
        }
        if (CommonTools.isEmpty((String)titleConfig.getSellerBankAccount())) {
            msg.append("--\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a--");
        }
        if (CommonTools.isEmpty((String)titleConfig.getSellerBankName())) {
            msg.append("--\u94f6\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a--");
        }
        if (CommonTools.isEmpty((String)titleConfig.getSellerTel())) {
            msg.append("--\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a--");
        }
        if (BusinessSalesBillTypeEnum.AR.getBusinessSalesBillType().equals(titleConfig.getBusinessBillType())) {
            if (StringUtils.isBlank((CharSequence)titleConfig.getSellerOrgType())) {
                msg.append("\u9500\u65b9\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            msg.append(this.validateSellerOrgValue(userInfo, (ConfigBase)titleConfig, configBean));
        }
        return msg.toString();
    }
}

