/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.task;

import com.google.common.collect.Lists;
import com.xforceplus.janus.message.sdk.MBClient;
import com.xforceplus.janus.message.sdk.ResponseMessage;
import com.xforceplus.janus.message.sdk.request.AckRequest;
import com.xforceplus.janus.message.sdk.response.AckResponse;
import com.xforceplus.janus.message.sdk.response.SubResponse;
import com.xforceplus.micro.tax.device.contract.model.LimitInfo;
import com.xforceplus.micro.tax.device.contract.model.QualificationInfo;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.PriceMethodTypeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.MsConfigItemBatchQueryRequest;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.config.PubSubProperties;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.util.JsonUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeviceAmountLimitTask {
    private static final Logger log = LoggerFactory.getLogger(DeviceAmountLimitTask.class);
    private static MBClient mbClient;
    @Autowired
    private PubSubProperties pubSubProperties;
    @Autowired
    private ConfigBizConfigService configBizConfigService;

    public void deviceAmountLimitResult() {
        SubResponse response2;
        if (!this.pubSubProperties.getDeviceLimitAmountSwitch().booleanValue()) {
            log.warn("\u83b7\u53d6\u9650\u989d\u5f00\u5173\u672a\u5f00\u542f");
            return;
        }
        if (mbClient == null) {
            mbClient = MBClient.getInstance((String)this.pubSubProperties.getUrl(), (String)this.pubSubProperties.getDeviceLimiToken());
        }
        if (!(response2 = mbClient.sub()).getSuccess().booleanValue()) {
            log.warn("\u83b7\u53d6\u6d88\u606f\u5931\u8d25\uff0cresponse:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            return;
        }
        List messages = response2.getResponseMessages();
        if (CollectionUtils.isEmpty((Collection)messages)) {
            return;
        }
        ArrayList acks = Lists.newArrayList();
        for (ResponseMessage message : messages) {
            QualificationInfo info = (QualificationInfo)JsonUtils.writeFastJsonToObject((String)message.getContent(), QualificationInfo.class);
            try {
                this.updateSplitLimit(info);
            }
            catch (Exception e) {
                log.error("\u4fee\u6539\u9650\u989d\u5f02\u5e38", (Throwable)e);
            }
            acks.add(message.getReceiptHandle());
        }
        if (CollectionUtils.isNotEmpty((Collection)acks)) {
            AckRequest ackRequest = new AckRequest((List)acks);
            AckResponse ack = mbClient.ack(ackRequest);
            log.info("ack\u56de\u6267\u7ed3\u679c,{}", (Object)ack.getSuccess());
        }
    }

    private void updateSplitLimit(QualificationInfo info) {
        log.info("\u83b7\u53d6\u5f97\u7a0e\u76d8\u9650\u989d\uff0cinfo:{}", (Object)JsonUtils.writeObjectToFastJson((Object)info));
        if (StringUtils.isEmpty((CharSequence)info.getTaxCode())) {
            return;
        }
        List invoiceTypes = info.getLimitInfoList().stream().filter(v -> v.getSingleAmountLimit() != null).map(LimitInfo::getInvoiceType).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(invoiceTypes)) {
            return;
        }
        MsConfigQueryRequest msConfigQueryRequest = new MsConfigQueryRequest();
        msConfigQueryRequest.setConfigType(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType());
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        msConfigQueryRequest.setSellerTaxNo(info.getTaxCode());
        msConfigQueryRequest.setInvoiceType(invoiceTypes);
        msConfigQueryRequest.setPageSize(Integer.valueOf(100));
        log.info("\u62c6\u7968\u89c4\u5219\u8bf7\u6c42\uff0c{}", (Object)JsonUtils.writeObjectToFastJson((Object)msConfigQueryRequest));
        List configList = this.configBizConfigService.querConfigList(msConfigQueryRequest);
        if (CollectionUtils.isEmpty((Collection)configList)) {
            return;
        }
        List configIds = configList.stream().map(CfgConfigEntity::getConfigId).collect(Collectors.toList());
        MsConfigItemBatchQueryRequest itemBatchQueryRequest = new MsConfigItemBatchQueryRequest();
        itemBatchQueryRequest.setConfigItemName(Arrays.asList("invoiceLimit", "syncDeviceAmountLimitFlag", "priceMethod"));
        itemBatchQueryRequest.setConfigIds(configIds);
        List itemBeanList = this.configBizConfigService.queryConfigItemsByConfigs(itemBatchQueryRequest);
        if (CollectionUtils.isEmpty((Collection)itemBeanList)) {
            return;
        }
        Map<String, List<CfgConfigEntity>> configMap = configList.stream().collect(Collectors.groupingBy(CfgConfigEntity::getInvoiceType));
        Map<Long, List<MsConfigItemBean>> configItemMap = itemBeanList.stream().collect(Collectors.groupingBy(MsConfigItemBean::getConfigId));
        ArrayList<MsConfigItemBean> updateList = new ArrayList<MsConfigItemBean>();
        for (LimitInfo limitInfo : info.getLimitInfoList()) {
            List<CfgConfigEntity> configEntities = configMap.get(limitInfo.getInvoiceType());
            if (CollectionUtils.isEmpty(configEntities)) continue;
            for (CfgConfigEntity configEntity : configEntities) {
                List<MsConfigItemBean> limitBeans;
                MsConfigItemBean priceMethod;
                List<MsConfigItemBean> priceBeans;
                Map<String, List<MsConfigItemBean>> beanMap;
                List<MsConfigItemBean> itemBeans;
                List<MsConfigItemBean> items = configItemMap.get(configEntity.getConfigId());
                if (CollectionUtils.isEmpty(items) || CollectionUtils.isEmpty(itemBeans = (beanMap = items.stream().collect(Collectors.groupingBy(MsConfigItemBean::getConfigItemName))).get("syncDeviceAmountLimitFlag"))) continue;
                String limitFlag = (String)itemBeans.get(0).getConfigItemValue().get(0);
                log.warn("sellerTaxNo:{},\u81ea\u52a8\u540c\u6b65\u7a0e\u989d\u5f00\u5173\uff1a{}", (Object)info.getTaxCode(), (Object)limitFlag);
                if (!StringUtils.equals((CharSequence)limitFlag, (CharSequence)"1") || CollectionUtils.isEmpty(priceBeans = beanMap.get("priceMethod")) || !StringUtils.equals((CharSequence)((CharSequence)(priceMethod = priceBeans.get(0)).getConfigItemValue().get(0)), (CharSequence)String.valueOf(PriceMethodTypeEnum.WITHOUT_PRICE.getValue())) || CollectionUtils.isEmpty(limitBeans = beanMap.get("invoiceLimit"))) continue;
                MsConfigItemBean itemBean = limitBeans.get(0);
                BigDecimal singleAmountLimit = new BigDecimal((String)itemBean.getConfigItemValue().get(0));
                log.info("\u9650\u989d\u7a0e\u53f7\uff0csellerTaxNo:{},deviceLimit:{},\u5e73\u53f0\u9650\u989d\uff1a{}", new Object[]{info.getTaxCode(), limitInfo.getSingleAmountLimit(), singleAmountLimit});
                itemBean.setConfigItemValue(Arrays.asList(String.valueOf(limitInfo.getSingleAmountLimit())));
                log.info("\u4fee\u6539\u9650\u989d\uff0c{}", (Object)JsonUtils.writeObjectToFastJson((Object)itemBean));
                updateList.add(itemBean);
            }
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            int count = this.configBizConfigService.updateConfigItems(updateList);
            log.info("\u66f4\u65b0\u62c6\u7968\u9650\u989d\uff1aselelrTaxNo:{},count:{}", (Object)info.getTaxCode(), (Object)count);
        }
    }
}

