/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.task;

import com.alibaba.excel.EasyExcel;
import com.xforceplus.micro.tax.device.contract.model.GoodsInfo;
import com.xforceplus.phoenix.oss.Module;
import com.xforceplus.phoenix.oss.OssUtil;
import com.xforceplus.seller.config.client.model.PubSubResponse;
import com.xforceplus.seller.config.client.model.PubSubResult;
import com.xforceplus.seller.config.config.PubSubProperties;
import com.xforceplus.seller.config.services.MessageHelper;
import com.xforceplus.seller.config.util.DateTools;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

@Component
public class GoodsTask {
    private static final Logger log = LoggerFactory.getLogger(GoodsTask.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MessageHelper messageHelper;
    @Autowired
    private OssUtil ossUtil;
    @Autowired
    private PubSubProperties pubSubProperties;

    public void getGoodsResult() {
        if (!StringUtils.equals((CharSequence)this.pubSubProperties.getPubSubSwitch(), (CharSequence)"on")) {
            log.info("\u4efb\u52a1\u5f00\u5173\u5df2\u5173\u95ed");
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("MB_TOKEN", this.pubSubProperties.getAccessToken());
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaType.APPLICATION_JSON);
        headers.setAccept(mediaTypes);
        HttpEntity entity = new HttpEntity((Object)"", (MultiValueMap)headers);
        String subUrl = this.pubSubProperties.getUrl() + "/global/mb/v1/messages/sub";
        try {
            List ackList;
            ResponseEntity response2 = this.restTemplate.exchange(subUrl, HttpMethod.GET, entity, PubSubResponse.class, new Object[0]);
            log.info("\u5546\u54c1\u7ed3\u679c\u8fd4\u56de\uff0cresponse:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            if (response2 != null && response2.getBody() != null && StringUtils.equals((CharSequence)((PubSubResponse)response2.getBody()).getCode(), (CharSequence)"1") && !CollectionUtils.isEmpty((Collection)(ackList = this.processInfo(((PubSubResponse)response2.getBody()).getResult())))) {
                HashMap<String, List> paramMap = new HashMap<String, List>();
                paramMap.put("receiptHandles", ackList);
                entity = new HttpEntity((Object)JsonUtils.writeObjectToFastJson(paramMap), (MultiValueMap)headers);
                String ackUrl = this.pubSubProperties.getUrl() + "/global/mb/v1/messages/ack";
                response2 = this.restTemplate.exchange(ackUrl, HttpMethod.PUT, entity, PubSubResponse.class, new Object[0]);
                log.info("ack\u8fd4\u56de\uff0cresponse:{}", (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            }
        }
        catch (RestClientResponseException e) {
            log.error("\u8bf7\u6c42\u62a5\u9519,\u72b6\u6001\u7801\uff1a{}", (Object)e.getRawStatusCode(), (Object)e.getMessage());
        }
    }

    private List<String> processInfo(List<PubSubResult> resultList) {
        if (resultList == null) {
            return null;
        }
        ArrayList ackList = new ArrayList();
        List<String> synchronizedList = Collections.synchronizedList(ackList);
        resultList.parallelStream().forEach(v -> {
            try {
                List goodsInfos;
                Map<Integer, List<GoodsInfo>> goodsMap;
                if (v.getConsumeTimes() > 3) {
                    synchronizedList.add(v.getReceiptHandle());
                    return;
                }
                UserInfo userInfo = new UserInfo();
                Map propertyMap = v.getProperties();
                if (propertyMap != null) {
                    Long userId = propertyMap.get("opUserId") == null ? 0L : Long.parseLong(v.getProperties().get("opUserId").toString());
                    Long groupId = propertyMap.get("tenantId") == null ? 0L : Long.parseLong(v.getProperties().get("tenantId").toString());
                    userInfo.setUserId(userId.longValue());
                    userInfo.setUserName(String.valueOf(propertyMap.get("opUserName")));
                    userInfo.setGroupId(groupId.longValue());
                }
                int success = (goodsMap = (goodsInfos = JsonUtils.writeFastJsonToListObject((String)v.getContent(), GoodsInfo.class)).parallelStream().collect(Collectors.groupingBy(GoodsInfo::getCode))).get(1) == null ? 0 : goodsMap.get(1).size();
                int fail = goodsMap.get(0) == null ? 0 : goodsMap.get(0).size();
                String url = "";
                if (fail > 0) {
                    String filepath = "file/import-fail/" + Module.SELLER.value() + "/" + DateTools.day() + "/" + v.getThirdPartyId() + ".xls";
                    File file = new File(filepath);
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    EasyExcel.write((String)filepath, GoodsInfo.class).sheet("\u5546\u54c1\u5bfc\u5165\u7ed3\u679c").doWrite(goodsMap.get(0));
                    String key = this.ossUtil.uploadFileInternal(filepath, Module.SELLER, true);
                    url = this.ossUtil.fileKeyToDownloadUrlViaPlatform(key);
                    FileUtils.deleteQuietly((File)file);
                }
                String title = "\u5546\u54c1\u5bfc\u5165\u7ed3\u679c";
                String content = "\u6210\u529f" + success + "\u6761\uff0c\u5931\u8d25" + fail + "\u6761";
                this.messageHelper.sendMessageMiddle(userInfo, title, content, url);
                synchronizedList.add(v.getReceiptHandle());
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            }
        });
        return synchronizedList;
    }
}

