/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.task;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.janus.message.sdk.MBClient;
import com.xforceplus.janus.message.sdk.ResponseMessage;
import com.xforceplus.janus.message.sdk.request.AckRequest;
import com.xforceplus.janus.message.sdk.response.AckResponse;
import com.xforceplus.janus.message.sdk.response.SubResponse;
import com.xforceplus.seller.config.task.handler.ResultHandler;
import com.xforceplus.seller.config.util.DingDingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class MessageListener {
    private static final Logger log = LoggerFactory.getLogger(MessageListener.class);
    @Autowired
    MBClient client;
    @Autowired
    DingDingUtils dingDingUtils;
    private final Map<String, ResultHandler> map = new HashMap();

    public MessageListener(List<ResultHandler> handlers) {
        for (ResultHandler handler : handlers) {
            this.map.put(handler.pubCode(), handler);
        }
    }

    @Scheduled(fixedDelay=2000L)
    public void onMessage() {
        SubResponse sub = this.client.sub();
        ArrayList<String> ackList = new ArrayList<String>();
        if (sub.getSuccess().booleanValue()) {
            List responseMessages = sub.getResponseMessages();
            if (CollectionUtils.isEmpty((Collection)responseMessages)) {
                return;
            }
            for (ResponseMessage responseMessage : responseMessages) {
                String pubCode = responseMessage.getPubCode();
                String businessNo = (String)responseMessage.getProperties().get("businessNo");
                try {
                    log.info("\u5904\u7406\u6d88\u606f\u63a5\u53d7\u5230pubCode:{},\u6d88\u606fid:{},businessNo:{}", new Object[]{pubCode, responseMessage.getId(), responseMessage.getProperties().get("businessNo")});
                    Boolean result = Optional.ofNullable(this.map.get(pubCode)).map(x -> {
                        Boolean handleResult = x.handle(responseMessage);
                        return handleResult;
                    }).orElseGet(() -> {
                        log.info("pubCode:[{}] not found", (Object)pubCode);
                        return Boolean.TRUE;
                    });
                    if (!result.booleanValue()) continue;
                    ackList.add(responseMessage.getReceiptHandle());
                }
                catch (Exception e) {
                    log.error("\u603b\u7ebf\u5f02\u5e38\u6d88\u8d39\u5f02\u5e38", (Throwable)e);
                    this.dingDingUtils.sendMsgMarkDownWarn(pubCode, String.valueOf(responseMessage.getId()), businessNo, StringUtils.substring((String)e.getMessage(), (int)0, (int)500), null);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(ackList)) {
            AckRequest ackRequest = new AckRequest(ackList);
            AckResponse ack = this.client.ack(ackRequest);
            log.info(JSONObject.toJSONString((Object)ack));
        }
    }
}

