/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.task.handler;

import com.google.common.collect.Lists;
import com.xforceplus.janus.message.sdk.ResponseMessage;
import com.xforceplus.micro.tax.device.contract.model.CompanyQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.DeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.DeviceQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.TaxDeviceInfo;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.MsBusinessObjBean;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsMataDataAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.config.DingDingConfig;
import com.xforceplus.seller.config.config.TaxWareInvoiceRemarkLengthProperties;
import com.xforceplus.seller.config.core.enums.InvoiceTypeEnum;
import com.xforceplus.seller.config.core.enums.TaxDeviceType;
import com.xforceplus.seller.config.core.enums.TaxWareRemarkDeviceType;
import com.xforceplus.seller.config.core.enums.TaxWareRemarkIssueType;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import com.xforceplus.seller.config.infrastructure.helper.DeviceApiProxy;
import com.xforceplus.seller.config.infrastructure.helper.RestTemplateTools;
import com.xforceplus.seller.config.models.BusiTypeAndUserRelationRequest;
import com.xforceplus.seller.config.models.BusiTypeAndUserRelationResponse;
import com.xforceplus.seller.config.models.BusinessExtensionAttribute;
import com.xforceplus.seller.config.models.UserInfoFromUserCenterResponse;
import com.xforceplus.seller.config.models.UserInfoFromUserCenterVO;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigItemEntity;
import com.xforceplus.seller.config.services.CfgConfigDataService;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.ConfigMetaDataService;
import com.xforceplus.seller.config.task.handler.ResultHandler;
import com.xforceplus.seller.config.util.DingDingUtils;
import com.xforceplus.seller.enums.BusinessBillType;
import com.xforceplus.unifiedPortal.contract.constant.enums.AuthType;
import com.xforceplus.unifiedPortal.contract.model.TenantRegistrationResult;
import com.xforceplus.unifiedPortal.contract.model.UnifiedPortalTenantRegistrationInfo;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliCreateBusiTypeAndRulesHandler
implements ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(AliCreateBusiTypeAndRulesHandler.class);
    public static final String PUB_CODE = "xforce.tenant.settle";
    public static final String ALI_QIAN_NIU = "qianniu";
    private String amountLimitDefault = "9999";
    private String taxDeviceTypeDefault = "0";
    @Autowired
    private ConfigBizConfigService configBizConfigService;
    @Autowired
    private ConfigMetaDataService configMetaDataService;
    @Autowired
    private RestTemplateTools restTemplateTools;
    @Autowired
    private TaxWareInvoiceRemarkLengthProperties taxWareInvoiceRemarkLengthProperties;
    @Autowired
    private DeviceApiProxy deviceApiProxy;
    @Autowired
    DingDingUtils dingDingUtils;
    @Autowired
    private DingDingConfig dingDingConfig;
    @Autowired
    private CfgConfigDataService cfgConfigDataService;
    private static List<String> busiTypeEditFields = Lists.newArrayList((Object[])new String[]{"purchaserName", "purchaserTaxNo", "purchaserAddress", "purchaserTel", "purchaserBankName", "purchaserBankAccount", "remark", "goodsTaxNo", "taxInvoiceSource"});
    private static List<String> busiTypeNotRequiredFields = Lists.newArrayList((Object[])new String[]{"goodsTaxNo"});
    private static List<String> busiTypeNotRequiredFieldsForMain = Lists.newArrayList((Object[])new String[]{"amountWithTax", "amountWithoutTax", "taxAmount"});
    private static List<String> qdBusiTypeNotRequiredFields = Lists.newArrayList((Object[])new String[]{"invoicerName", "sellerBankName", "sellerBankAccount", "sellerTel", "sellerAddress"});
    private static String salesbillType = "\u5343\u725b\u6e20\u9053";
    private static List<String> invoiceMatchConfigInvoiceTypes = Lists.newArrayList((Object[])new String[]{"c", "ce", "s", "se"});

    public boolean handle(ResponseMessage responseMessage) {
        String id = !Objects.isNull(responseMessage) && !Objects.isNull(responseMessage.getId()) ? String.valueOf(responseMessage.getId()) : "";
        String businessNo = !Objects.isNull(responseMessage) && !Objects.isNull(responseMessage.getProperties()) && !Objects.isNull(responseMessage.getProperties().get("businessNo")) ? (String)responseMessage.getProperties().get("businessNo") : "";
        try {
            String errorMsg;
            log.info("AliCreateBusiTypeAndRules message:{}", (Object)JsonUtils.writeObjectToFastJson((Object)responseMessage));
            UnifiedPortalTenantRegistrationInfo info = (UnifiedPortalTenantRegistrationInfo)JsonUtils.writeFastJsonToObject((String)responseMessage.getContent(), UnifiedPortalTenantRegistrationInfo.class);
            if (Objects.nonNull(info) && StringUtils.isNotBlank((CharSequence)info.getChannelTenantId()) && StringUtils.isNotBlank((CharSequence)(errorMsg = this.createSalesbillTypeAndRules(info)))) {
                log.error("\u5343\u725b\u6e20\u9053" + errorMsg);
                this.dingDingUtils.sendMsgMarkDownWarn(PUB_CODE, id, businessNo, StringUtils.substring((String)("\u5343\u725b\u6e20\u9053" + errorMsg), (int)0, (int)300), this.dingDingConfig.getQianNiuDingUrl());
            }
        }
        catch (Exception e) {
            log.error("AliCreateBusiTypeAndRules error: {}", (Object)e.getMessage(), (Object)e);
            String errorMsg = "\u5343\u725b\u6e20\u9053\u4e1a\u52a1\u5355\u7c7b\u578b\u53ca\u89c4\u5219\u521b\u5efa\u5931\u8d25\uff0cid\uff1a" + id + ",error\uff1a" + e.getMessage() + e;
            this.dingDingUtils.sendMsgMarkDownWarn(PUB_CODE, id, businessNo, StringUtils.substring((String)errorMsg, (int)0, (int)300), this.dingDingConfig.getQianNiuDingUrl());
        }
        return true;
    }

    public String createSalesbillTypeAndRules(UnifiedPortalTenantRegistrationInfo registrationInfo) {
        MsCommonUserInfo userInfo;
        String errorMsg = this.checkRequestInfo(registrationInfo);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        Boolean isAllElectronic = false;
        if (Objects.nonNull(registrationInfo.getAuthResult()) && StringUtils.isNotBlank((CharSequence)registrationInfo.getAuthResult().getAuthType()) && StringUtils.equalsAny((CharSequence)registrationInfo.getAuthResult().getAuthType(), (CharSequence[])new CharSequence[]{AuthType.ALLELECTRONIC.getValue(), AuthType.BUSINESSLICENSEALLELECTRONIC.getValue()})) {
            isAllElectronic = true;
        }
        if (StringUtils.isNotBlank((CharSequence)(errorMsg = this.createSalesbillType(registrationInfo, userInfo = this.convertUserInfo(registrationInfo), isAllElectronic)))) {
            return errorMsg;
        }
        errorMsg = errorMsg + this.addBusiTypeAndUserRelation(registrationInfo, userInfo);
        String taxInvoiceSource = this.getExistsTaxInvoiceSource(registrationInfo);
        errorMsg = errorMsg + this.createSystermConfigRule(registrationInfo, userInfo, isAllElectronic, taxInvoiceSource);
        errorMsg = errorMsg + this.createInvoiceSplitConfigRule(registrationInfo, userInfo, isAllElectronic);
        if (StringUtils.isNotBlank((CharSequence)(errorMsg = errorMsg + this.createInvoiceMatchConfigRule(registrationInfo, userInfo, isAllElectronic)))) {
            return errorMsg;
        }
        return null;
    }

    private String getExistsTaxInvoiceSource(UnifiedPortalTenantRegistrationInfo registrationInfo) {
        MsMataDataQueryRequest mataDataQueryRequest = new MsMataDataQueryRequest();
        mataDataQueryRequest.setGroupId(Long.valueOf(registrationInfo.getTenantId()));
        mataDataQueryRequest.setObjCode(ObjCodeEnum.BILL.getObjCode());
        mataDataQueryRequest.setObjStatus(Integer.valueOf(1));
        mataDataQueryRequest.setPageNo(Integer.valueOf(1));
        mataDataQueryRequest.setPageSize(Integer.valueOf(100));
        List cfgBusinessObjEntities = this.configMetaDataService.queryMetaDataList(mataDataQueryRequest);
        if (CollectionUtils.isEmpty((Collection)cfgBusinessObjEntities)) {
            log.info("\u5546\u6237\u4e0d\u5b58\u5728\u6e20\u9053\u7c7b\u578b\u7684\u4e1a\u52a1\u5355\uff0c\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u8bfb\u53d6\u5165\u9a7b\u6a21\u7248\u914d\u7f6e\uff0ctenantId:{}", (Object)registrationInfo.getTenantId());
            return "";
        }
        List channelSalesbillTypeList = cfgBusinessObjEntities.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getChannel())).map(CfgBusinessObjEntity::getObjType).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(channelSalesbillTypeList)) {
            log.info("\u5546\u6237\u4e0d\u5b58\u5728\u6e20\u9053\u7c7b\u578b\u7684\u4e1a\u52a1\u5355\uff0c\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u8bfb\u53d6\u5165\u9a7b\u6a21\u7248\u914d\u7f6e\uff0ctenantId:{}", (Object)registrationInfo.getTenantId());
            return "";
        }
        TenantRegistrationResult.Company company = registrationInfo.getCreateResult().getCompany();
        for (String salesbillType : channelSalesbillTypeList) {
            List configIdList;
            List taxInvoiceSourceItemList;
            MsConfigQueryRequest msConfigQueryRequest = new MsConfigQueryRequest();
            msConfigQueryRequest.setSellerGroupId(Long.valueOf(registrationInfo.getTenantId()));
            msConfigQueryRequest.setBusinessBillType(BusinessBillType.AR.value());
            msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
            msConfigQueryRequest.setConfigType(ConfigTypeEnum.SYS_CONFIG_TYPE.getConfigType());
            msConfigQueryRequest.setSalesbillType(salesbillType);
            msConfigQueryRequest.setSellerTaxNo(company.getTaxNum());
            List settingCfgConfigEntityList = this.configBizConfigService.querySettingConfigList(msConfigQueryRequest);
            if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList) || CollectionUtils.isEmpty((Collection)(taxInvoiceSourceItemList = this.cfgConfigDataService.queryItemByConfigIdList(configIdList = settingCfgConfigEntityList.stream().map(CfgConfigEntity::getConfigId).collect(Collectors.toList()), "taxInvoiceSource")))) continue;
            for (CfgConfigItemEntity entity : taxInvoiceSourceItemList) {
                if (!"taxInvoiceSource".equals(entity.getConfigItemName()) || !StringUtils.isNotBlank((CharSequence)entity.getConfigItemValue()) || !CollectionUtils.isNotEmpty((Collection)((Collection)JsonUtils.writeFastJsonToObject((String)entity.getConfigItemValue(), List.class))) || !StringUtils.isNotBlank((CharSequence)String.valueOf(((List)JsonUtils.writeFastJsonToObject((String)entity.getConfigItemValue(), List.class)).get(0)))) continue;
                return String.valueOf(((List)JsonUtils.writeFastJsonToObject((String)entity.getConfigItemValue(), List.class)).get(0));
            }
        }
        log.info("\u5546\u6237\u4e0d\u5b58\u5728\u6e20\u9053\u7c7b\u578b\u7684\u9500\u9879\u4e1a\u52a1\u89c4\u5219 \u6216 \u9500\u9879\u4e1a\u52a1\u89c4\u5219\u7684\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u4e3a\u7a7a\uff0c\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u8bfb\u53d6\u5165\u9a7b\u6a21\u7248\u914d\u7f6e\uff0ctenantId:{}", (Object)registrationInfo.getTenantId());
        return "";
    }

    private String checkRequestInfo(UnifiedPortalTenantRegistrationInfo registrationInfo) {
        if (StringUtils.isBlank((CharSequence)registrationInfo.getTenantId())) {
            return "\u5165\u9a7b\u521b\u5efa\u7684\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (Objects.isNull(registrationInfo.getCreateResult())) {
            return "\u79df\u6237\u5165\u9a7b\u8be6\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (Objects.isNull(registrationInfo.getCreateResult().getUser())) {
            return "\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        TenantRegistrationResult.User user = registrationInfo.getCreateResult().getUser();
        if (StringUtils.isBlank((CharSequence)user.getTenantId())) {
            return "\u7528\u6237\u6240\u5c5e\u79df\u6237\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)user.getId())) {
            return "\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (Objects.isNull(registrationInfo.getCreateResult().getTenant())) {
            return "\u6e20\u9053\u5165\u9a7b\u79df\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        TenantRegistrationResult.Tenant tenant = registrationInfo.getCreateResult().getTenant();
        if (StringUtils.isBlank((CharSequence)tenant.getTenantName())) {
            return "\u6e20\u9053\u5165\u9a7b\u79df\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (Objects.isNull(registrationInfo.getCreateResult().getCompany())) {
            return "\u6e20\u9053\u5165\u9a7b\u516c\u53f8\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a";
        }
        TenantRegistrationResult.Company company = registrationInfo.getCreateResult().getCompany();
        if (StringUtils.isBlank((CharSequence)company.getCompanyName())) {
            return "\u6e20\u9053\u5165\u9a7b\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)company.getTaxNum())) {
            return "\u6e20\u9053\u5165\u9a7b\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return "";
    }

    private MsCommonUserInfo convertUserInfo(UnifiedPortalTenantRegistrationInfo registrationInfo) {
        TenantRegistrationResult.User user = registrationInfo.getCreateResult().getUser();
        MsCommonUserInfo userInfo = new MsCommonUserInfo();
        userInfo.setGroupId(Long.valueOf(user.getTenantId()));
        userInfo.setUserId(Long.valueOf(user.getId()));
        userInfo.setUserName(user.getUserName());
        userInfo.setMobile(user.getUserPhone());
        return userInfo;
    }

    public String createSalesbillType(UnifiedPortalTenantRegistrationInfo registrationInfo, MsCommonUserInfo userInfo, Boolean isAllElectronic) {
        MsMataDataQueryRequest mataDataQueryRequest = new MsMataDataQueryRequest();
        mataDataQueryRequest.setGroupId(Long.valueOf(registrationInfo.getTenantId()));
        mataDataQueryRequest.setObjCode(ObjCodeEnum.BILL.getObjCode());
        mataDataQueryRequest.setObjType(salesbillType);
        mataDataQueryRequest.setObjStatus(Integer.valueOf(1));
        mataDataQueryRequest.setPageNo(Integer.valueOf(1));
        mataDataQueryRequest.setPageSize(Integer.valueOf(5));
        List cfgBusinessObjEntities = this.configMetaDataService.queryMetaDataList(mataDataQueryRequest);
        if (CollectionUtils.isNotEmpty((Collection)cfgBusinessObjEntities)) {
            log.info("\u5343\u725b\u6e20\u9053\u4e1a\u52a1\u5355\u7c7b\u578b\u5df2\u5b58\u5728 tenantId\uff1a" + registrationInfo.getTenantId());
            return "";
        }
        List msBusinessObjMetadataBeanList = this.configMetaDataService.queryTemplateMetaDataList(mataDataQueryRequest);
        if (CollectionUtils.isEmpty((Collection)msBusinessObjMetadataBeanList)) {
            return "\u4e1a\u52a1\u5355\u7c7b\u578b\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728 tenantId\uff1a" + registrationInfo.getTenantId();
        }
        msBusinessObjMetadataBeanList.forEach(bean -> {
            if (busiTypeEditFields.contains(bean.getFieldName())) {
                bean.setFieldReadonly(Integer.valueOf(0));
            }
            if (busiTypeNotRequiredFields.contains(bean.getFieldName())) {
                bean.setFieldRequired(Integer.valueOf(0));
            }
            if (busiTypeNotRequiredFieldsForMain.contains(bean.getFieldName()) && bean.getFieldGroupIndex() == 0) {
                bean.setFieldRequired(Integer.valueOf(0));
            }
            if (isAllElectronic.booleanValue() && qdBusiTypeNotRequiredFields.contains(bean.getFieldName())) {
                bean.setFieldRequired(Integer.valueOf(0));
            }
            if (CollectionUtils.isEmpty((Collection)bean.getFieldEnumValue())) {
                bean.setFieldEnumValue((List)Lists.newArrayList());
            }
            if (CollectionUtils.isEmpty((Collection)bean.getFieldHighlightValue())) {
                bean.setFieldHighlightValue((List)Lists.newArrayList());
            }
            if (CollectionUtils.isEmpty((Collection)bean.getFieldDefaultValue())) {
                bean.setFieldDefaultValue((List)Lists.newArrayList());
            }
        });
        MsBusinessObjBean msBusinessObjBean = new MsBusinessObjBean();
        msBusinessObjBean.setItems(msBusinessObjMetadataBeanList);
        msBusinessObjBean.setObjCode("bill");
        msBusinessObjBean.setObjDesc("");
        msBusinessObjBean.setObjName(salesbillType);
        msBusinessObjBean.setObjType(salesbillType);
        msBusinessObjBean.setChannel(registrationInfo.getChannelTenantId());
        ArrayList<MsBusinessObjBean> itemDTOList = new ArrayList<MsBusinessObjBean>();
        itemDTOList.add(msBusinessObjBean);
        MsMataDataAddRequestWithUserInfo mataDataAddRequest = new MsMataDataAddRequestWithUserInfo();
        mataDataAddRequest.setItemDTOList(itemDTOList);
        mataDataAddRequest.setUserInfo(userInfo);
        try {
            int isOk = this.configMetaDataService.addMetaObjData(mataDataAddRequest);
            if (isOk == Response.OK) {
                log.info("\u5343\u725b\u6e20\u9053\u79df\u6237\u4e1a\u52a1\u5355\u7c7b\u578b\u4fdd\u5b58\u6210\u529f\uff0ctenantId\uff1a" + registrationInfo.getTenantId());
                return "";
            }
            return "\u65b0\u589e\u4e1a\u52a1\u5355\u7c7b\u578b\u5931\u8d25\uff0ctenantId\uff1a" + registrationInfo.getTenantId();
        }
        catch (Exception e) {
            String errorMsg = "\u65b0\u589e\u4e1a\u52a1\u5355\u7c7b\u578b\u5931\u8d25\uff0ctenantId\uff1a" + registrationInfo.getTenantId() + "\uff0cerrorMsg\uff1a" + e;
            log.error(errorMsg);
            return errorMsg;
        }
    }

    public String addBusiTypeAndUserRelation(UnifiedPortalTenantRegistrationInfo registrationInfo, MsCommonUserInfo userInfo) {
        StringBuilder errorMsg = new StringBuilder();
        List<BusinessExtensionAttribute> list = Lists.newArrayList();
        UserInfoFromUserCenterVO userInfoFromUserCenterVO = this.queryBusiTypeAndUserRelation(registrationInfo, userInfo, errorMsg);
        if (Objects.isNull(userInfoFromUserCenterVO) || StringUtils.isBlank((CharSequence)userInfoFromUserCenterVO.getBusinessExtensionAttribute())) {
            log.info("\u672a\u67e5\u8be2\u5230\u4eba\u5458\u5728\u7528\u6237\u4e2d\u5fc3\u5df2\u7ed1\u5b9a\u7684\u4e1a\u52a1\u5355\u7c7b\u578b userId:" + userInfo.getUserId().toString() + ", tenantId:" + registrationInfo.getTenantId() + "\uff1b");
        } else {
            list = JsonUtils.writeJsonToListObject((String)userInfoFromUserCenterVO.getBusinessExtensionAttribute(), BusinessExtensionAttribute.class);
        }
        Optional<BusinessExtensionAttribute> optional = list.stream().filter(i -> Objects.nonNull(i) && StringUtils.isNotBlank((CharSequence)i.getObjType()) && i.getObjType().equals(salesbillType)).findFirst();
        if (optional.isPresent()) {
            log.info("\u7528\u6237\u4e2d\u5fc3\u4eba\u5458\u5df2\u7ed1\u5b9a\u8fc7\u8be5\u4e1a\u52a1\u5355\u7c7b\u578b\uff0c\u4e0d\u518d\u7ed1\u5b9a userId:{}, tenantId:{}, salesbillType:{}", new Object[]{userInfo.getUserId().toString(), registrationInfo.getTenantId(), salesbillType});
            return "";
        }
        BusinessExtensionAttribute businessExtensionAttribute = new BusinessExtensionAttribute();
        businessExtensionAttribute.setObjType(salesbillType);
        businessExtensionAttribute.setMetaList((List)Lists.newArrayList());
        list.add(businessExtensionAttribute);
        this.addRelation(registrationInfo, userInfo, errorMsg, list);
        return errorMsg.toString();
    }

    public void addRelation(UnifiedPortalTenantRegistrationInfo registrationInfo, MsCommonUserInfo userInfo, StringBuilder errorMsg, List<BusinessExtensionAttribute> list) {
        try {
            log.info("addBusiTypeAndUserRelation tenantId:{}, userId:{},", (Object)registrationInfo.getTenantId(), (Object)userInfo.getUserId().toString());
            BusiTypeAndUserRelationRequest request = new BusiTypeAndUserRelationRequest();
            request.setBusinessExtensionAttribute(list);
            String subUrl = "api/{groupId}/v2/users/{userId}/simple";
            BusiTypeAndUserRelationResponse response2 = this.restTemplateTools.putEntity((Object)request, String.valueOf(registrationInfo.getTenantId()), userInfo.getUserId().toString(), subUrl, BusiTypeAndUserRelationResponse.class);
            if (Objects.nonNull(response2) && "1".equals(response2.getCode())) {
                log.info("\u79df\u6237\u7ed1\u5b9a\u4e1a\u52a1\u5355\u7c7b\u578b\u548c\u4eba\u5458\u5173\u7cfb\u6210\u529f,tenantId:{}, userId:{},", (Object)registrationInfo.getTenantId(), (Object)userInfo.getUserId().toString());
            } else {
                errorMsg.append("\u7ed1\u5b9a\u4e1a\u52a1\u5355\u7c7b\u578b\u548c\u4eba\u5458\u5173\u7cfb\u5931\u8d25 tenantId:" + registrationInfo.getTenantId() + ", userId:" + userInfo.getUserId().toString() + ", error:" + (Objects.nonNull(response2) ? response2.getMessage() : "") + "\uff1b");
            }
        }
        catch (Exception e) {
            String error = "\u7ed1\u5b9a\u4e1a\u52a1\u5355\u7c7b\u578b\u548c\u4eba\u5458\u5173\u7cfb\u5931\u8d25 tenantId:" + registrationInfo.getTenantId() + ", userId:" + userInfo.getUserId().toString() + ", error:" + e + "\uff1b";
            log.error(error);
            errorMsg.append(error);
        }
    }

    public UserInfoFromUserCenterVO queryBusiTypeAndUserRelation(UnifiedPortalTenantRegistrationInfo registrationInfo, MsCommonUserInfo userInfo, StringBuilder errorMsg) {
        try {
            log.info("queryBusiTypeAndUserRelation tenantId:{}, userId:{},", (Object)registrationInfo.getTenantId(), (Object)userInfo.getUserId().toString());
            String subUrl = "api/" + registrationInfo.getTenantId() + "/v2/users/" + userInfo.getUserId().toString();
            UserInfoFromUserCenterResponse response2 = this.restTemplateTools.getFromUserCenter(subUrl, UserInfoFromUserCenterResponse.class);
            if (Objects.nonNull(response2) && "1".equals(response2.getCode())) {
                log.info("\u67e5\u8be2\u4eba\u5458\u5df2\u7ed1\u5b9a\u7684\u4e1a\u52a1\u5355\u7c7b\u578b\u6210\u529f userId:{},", (Object)userInfo.getUserId().toString());
                return response2.getResult();
            }
            errorMsg.append("\u67e5\u8be2\u4eba\u5458\u5df2\u7ed1\u5b9a\u7684\u4e1a\u52a1\u5355\u7c7b\u578b\u5931\u8d25 userId:" + userInfo.getUserId().toString() + ", error:" + (Objects.nonNull(response2) ? response2.getMessage() : "") + "\uff1b");
        }
        catch (Exception e) {
            String error = "\u67e5\u8be2\u4eba\u5458\u5df2\u7ed1\u5b9a\u7684\u4e1a\u52a1\u5355\u7c7b\u578b\u5931\u8d25 userId:" + userInfo.getUserId().toString() + ", error:" + e + "\uff1b";
            log.error(error);
            errorMsg.append(error);
        }
        return null;
    }

    public String createSystermConfigRule(UnifiedPortalTenantRegistrationInfo registrationInfo, MsCommonUserInfo userInfo, Boolean isAllElectronic, String taxInvoiceSource) {
        TenantRegistrationResult.Tenant tenant = registrationInfo.getCreateResult().getTenant();
        TenantRegistrationResult.Company company = registrationInfo.getCreateResult().getCompany();
        MsConfigQueryRequest msConfigQueryRequest = new MsConfigQueryRequest();
        msConfigQueryRequest.setSellerGroupId(Long.valueOf(registrationInfo.getTenantId()));
        msConfigQueryRequest.setBusinessBillType(BusinessBillType.AR.value());
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        msConfigQueryRequest.setConfigType(ConfigTypeEnum.SYS_CONFIG_TYPE.getConfigType());
        msConfigQueryRequest.setSalesbillType(salesbillType);
        msConfigQueryRequest.setSellerTaxNo(company.getTaxNum());
        List settingCfgConfigEntityList = this.configBizConfigService.querySettingConfigList(msConfigQueryRequest);
        if (CollectionUtils.isNotEmpty((Collection)settingCfgConfigEntityList)) {
            log.info("\u5343\u725b\u6e20\u9053\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u5df2\u5b58\u5728 tenantId\uff1a" + registrationInfo.getTenantId());
            return "";
        }
        List itemList = this.getEffectiveMetaDataList(Long.valueOf(registrationInfo.getTenantId()), userInfo.getUserId(), "systermConfig", null, null, isAllElectronic, taxInvoiceSource);
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            return "\u9500\u9879\u4e1a\u52a1\u9ed8\u8ba4\u89c4\u5219\u4e0d\u5b58\u5728 tenantId\uff1a" + registrationInfo.getTenantId() + "\uff1b";
        }
        MsConfigBean msConfigBean = new MsConfigBean();
        msConfigBean.setBusinessBillType(BusinessBillType.AR.value());
        msConfigBean.setConfigName("\u3010" + company.getCompanyName() + "\u3011\u5343\u725b\u6e20\u9053\u89c4\u5219");
        msConfigBean.setConfigType(ConfigTypeEnum.SYS_CONFIG_TYPE.getConfigType());
        msConfigBean.setItemList(itemList);
        msConfigBean.setPurchaserGroupId(Long.valueOf(0L));
        msConfigBean.setPurchaserTaxNo("");
        msConfigBean.setSalesbillType(salesbillType);
        msConfigBean.setSellerGroupId(Long.valueOf(registrationInfo.getTenantId()));
        msConfigBean.setSellerName(company.getCompanyName());
        msConfigBean.setSellerTaxNo(company.getTaxNum());
        msConfigBean.setSysOrgId(Long.valueOf(0L));
        String errorMsg = this.addCfgConfig(msConfigBean, userInfo, "createSystermConfigRule", new String[0]);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return "\u9500\u9879\u4e1a\u52a1\u89c4\u5219\u521b\u5efa\u5931\u8d25\uff1a" + errorMsg + "\uff1b";
        }
        return "";
    }

    public String createInvoiceSplitConfigRule(UnifiedPortalTenantRegistrationInfo registrationInfo, MsCommonUserInfo userInfo, Boolean isAllElectronic) {
        List itemList;
        String taxDeviceType;
        TenantRegistrationResult.Company company = registrationInfo.getCreateResult().getCompany();
        MsConfigQueryRequest msConfigQueryRequest = new MsConfigQueryRequest();
        msConfigQueryRequest.setConfigType(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType());
        msConfigQueryRequest.setInvoiceType((List)Lists.newArrayList((Object[])new String[]{"ce"}));
        msConfigQueryRequest.setSalesbillType(salesbillType);
        msConfigQueryRequest.setSellerTaxNo(company.getTaxNum());
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        msConfigQueryRequest.setTaxInvoiceSource("sk");
        msConfigQueryRequest.setSellerGroupId(Long.valueOf(registrationInfo.getTenantId()));
        List settingCfgConfigEntityList = this.configBizConfigService.querySettingConfigList(msConfigQueryRequest);
        if (CollectionUtils.isNotEmpty((Collection)settingCfgConfigEntityList)) {
            log.info("\u5343\u725b\u6e20\u9053\u516c\u53f8\u62c6\u7968\u89c4\u5219\u5df2\u5b58\u5728,tenantId\uff1a{}, companyName\uff1a{}\uff0ccompanyTaxNo\uff1a{}", new Object[]{registrationInfo.getTenantId(), company.getCompanyName(), company.getTaxNum()});
            return "";
        }
        MsConfigBean msConfigBean = new MsConfigBean();
        msConfigBean.setInvoiceType("ce");
        msConfigBean.setSellerTaxNo(company.getTaxNum());
        BigDecimal singleAmountLimit = this.configBizConfigService.getSingleAmountLimit(msConfigBean, Long.valueOf(registrationInfo.getTenantId()));
        log.info("\u7a0e\u4ef6\u63a5\u53e3\u67e5\u8be2\u9650\u989d\u5927\u5c0f:{}\uff0ctenantId\uff1a{}, companyName\uff1a{}\uff0ccompanyTaxNo\uff1a{}", new Object[]{singleAmountLimit, registrationInfo.getTenantId(), company.getCompanyName(), company.getTaxNum()});
        if (Objects.isNull(singleAmountLimit)) {
            if (StringUtils.isNotBlank((CharSequence)this.amountLimitDefault)) {
                singleAmountLimit = new BigDecimal(this.amountLimitDefault);
            } else {
                return "\u62c6\u7968\u89c4\u5219\u521b\u5efa\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u7a0e\u4ef6\u9650\u989d\uff0ctenantId\uff1a" + registrationInfo.getTenantId() + ", companyName\uff1a" + company.getCompanyName() + "\uff0ccompanyTaxNo\uff1a" + company.getTaxNum() + "\uff1b";
            }
        }
        if (StringUtils.isBlank((CharSequence)(taxDeviceType = this.queryTaxDeviceType(Long.valueOf(registrationInfo.getTenantId()), company.getTaxNum())))) {
            if (StringUtils.isNotBlank((CharSequence)this.taxDeviceTypeDefault)) {
                taxDeviceType = this.taxDeviceTypeDefault;
            } else {
                return "\u62c6\u7968\u89c4\u5219\u521b\u5efa\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u7a0e\u4ef6\u8bbe\u5907\u7c7b\u578b\uff0ctenantId\uff1a" + registrationInfo.getTenantId() + ", companyName\uff1a" + company.getCompanyName() + "\uff0ccompanyTaxNo\uff1a" + company.getTaxNum() + "\uff1b";
            }
        }
        if (CollectionUtils.isEmpty((Collection)(itemList = this.getEffectiveMetaDataList(Long.valueOf(registrationInfo.getTenantId()), userInfo.getUserId(), "invoiceSplitConfig", singleAmountLimit, taxDeviceType, Boolean.valueOf(false), null)))) {
            return "\u62c6\u7968\u89c4\u5219\u521b\u5efa\u5931\u8d25\uff0c\u9ed8\u8ba4\u89c4\u5219\u914d\u7f6e\u4e0d\u5b58\u5728 tenantId\uff1a" + registrationInfo.getTenantId() + "\uff1b";
        }
        msConfigBean.setBusinessBillType(BusinessBillType.AR.value());
        msConfigBean.setConfigName("\u3010" + company.getCompanyName() + "\u3011\u5343\u725b\u6e20\u9053\u62c6\u7968\u89c4\u5219");
        msConfigBean.setConfigType(ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType());
        msConfigBean.setItemList(itemList);
        msConfigBean.setPurchaserGroupId(Long.valueOf(0L));
        msConfigBean.setPurchaserTaxNo("");
        msConfigBean.setSalesbillType(salesbillType);
        msConfigBean.setSellerGroupId(Long.valueOf(registrationInfo.getTenantId()));
        msConfigBean.setSysOrgId(Long.valueOf(0L));
        msConfigBean.setTaxInvoiceSource("sk");
        String errorMsg = this.addCfgConfig(msConfigBean, userInfo, "createInvoiceSplitConfigRule", new String[]{ALI_QIAN_NIU});
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return "\u62c6\u7968\u89c4\u5219\u521b\u5efa\u5931\u8d25\uff1a" + errorMsg + "\uff1b";
        }
        return "";
    }

    public String createInvoiceMatchConfigRule(UnifiedPortalTenantRegistrationInfo registrationInfo, MsCommonUserInfo userInfo, Boolean isAllElectronic) {
        List itemList;
        TenantRegistrationResult.Company company = registrationInfo.getCreateResult().getCompany();
        ArrayList insertInvoiceTypeList = Lists.newArrayList();
        insertInvoiceTypeList.addAll(invoiceMatchConfigInvoiceTypes);
        ArrayList settingCfgConfigEntityList = Lists.newArrayList();
        for (String invoiceType : insertInvoiceTypeList) {
            MsConfigQueryRequest msConfigQueryRequest = new MsConfigQueryRequest();
            msConfigQueryRequest.setConfigType(ConfigTypeEnum.BILL_INVOICE_MATCH_TYPE.getConfigType());
            msConfigQueryRequest.setInvoiceType((List)Lists.newArrayList((Object[])new String[]{invoiceType}));
            msConfigQueryRequest.setSalesbillType(salesbillType);
            msConfigQueryRequest.setSellerTaxNo(company.getTaxNum());
            msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
            msConfigQueryRequest.setSellerGroupId(Long.valueOf(registrationInfo.getTenantId()));
            List settingConfigForInvoiceTypeList = this.configBizConfigService.querySettingConfigList(msConfigQueryRequest);
            if (!CollectionUtils.isNotEmpty((Collection)settingConfigForInvoiceTypeList)) continue;
            settingCfgConfigEntityList.addAll(settingConfigForInvoiceTypeList);
        }
        if (CollectionUtils.isNotEmpty((Collection)settingCfgConfigEntityList)) {
            List invoiceTypeList = settingCfgConfigEntityList.stream().map(CfgConfigEntity::getInvoiceType).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(invoiceTypeList)) {
                insertInvoiceTypeList.removeAll(invoiceTypeList);
            }
            if (CollectionUtils.isEmpty((Collection)insertInvoiceTypeList)) {
                log.info("\u5343\u725b\u6e20\u9053\u516c\u53f8\u53d1\u7968\u5339\u914d\u89c4\u5219\u5df2\u5168\u90e8\u5b58\u5728,tenantId\uff1a{}, companyName\uff1a{}\uff0ccompanyTaxNo\uff1a{}", new Object[]{registrationInfo.getTenantId(), company.getCompanyName(), company.getTaxNum()});
                return "";
            }
        }
        if (CollectionUtils.isEmpty((Collection)(itemList = this.getEffectiveMetaDataList(Long.valueOf(registrationInfo.getTenantId()), userInfo.getUserId(), "invoiceMatchConfig", null, null, isAllElectronic, null)))) {
            return "\u53d1\u7968\u5339\u914d\u89c4\u5219\u521b\u5efa\u5931\u8d25\uff0c\u9ed8\u8ba4\u89c4\u5219\u914d\u7f6e\u4e0d\u5b58\u5728 tenantId\uff1a" + registrationInfo.getTenantId() + "\uff1b";
        }
        for (String invoiceType : insertInvoiceTypeList) {
            String invoiceTypeName = this.getInvoiceTypeName(invoiceType);
            MsConfigBean msConfigBean = new MsConfigBean();
            msConfigBean.setInvoiceType(invoiceType);
            msConfigBean.setSellerTaxNo(company.getTaxNum());
            msConfigBean.setBusinessBillType(BusinessBillType.AR.value());
            msConfigBean.setConfigName("\u3010" + company.getCompanyName() + "\u3011\u3010" + invoiceTypeName + "\u3011\u5355\u636e\u5339\u914d\u89c4\u5219");
            msConfigBean.setConfigType(ConfigTypeEnum.BILL_INVOICE_MATCH_TYPE.getConfigType());
            msConfigBean.setItemList(itemList);
            msConfigBean.setPurchaserGroupId(Long.valueOf(0L));
            msConfigBean.setPurchaserTaxNo("");
            msConfigBean.setSalesbillType(salesbillType);
            msConfigBean.setSellerGroupId(Long.valueOf(registrationInfo.getTenantId()));
            msConfigBean.setSysOrgId(Long.valueOf(0L));
            String errorMsg = this.addCfgConfig(msConfigBean, userInfo, "createInvoiceMatchConfigRule", new String[0]);
            if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
            return "\u5355\u636e\u5339\u914d\u89c4\u5219\u521b\u5efa\u5931\u8d25\uff1a" + errorMsg + "\uff1b";
        }
        return "";
    }

    private String getInvoiceTypeName(String invoiceType) {
        switch (invoiceType) {
            case "c": {
                return "\u666e\u7968";
            }
            case "s": {
                return "\u4e13\u7968";
            }
            case "ce": {
                return "\u7535\u5b50\u666e\u7968";
            }
            case "se": {
                return "\u7535\u5b50\u4e13\u7968";
            }
        }
        return "";
    }

    public String queryTaxDeviceType(Long tenantId, String companyTaxNum) {
        CompanyQueryInfo companyQueryInfo = new CompanyQueryInfo();
        DeviceQueryInfo deviceQueryInfo = new DeviceQueryInfo();
        QueryDeviceRequest request = new QueryDeviceRequest();
        deviceQueryInfo.setCompanyInfo(companyQueryInfo);
        request.setQueryInfo(deviceQueryInfo);
        QueryDeviceResponse queryDeviceResponse = this.deviceApiProxy.deviceQueryPost(request, tenantId, (List)Lists.newArrayList((Object[])new String[]{companyTaxNum}));
        log.info("queryTaxDeviceType:{}", (Object)JsonUtils.writeObjectToJson((Object)queryDeviceResponse));
        TaxDeviceType taxDeviceType = null;
        if (queryDeviceResponse != null && queryDeviceResponse.getHead().getCode().equals(BaseResponse.OK)) {
            List devices = queryDeviceResponse.getDevices();
            if (CollectionUtils.isNotEmpty((Collection)devices)) {
                List distinctTaxDeviceTypes = devices.stream().filter(device -> !Objects.isNull(device) && !Objects.isNull(device.getTaxDeviceInfo()) && !Objects.isNull(device.getTaxDeviceInfo().getTaxDeviceType())).map(DeviceInfo::getTaxDeviceInfo).map(TaxDeviceInfo::getTaxDeviceType).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(distinctTaxDeviceTypes) && distinctTaxDeviceTypes.size() > 1) {
                    return String.valueOf(TaxWareRemarkDeviceType.DEFAULT.ordinal());
                }
                if (CollectionUtils.isNotEmpty(distinctTaxDeviceTypes)) {
                    taxDeviceType = ValueEnum.getEnumByValue(TaxDeviceType.class, distinctTaxDeviceTypes.get(0)).orElse(null);
                }
            }
        } else {
            log.error("queryTaxDeviceType \u83b7\u53d6\u7a0e\u4ef6\u8bbe\u5907\u63a5\u53e3\u5931\u8d25:{}", (Object)queryDeviceResponse.getHead().getMessage());
            return null;
        }
        if (Objects.isNull(taxDeviceType)) {
            log.error("queryTaxDeviceType \u672a\u83b7\u53d6\u5230\u7a0e\u4ef6\u8bbe\u5907\u7c7b\u578b:{}", (Object)queryDeviceResponse.getHead().getMessage());
            return null;
        }
        return String.valueOf(taxDeviceType.getRemarkDeviceType().ordinal());
    }

    public List<MsConfigItemBean> getEffectiveMetaDataList(Long tenantId, Long userId, String objCode, BigDecimal amountLimit, String taxDeviceType, Boolean isAllElectronic, String taxInvoiceSource) {
        boolean notSetSyncDeviceAmountLimitFlag;
        MsMataDataQueryRequest msMataDataQueryRequest = new MsMataDataQueryRequest();
        msMataDataQueryRequest.setGroupId(tenantId);
        msMataDataQueryRequest.setObjCode(objCode);
        if ("invoiceSplitConfig".equals(objCode)) {
            msMataDataQueryRequest.setExt1("c");
        }
        List msBusinessObjMetadataBeanList = this.configMetaDataService.queryEffectiveMetaDataList(msMataDataQueryRequest, userId);
        ArrayList<MsConfigItemBean> itemList = new ArrayList<MsConfigItemBean>();
        msBusinessObjMetadataBeanList.forEach(bean -> {
            MsConfigItemBean msConfigItemBean = new MsConfigItemBean();
            msConfigItemBean.setConfigItemName(bean.getFieldName());
            if (Objects.isNull(bean.getFieldDefaultValue())) {
                Object defaultValue = null;
                msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{defaultValue}));
            } else {
                msConfigItemBean.setConfigItemValue(bean.getFieldDefaultValue());
            }
            if ("systermConfig".equals(objCode)) {
                if ("manualTagField".equals(bean.getFieldName()) && Objects.isNull(bean.getFieldDefaultValue())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{""}));
                }
                if ("abandonNoMakeAmountBill".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"true"}));
                }
                if ("elecInvoiceRedFlushReleaseFalg".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"3"}));
                }
                if ("autoSplitBillPreInvoice".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"false"}));
                }
                if ("uploadBillAutoMake-ce".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"false"}));
                }
                if ("taxInvoiceSource".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"sk"}));
                }
                if ("qdSellerTitle".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"1"}));
                }
                if ("qdVoucherControl".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"1"}));
                }
                if ("taxInvoiceSource".equals(bean.getFieldName()) && StringUtils.isNotBlank((CharSequence)taxInvoiceSource)) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{taxInvoiceSource}));
                } else if (isAllElectronic.booleanValue() && "taxInvoiceSource".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"qd"}));
                }
            }
            if ("invoiceSplitConfig".equals(objCode)) {
                msConfigItemBean.setConfigItemDisplayName(bean.getFieldDisplayName());
                if ("invoiceLimit".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{String.valueOf(amountLimit)}));
                }
                if ("priceMethod".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"0"}));
                }
                if ("taxDeviceType".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{taxDeviceType}));
                }
                if ("customRemarkSize".equals(bean.getFieldName())) {
                    Integer taxDeviceTypeOrdinal = NumberUtils.toInt((String)taxDeviceType, (int)-1);
                    Optional deviceTypeOptional = ValueEnum.getEnumByOrdinal(TaxWareRemarkDeviceType.class, (Integer)taxDeviceTypeOrdinal);
                    TaxWareRemarkDeviceType deviceTypeEnum = TaxWareRemarkDeviceType.DEFAULT;
                    deviceTypeEnum = (TaxWareRemarkDeviceType)deviceTypeOptional.get();
                    Integer limitRemarkLength = this.taxWareInvoiceRemarkLengthProperties.getRemarkLength(InvoiceTypeEnum.ELECTRONIC, TaxWareRemarkIssueType.BLUE, deviceTypeEnum);
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{String.valueOf(limitRemarkLength)}));
                }
                if ("amountSplitRule".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"2"}));
                }
                if ("discountRateLimit".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"100"}));
                }
                if ("hideRemarkFieldName".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"false"}));
                }
                if ("invoiceItemMaxRow".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"8"}));
                }
                if ("invoiceRemarkDistinctFlag".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"1"}));
                }
                if ("itemSort".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"0"}));
                }
                if ("mergeBySplitField".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"0"}));
                }
                if ("saleListOption".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"1"}));
                }
                if ("salesListMaxRow".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"2000"}));
                }
                if ("unitPriceAmountOps".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"0"}));
                }
                if ("taxAmountAllowMax".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"1.26"}));
                }
                if ("syncDeviceAmountLimitFlag".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"1"}));
                }
            }
            if ("invoiceMatchConfig".equals(objCode)) {
                if ("invoiceMatchOptionalFieldList".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"purchaserName", "purchaserTaxNo"}));
                }
                if ("ignoreElectricInvoiceType".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"true"}));
                }
                if ("autoRelationInvoice".equals(bean.getFieldName())) {
                    msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"false"}));
                }
            }
            itemList.add(msConfigItemBean);
        });
        if ("invoiceSplitConfig".equals(objCode) && (notSetSyncDeviceAmountLimitFlag = itemList.stream().noneMatch(msConfigItemBean -> "syncDeviceAmountLimitFlag".equals(msConfigItemBean.getConfigItemName())))) {
            MsConfigItemBean msConfigItemBean2 = new MsConfigItemBean();
            msConfigItemBean2.setConfigItemName("syncDeviceAmountLimitFlag");
            msConfigItemBean2.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{"1"}));
            msConfigItemBean2.setConfigItemDisplayName("\u81ea\u52a8\u540c\u6b65\u7a0e\u76d8\u9650\u989d");
            itemList.add(msConfigItemBean2);
        }
        return itemList;
    }

    private String addCfgConfig(MsConfigBean msConfigBean, MsCommonUserInfo userInfo, String source, String ... channels) {
        MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = new MsConfigAddRequestWithUserInfo();
        msConfigAddRequestWithUserInfo.setItemDTOList((List)Lists.newArrayList((Object[])new MsConfigBean[]{msConfigBean}));
        msConfigAddRequestWithUserInfo.setUserInfo(userInfo);
        try {
            Response response2 = this.configBizConfigService.addCfgConfig(msConfigAddRequestWithUserInfo, channels);
            log.info("{} response====>{}", (Object)source, (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            if (response2.getCode().intValue() == Response.OK.intValue()) {
                return null;
            }
            return "\uff1a" + response2.getMessage();
        }
        catch (Exception e) {
            log.error("{} configName:{} error:{} ", new Object[]{source, msConfigBean.getConfigName(), e});
            return "\uff1a" + e;
        }
    }

    public String pubCode() {
        return PUB_CODE;
    }
}

