/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.task.handler;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.janus.message.sdk.ResponseMessage;
import com.xforceplus.micro.tax.device.contract.model.CompanyQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.DeviceInfo;
import com.xforceplus.micro.tax.device.contract.model.DeviceQueryInfo;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceRequest;
import com.xforceplus.micro.tax.device.contract.model.QueryDeviceResponse;
import com.xforceplus.micro.tax.device.contract.model.TaxDeviceInfo;
import com.xforceplus.seller.config.client.constant.ConfigTypeEnum;
import com.xforceplus.seller.config.client.constant.ObjCodeEnum;
import com.xforceplus.seller.config.client.constant.StatusEnum;
import com.xforceplus.seller.config.client.model.ConfigTitleAndIssueInfoAddRequest;
import com.xforceplus.seller.config.client.model.MsBusinessObjBean;
import com.xforceplus.seller.config.client.model.MsBusinessObjMetadataBean;
import com.xforceplus.seller.config.client.model.MsCommonUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsConfigBean;
import com.xforceplus.seller.config.client.model.MsConfigItemBean;
import com.xforceplus.seller.config.client.model.MsConfigMailRule;
import com.xforceplus.seller.config.client.model.MsConfigQueryRequest;
import com.xforceplus.seller.config.client.model.MsEnumBean;
import com.xforceplus.seller.config.client.model.MsMataDataAddRequestWithUserInfo;
import com.xforceplus.seller.config.client.model.MsMataDataQueryRequest;
import com.xforceplus.seller.config.client.model.SettledTemplateConifgVo;
import com.xforceplus.seller.config.config.DingDingConfig;
import com.xforceplus.seller.config.core.enums.InitTemplateConfigEnum;
import com.xforceplus.seller.config.core.enums.TaxDeviceType;
import com.xforceplus.seller.config.core.enums.TaxWareRemarkDeviceType;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import com.xforceplus.seller.config.facade.ConfigInfoAllInOneFacade;
import com.xforceplus.seller.config.infrastructure.helper.DeviceApiProxy;
import com.xforceplus.seller.config.infrastructure.helper.RestTemplateTools;
import com.xforceplus.seller.config.models.BusiTypeAndUserRelationRequest;
import com.xforceplus.seller.config.models.BusiTypeAndUserRelationResponse;
import com.xforceplus.seller.config.models.BusinessExtensionAttribute;
import com.xforceplus.seller.config.models.UserInfoFromUserCenterResponse;
import com.xforceplus.seller.config.models.UserInfoFromUserCenterVO;
import com.xforceplus.seller.config.repository.dao.CfgConfigDao;
import com.xforceplus.seller.config.repository.daoext.CfgConfigExtDao;
import com.xforceplus.seller.config.repository.model.CfgBusinessObjEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigEntity;
import com.xforceplus.seller.config.repository.model.CfgConfigExample;
import com.xforceplus.seller.config.repository.model.CfgConfigItemEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateSettledObjEntity;
import com.xforceplus.seller.config.repository.model.CfgTemplateSettledObjExample;
import com.xforceplus.seller.config.services.CfgConfigDataService;
import com.xforceplus.seller.config.services.ConfigBizConfigService;
import com.xforceplus.seller.config.services.ConfigMetaDataService;
import com.xforceplus.seller.config.services.TemplateObjMetadataService;
import com.xforceplus.seller.config.task.handler.ResultHandler;
import com.xforceplus.seller.config.util.DingDingUtils;
import com.xforceplus.seller.enums.BusinessBillType;
import com.xforceplus.unifiedPortal.contract.model.TenantRegistrationByTemplateInfo;
import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.common.util.BeanUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import io.vavr.Tuple;
import io.vavr.Tuple3;
import io.vavr.Tuple5;
import io.vavr.control.Either;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateBusiTypeAndRulesHandler
implements ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(CreateBusiTypeAndRulesHandler.class);
    public static final String PUB_CODE = "one.billing.order.sync";
    private final String amountLimitDefault = "9999";
    private final String taxDeviceTypeDefault = "0";
    @Autowired
    private ConfigBizConfigService configBizConfigService;
    @Autowired
    private ConfigMetaDataService configMetaDataService;
    @Autowired
    private RestTemplateTools restTemplateTools;
    @Autowired
    private DeviceApiProxy deviceApiProxy;
    @Autowired
    DingDingUtils dingDingUtils;
    @Autowired
    private DingDingConfig dingDingConfig;
    @Autowired
    private TemplateObjMetadataService templateObjMetadataService;
    @Autowired
    private ConfigInfoAllInOneFacade configInfoAllInOneFacade;
    @Autowired
    private CfgConfigDataService cfgConfigDataService;
    @Autowired
    private CfgConfigDao cfgConfigDao;
    @Autowired
    private CfgConfigExtDao cfgConfigExtDao;
    @Autowired
    private RedissonClient redissonClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(ResponseMessage responseMessage) {
        String id = !Objects.isNull(responseMessage) && !Objects.isNull(responseMessage.getId()) ? String.valueOf(responseMessage.getId()) : "";
        String businessNo = !Objects.isNull(responseMessage) && !Objects.isNull(responseMessage.getProperties()) && !Objects.isNull(responseMessage.getProperties().get("businessNo")) ? (String)responseMessage.getProperties().get("businessNo") : "";
        RLock lock = null;
        try {
            String errorMsg;
            log.info("CreateBusiTypeAndRulesHandler message:{}", (Object)JsonUtils.writeObjectToFastJson((Object)responseMessage));
            TenantRegistrationByTemplateInfo info = (TenantRegistrationByTemplateInfo)JsonUtils.writeFastJsonToObject((String)responseMessage.getContent(), TenantRegistrationByTemplateInfo.class);
            lock = this.redissonClient.getLock(String.format("initRule:%s:%s:%s", info.getCenterTenantId(), info.getOrderModel().getOrgRecordId(), info.getTaxNum()));
            boolean lockRs = lock.tryLock(600L, TimeUnit.SECONDS);
            log.info("\u6d88\u606f\u603b\u7ebf\u76d1\u542c-\u521d\u59cb\u5316\u5165\u9a7b\u914d\u7f6e\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u7ed3\u679c: {}", (Object)lockRs);
            if (!lockRs) {
                log.error("\u6d88\u606f\u603b\u7ebf\u76d1\u542c-\u521d\u59cb\u5316\u5165\u9a7b\u914d\u7f6e\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
                this.dingDingUtils.sendMsgMarkDownWarn(PUB_CODE, businessNo, businessNo, String.format("\u6d88\u606f\u603b\u7ebf\u76d1\u542c-\u521d\u59cb\u5316\u5165\u9a7b\u914d\u7f6e\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25, \u79df\u6237ID: {},\u7a0e\u53f7: {}", info.getOrderModel().getOrgRecordId(), info.getTaxNum()), this.dingDingConfig.getQianNiuDingUrl());
                boolean bl = true;
                return bl;
            }
            if (Objects.nonNull(info) && StringUtils.isNotBlank((CharSequence)(errorMsg = this.createSalesbillTypeAndRules(info)))) {
                String tenant = Objects.nonNull(info.getOrderModel()) && StringUtils.isNotBlank((CharSequence)info.getOrderModel().getCenterTenantName()) ? info.getOrderModel().getCenterTenantName() : info.getCenterTenantId();
                String msg = "channelTenantId\uff1a" + info.getCenterTenantId() + "\uff0ctenantId\uff1a" + (Objects.nonNull(info.getOrderModel()) ? info.getOrderModel().getOrgRecordId() : null) + "\uff0cproductCode\uff1a" + (Objects.nonNull(info.getOrderModel()) && CollectionUtils.isNotEmpty((Collection)info.getOrderModel().getFeatureCodes()) ? JsonUtils.writeObjectToFastJson((Object)info.getOrderModel().getFeatureCodes()) : null);
                log.error(tenant + errorMsg + "\uff1b" + msg);
                this.dingDingUtils.sendMsgMarkDownWarn(PUB_CODE, id, businessNo, StringUtils.substring((String)(tenant + errorMsg + "\uff1b" + msg), (int)0, (int)300), this.dingDingConfig.getQianNiuDingUrl());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("CreateBusiTypeAndRulesHandler error: {}", (Object)e.getMessage(), (Object)e);
            String errorMsg = "\u81ea\u52a8\u5165\u9a7b \u6839\u636e\u6a21\u677f\u914d\u7f6e\u521b\u5efa\u4e1a\u52a1\u5355\u7c7b\u578b\u53ca\u89c4\u5219 \u521b\u5efa\u5931\u8d25\uff0cid\uff1a" + id + ",error\uff1a" + e.getMessage() + e;
            this.dingDingUtils.sendMsgMarkDownWarn(PUB_CODE, id, businessNo, StringUtils.substring((String)errorMsg, (int)0, (int)300), this.dingDingConfig.getQianNiuDingUrl());
        }
        finally {
            if (null != lock) {
                try {
                    lock.unlock();
                }
                catch (Throwable throwable) {}
            }
        }
        return true;
    }

    public String createSalesbillTypeAndRules(TenantRegistrationByTemplateInfo registrationInfo) {
        StringBuilder errorMsg = new StringBuilder();
        Boolean messageLegal = Optional.ofNullable(registrationInfo).map(TenantRegistrationByTemplateInfo::getOrderModel).map(r -> "1".equals(r.getOrderStatus()) || "0".equals(r.getOrderStatus()) && "1".equals(r.getLaterPay())).orElse(false);
        if (!messageLegal.booleanValue()) {
            log.info("createSalesbillTypeAndRules,orderStatusIllegal:{}", (Object)false);
            return null;
        }
        errorMsg.append(this.checkRequestInfo(registrationInfo));
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg.toString();
        }
        List featureCodes = registrationInfo.getOrderModel().getFeatureCodes();
        Map settledTemplateDataMap = this.querySettledTemplateList(registrationInfo.getCenterTenantId(), featureCodes);
        if (Objects.isNull(settledTemplateDataMap)) {
            return "\u81ea\u52a8\u5165\u9a7b\u914d\u7f6e\u6a21\u677f\u4e0d\u5b58\u5728";
        }
        MsCommonUserInfo userInfo = this.convertUserInfo(registrationInfo);
        boolean isSendConfigInfo = true;
        for (String featureCode : featureCodes) {
            Tuple5 tuple5 = this.getAutoSettledTemplateConfig(errorMsg, settledTemplateDataMap, featureCode);
            if (Objects.nonNull(tuple5) && Objects.nonNull(tuple5._1()) && !((Boolean)tuple5._1()).booleanValue()) continue;
            if (Objects.nonNull(tuple5) && Objects.isNull(tuple5._2())) {
                log.info("\u672a\u67e5\u8be2\u5230\u4efb\u4f55\u89c4\u5219\u914d\u7f6e\uff0c\u81ea\u52a8\u5165\u9a7b\u6d41\u7a0b\u5e94\u8be5\u53ea\u521b\u5efa\u9ed8\u8ba4\u4e1a\u52a1\u5355\u7c7b\u578b featureCode:{},tenantId:{}", (Object)featureCode, (Object)registrationInfo.getOrderModel().getOrgRecordId());
                continue;
            }
            Boolean createSalesbillSuccess = this.createSalesbillType(registrationInfo, userInfo, errorMsg, featureCode, tuple5);
            if (!createSalesbillSuccess.booleanValue()) continue;
            this.addBusiTypeAndUserRelation(registrationInfo, userInfo, tuple5, errorMsg);
            String taxInvoiceSource = this.getExistsTaxInvoiceSource(registrationInfo);
            this.createConfigRule(registrationInfo, userInfo, tuple5, errorMsg, featureCode, Tuple.of((Object)InitTemplateConfigEnum.SYSTEM_TEMPLATE, (Object)ConfigTypeEnum.SYS_CONFIG_TYPE, (Object)"\u9500\u9879\u4e1a\u52a1\u89c4\u5219"), taxInvoiceSource);
            this.createConfigRule(registrationInfo, userInfo, tuple5, errorMsg, featureCode, Tuple.of((Object)InitTemplateConfigEnum.INVOICE_SPLIT_TEMPLATE, (Object)ConfigTypeEnum.SPLIT_CONFIG_TYPE, (Object)"\u62c6\u7968\u89c4\u5219"), null);
            this.createConfigRule(registrationInfo, userInfo, tuple5, errorMsg, featureCode, Tuple.of((Object)InitTemplateConfigEnum.MERGE_RULE_TEMPLATE, (Object)ConfigTypeEnum.BILL_MERGE_TYPE, (Object)"\u7ec4\u5408\u5408\u5e76\u89c4\u5219"), null);
            this.createConfigRule(registrationInfo, userInfo, tuple5, errorMsg, featureCode, Tuple.of((Object)InitTemplateConfigEnum.INVOICE_DELIVERY_TEMPLATE, (Object)ConfigTypeEnum.INVOICE_MAIL_RULE_CONFIG_TYPE, (Object)"\u53d1\u7968\u63a8\u9001\u89c4\u5219"), null);
            this.createConfigRule(registrationInfo, userInfo, tuple5, errorMsg, featureCode, Tuple.of((Object)InitTemplateConfigEnum.INVOICE_MATCH_TEMPLATE, (Object)ConfigTypeEnum.BILL_INVOICE_MATCH_TYPE, (Object)"\u53d1\u7968\u5339\u914d\u89c4\u5219"), null);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                isSendConfigInfo = false;
            }
            if (!isSendConfigInfo) continue;
            isSendConfigInfo = this.isSendConfigInfo(registrationInfo, tuple5);
        }
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg.toString();
        }
        if (isSendConfigInfo) {
            ConfigTitleAndIssueInfoAddRequest request = new ConfigTitleAndIssueInfoAddRequest();
            request.setTenantId(Long.valueOf(registrationInfo.getOrderModel().getOrgRecordId()));
            request.setChannel(registrationInfo.getCenterTenantId());
            request.setCompanyName(registrationInfo.getOrderModel().getCompanyName());
            request.setCompanyTaxNo(registrationInfo.getTaxNum());
            this.configInfoAllInOneFacade.sendSettledDataFinishData(Boolean.valueOf(true), request);
        }
        return null;
    }

    private String getExistsTaxInvoiceSource(TenantRegistrationByTemplateInfo registrationInfo) {
        MsMataDataQueryRequest mataDataQueryRequest = new MsMataDataQueryRequest();
        mataDataQueryRequest.setGroupId(Long.valueOf(registrationInfo.getOrderModel().getOrgRecordId()));
        mataDataQueryRequest.setObjCode(ObjCodeEnum.BILL.getObjCode());
        mataDataQueryRequest.setObjStatus(Integer.valueOf(1));
        mataDataQueryRequest.setPageNo(Integer.valueOf(1));
        mataDataQueryRequest.setPageSize(Integer.valueOf(100));
        List cfgBusinessObjEntities = this.configMetaDataService.queryMetaDataList(mataDataQueryRequest);
        if (CollectionUtils.isEmpty((Collection)cfgBusinessObjEntities)) {
            log.info("\u5546\u6237\u4e0d\u5b58\u5728\u6e20\u9053\u7c7b\u578b\u7684\u4e1a\u52a1\u5355\uff0c\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u8bfb\u53d6\u5165\u9a7b\u6a21\u7248\u914d\u7f6e\uff0ctenantId:{}", (Object)registrationInfo.getOrderModel().getOrgRecordId());
            return "";
        }
        List channelSalesbillTypeList = cfgBusinessObjEntities.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getChannel())).map(CfgBusinessObjEntity::getObjType).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(channelSalesbillTypeList)) {
            log.info("\u5546\u6237\u4e0d\u5b58\u5728\u6e20\u9053\u7c7b\u578b\u7684\u4e1a\u52a1\u5355\uff0c\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u8bfb\u53d6\u5165\u9a7b\u6a21\u7248\u914d\u7f6e\uff0ctenantId:{}", (Object)registrationInfo.getOrderModel().getOrgRecordId());
            return "";
        }
        for (String salesbillType : channelSalesbillTypeList) {
            List configIdList;
            List taxInvoiceSourceItemList;
            MsConfigQueryRequest msConfigQueryRequest = new MsConfigQueryRequest();
            msConfigQueryRequest.setSellerGroupId(Long.valueOf(registrationInfo.getOrderModel().getOrgRecordId()));
            msConfigQueryRequest.setBusinessBillType(BusinessBillType.AR.value());
            msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
            msConfigQueryRequest.setConfigType(ConfigTypeEnum.SYS_CONFIG_TYPE.getConfigType());
            msConfigQueryRequest.setSalesbillType(salesbillType);
            msConfigQueryRequest.setSellerTaxNo(registrationInfo.getTaxNum());
            List settingCfgConfigEntityList = this.configBizConfigService.querySettingConfigList(msConfigQueryRequest);
            if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList) || CollectionUtils.isEmpty((Collection)(taxInvoiceSourceItemList = this.cfgConfigDataService.queryItemByConfigIdList(configIdList = settingCfgConfigEntityList.stream().map(CfgConfigEntity::getConfigId).collect(Collectors.toList()), "taxInvoiceSource")))) continue;
            for (CfgConfigItemEntity entity : taxInvoiceSourceItemList) {
                if (!"taxInvoiceSource".equals(entity.getConfigItemName()) || !StringUtils.isNotBlank((CharSequence)entity.getConfigItemValue()) || !CollectionUtils.isNotEmpty((Collection)((Collection)JsonUtils.writeFastJsonToObject((String)entity.getConfigItemValue(), List.class))) || !StringUtils.isNotBlank((CharSequence)String.valueOf(((List)JsonUtils.writeFastJsonToObject((String)entity.getConfigItemValue(), List.class)).get(0)))) continue;
                return String.valueOf(((List)JsonUtils.writeFastJsonToObject((String)entity.getConfigItemValue(), List.class)).get(0));
            }
        }
        log.info("\u5546\u6237\u4e0d\u5b58\u5728\u6e20\u9053\u7c7b\u578b\u7684\u9500\u9879\u4e1a\u52a1\u89c4\u5219 \u6216 \u9500\u9879\u4e1a\u52a1\u89c4\u5219\u7684\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u4e3a\u7a7a\uff0c\u56fd\u7a0e\u53d1\u7968\u6765\u6e90\u8bfb\u53d6\u5165\u9a7b\u6a21\u7248\u914d\u7f6e\uff0ctenantId:{}", (Object)registrationInfo.getOrderModel().getOrgRecordId());
        return "";
    }

    private Boolean isSendConfigInfo(TenantRegistrationByTemplateInfo registrationInfo, Tuple5<Boolean, SettledTemplateConifgVo, String, Integer, SettledTemplateConifgVo> tuple5) {
        List invoiceMemberTemplateList;
        SettledTemplateConifgVo settledTemplateConfigVo = (SettledTemplateConifgVo)tuple5._5();
        String salesbillType = (String)tuple5._3();
        if (Objects.isNull(settledTemplateConfigVo) || CollectionUtils.isEmpty((Collection)settledTemplateConfigVo.getCfgTemplateObjVoList())) {
            return true;
        }
        List invoiceInfoTemplateList = settledTemplateConfigVo.getCfgTemplateObjVoList().stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getTemplateObjCode()) && r.getTemplateObjCode().contains(InitTemplateConfigEnum.INVOICE_INFO_TEMPLATE.getObjCode())).collect(Collectors.toList());
        MsConfigQueryRequest msConfigQueryRequest = new MsConfigQueryRequest();
        msConfigQueryRequest.setSellerGroupId(Long.valueOf(registrationInfo.getOrderModel().getOrgRecordId()));
        msConfigQueryRequest.setBusinessBillType(BusinessBillType.AR.value());
        msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
        msConfigQueryRequest.setSalesbillType(salesbillType);
        msConfigQueryRequest.setSellerTaxNo(registrationInfo.getTaxNum());
        if (!CollectionUtils.isEmpty(invoiceInfoTemplateList)) {
            msConfigQueryRequest.setConfigType(ConfigTypeEnum.INVOICE_CONFIG_TYPE.getConfigType());
            List settingCfgConfigEntityList = this.querySettingInvoiceConfigAR(msConfigQueryRequest);
            if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList) || settingCfgConfigEntityList.size() < invoiceInfoTemplateList.size()) {
                log.info("\u5f00\u7968\u62ac\u5934\u89c4\u5219\u672a\u914d\u7f6e\uff0c\u4e0d\u4e0b\u53d1\u96c6\u6210\u5e73\u53f0\uff0ctenantId=" + registrationInfo.getOrderModel().getOrgRecordId() + ",SellerTaxNo=" + registrationInfo.getTaxNum() + ",salesbillType=" + salesbillType);
                return false;
            }
        }
        if (!CollectionUtils.isEmpty(invoiceMemberTemplateList = settledTemplateConfigVo.getCfgTemplateObjVoList().stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getTemplateObjCode()) && r.getTemplateObjCode().contains(InitTemplateConfigEnum.INVOICE_MEMBER_INFO_TEMPLATE.getObjCode())).collect(Collectors.toList()))) {
            msConfigQueryRequest.setConfigType(ConfigTypeEnum.INVOICE_USER_CONFIG_TYPE.getConfigType());
            List settingCfgConfigEntityList = this.querySettingInvoiceConfigAR(msConfigQueryRequest);
            if (CollectionUtils.isEmpty((Collection)settingCfgConfigEntityList) || settingCfgConfigEntityList.size() < invoiceMemberTemplateList.size()) {
                log.info("\u7968\u9762\u4eba\u5458\u89c4\u5219\u914d\u7f6e\u672a\u914d\u7f6e\uff0c\u4e0d\u4e0b\u53d1\u96c6\u6210\u5e73\u53f0\uff0ctenantId=" + registrationInfo.getOrderModel().getOrgRecordId() + ",SellerTaxNo=" + registrationInfo.getTaxNum() + ",salesbillType=" + salesbillType);
                return false;
            }
        }
        return true;
    }

    private Tuple5<Boolean, SettledTemplateConifgVo, String, Integer, SettledTemplateConifgVo> getAutoSettledTemplateConfig(StringBuilder errorMsg, Map<String, List<CfgTemplateSettledObjEntity>> settledTemplateDataMap, String featureCode) {
        Either either;
        List<CfgTemplateSettledObjEntity> settledTemplateDataVoList = settledTemplateDataMap.get(featureCode);
        if (CollectionUtils.isEmpty(settledTemplateDataVoList)) {
            errorMsg.append("\u81ea\u52a8\u5165\u9a7b\u914d\u7f6e\u6a21\u677f\u4e0d\u5b58\u5728\uff08\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801\uff1a" + featureCode + " \uff09\uff0c");
            return Tuple.of((Object)false, null, null, null, null);
        }
        CfgTemplateSettledObjEntity settledTemplateDataVo = settledTemplateDataVoList.get(0);
        if (settledTemplateDataVoList.size() > 1) {
            log.info("\u81ea\u52a8\u5165\u9a7b\u914d\u7f6e\u6a21\u677f\u6709" + settledTemplateDataVoList.size() + "\u4e2a\uff08\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801\uff1a" + featureCode + " \uff09\uff0c");
            settledTemplateDataVo = settledTemplateDataVoList.stream().sorted(Comparator.comparing(CfgTemplateSettledObjEntity::getUpdateTime).reversed()).findFirst().get();
        }
        if ((either = this.templateObjMetadataService.querySettledTemplateConfigItem(settledTemplateDataVo.getSettledObjId(), Boolean.valueOf(false))).isLeft()) {
            errorMsg.append("\u81ea\u52a8\u5165\u9a7b\u914d\u7f6e\u2014\u81ea\u52a8\u521b\u5efa\u89c4\u5219\u6a21\u677f\u83b7\u53d6\u9519\u8bef\uff1a" + (String)either.getLeft() + "\uff08\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801\uff1a" + featureCode + " \uff09\uff0c");
            return Tuple.of((Object)false, null, null, null, null);
        }
        Either eitherManual = this.templateObjMetadataService.querySettledTemplateConfigItem(settledTemplateDataVo.getSettledObjId(), Boolean.valueOf(true));
        if (eitherManual.isLeft()) {
            log.info("\u81ea\u52a8\u5165\u9a7b\u914d\u7f6e\u2014\u672a\u83b7\u53d6\u5230\u624b\u52a8\u5165\u9a7b\u6a21\u677f\uff1a" + (String)eitherManual.getLeft() + "\uff08\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801\uff1a" + featureCode + " \uff09\uff0c");
            return Tuple.of(null, (Object)either.get(), (Object)settledTemplateDataVo.getSalesbillType(), (Object)settledTemplateDataVo.getToCFlag(), null);
        }
        return Tuple.of(null, (Object)either.get(), (Object)settledTemplateDataVo.getSalesbillType(), (Object)settledTemplateDataVo.getToCFlag(), (Object)eitherManual.get());
    }

    private Map<String, List<CfgTemplateSettledObjEntity>> querySettledTemplateList(String tenantId, List<String> featureCodes) {
        Consumer<CfgTemplateSettledObjExample.Criteria> condition = criteria -> {
            criteria.andTenantIdEqualTo(Long.valueOf(tenantId));
            criteria.andProductCodeIn(featureCodes);
            criteria.andStatusEqualTo(Integer.valueOf(1));
        };
        List settledObjVoList = this.templateObjMetadataService.queryByCondition(condition);
        if (CollectionUtils.isNotEmpty((Collection)settledObjVoList)) {
            return settledObjVoList.stream().collect(Collectors.groupingBy(CfgTemplateSettledObjEntity::getProductCode));
        }
        return null;
    }

    private String checkRequestInfo(TenantRegistrationByTemplateInfo registrationInfo) {
        if (StringUtils.isBlank((CharSequence)registrationInfo.getCenterTenantId())) {
            return "\u6e20\u9053\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)registrationInfo.getTaxNum())) {
            return "\u8d2d\u4e70\u65b9\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (Objects.isNull(registrationInfo.getOrderModel())) {
            return "orderModel\u4e0d\u80fd\u4e3a\u7a7a";
        }
        TenantRegistrationByTemplateInfo.OrderModel orderModel = registrationInfo.getOrderModel();
        if (StringUtils.isBlank((CharSequence)orderModel.getOrderStatus())) {
            return "\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (Objects.isNull(orderModel.getOrgRecordId())) {
            return "\u8d2d\u4e70\u65b9\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)orderModel.getOrgName())) {
            return "\u8d2d\u4e70\u65b9\u79df\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((CharSequence)orderModel.getCompanyName())) {
            return "\u8d2d\u4e70\u65b9\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)orderModel.getFeatureCodes())) {
            return "\u8d2d\u4e70\u65b9\u529f\u80fd\u5305Code\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (Objects.isNull(orderModel.getCreateUserId())) {
            return "\u7528\u6237Id\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return "";
    }

    private MsCommonUserInfo convertUserInfo(TenantRegistrationByTemplateInfo registrationInfo) {
        MsCommonUserInfo userInfo = new MsCommonUserInfo();
        userInfo.setGroupId(Long.valueOf(registrationInfo.getOrderModel().getOrgRecordId()));
        userInfo.setUserId(Long.valueOf(registrationInfo.getOrderModel().getCreateUserId()));
        return userInfo;
    }

    public Boolean createSalesbillType(TenantRegistrationByTemplateInfo registrationInfo, MsCommonUserInfo userInfo, StringBuilder errorMsg, String featureCode, Tuple5<Boolean, SettledTemplateConifgVo, String, Integer, SettledTemplateConifgVo> tuple5) {
        SettledTemplateConifgVo settledTemplateConfigVo = (SettledTemplateConifgVo)tuple5._2();
        String salesbillType = (String)tuple5._3();
        Integer toCFlag = (Integer)tuple5._4();
        MsMataDataQueryRequest mataDataQueryRequest = new MsMataDataQueryRequest();
        mataDataQueryRequest.setGroupId(Long.valueOf(registrationInfo.getOrderModel().getOrgRecordId()));
        mataDataQueryRequest.setObjCode(ObjCodeEnum.BILL.getObjCode());
        mataDataQueryRequest.setObjType(salesbillType);
        mataDataQueryRequest.setObjStatus(Integer.valueOf(1));
        mataDataQueryRequest.setPageNo(Integer.valueOf(1));
        mataDataQueryRequest.setPageSize(Integer.valueOf(5));
        List cfgBusinessObjEntities = this.configMetaDataService.queryMetaDataList(mataDataQueryRequest);
        if (CollectionUtils.isNotEmpty((Collection)cfgBusinessObjEntities)) {
            log.info(salesbillType + "\u4e1a\u52a1\u5355\u7c7b\u578b\u5df2\u5b58\u5728 tenantId\uff1a" + registrationInfo.getOrderModel().getOrgRecordId());
            return true;
        }
        if (Objects.nonNull(toCFlag) && toCFlag == 1) {
            MsMataDataQueryRequest toCMataDataQueryRequest = new MsMataDataQueryRequest();
            toCMataDataQueryRequest.setGroupId(Long.valueOf(registrationInfo.getOrderModel().getOrgRecordId()));
            toCMataDataQueryRequest.setObjCode(ObjCodeEnum.BILL.getObjCode());
            toCMataDataQueryRequest.setObjFlag(Integer.valueOf(1));
            toCMataDataQueryRequest.setObjStatus(Integer.valueOf(1));
            toCMataDataQueryRequest.setPageNo(Integer.valueOf(1));
            toCMataDataQueryRequest.setPageSize(Integer.valueOf(5));
            List toCCfgBusinessObjEntities = this.configMetaDataService.queryMetaDataList(toCMataDataQueryRequest);
            if (CollectionUtils.isNotEmpty((Collection)toCCfgBusinessObjEntities)) {
                errorMsg.append("\u79df\u6237\u4e0b\u5df2\u5b58\u5728\u96f6\u552e\u5f00\u7968\u4e1a\u52a1\u5355\uff0c\u4e0d\u53ef\u518d\u6b21\u65b0\u5efa\uff08tenantId\uff1a" + registrationInfo.getOrderModel().getOrgRecordId() + "\uff0c\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801\uff1a" + featureCode + " \uff09\uff1b");
                return false;
            }
        }
        String objDesc = "";
        List<MsBusinessObjMetadataBean> msBusinessObjMetadataBeanList = Lists.newArrayList();
        Optional<SettledTemplateConifgVo.CfgTemplateObjVo> optional = null;
        if (Objects.nonNull(settledTemplateConfigVo) && CollectionUtils.isNotEmpty((Collection)settledTemplateConfigVo.getCfgTemplateObjVoList())) {
            optional = settledTemplateConfigVo.getCfgTemplateObjVoList().stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getTemplateObjCode()) && r.getTemplateObjCode().contains(InitTemplateConfigEnum.BILL_TEMPLATE.getObjCode())).findFirst();
        }
        if (!optional.isPresent() || CollectionUtils.isEmpty((Collection)((SettledTemplateConifgVo.CfgTemplateObjVo)optional.get()).getCfgTemplateObjMetadataList())) {
            log.info("\u81ea\u52a8\u5165\u9a7b\u914d\u7f6e\u6a21\u677f\u2014\u672a\u83b7\u53d6\u5230\u3010\u4e1a\u52a1\u5355\u3011\u81ea\u52a8\u521b\u5efa\u89c4\u5219\u6a21\u677f\uff0c\u9700\u8981\u67e5\u8be2\u4e1a\u52a1\u5355\u6807\u51c6\u6a21\u677f\uff08\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801\uff1a" + featureCode + " \uff09\uff1b tenantId\uff1a" + registrationInfo.getOrderModel().getOrgRecordId());
            msBusinessObjMetadataBeanList = this.configMetaDataService.queryTemplateMetaDataList(mataDataQueryRequest);
            if (CollectionUtils.isEmpty((Collection)msBusinessObjMetadataBeanList)) {
                errorMsg.append("\u4e1a\u52a1\u5355\u9ed8\u8ba4\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728 tenantId\uff1a" + registrationInfo.getOrderModel().getOrgRecordId());
                return false;
            }
            msBusinessObjMetadataBeanList.forEach(r -> {
                if (CollectionUtils.isEmpty((Collection)r.getFieldEnumValue())) {
                    r.setFieldEnumValue((List)Lists.newArrayList());
                }
                if (CollectionUtils.isEmpty((Collection)r.getFieldHighlightValue())) {
                    r.setFieldHighlightValue((List)Lists.newArrayList());
                }
                if (CollectionUtils.isEmpty((Collection)r.getFieldDefaultValue())) {
                    r.setFieldDefaultValue((List)Lists.newArrayList());
                }
            });
        } else {
            SettledTemplateConifgVo.CfgTemplateObjVo cfgTemplateObjVo = optional.get();
            objDesc = cfgTemplateObjVo.getTemplateObjDesc();
            List cfgTemplateObjMetadataList = cfgTemplateObjVo.getCfgTemplateObjMetadataList();
            for (SettledTemplateConifgVo.CfgTemplateObjMetadataVo bean : cfgTemplateObjMetadataList) {
                ArrayList fieldDefaultValue = StringUtils.isBlank((CharSequence)bean.getFieldDefaultValue()) ? Lists.newArrayList() : (List)JsonUtils.writeFastJsonToObject((String)bean.getFieldDefaultValue(), List.class);
                bean.setFieldEnumValue(null);
                bean.setFieldDefaultValue(null);
                MsBusinessObjMetadataBean msBusinessObjMetadataBean = new MsBusinessObjMetadataBean();
                BeanUtils.copyProperties((Object)bean, (Object)msBusinessObjMetadataBean);
                msBusinessObjMetadataBean.setFieldDefaultValue((List)fieldDefaultValue);
                msBusinessObjMetadataBean.setFieldEnumValue((List)Lists.newArrayList());
                if (CollectionUtils.isEmpty((Collection)msBusinessObjMetadataBean.getFieldHighlightValue())) {
                    msBusinessObjMetadataBean.setFieldHighlightValue((List)Lists.newArrayList());
                }
                msBusinessObjMetadataBeanList.add(msBusinessObjMetadataBean);
            }
        }
        MsBusinessObjBean msBusinessObjBean = new MsBusinessObjBean();
        msBusinessObjBean.setItems(msBusinessObjMetadataBeanList);
        msBusinessObjBean.setObjCode("bill");
        msBusinessObjBean.setObjDesc(objDesc);
        msBusinessObjBean.setObjName(salesbillType);
        msBusinessObjBean.setObjType(salesbillType);
        msBusinessObjBean.setChannel(registrationInfo.getCenterTenantId());
        if (Objects.nonNull(toCFlag) && toCFlag == 1) {
            msBusinessObjBean.setObjFlag(Integer.valueOf(1));
        }
        ArrayList<MsBusinessObjBean> itemDTOList = new ArrayList<MsBusinessObjBean>();
        itemDTOList.add(msBusinessObjBean);
        MsMataDataAddRequestWithUserInfo mataDataAddRequest = new MsMataDataAddRequestWithUserInfo();
        mataDataAddRequest.setItemDTOList(itemDTOList);
        mataDataAddRequest.setUserInfo(userInfo);
        try {
            int isOk = this.configMetaDataService.addMetaObjData(mataDataAddRequest);
            if (isOk == Response.OK) {
                log.info(registrationInfo.getOrderModel().getOrgName() + "(" + registrationInfo.getOrderModel().getOrgRecordId() + ")\u79df\u6237\u4e1a\u52a1\u5355\u7c7b\u578b\u4fdd\u5b58\u6210\u529f,featureCode:" + featureCode);
                return true;
            }
            errorMsg.append("\u65b0\u589e\u4e1a\u52a1\u5355\u7c7b\u578b\u5931\u8d25\uff0ctenantId\uff1a" + registrationInfo.getOrderModel().getOrgRecordId() + ",featureCode:" + featureCode + "\uff1b");
            return false;
        }
        catch (Exception e) {
            String error = "\u65b0\u589e\u4e1a\u52a1\u5355\u7c7b\u578b\u5931\u8d25\uff0ctenantId\uff1a" + registrationInfo.getOrderModel().getOrgRecordId() + ",featureCode:" + featureCode + "\uff0cerrorMsg\uff1a" + e + "\uff1b";
            log.error(error);
            e.printStackTrace();
            errorMsg.append(error);
            return false;
        }
    }

    public void addBusiTypeAndUserRelation(TenantRegistrationByTemplateInfo registrationInfo, MsCommonUserInfo userInfo, Tuple5<Boolean, SettledTemplateConifgVo, String, Integer, SettledTemplateConifgVo> tuple5, StringBuilder errorMsg) {
        List<BusinessExtensionAttribute> list = Lists.newArrayList();
        UserInfoFromUserCenterVO userInfoFromUserCenterVO = this.queryBusiTypeAndUserRelation(registrationInfo, userInfo, errorMsg);
        if (Objects.isNull(userInfoFromUserCenterVO) || StringUtils.isBlank((CharSequence)userInfoFromUserCenterVO.getBusinessExtensionAttribute())) {
            log.info("\u672a\u67e5\u8be2\u5230\u4eba\u5458\u5728\u7528\u6237\u4e2d\u5fc3\u5df2\u7ed1\u5b9a\u7684\u4e1a\u52a1\u5355\u7c7b\u578b userId:" + userInfo.getUserId().toString() + ", tenantId:" + registrationInfo.getOrderModel().getOrgRecordId() + "\uff1b");
        } else {
            list = JsonUtils.writeJsonToListObject((String)userInfoFromUserCenterVO.getBusinessExtensionAttribute(), BusinessExtensionAttribute.class);
        }
        Optional<BusinessExtensionAttribute> optional = list.stream().filter(i -> Objects.nonNull(i) && StringUtils.isNotBlank((CharSequence)i.getObjType()) && i.getObjType().equals(tuple5._3())).findFirst();
        if (optional.isPresent()) {
            log.info("\u7528\u6237\u4e2d\u5fc3\u4eba\u5458\u5df2\u7ed1\u5b9a\u8fc7\u8be5\u4e1a\u52a1\u5355\u7c7b\u578b\uff0c\u4e0d\u518d\u7ed1\u5b9a userId:{}, tenantId:{}, salesbillType:{}", new Object[]{userInfo.getUserId().toString(), registrationInfo.getOrderModel().getOrgRecordId(), tuple5._3()});
            return;
        }
        BusinessExtensionAttribute businessExtensionAttribute = new BusinessExtensionAttribute();
        businessExtensionAttribute.setObjType((String)tuple5._3());
        businessExtensionAttribute.setMetaList((List)Lists.newArrayList());
        list.add(businessExtensionAttribute);
        this.addRelation(registrationInfo, userInfo, errorMsg, list);
    }

    public void addRelation(TenantRegistrationByTemplateInfo registrationInfo, MsCommonUserInfo userInfo, StringBuilder errorMsg, List<BusinessExtensionAttribute> list) {
        try {
            log.info("addBusiTypeAndUserRelation tenantId:{}, userId:{},", (Object)registrationInfo.getOrderModel().getOrgRecordId(), (Object)userInfo.getUserId().toString());
            BusiTypeAndUserRelationRequest request = new BusiTypeAndUserRelationRequest();
            request.setBusinessExtensionAttribute(list);
            String subUrl = "api/{groupId}/v2/users/{userId}/simple";
            BusiTypeAndUserRelationResponse response2 = this.restTemplateTools.putEntity((Object)request, String.valueOf(registrationInfo.getOrderModel().getOrgRecordId()), userInfo.getUserId().toString(), subUrl, BusiTypeAndUserRelationResponse.class);
            if (Objects.nonNull(response2) && "1".equals(response2.getCode())) {
                log.info("\u79df\u6237\u7ed1\u5b9a\u4e1a\u52a1\u5355\u7c7b\u578b\u548c\u4eba\u5458\u5173\u7cfb\u6210\u529f,tenantId:{}, userId:{},", (Object)registrationInfo.getOrderModel().getOrgRecordId(), (Object)userInfo.getUserId().toString());
            } else {
                errorMsg.append("\u7ed1\u5b9a\u4e1a\u52a1\u5355\u7c7b\u578b\u548c\u4eba\u5458\u5173\u7cfb\u5931\u8d25 tenantId:" + registrationInfo.getOrderModel().getOrgRecordId() + ", userId:" + userInfo.getUserId().toString() + ", error:" + (Objects.nonNull(response2) ? response2.getMessage() : "") + "\uff1b");
            }
        }
        catch (Exception e) {
            String error = "\u7ed1\u5b9a\u4e1a\u52a1\u5355\u7c7b\u578b\u548c\u4eba\u5458\u5173\u7cfb\u5931\u8d25 tenantId:" + registrationInfo.getOrderModel().getOrgRecordId() + ", userId:" + userInfo.getUserId().toString() + ", error:" + e + "\uff1b";
            log.error(error);
            errorMsg.append(error);
        }
    }

    public UserInfoFromUserCenterVO queryBusiTypeAndUserRelation(TenantRegistrationByTemplateInfo registrationInfo, MsCommonUserInfo userInfo, StringBuilder errorMsg) {
        try {
            log.info("queryBusiTypeAndUserRelation tenantId:{}, userId:{},", (Object)registrationInfo.getOrderModel().getOrgRecordId(), (Object)userInfo.getUserId().toString());
            String subUrl = "api/" + registrationInfo.getOrderModel().getOrgRecordId() + "/v2/users/" + userInfo.getUserId().toString();
            UserInfoFromUserCenterResponse response2 = this.restTemplateTools.getFromUserCenter(subUrl, UserInfoFromUserCenterResponse.class);
            if (Objects.nonNull(response2) && "1".equals(response2.getCode())) {
                log.info("\u67e5\u8be2\u4eba\u5458\u5df2\u7ed1\u5b9a\u7684\u4e1a\u52a1\u5355\u7c7b\u578b\u6210\u529f userId:{},", (Object)userInfo.getUserId().toString());
                return response2.getResult();
            }
            errorMsg.append("\u67e5\u8be2\u4eba\u5458\u5df2\u7ed1\u5b9a\u7684\u4e1a\u52a1\u5355\u7c7b\u578b\u5931\u8d25 userId:" + userInfo.getUserId().toString() + ", error:" + (Objects.nonNull(response2) ? response2.getMessage() : "") + "\uff1b");
        }
        catch (Exception e) {
            String error = "\u67e5\u8be2\u4eba\u5458\u5df2\u7ed1\u5b9a\u7684\u4e1a\u52a1\u5355\u7c7b\u578b\u5931\u8d25 userId:" + userInfo.getUserId().toString() + ", error:" + e + "\uff1b";
            log.error(error);
            errorMsg.append(error);
        }
        return null;
    }

    public void createConfigRule(TenantRegistrationByTemplateInfo registrationInfo, MsCommonUserInfo userInfo, Tuple5<Boolean, SettledTemplateConifgVo, String, Integer, SettledTemplateConifgVo> tuple5, StringBuilder errorMsg, String featureCode, Tuple3<InitTemplateConfigEnum, ConfigTypeEnum, String> tuple3, String taxInvoiceSource) {
        SettledTemplateConifgVo settledTemplateConfigVo = (SettledTemplateConifgVo)tuple5._2();
        String salesbillType = (String)tuple5._3();
        List<Object> templateList = Lists.newArrayList();
        if (Objects.nonNull(settledTemplateConfigVo) && CollectionUtils.isNotEmpty((Collection)settledTemplateConfigVo.getCfgTemplateObjVoList())) {
            templateList = settledTemplateConfigVo.getCfgTemplateObjVoList().stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getTemplateObjCode()) && r.getTemplateObjCode().contains(((InitTemplateConfigEnum)tuple3._1()).getObjCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)templateList)) {
            log.info("\u81ea\u52a8\u5165\u9a7b\u89c4\u5219\u4e2d\u672a\u914d\u7f6e" + (String)tuple3._3() + "\u6a21\u677f,\u4e0d\u521b\u5efa\u8be5\u89c4\u5219\uff08tenantId\uff1a" + registrationInfo.getOrderModel().getOrgRecordId() + "\uff0c\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801\uff1a" + featureCode + " \uff09\uff1b");
            return;
        }
        for (SettledTemplateConifgVo.CfgTemplateObjVo cfgTemplateObjVo : templateList) {
            String error;
            Optional<SettledTemplateConifgVo.CfgTemplateObjMetadataVo> optional;
            List cfgTemplateObjMetadataList = cfgTemplateObjVo.getCfgTemplateObjMetadataList();
            if (CollectionUtils.isEmpty((Collection)cfgTemplateObjMetadataList)) {
                errorMsg.append(salesbillType + "\u3010" + (String)tuple3._3() + "\u3011\u81ea\u52a8\u521b\u5efa\u89c4\u5219\u6a21\u677f\u4e0d\u5b58\u5728\uff08tenantId\uff1a" + registrationInfo.getOrderModel().getOrgRecordId() + "\uff0c\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801\uff1a" + featureCode + " \uff09\uff1b");
                continue;
            }
            if (InitTemplateConfigEnum.INVOICE_DELIVERY_TEMPLATE == tuple3._1() && (!(optional = cfgTemplateObjMetadataList.stream().filter(i -> "autoSend".equals(i.getFieldName())).findFirst()).isPresent() || StringUtils.isBlank((CharSequence)optional.get().getFieldDefaultValue()) || optional.get().getFieldDefaultValue().contains("false"))) continue;
            SettledTemplateConifgVo.CfgTemplateObjVo.convert((SettledTemplateConifgVo.CfgTemplateObjVo)cfgTemplateObjVo);
            MsConfigQueryRequest msConfigQueryRequest = new MsConfigQueryRequest();
            msConfigQueryRequest.setSellerGroupId(Long.valueOf(registrationInfo.getOrderModel().getOrgRecordId()));
            msConfigQueryRequest.setBusinessBillType(BusinessBillType.AR.value());
            msConfigQueryRequest.setStatus(StatusEnum.NORMAL.getStatus());
            msConfigQueryRequest.setConfigType(((ConfigTypeEnum)tuple3._2()).getConfigType());
            msConfigQueryRequest.setSalesbillType(salesbillType);
            msConfigQueryRequest.setSellerTaxNo(registrationInfo.getTaxNum());
            if (StringUtils.isNotBlank((CharSequence)cfgTemplateObjVo.getInvoiceType())) {
                msConfigQueryRequest.setInvoiceType((List)Lists.newArrayList((Object[])new String[]{cfgTemplateObjVo.getInvoiceType()}));
            }
            if (StringUtils.isNotBlank((CharSequence)cfgTemplateObjVo.getTaxInvoiceSource()) && StringUtils.isNotBlank((CharSequence)taxInvoiceSource)) {
                msConfigQueryRequest.setTaxInvoiceSource(taxInvoiceSource);
            } else if (StringUtils.isNotBlank((CharSequence)cfgTemplateObjVo.getTaxInvoiceSource())) {
                msConfigQueryRequest.setTaxInvoiceSource(cfgTemplateObjVo.getTaxInvoiceSource());
            }
            List<Object> settingCfgConfigEntityList = Lists.newArrayList();
            settingCfgConfigEntityList = ConfigTypeEnum.SYS_CONFIG_TYPE.getConfigType().equals(((ConfigTypeEnum)tuple3._2()).getConfigType()) ? this.querySysConfigByAR(msConfigQueryRequest) : (ConfigTypeEnum.INVOICE_MAIL_RULE_CONFIG_TYPE.getConfigType().equals(((ConfigTypeEnum)tuple3._2()).getConfigType()) ? this.queryMailConfigByAR(msConfigQueryRequest) : this.configBizConfigService.querySettingConfigList(msConfigQueryRequest));
            settingCfgConfigEntityList = settingCfgConfigEntityList.stream().filter(r -> Objects.nonNull(r.getSellerGroupId()) && r.getSellerGroupId() != 0L && StringUtils.isNotBlank((CharSequence)r.getSellerTaxNo())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty((Collection)settingCfgConfigEntityList)) {
                log.info(registrationInfo.getOrderModel().getOrgName() + (String)tuple3._3() + "\u5df2\u5b58\u5728 \uff08tenantId\uff1a" + registrationInfo.getOrderModel().getOrgRecordId() + "\uff0c\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801\uff1a" + featureCode + " \uff09\uff1b");
                continue;
            }
            MsConfigBean msConfigBean = new MsConfigBean();
            msConfigBean.setSellerTaxNo(registrationInfo.getTaxNum());
            if (StringUtils.isNotBlank((CharSequence)cfgTemplateObjVo.getInvoiceType())) {
                msConfigBean.setInvoiceType(cfgTemplateObjVo.getInvoiceType());
            }
            BigDecimal singleAmountLimit = new BigDecimal("9999");
            String taxDeviceType = "0";
            if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().equals(((ConfigTypeEnum)tuple3._2()).getConfigType()) && "sk".equals(cfgTemplateObjVo.getTaxInvoiceSource())) {
                singleAmountLimit = this.configBizConfigService.getSingleAmountLimit(msConfigBean, Long.valueOf(registrationInfo.getOrderModel().getOrgRecordId()));
                log.info("\u7a0e\u4ef6\u63a5\u53e3\u67e5\u8be2\u9650\u989d\u5927\u5c0f:{}\uff0ctenantId\uff1a{}, companyName\uff1a{}\uff0ccompanyTaxNo\uff1a{}", new Object[]{singleAmountLimit, registrationInfo.getOrderModel().getOrgRecordId(), registrationInfo.getOrderModel().getCompanyName(), registrationInfo.getTaxNum()});
                if (Objects.isNull(singleAmountLimit)) {
                    if (StringUtils.isNotBlank((CharSequence)"9999")) {
                        singleAmountLimit = new BigDecimal("9999");
                    } else {
                        errorMsg.append("\u62c6\u7968\u89c4\u5219\u521b\u5efa\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u7a0e\u4ef6\u9650\u989d\uff0ctenantId\uff1a" + registrationInfo.getOrderModel().getOrgRecordId() + ", companyName\uff1a" + registrationInfo.getOrderModel().getCompanyName() + "\uff0ccompanyTaxNo\uff1a" + registrationInfo.getTaxNum() + "\uff0cinvoiceType\uff1a" + cfgTemplateObjVo.getInvoiceType() + "\uff1b");
                    }
                }
                if (StringUtils.isBlank((CharSequence)(taxDeviceType = this.queryTaxDeviceType(Long.valueOf(registrationInfo.getOrderModel().getOrgRecordId()), registrationInfo.getTaxNum())))) {
                    if (StringUtils.isNotBlank((CharSequence)"0")) {
                        taxDeviceType = "0";
                    } else {
                        errorMsg.append("\u62c6\u7968\u89c4\u5219\u521b\u5efa\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u7a0e\u4ef6\u8bbe\u5907\u7c7b\u578b\uff0ctenantId\uff1a" + registrationInfo.getOrderModel().getOrgRecordId() + ", companyName\uff1a" + registrationInfo.getOrderModel().getCompanyName() + "\uff0ccompanyTaxNo\uff1a" + registrationInfo.getTaxNum() + "\uff1b");
                    }
                }
            }
            ArrayList itemList = Lists.newArrayList();
            MsConfigMailRule mailRule = new MsConfigMailRule();
            if (InitTemplateConfigEnum.INVOICE_DELIVERY_TEMPLATE == tuple3._1()) {
                for (SettledTemplateConifgVo.CfgTemplateObjMetadataVo bean : cfgTemplateObjMetadataList) {
                    List fieldEnumValue;
                    Optional<MsEnumBean> optional2;
                    if (StringUtils.isBlank((CharSequence)bean.getFieldDefaultValue())) continue;
                    if ("autoSend".equals(bean.getFieldName())) {
                        mailRule.setAutosend(Boolean.valueOf(bean.getFieldDefaultValue()).booleanValue());
                    }
                    if ("sendType".equals(bean.getFieldName()) && StringUtils.isNotBlank((CharSequence)bean.getFieldEnumValue()) && (optional2 = (fieldEnumValue = JSON.parseArray((String)bean.getFieldEnumValue(), MsEnumBean.class)).stream().filter(i -> bean.getFieldDefaultValue().equals(i.getValue())).findFirst()).isPresent()) {
                        mailRule.setNoticeType(optional2.get().getCode());
                    }
                    if ("emailCategory".equals(bean.getFieldName()) && "0".equals(bean.getFieldDefaultValue())) {
                        mailRule.setPickBizBillAddress(true);
                    }
                    if ("emailCategory".equals(bean.getFieldName()) && "1".equals(bean.getFieldDefaultValue())) {
                        mailRule.setPickUCAddress(true);
                    }
                    if ("emailCategory".equals(bean.getFieldName()) && "2".equals(bean.getFieldDefaultValue())) {
                        mailRule.setUseCustomAddress(true);
                    }
                    if ("otherEmail".equals(bean.getFieldName())) {
                        mailRule.setCustomMailList(bean.getFieldDefaultValue());
                    }
                    if ("sendTime".equals(bean.getFieldName()) && "1".equals(bean.getFieldDefaultValue())) {
                        mailRule.setSendAtOnce(true);
                    }
                    if ("sendTime".equals(bean.getFieldName()) && "2".equals(bean.getFieldDefaultValue())) {
                        mailRule.setSendDaily(true);
                    }
                    if ("daySendTime".equals(bean.getFieldName())) {
                        mailRule.setSendTime(bean.getFieldDefaultValue());
                    }
                    if ("sendTime".equals(bean.getFieldName()) && "3".equals(bean.getFieldDefaultValue())) {
                        mailRule.setSendMonthly(true);
                    }
                    if ("monthSendTime".equals(bean.getFieldName())) {
                        mailRule.setMonthSendTime(bean.getFieldDefaultValue());
                    }
                    if (!"combineType".equals(bean.getFieldName())) continue;
                    mailRule.setCombineType(bean.getFieldDefaultValue());
                    mailRule.setMonthCombineType(bean.getFieldDefaultValue());
                }
            } else {
                for (SettledTemplateConifgVo.CfgTemplateObjMetadataVo bean : cfgTemplateObjMetadataList) {
                    MsConfigItemBean msConfigItemBean = new MsConfigItemBean();
                    msConfigItemBean.setConfigItemName(bean.getFieldName());
                    msConfigItemBean.setConfigItemDisplayName(bean.getFieldDisplayName());
                    List itemValueList = (List)JsonUtils.writeFastJsonToObject((String)bean.getFieldDefaultValue(), List.class);
                    if (CollectionUtils.isNotEmpty((Collection)itemValueList) && Objects.nonNull(itemValueList.get(0)) && itemValueList.get(0).getClass() != String.class) {
                        ArrayList itemValueStringList = Lists.newArrayList();
                        for (Object itemValue : itemValueList) {
                            if (Objects.isNull(itemValue)) continue;
                            itemValueStringList.add(String.valueOf(itemValue));
                        }
                        itemValueList = itemValueStringList;
                    }
                    msConfigItemBean.setConfigItemValue(itemValueList);
                    if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().equals(((ConfigTypeEnum)tuple3._2()).getConfigType()) && "sk".equals(cfgTemplateObjVo.getTaxInvoiceSource()) && "invoiceLimit".equals(bean.getFieldName())) {
                        msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{String.valueOf(singleAmountLimit)}));
                    }
                    if (ConfigTypeEnum.SPLIT_CONFIG_TYPE.getConfigType().equals(((ConfigTypeEnum)tuple3._2()).getConfigType()) && "sk".equals(cfgTemplateObjVo.getTaxInvoiceSource()) && "taxDeviceType".equals(bean.getFieldName())) {
                        msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{taxDeviceType}));
                    }
                    if (ConfigTypeEnum.SYS_CONFIG_TYPE.getConfigType().equals(((ConfigTypeEnum)tuple3._2()).getConfigType()) && StringUtils.isNotBlank((CharSequence)taxInvoiceSource) && "taxInvoiceSource".equals(bean.getFieldName())) {
                        msConfigItemBean.setConfigItemValue((List)Lists.newArrayList((Object[])new String[]{taxInvoiceSource}));
                    }
                    itemList.add(msConfigItemBean);
                }
            }
            msConfigBean.setBusinessBillType(BusinessBillType.AR.value());
            msConfigBean.setConfigName("\u3010" + registrationInfo.getOrderModel().getCompanyName() + "\u3011" + salesbillType + "\u89c4\u5219");
            msConfigBean.setConfigType(((ConfigTypeEnum)tuple3._2()).getConfigType());
            msConfigBean.setPurchaserGroupId(Long.valueOf(0L));
            msConfigBean.setPurchaserTaxNo("");
            msConfigBean.setSalesbillType(salesbillType);
            msConfigBean.setSellerGroupId(Long.valueOf(registrationInfo.getOrderModel().getOrgRecordId()));
            msConfigBean.setSellerName(registrationInfo.getOrderModel().getCompanyName());
            msConfigBean.setSysOrgId(Long.valueOf(0L));
            if (StringUtils.isNotBlank((CharSequence)msConfigQueryRequest.getTaxInvoiceSource())) {
                msConfigBean.setTaxInvoiceSource(msConfigQueryRequest.getTaxInvoiceSource());
            }
            if (InitTemplateConfigEnum.INVOICE_DELIVERY_TEMPLATE == tuple3._1()) {
                msConfigBean.setMailRule(mailRule);
            } else {
                msConfigBean.setItemList((List)itemList);
            }
            if (!StringUtils.isNotBlank((CharSequence)(error = this.addCfgConfig(msConfigBean, userInfo, ((InitTemplateConfigEnum)tuple3._1()).getObjCode() + "Rule", new String[0])))) continue;
            errorMsg.append(salesbillType + (String)tuple3._3() + "\u521b\u5efa\u5931\u8d25\uff08tenantId\uff1a" + registrationInfo.getOrderModel().getOrgRecordId() + "\uff0c\u4ea7\u54c1\u670d\u52a1\u5305\u4ee3\u7801\uff1a" + featureCode + " \uff09;error:" + error);
        }
    }

    public String queryTaxDeviceType(Long tenantId, String companyTaxNum) {
        CompanyQueryInfo companyQueryInfo = new CompanyQueryInfo();
        DeviceQueryInfo deviceQueryInfo = new DeviceQueryInfo();
        QueryDeviceRequest request = new QueryDeviceRequest();
        deviceQueryInfo.setCompanyInfo(companyQueryInfo);
        request.setQueryInfo(deviceQueryInfo);
        QueryDeviceResponse queryDeviceResponse = this.deviceApiProxy.deviceQueryPost(request, tenantId, (List)Lists.newArrayList((Object[])new String[]{companyTaxNum}));
        log.info("queryTaxDeviceType:{}", (Object)JsonUtils.writeObjectToJson((Object)queryDeviceResponse));
        TaxDeviceType taxDeviceType = null;
        if (queryDeviceResponse != null && queryDeviceResponse.getHead().getCode().equals(BaseResponse.OK)) {
            List devices = queryDeviceResponse.getDevices();
            if (CollectionUtils.isNotEmpty((Collection)devices)) {
                List distinctTaxDeviceTypes = devices.stream().filter(device -> !Objects.isNull(device) && !Objects.isNull(device.getTaxDeviceInfo()) && !Objects.isNull(device.getTaxDeviceInfo().getTaxDeviceType())).map(DeviceInfo::getTaxDeviceInfo).map(TaxDeviceInfo::getTaxDeviceType).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(distinctTaxDeviceTypes) && distinctTaxDeviceTypes.size() > 1) {
                    return String.valueOf(TaxWareRemarkDeviceType.DEFAULT.ordinal());
                }
                if (CollectionUtils.isNotEmpty(distinctTaxDeviceTypes)) {
                    taxDeviceType = ValueEnum.getEnumByValue(TaxDeviceType.class, distinctTaxDeviceTypes.get(0)).orElse(null);
                }
            }
        } else {
            log.error("queryTaxDeviceType \u83b7\u53d6\u7a0e\u4ef6\u8bbe\u5907\u63a5\u53e3\u5931\u8d25:{}", (Object)queryDeviceResponse.getHead().getMessage());
            return null;
        }
        if (Objects.isNull(taxDeviceType)) {
            log.error("queryTaxDeviceType \u672a\u83b7\u53d6\u5230\u7a0e\u4ef6\u8bbe\u5907\u7c7b\u578b:{}", (Object)queryDeviceResponse.getHead().getMessage());
            return null;
        }
        return String.valueOf(taxDeviceType.getRemarkDeviceType().ordinal());
    }

    private String addCfgConfig(MsConfigBean msConfigBean, MsCommonUserInfo userInfo, String source, String ... channels) {
        MsConfigAddRequestWithUserInfo msConfigAddRequestWithUserInfo = new MsConfigAddRequestWithUserInfo();
        msConfigAddRequestWithUserInfo.setItemDTOList((List)Lists.newArrayList((Object[])new MsConfigBean[]{msConfigBean}));
        msConfigAddRequestWithUserInfo.setUserInfo(userInfo);
        try {
            Response response2 = this.configBizConfigService.addCfgConfig(msConfigAddRequestWithUserInfo, channels);
            log.info("{} response====>{}", (Object)source, (Object)JsonUtils.writeObjectToFastJson((Object)response2));
            if (response2.getCode().intValue() == Response.OK.intValue()) {
                return null;
            }
            return "\uff1a" + response2.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("{} configName:{} error:{} ", new Object[]{source, msConfigBean.getConfigName(), e});
            return "\uff1a" + e;
        }
    }

    private List<CfgConfigEntity> querySysConfigByAR(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample configExample = new CfgConfigExample();
        CfgConfigExample.Criteria criteria = configExample.createCriteria();
        criteria.andSellerGroupIdEqualTo(Long.valueOf(msConfigQueryRequest.getSellerGroupId() == null ? 0L : msConfigQueryRequest.getSellerGroupId()));
        criteria.andBusinessBillTypeEqualTo(msConfigQueryRequest.getBusinessBillType());
        criteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        criteria.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        criteria.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
        criteria.andSellerTaxNoEqualTo(msConfigQueryRequest.getSellerTaxNo());
        return this.cfgConfigDao.selectByExample(configExample);
    }

    private List<CfgConfigEntity> queryMailConfigByAR(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigEntity cfgConfigEntity = new CfgConfigEntity();
        cfgConfigEntity.setSellerGroupId(Long.valueOf(msConfigQueryRequest.getSellerGroupId() == null ? 0L : msConfigQueryRequest.getSellerGroupId()));
        cfgConfigEntity.setBusinessBillType(msConfigQueryRequest.getBusinessBillType());
        cfgConfigEntity.setStatus(StatusEnum.NORMAL.getStatus());
        cfgConfigEntity.setConfigType(ConfigTypeEnum.INVOICE_MAIL_RULE_CONFIG_TYPE.getConfigType());
        cfgConfigEntity.setSellerTaxNo(msConfigQueryRequest.getSellerTaxNo());
        ArrayList salesbillTypeList = Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()});
        return this.cfgConfigExtDao.innerJoinMailQueryConfigByTaxNo(cfgConfigEntity, (List)salesbillTypeList, msConfigQueryRequest.getInvoiceType());
    }

    private List<CfgConfigEntity> querySettingInvoiceConfigAR(MsConfigQueryRequest msConfigQueryRequest) {
        CfgConfigExample cfgConfigExample = new CfgConfigExample();
        CfgConfigExample.Criteria invoiceCriteria = cfgConfigExample.createCriteria();
        invoiceCriteria.andSellerGroupIdEqualTo(msConfigQueryRequest.getSellerGroupId() != null ? msConfigQueryRequest.getSellerGroupId() : Long.valueOf(0L));
        invoiceCriteria.andConfigTypeEqualTo(Byte.valueOf(msConfigQueryRequest.getConfigType().byteValue()));
        invoiceCriteria.andStatusEqualTo(Byte.valueOf(StatusEnum.NORMAL.getStatus().byteValue()));
        invoiceCriteria.andSalesbillTypeIn((List)Lists.newArrayList((Object[])new String[]{"", msConfigQueryRequest.getSalesbillType()}));
        invoiceCriteria.andSellerTaxNoEqualTo(msConfigQueryRequest.getSellerTaxNo());
        List cfgConfigEntities = this.cfgConfigDao.selectByExample(cfgConfigExample);
        return cfgConfigEntities;
    }

    public String pubCode() {
        return PUB_CODE;
    }
}

