/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.task.handler;

import com.alibaba.excel.EasyExcel;
import com.xforceplus.janus.message.sdk.ResponseMessage;
import com.xforceplus.micro.tax.device.contract.model.GoodsInfo;
import com.xforceplus.phoenix.oss.Module;
import com.xforceplus.phoenix.oss.OssUtil;
import com.xforceplus.seller.config.config.PubSubProperties;
import com.xforceplus.seller.config.services.MessageHelper;
import com.xforceplus.seller.config.task.handler.ResultHandler;
import com.xforceplus.seller.config.util.DateTools;
import com.xforceplus.seller.config.util.JsonUtils;
import com.xforceplus.xplatframework.apimodel.UserInfo;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoodsResultHandler
implements ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(GoodsResultHandler.class);
    public static final String PUB_CODE = "goodsServiceImportReceipt";
    @Autowired
    private MessageHelper messageHelper;
    @Autowired
    private OssUtil ossUtil;
    @Autowired
    private PubSubProperties pubSubProperties;

    public boolean handle(ResponseMessage responseMessage) {
        if (StringUtils.equals((CharSequence)this.pubSubProperties.getPubSubSwitch(), (CharSequence)"on")) {
            String content = responseMessage.getContent();
            Map properties = responseMessage.getProperties();
            List goodsInfos = JsonUtils.writeFastJsonToListObject((String)content, GoodsInfo.class);
            String thirdPartyId = responseMessage.getThirdPartyId();
            try {
                this.processInfo(goodsInfos, properties, thirdPartyId);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u5546\u54c1\u5bfc\u5165\u7ed3\u679c\u5f02\u5e38");
                return false;
            }
        }
        return true;
    }

    void processInfo(List<GoodsInfo> goodsInfos, Map<String, String> propertyMap, String thirdPartyId) throws Exception {
        Map<Integer, List<GoodsInfo>> goodsMap;
        UserInfo userInfo = new UserInfo();
        if (propertyMap != null) {
            Long userId = propertyMap.get("opUserId") == null ? 0L : Long.parseLong(propertyMap.get("opUserId").toString());
            Long groupId = propertyMap.get("tenantId") == null ? 0L : Long.parseLong(propertyMap.get("tenantId").toString());
            userInfo.setUserId(userId.longValue());
            userInfo.setUserName(String.valueOf(propertyMap.get("opUserName")));
            userInfo.setGroupId(groupId.longValue());
        }
        int success = (goodsMap = goodsInfos.parallelStream().collect(Collectors.groupingBy(GoodsInfo::getCode))).get(1) == null ? 0 : goodsMap.get(1).size();
        int fail = goodsMap.get(0) == null ? 0 : goodsMap.get(0).size();
        String url = "";
        if (fail > 0) {
            String filepath = "file/import-fail/" + Module.SELLER.value() + "/" + DateTools.day() + "/" + thirdPartyId + ".xls";
            File file = new File(filepath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            EasyExcel.write((String)filepath, GoodsInfo.class).sheet("\u5546\u54c1\u5bfc\u5165\u7ed3\u679c").doWrite(goodsMap.get(0));
            String key = this.ossUtil.uploadFileInternal(filepath, Module.SELLER, true);
            url = this.ossUtil.fileKeyToDownloadUrlViaPlatform(key);
            FileUtils.deleteQuietly((File)file);
        }
        String title = "\u5546\u54c1\u5bfc\u5165\u7ed3\u679c";
        String content = "\u6210\u529f" + success + "\u6761\uff0c\u5931\u8d25" + fail + "\u6761";
        this.messageHelper.sendMessageMiddle(userInfo, title, content, url);
    }

    public String pubCode() {
        return PUB_CODE;
    }
}

