/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.util;

import com.google.common.base.Preconditions;
import com.xforceplus.seller.config.core.enums.ErrorCodeEnum;
import com.xforceplus.seller.config.core.enums.ValueEnum;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.helpers.MessageFormatter;

/*
 * Exception performing whole class analysis ignored.
 */
public class AssertUtil {
    public static String formatMsg(String var, Object ... args) {
        return MessageFormatter.arrayFormat((String)var, (Object[])args).getMessage();
    }

    public static String formatArrayMsg(String var, Object[] array) {
        return MessageFormatter.arrayFormat((String)var, (Object[])array).getMessage();
    }

    public static void checkState(boolean expression, ErrorCodeEnum errorCode) {
        Preconditions.checkState((boolean)expression, (Object)(errorCode.getValue() + "::" + errorCode.getDescription()));
    }

    public static void checkState(boolean expression, ErrorCodeEnum errorCode, Object ... args) {
        Preconditions.checkState((boolean)expression, (Object)(errorCode.getValue() + "::" + AssertUtil.formatMsg((String)errorCode.getDescription(), (Object[])args)));
    }

    public static void checkNotEmpty(String reference) {
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((CharSequence)reference), (Object)(ErrorCodeEnum.SYSTEM1002.getValue() + "::" + ErrorCodeEnum.SYSTEM1002.getDescription()));
    }

    public static void checkNotNull(Object reference) {
        Preconditions.checkState((null != reference ? 1 : 0) != 0, (Object)(ErrorCodeEnum.SYSTEM1002.getValue() + "::" + ErrorCodeEnum.SYSTEM1002.getDescription()));
    }

    public static void checkNotNull(Object ... references) {
        Arrays.stream(references).forEach(AssertUtil::checkNotNull);
    }

    public static void checkNotEmpty(String ... references) {
        Arrays.stream(references).forEach(AssertUtil::checkNotEmpty);
    }

    public static void checkNotEmpty(List<String> references) {
        references.forEach(AssertUtil::checkNotEmpty);
    }

    public static <T> T checkNotNull(T reference, ErrorCodeEnum errorCode) {
        return (T)Preconditions.checkNotNull(reference, (Object)(errorCode.getValue() + "::" + errorCode.getDescription()));
    }

    public static <T> T checkNotNull(T reference, ErrorCodeEnum errorCode, Object ... args) {
        return (T)Preconditions.checkNotNull(reference, (Object)(errorCode.getValue() + "::" + AssertUtil.formatMsg((String)errorCode.getDescription(), (Object[])args)));
    }

    public static <E extends Enum<E>, T> void check(@NonNull Class<E> clazz, Integer value) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        AssertUtil.check(clazz, (String)String.valueOf(value));
    }

    public static <E extends Enum<E>, T> void check(@NonNull Class<E> clazz, String value) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        AssertUtil.checkState((boolean)EnumUtils.getEnumList(clazz).stream().anyMatch(c -> value.equals(String.valueOf(((ValueEnum)c).getValue()))), (ErrorCodeEnum)(StringUtils.isEmpty((CharSequence)value) ? ErrorCodeEnum.SYSTEM1001 : ErrorCodeEnum.SYSTEM1005), (Object[])new Object[]{value});
    }

    public static <E extends Enum<E>, T> void check(@NonNull Class<E> clazz, boolean isCurrent, String value, List<String> values) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (isCurrent) {
            Optional.ofNullable(value).ifPresent(v -> AssertUtil.check((Class)clazz, (String)value));
            Optional.ofNullable(values).ifPresent(v -> values.forEach(i -> AssertUtil.check((Class)clazz, (String)i)));
        }
    }
}

