/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CommonTools {
    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        if (str.trim().length() == 0) {
            return true;
        }
        return str.trim().equalsIgnoreCase("null");
    }

    public static <U> void setValue(Consumer<U> setter, U u) {
        setter.accept(u);
    }

    public static <T, U> void checkNullSetValue(Supplier<U> getter, Consumer<U> setter, T t, U u) {
        if (null == getter.get()) {
            setter.accept(u);
        }
    }

    public static int getStringCharLength(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0;
        }
        int valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            if (temp.matches(chinese)) {
                valueLength += 2;
                continue;
            }
            ++valueLength;
        }
        return valueLength;
    }

    public static <K, V> void mapPutValue(Map<K, List<V>> map, K key, V value) {
        List valueList = map.getOrDefault(key, Lists.newArrayList());
        valueList.add(value);
        map.put(key, valueList);
    }

    public static boolean checkContainChineseValue(String value) {
        Pattern p = Pattern.compile("[\\u4e00-\\u9fa5]+");
        Matcher m = p.matcher(value);
        boolean b = m.find();
        return b;
    }
}

