/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.config.util;

import com.xforceplus.seller.config.util.CommonTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static PoolingHttpClientConnectionManager connMgr;
    private static RequestConfig requestConfig;
    private static final int MAX_TIMEOUT = 8000;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String APPLICATION_JSON = "application/json; charset=UTF-8";
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";

    public static String doPost(String url) throws IOException {
        return HttpUtils.doPost((String)url, null);
    }

    public static String doGet(String url, boolean json) throws IOException {
        return HttpUtils.doGet((String)url, null, (boolean)json);
    }

    public static String doPost(String url, Map<String, Object> params) throws IOException {
        List pairList = HttpUtils.convertToPair(params);
        return HttpUtils.doPostl((String)url, (List)pairList);
    }

    private static List<NameValuePair> convertToPair(Map<String, Object> params) {
        ArrayList<NameValuePair> pairList = new ArrayList<NameValuePair>();
        if (MapUtils.isEmpty(params)) {
            return pairList;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            pairList.add((NameValuePair)new BasicNameValuePair(entry.getKey(), (String)entry.getValue()));
        }
        return pairList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostl(String url, List<NameValuePair> pairs) throws IOException {
        String result = null;
        InputStream instream = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httpPost = new HttpPost(url);
            UrlEncodedFormEntity uefEntity = new UrlEncodedFormEntity(pairs, "UTF-8");
            httpPost.setEntity((HttpEntity)uefEntity);
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = httpResponse.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                result = HttpUtils.getStreamAsString((InputStream)instream, (String)"UTF-8");
            }
        }
        finally {
            if (null != instream) {
                instream.close();
            }
        }
        return result;
    }

    public static String doGet(String url, Map<String, String> params, boolean json) throws IOException {
        return HttpUtils.doGet((String)url, params, (boolean)json, null);
    }

    public static String doGet(String url, Map<String, String> params, boolean json, Map<String, String> headers) throws IOException {
        HttpResponse response2;
        HttpEntity entity;
        String result = null;
        InputStream instream = null;
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(HttpUtils.buildQueryUrlWithParams((String)url, params));
        httpget.setConfig(requestConfig);
        if (json) {
            httpget.addHeader("Content-Type", "application/json; charset=UTF-8");
        }
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpget.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if ((entity = (response2 = httpclient.execute((HttpUriRequest)httpget)).getEntity()) != null) {
            instream = entity.getContent();
            result = HttpUtils.getStreamAsString((InputStream)instream, (String)"UTF-8");
        }
        return result;
    }

    public static String doGet(String url, Map<String, String> params, int timeout) throws IOException {
        String result = null;
        InputStream instream = null;
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet httpget = new HttpGet(HttpUtils.buildQueryUrlWithParams((String)url, params));
        RequestConfig requestConf = RequestConfig.custom().setConnectTimeout(timeout).build();
        httpget.setConfig(requestConf);
        HttpResponse response2 = httpclient.execute((HttpUriRequest)httpget);
        HttpEntity entity = response2.getEntity();
        if (entity != null) {
            instream = entity.getContent();
            result = HttpUtils.getStreamAsString((InputStream)instream, (String)"UTF-8");
        }
        return result;
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query2 = new StringBuilder();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (CommonTools.isEmpty((String)entry.getKey()) || CommonTools.isEmpty((String)entry.getValue())) continue;
            if (hasParam) {
                query2.append("&");
            } else {
                hasParam = true;
            }
            query2.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue(), charset));
        }
        return query2.toString();
    }

    public static String getStreamAsString(InputStream stream, String charset) throws IOException {
        String result = null;
        BufferedReader in = null;
        in = new BufferedReader(new InputStreamReader(stream, charset));
        StringBuffer buffer = new StringBuffer();
        String line = "";
        while ((line = in.readLine()) != null) {
            buffer.append(line);
        }
        result = buffer.toString();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String http(String url, Map<String, String> params) {
        URL u = null;
        HttpURLConnection con = null;
        StringBuffer sb = new StringBuffer();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                sb.append(e.getKey());
                sb.append("=");
                sb.append(e.getValue());
                sb.append("&");
            }
            sb.substring(0, sb.length() - 1);
        }
        try {
            u = new URL(url);
            con = (HttpURLConnection)u.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStreamWriter osw = new OutputStreamWriter(con.getOutputStream(), "UTF-8");
            osw.write(sb.toString());
            osw.flush();
            osw.close();
        }
        catch (Exception osw) {
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        StringBuffer buffer = new StringBuffer();
        try {
            String temp;
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "GBK"));
            while ((temp = br.readLine()) != null) {
                buffer.append(temp);
                buffer.append("\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer.toString();
    }

    public static String doPostJson(String url, String json) throws IOException {
        return HttpUtils.doPostJson((String)url, (String)json, null);
    }

    public static String doPostJson(String url, String json, Map<String, String> headers) throws IOException {
        return HttpUtils.doPostJson((String)url, (String)json, headers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostJson(String url, String json, Map<String, String> headers, Map<String, String> params) throws IOException {
        String result = null;
        try (InputStream instream = null;){
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpPost httpPost = new HttpPost(HttpUtils.buildQueryUrlWithParams((String)url, params));
            httpPost.addHeader("Content-Type", "application/json; charset=UTF-8");
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpPost.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)json)) {
                StringEntity se = new StringEntity(json, "UTF-8");
                se.setContentType("text/json");
                se.setContentEncoding((Header)new BasicHeader("Content-Encoding", "UTF-8"));
                httpPost.setEntity((HttpEntity)se);
            }
            httpPost.setConfig(requestConfig);
            HttpResponse response2 = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response2.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                result = HttpUtils.getStreamAsString((InputStream)instream, (String)"UTF-8");
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostJsonSkipSsl(String url, String json) {
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        String result = null;
        InputStream instream = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-Type", "application/json; charset=UTF-8");
            StringEntity se = new StringEntity(json, "UTF-8");
            se.setContentType("text/json");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json; charset=UTF-8"));
            httpPost.setEntity((HttpEntity)se);
            CloseableHttpResponse response2 = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response2.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                result = HttpUtils.getStreamAsString((InputStream)instream, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (null != instream) {
                try {
                    instream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPostSSL(String apiUrl, Map<String, Object> params) {
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response2 = null;
        String httpStr = null;
        try {
            httpPost.setConfig(requestConfig);
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            response2 = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response2.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                Map.Entry<String, Object> entry;
                entry = null;
                return entry;
            }
            HttpEntity entity = response2.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return httpStr;
        }
        catch (Exception exception) {
            return httpStr;
        }
        finally {
            if (response2 != null) {
                try {
                    EntityUtils.consume((HttpEntity)response2.getEntity());
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPostSSL(String apiUrl, Object json) {
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response2 = null;
        String httpStr = null;
        try {
            httpPost.setConfig(requestConfig);
            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json; charset=UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
            response2 = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response2.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String string = null;
                return string;
            }
            HttpEntity entity = response2.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return httpStr;
        }
        catch (Exception exception) {
            return httpStr;
        }
        finally {
            if (response2 != null) {
                try {
                    EntityUtils.consume((HttpEntity)response2.getEntity());
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new /* Unavailable Anonymous Inner Class!! */).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return sslsf;
    }

    private static void outputFoot(String boundary, OutputStream os) throws IOException {
        os.write(("--" + boundary + "--\r\n").getBytes());
        os.flush();
    }

    public static String buildQueryUrlWithParams(String url, Map<String, String> params) throws IOException {
        if (MapUtils.isEmpty(params)) {
            return url;
        }
        StringBuilder urlSb = new StringBuilder(url);
        String urlParam = HttpUtils.buildQuery(params, (String)"UTF-8");
        if (url.contains("?") && url.contains("=")) {
            urlSb.append("&");
        } else {
            urlSb.append("?");
        }
        urlSb.append(urlParam);
        return urlSb.toString();
    }

    public static String doPutHttpRequest(String url, Map<String, String> headerMap, String requestBody) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String entityStr = null;
        CloseableHttpResponse response2 = null;
        try {
            HttpPut post = new HttpPut(url);
            for (Map.Entry<String, String> header : headerMap.entrySet()) {
                post.addHeader(header.getKey(), header.getValue());
            }
            StringEntity entity = new StringEntity(requestBody, "Utf-8");
            System.out.println("\u8bf7\u6c42\u4f53\u662f\uff1a" + requestBody);
            post.setEntity((HttpEntity)entity);
            response2 = httpClient.execute((HttpUriRequest)post);
            HttpEntity httpEntity = response2.getEntity();
            entityStr = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            System.out.println("PUT\u8bf7\u6c42\u8def\u5f84\uff1a" + post);
            System.out.println("PUT\u8bf7\u6c42\u7ed3\u679c\uff1a" + entityStr);
        }
        catch (ClientProtocolException e) {
            System.err.println("Http\u534f\u8bae\u51fa\u73b0\u95ee\u9898");
            e.printStackTrace();
        }
        catch (ParseException e) {
            System.err.println("\u89e3\u6790\u9519\u8bef");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("IO\u5f02\u5e38");
            e.printStackTrace();
        }
        return entityStr;
    }

    static {
        Registry registry = RegistryBuilder.create().register("https", (Object)HttpUtils.createSSLConnSocketFactory()).build();
        connMgr = new PoolingHttpClientConnectionManager(registry);
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(8000);
        configBuilder.setSocketTimeout(8000);
        configBuilder.setConnectionRequestTimeout(8000);
        configBuilder.setStaleConnectionCheckEnabled(true);
        requestConfig = configBuilder.build();
    }
}

