/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.constant;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xforceplus.phoenix.redletter.enums.RedConfirmationApplyStatus;
import com.xforceplus.seller.invoice.client.model.SmartMatchInvoiceResult;
import com.xforceplus.seller.invoice.constant.enums.InvoiceType;
import com.xforceplus.seller.invoice.models.businessdomian.InvSellerInvoiceDocument;
import com.xforceplus.seller.invoice.models.businessdomian.PreInvoiceDocument;
import com.xforceplus.seller.invoice.repository.model.InvSellerInvoiceEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerInvoiceExtEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerInvoiceVehicleInfoEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerIssueRecordEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerRepeatInvoiceEntity;
import io.vavr.Lazy;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class InvoiceConstants {
    public static final Integer INVOICE_NORMAL_STATUS = 1;
    public static final Integer INVOICE_BATCH_ABANDON_LIMIT = 500;
    public static final Integer INVOICE_BATCH_HC_LIMIT = 300;
    public static final Integer INVOICE_BATCH_REJECT_LIMIT = 1000;
    public static final Integer INVOICE_BATCH_LOCK_LIMIT = 1000;
    public static final Integer INVOICE_BATCH_UNLOCK_LIMIT = 1000;
    public static final Integer PDF_INVOICE_BATCH_EXPORT_LIMIT = 10000;
    public static final Integer INVOICE_BATCH_PRINT_LIMIT = 300;
    public static final Integer ELECTRIC_INVOICE_BATCH_PRINT_LIMIT = 50;
    public static final Integer INVOICE_BATCH_PRINT_SELL_LIST_LIMIT = 300;
    public static final Integer INVOICE_SEND_EMAIL_LIMIT = 1000;
    public static final int INVOICE_DEFAULT_REMARK_MAX_LENGTH = 168;
    public static final int INVOICE_DEFAULT_REMARK_CE_MAX_LENGTH = 130;
    public static final int INVOICE_REMARK_MAX_LENGTH = 230;
    public static final int INVOICE_REMARK_CE_MAX_LENGTH = 250;
    public static final int ALL_ELECTRIC_REMARK_MAX_LENGTH = 200;
    public static final String ABANDON_ABLE = "1";
    public static final String NOT_ABLE_ABANDON = "0";
    public static final int SEND_COOPERATION = 1;
    public static final int PDF_REQUEST_RETRY = 1;
    public static final int PDF_REQUEST_STOP = 0;
    public static final int QUERY_FAIL_PDF_REQUEST_MAX = 10000;
    public static final String SYS_CONFIG_INVOICE_LOCK = "invoiceLock";
    public static final String OPT_PROCESSING = "%s\u5904\u7406\u4e2d\u3002";
    public static final Integer MAX_ABANDON_COUNT = 500;
    public static final String ABANDON_INVOICE_PRE_FIX = "abandon_invoice";
    public static final String INV_SELLER_INVOICE = "inv_seller_invoice";
    public static final String INV_SELLER_PRE_INVOICE = "inv_seller_pre_invoice";
    public static final String INV_SELLER_ISSUE_RECORD = "inv_seller_issue_record";
    public static final String INV_SELLER_REPEAT_INVOICE = "inv_seller_repeat_invoice";
    public static final List<String> INVOICE_FIELDS = Arrays.stream(InvSellerInvoiceDocument.class.getDeclaredFields()).filter(r -> !r.isSynthetic()).map(Field::getName).collect(Collectors.toList());
    public static final List<String> PRE_INVOICE_FIELDS = Arrays.stream(PreInvoiceDocument.class.getDeclaredFields()).filter(r -> !r.isSynthetic()).map(Field::getName).collect(Collectors.toList());
    public static final List<String> ISSUE_RECORD_FIELDS = Stream.of(InvSellerIssueRecordEntity.class.getDeclaredFields()).filter(r -> !r.isSynthetic()).map(Field::getName).collect(Collectors.toList());
    public static final List<String> INVOICE_ENTITY_FIELDS = Arrays.stream(InvSellerInvoiceEntity.class.getDeclaredFields()).filter(r -> !r.isSynthetic()).map(Field::getName).collect(Collectors.toList());
    public static final List<String> SMART_MATCH_INVOICE_FIELDS = Arrays.stream(SmartMatchInvoiceResult.SmartMatchedInvoice.class.getDeclaredFields()).filter(r -> !r.isSynthetic()).map(Field::getName).collect(Collectors.toList());
    public static final List<String> REPEAT_INVOICE_FIELDS;
    public static final List<String> INVOICE_EXT_UNIQUE_FIELDS;
    public static final Lazy<Set<String>> RED_ISSUE_INVOICE_TYPE_CHECK;
    public static final Lazy<Set<String>> NORMAL_RED_CONFIRMATION_APPLY_STATUS;
    public static final String SPLIT_REDIS_LOCK_KEY = "split_result_lock_%s";
    public static final Integer RED_NOTIFICATION_SYNC_SUCCESS_STATUS;
    public static final Integer RED_NOTIFICATION_REVOKE_SUCCESS_STATUS;
    public static final int MAX_RED_NO_SYNC_NUMBER = 1500;
    public static final String drawInvAfter = "-D";
    public static final String BILL_FORBID_INVALID = "bill_forbid_invalid_%s";
    public static final String SELLER_CONFIG_SK_PAPER_CONTINUE_ISSUE_WHEN_FAIL = "skPaperContinueIssueWhenFail";
    public static final String SELLER_CONFIG_QD_SHOW_PAYEE_REVIEWER = "checkEIvoiceDisplayOthers";
    public static final String SELLER_CONFIG_QD_VOUCHER_CONTROL = "qdVoucherControl";
    public static final String SELLER_CONFIG_QD_SELLER_TITLE = "qdSellerTitle";
    public static final String SELLER_CONFIG_IS_AUTO_SELECT_ISSUER_FLAG = "isAutoSelectIssuerFlag";
    public static final String SELLER_CONFIG_QD_FORCE_BACK_CALCULATE_TAX_AMOUNT = "qdForceBackCalculateTaxAmount";
    public static final String SELLER_CONFIG_IS_AUTO_CONFIRM_FLAG = "redBillAutoConfirmFlag";
    public static final String RED_SALE_LIST_CARGO_NAME = "\u8be6\u89c1\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u53ca\u6e05\u5355";
    public static final String MINERAL_RED_SALE_LIST_CARGO_NAME = "\u8be6\u89c1\u9500\u552e\u9000\u56de\u6e05\u5355";
    public static final Lazy<Map<String, String>> OLD_TO_NEW_TAX_CODE_MAP;
    public static final Date MYSQL_TIMESTAMP_MIN_VALUE;
    public static final String RED_CONFIRMATION_REDIS_LOCK = "op_red_confirm:";
    public static final Integer SD_UNIT_PRICE_MAX_LENGTH;
    public static final Integer SD_UNIT_PRICE_MAX_SCALE;
    public static final String INVOICE_PRE_REVERSE_LOCK = "invoice_pre_reverse_lock_%s";
    public static final String PRE_INVOICE_ISSUE_LOCK = "pre_invoice_issue_lock_%s";
    public static final String VEHICLE_DEFAULT_REMARK = "\u4e00\u8f66\u4e00\u7968";
    public static final List<String> INVOICE_VEHICLE_UNIQUE_FIELDS;

    static {
        INVOICE_ENTITY_FIELDS.add("id");
        REPEAT_INVOICE_FIELDS = Stream.of(InvSellerRepeatInvoiceEntity.class.getDeclaredFields()).filter(r -> !r.isSynthetic()).map(Field::getName).collect(Collectors.toList());
        REPEAT_INVOICE_FIELDS.add("id");
        INVOICE_EXT_UNIQUE_FIELDS = Stream.of(InvSellerInvoiceExtEntity.class.getDeclaredFields()).filter(r -> !r.isSynthetic()).map(Field::getName).filter(r -> !StringUtils.equalsAny((CharSequence)"id", (CharSequence[])new CharSequence[]{"sellerTaxNo", "purchaserTaxNo", "paperDrawDate", "createTime", "updateTime", "sellerGroupId"})).collect(Collectors.toList());
        RED_ISSUE_INVOICE_TYPE_CHECK = Lazy.of(() -> {
            HashSet set = Sets.newHashSet();
            set.add(InvoiceType.SPECIAL.value());
            set.add(InvoiceType.SPECIAL_ELECTRONIC.value());
            set.add(InvoiceType.QS.value());
            set.add(InvoiceType.QC.value());
            set.add(InvoiceType.SZ.value());
            set.add(InvoiceType.CZ.value());
            set.add(InvoiceType.VZ.value());
            return set;
        });
        NORMAL_RED_CONFIRMATION_APPLY_STATUS = Lazy.of(() -> {
            HashSet set = Sets.newHashSet();
            set.add(RedConfirmationApplyStatus.WITHOUT_CONFIRM.getValue());
            set.add(RedConfirmationApplyStatus.WAIT_FOR_BUYER_CONFIRM.getValue());
            set.add(RedConfirmationApplyStatus.WAIT_FOR_BUYER_CONFIRM.getValue());
            set.add(RedConfirmationApplyStatus.CONFIRMED.getValue());
            return set;
        });
        RED_NOTIFICATION_SYNC_SUCCESS_STATUS = 2;
        RED_NOTIFICATION_REVOKE_SUCCESS_STATUS = 2;
        OLD_TO_NEW_TAX_CODE_MAP = Lazy.of(() -> {
            HashMap taxCodeMap = Maps.newHashMap();
            taxCodeMap.put("4060000000000000000", "4069900000000000000");
            return taxCodeMap;
        });
        MYSQL_TIMESTAMP_MIN_VALUE = Date.from(Instant.ofEpochMilli(1000L));
        SD_UNIT_PRICE_MAX_LENGTH = 16;
        SD_UNIT_PRICE_MAX_SCALE = 13;
        INVOICE_VEHICLE_UNIQUE_FIELDS = Stream.of(InvSellerInvoiceVehicleInfoEntity.class.getDeclaredFields()).filter(r -> !r.isSynthetic()).map(Field::getName).filter(r -> !StringUtils.equalsAny((CharSequence)"ext1", (CharSequence[])new CharSequence[]{"ext2", "sellerGroupId", "paperDrawDate"})).collect(Collectors.toList());
    }
}

