/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.constant.enums;

import com.xforceplus.seller.invoice.constant.enums.SpecialInvoiceFlagEnum;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.EnumUtils;

public enum InvoiceItemType {
    NORMAL("CPY", "\u6210\u54c1\u6cb9", SpecialInvoiceFlagEnum.OIL),
    TRANSPORT("SG", "\u6536\u8d2d\u7c7b\u53d1\u7968", SpecialInvoiceFlagEnum.DEFAULT),
    VEHICLE_SEPCIAL("JDC", "\u673a\u52a8\u8f66\u4e13\u7968", SpecialInvoiceFlagEnum.VEHICLE),
    MINERALS_SEPCIAL("KCP", "\u77ff\u4ea7\u54c1", SpecialInvoiceFlagEnum.MINERALS);

    private final String value;
    private final String description;
    private final SpecialInvoiceFlagEnum specialInvoiceFlagEnum;

    private InvoiceItemType(String value, String description, SpecialInvoiceFlagEnum specialInvoiceFlagEnum) {
        this.value = value;
        this.description = description;
        this.specialInvoiceFlagEnum = specialInvoiceFlagEnum;
    }

    public String value() {
        return this.value;
    }

    public static InvoiceItemType fromValue(String value) {
        return Stream.of(InvoiceItemType.values()).filter(t -> t.value().equals(value)).findFirst().orElse(null);
    }

    public static Optional<InvoiceItemType> getEnumFromSpecialInvoiceFlag(String specialInvoiceFlag) {
        return EnumUtils.getEnumList(InvoiceItemType.class).stream().filter(r -> r.getSpecialInvoiceFlagEnum().getValue().equals(specialInvoiceFlag)).findFirst();
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public SpecialInvoiceFlagEnum getSpecialInvoiceFlagEnum() {
        return this.specialInvoiceFlagEnum;
    }
}

