/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.constant.enums;

import com.xforceplus.seller.invoice.constant.enums.InvoiceKind;
import com.xforceplus.seller.invoice.constant.enums.TaxInvoiceSource;
import com.xforceplus.seller.invoice.constant.enums.ValueEnum;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public enum InvoiceType {
    NORMAL("c", "\u7eb8\u8d28\u53d1\u7968\uff08\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff09", InvoiceKind.NORMAL, TaxInvoiceSource.TAX_CONTROL, "PAPER"),
    SPECIAL("s", "\u7eb8\u8d28\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09", InvoiceKind.SPECIAL, TaxInvoiceSource.TAX_CONTROL, "PAPER"),
    SPECIAL_ELECTRONIC("se", "\u7535\u5b50\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09", InvoiceKind.SPECIAL_ELECTRONIC, TaxInvoiceSource.TAX_CONTROL, "PAPER"),
    VEHICLE("v", "\u673a\u52a8\u8f66\u9500\u552e\u53d1\u7968", InvoiceKind.VEHICLE, TaxInvoiceSource.TAX_CONTROL, ""),
    UNIVERSAL("t", "\u901a\u7528\u673a\u6253\u53d1\u7968", InvoiceKind.UNIVERSAL, TaxInvoiceSource.TAX_CONTROL, ""),
    ELECTRONIC("ce", "\u7535\u5b50\u53d1\u7968\uff08\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff09", InvoiceKind.ELECTRONIC, TaxInvoiceSource.TAX_CONTROL, "ELECTRONIC"),
    NORMAL_ROLL("ju", " \u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968(\u5377\u7968)", InvoiceKind.ROLL, TaxInvoiceSource.TAX_CONTROL, ""),
    ELEC_BLOCKCHAIN("ceb", "\u7535\u5b50\u666e\u901a\u53d1\u7968\uff08\u533a\u5757\u94fe\uff09", InvoiceKind.ELECTRONIC, TaxInvoiceSource.TAX_CONTROL, ""),
    QS("qs", "\u7535\u5b50\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09", InvoiceKind.SPECIAL_ELECTRONIC, TaxInvoiceSource.ALL_ELECTRIC, "PAPER"),
    QC("qc", "\u7535\u5b50\u53d1\u7968\uff08\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff09", InvoiceKind.ELECTRONIC, TaxInvoiceSource.ALL_ELECTRIC, "PAPER"),
    SZ("sz", "\u7eb8\u8d28\u53d1\u7968\uff08\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\uff09", InvoiceKind.SPECIAL, TaxInvoiceSource.ALL_ELECTRIC, "PAPER"),
    CZ("cz", "\u7eb8\u8d28\u53d1\u7968\uff08\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff09", InvoiceKind.NORMAL, TaxInvoiceSource.ALL_ELECTRIC, "PAPER"),
    VZ("vz", "\u673a\u52a8\u8f66\u9500\u552e\u53d1\u7968", InvoiceKind.VEHICLE, TaxInvoiceSource.ALL_ELECTRIC, "PAPER");

    private final String type;
    private final String desc;
    private final InvoiceKind invoiceKind;
    private final TaxInvoiceSource taxInvoiceSource;
    private final String canMakeType;

    public String value() {
        return this.type;
    }

    public static InvoiceType fromValue(String value) throws RuntimeException {
        return Stream.of(InvoiceType.values()).filter(t -> t.value().equals(value)).findFirst().orElseThrow(() -> new RuntimeException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7c7b\u578b\u7684\u7968"));
    }

    public static InvoiceType getByInvoiceKindAndTaxInvoiceSource(String invoiceKind, String taxInvoiceSource) {
        Optional<InvoiceKind> invoiceKindOptional = ValueEnum.getEnumByValue(InvoiceKind.class, invoiceKind);
        if (!invoiceKindOptional.isPresent()) {
            throw new RuntimeException("\u975e\u6cd5\u7684invoiceKind");
        }
        InvoiceKind kind = invoiceKindOptional.get();
        TaxInvoiceSource source = ValueEnum.getEnumByValue(TaxInvoiceSource.class, taxInvoiceSource).orElse(TaxInvoiceSource.TAX_CONTROL);
        return EnumUtils.getEnumList(InvoiceType.class).stream().filter(r -> kind == r.getInvoiceKind() && source == r.getTaxInvoiceSource()).findFirst().orElseThrow(() -> new RuntimeException("\u975e\u6cd5\u7684\u53d1\u7968\u7c7b\u578b"));
    }

    public TaxInvoiceSource getTaxInvoiceSource() {
        return this.taxInvoiceSource;
    }

    public static Optional<InvoiceType> getEnumByValue(String value) {
        return EnumUtils.getEnumList(InvoiceType.class).stream().filter(r -> value.equals(r.value())).findFirst();
    }

    public static Optional<InvoiceType> speculateInvoiceType(String invoiceNo, String invoiceCode) {
        if (StringUtils.isNotBlank((CharSequence)invoiceNo) && invoiceNo.length() == 8 && StringUtils.isNotBlank((CharSequence)invoiceCode)) {
            if (invoiceCode.length() == 10) {
                if (invoiceCode.charAt(7) == '1' && invoiceCode.charAt(7) == '5') {
                    return Optional.of(SPECIAL);
                }
                if (invoiceCode.charAt(7) == '3' && invoiceCode.charAt(7) == '6') {
                    return Optional.of(NORMAL);
                }
            } else if (invoiceCode.length() == 12 && invoiceCode.charAt(0) == '1' && invoiceCode.substring(10).equals("11")) {
                return Optional.of(ELECTRONIC);
            }
        }
        return Optional.empty();
    }

    public static boolean isAllElectric(String invoiceType) {
        return StringUtils.equalsAny((CharSequence)invoiceType, (CharSequence[])new CharSequence[]{QC.value(), QS.value(), CZ.value(), SZ.value(), VZ.value()});
    }

    public static InvoiceType getAllElectricByTaxControl(String invoiceType) {
        Optional<InvoiceType> optional = InvoiceType.getEnumByValue(invoiceType);
        if (!optional.isPresent()) {
            throw new RuntimeException("\u975e\u6cd5\u7684invoiceType");
        }
        if (StringUtils.equalsAny((CharSequence)invoiceType, (CharSequence[])new CharSequence[]{NORMAL.value(), ELECTRONIC.value()})) {
            return QC;
        }
        if (StringUtils.equalsAny((CharSequence)invoiceType, (CharSequence[])new CharSequence[]{SPECIAL.value(), SPECIAL_ELECTRONIC.value()})) {
            return QS;
        }
        if (StringUtils.equals((CharSequence)invoiceType, (CharSequence)VEHICLE.value())) {
            return VZ;
        }
        return optional.get();
    }

    public static boolean isNormal(String invoiceType) {
        return StringUtils.equalsAny((CharSequence)invoiceType, (CharSequence[])new CharSequence[]{NORMAL.value(), ELECTRONIC.value(), QC.value(), CZ.value()});
    }

    public static boolean isSpecial(String invoiceType) {
        return StringUtils.equalsAny((CharSequence)invoiceType, (CharSequence[])new CharSequence[]{SPECIAL.value(), SPECIAL_ELECTRONIC.value(), QS.value(), SZ.value()});
    }

    public static boolean isElectric(String invoiceType) {
        return StringUtils.equalsAny((CharSequence)invoiceType, (CharSequence[])new CharSequence[]{ELECTRONIC.value(), SPECIAL_ELECTRONIC.value(), QS.value(), QC.value()});
    }

    public static boolean isTaxControl(String invoiceType) {
        return EnumUtils.getEnumList(InvoiceType.class).stream().anyMatch(r -> r.value().equals(invoiceType) && TaxInvoiceSource.TAX_CONTROL == r.getTaxInvoiceSource());
    }

    public static boolean isVehicle(String invoiceType) {
        return StringUtils.equalsAny((CharSequence)invoiceType, (CharSequence[])new CharSequence[]{VEHICLE.value(), VZ.value()});
    }

    public static boolean isAllElectricPaper(String invoiceType) {
        return StringUtils.equalsAny((CharSequence)invoiceType, (CharSequence[])new CharSequence[]{CZ.value(), SZ.value(), VZ.value()});
    }

    private InvoiceType(String type, String desc, InvoiceKind invoiceKind, TaxInvoiceSource taxInvoiceSource, String canMakeType) {
        this.type = type;
        this.desc = desc;
        this.invoiceKind = invoiceKind;
        this.taxInvoiceSource = taxInvoiceSource;
        this.canMakeType = canMakeType;
    }

    public String getDesc() {
        return this.desc;
    }

    public InvoiceKind getInvoiceKind() {
        return this.invoiceKind;
    }

    public String getCanMakeType() {
        return this.canMakeType;
    }
}

