/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.constant.enums;

import com.xforceplus.seller.invoice.constant.enums.ValueEnum;
import java.util.Optional;
import org.apache.commons.lang3.EnumUtils;

public enum IssueMode implements ValueEnum<Integer>
{
    ISSUE(1, "issue", "\u5f00\u5177"),
    ISSUE_PRINT(2, "issue_print", "\u5f00\u5177\u5e76\u6253\u5370"),
    RED_ISSUE_PRINT(3, "red_issue_print", "\u7ea2\u51b2\u5e76\u6253\u5370");

    private final Integer value;
    private final String mode;
    private final String description;

    public static Optional<IssueMode> getEnumByMode(String mode) {
        return mode == null ? Optional.empty() : EnumUtils.getEnumList(IssueMode.class).stream().filter(c -> mode.equals(c.getMode())).findFirst();
    }

    private IssueMode(Integer value, String mode, String description) {
        this.value = value;
        this.mode = mode;
        this.description = description;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public String getMode() {
        return this.mode;
    }

    public String getDescription() {
        return this.description;
    }
}

