/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.constant.enums;

import com.xforceplus.seller.invoice.constant.enums.ValueEnum;
import java.util.Optional;
import org.apache.commons.lang3.EnumUtils;

public enum IssueRecordStatus implements ValueEnum<String>
{
    ISSUING("issuing", 1, "\u5f00\u7968\u4e2d"),
    ALL_SUCCEEDED("all_succeeded", 2, "\u5168\u90e8\u6210\u529f"),
    PART_FAILED("part_failed", 3, "\u90e8\u5206\u5931\u8d25"),
    ALL_FAILED("all_failed", 4, "\u5168\u90e8\u5931\u8d25");

    private final String value;
    private final Integer type;
    private final String description;

    public static Optional<IssueRecordStatus> getEnumByType(Integer type) {
        return type == null ? Optional.empty() : EnumUtils.getEnumList(IssueRecordStatus.class).stream().filter(r -> type.equals(r.getType())).findFirst();
    }

    private IssueRecordStatus(String value, Integer type, String description) {
        this.value = value;
        this.type = type;
        this.description = description;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }
}

