/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.constant.enums;

import com.xforceplus.seller.invoice.constant.enums.ValueEnum;
import com.xforceplus.seller.invoice.models.ultraman.ConstructionServices;
import com.xforceplus.seller.invoice.models.ultraman.Freightage;
import com.xforceplus.seller.invoice.models.ultraman.RealEstateSales;
import com.xforceplus.seller.invoice.models.ultraman.RealLeasehold;
import java.util.Optional;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public enum SpecialInvoiceFlagEnum implements ValueEnum<String>
{
    NONE("", ""),
    DEFAULT("0", ""),
    TOLL("1", "\u901a\u884c\u8d39"),
    OIL("2", "\u6210\u54c1\u6cb9"),
    CHAIN("3", "\u533a\u5757\u94fe\u53d1\u7968"),
    VEHICLE("4", "\u673a\u52a8\u8f66\u4e13\u7968"),
    BUILDING("5", "\u5efa\u7b51\u670d\u52a1"),
    CARGO_TRANSPORT("6", "\u8d27\u7269\u8fd0\u8f93\u670d\u52a1"),
    PROPERTY_SALE("7", "\u4e0d\u52a8\u4ea7\u9500\u552e"),
    PROPERTY_RENT("8", "\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u8d41\u670d\u52a1"),
    MINERALS("9", "\u77ff\u4ea7\u54c1"),
    PRODUCT_SALE("10", "\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e");

    private final String value;
    private final String description;

    public static boolean needQuerySpecialInfo(String specialInvoiceFlag) {
        return StringUtils.equals((CharSequence)BUILDING.getValue(), (CharSequence)specialInvoiceFlag) || StringUtils.equals((CharSequence)CARGO_TRANSPORT.getValue(), (CharSequence)specialInvoiceFlag) || StringUtils.equals((CharSequence)PROPERTY_SALE.getValue(), (CharSequence)specialInvoiceFlag) || StringUtils.equals((CharSequence)PROPERTY_RENT.getValue(), (CharSequence)specialInvoiceFlag);
    }

    public static Optional<SpecialInvoiceFlagEnum> getEnumByValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Optional.empty();
        }
        return EnumUtils.getEnumList(SpecialInvoiceFlagEnum.class).stream().filter(r -> StringUtils.equals((CharSequence)r.getValue(), (CharSequence)value)).findFirst();
    }

    public static Class getSpecialInvoiceClassByFlag(String flag) {
        if (SpecialInvoiceFlagEnum.BUILDING.value.equals(flag)) {
            return ConstructionServices.class;
        }
        if (SpecialInvoiceFlagEnum.CARGO_TRANSPORT.value.equals(flag)) {
            return Freightage.class;
        }
        if (SpecialInvoiceFlagEnum.PROPERTY_SALE.value.equals(flag)) {
            return RealEstateSales.class;
        }
        return SpecialInvoiceFlagEnum.PROPERTY_RENT.value.equals(flag) ? RealLeasehold.class : null;
    }

    private SpecialInvoiceFlagEnum(String value, String description) {
        this.value = value;
        this.description = description;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }
}

