/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.constant.enums;

import com.xforceplus.seller.invoice.constant.enums.MakeTypeEnum;
import com.xforceplus.seller.invoice.constant.enums.ValueEnum;
import org.apache.commons.lang3.StringUtils;

public enum SplitType implements ValueEnum<Integer>
{
    MANUAL(0, "\u624b\u52a8\u62c6\u7968", ""),
    AUTO(1, "\u81ea\u52a8\u62c6\u7968", "1"),
    VIR_AUTO(2, "job\u865a\u62df\u5f00\u7968\u81ea\u52a8\u62c6\u7968\u3001\u81ea\u52a8\u5f00\u7968", ""),
    AUTO_SPLIT(3, "\u4e0a\u4f20\u5355\u636e\u81ea\u52a8\u62c6\u7968", ""),
    AUTO_ISSUE(4, "\u4e0a\u4f20\u5355\u636e\u81ea\u52a8\u62c6\u5e76\u81ea\u52a8\u5f00\u7968", "2"),
    RENEW(5, "\u4fee\u6539\u62c6\u7968\u89c4\u5219\u91cd\u62c6", ""),
    AUTO_PRINT(7, "\u4e0a\u4f20\u5355\u636e\u81ea\u52a8\u62c6\u5e76\u81ea\u52a8\u5f00\u7968\u6253\u5370\uff0c\u53ea\u9002\u7528\u5355\u76d8", "3"),
    AUTO_APPLY_RED_LETTER(8, "\u81ea\u52a8\u62c6\u7968\u65e0\u9884\u89c8\u5e76\u81ea\u52a8\u7533\u8bf7\u7ea2\u5b57\u786e\u8ba4\u5355", "");

    private final Integer value;
    private final String description;
    private final String mode;

    public static int autoType(SplitType type) {
        switch (type) {
            case AUTO: 
            case AUTO_ISSUE: 
            case VIR_AUTO: 
            case AUTO_PRINT: {
                return MakeTypeEnum.AUTO.getValue();
            }
        }
        return MakeTypeEnum.NOAUTO.getValue();
    }

    public static SplitType splitTypeByMode(String mode) {
        if (StringUtils.equals((CharSequence)SplitType.AUTO_ISSUE.mode, (CharSequence)mode)) {
            return AUTO_ISSUE;
        }
        if (StringUtils.equals((CharSequence)SplitType.AUTO_PRINT.mode, (CharSequence)mode)) {
            return AUTO_PRINT;
        }
        return null;
    }

    private SplitType(Integer value, String description, String mode) {
        this.value = value;
        this.description = description;
        this.mode = mode;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMode() {
        return this.mode;
    }
}

