/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.constant.enums;

import com.xforceplus.seller.invoice.constant.enums.SpecialInvoiceFlagEnum;
import com.xforceplus.seller.invoice.constant.enums.ValueEnum;
import java.util.Optional;
import org.apache.commons.lang3.EnumUtils;

public enum TaxWareInvoiceStyleType implements ValueEnum<String>
{
    OIL("01", "\u6210\u54c1\u6cb9", SpecialInvoiceFlagEnum.OIL),
    BUILDING("03", "\u5efa\u7b51\u670d\u52a1", SpecialInvoiceFlagEnum.BUILDING),
    CARGO_TRANSPORT("04", "\u8d27\u7269\u8fd0\u8f93\u670d\u52a1", SpecialInvoiceFlagEnum.CARGO_TRANSPORT),
    PROPERTY_SALE("05", "\u4e0d\u52a8\u4ea7\u9500\u552e", SpecialInvoiceFlagEnum.PROPERTY_SALE),
    PROPERTY_RENT("06", "\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u8d41\u670d\u52a1", SpecialInvoiceFlagEnum.PROPERTY_RENT),
    PRODUCT_SALE("12", "\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e", SpecialInvoiceFlagEnum.PRODUCT_SALE),
    VEHICLE("14", "\u673a\u52a8\u8f66\u4e13\u7968", SpecialInvoiceFlagEnum.VEHICLE);

    private final String value;
    private final String description;
    private final SpecialInvoiceFlagEnum specialInvoiceFlag;

    public static Optional<String> getValueBySpecialInvoiceFlagValue(String specialInvoiceFlagValue) {
        return EnumUtils.getEnumList(TaxWareInvoiceStyleType.class).stream().filter(r -> r.getSpecialInvoiceFlag().getValue().equals(specialInvoiceFlagValue)).map(TaxWareInvoiceStyleType::getValue).findFirst();
    }

    public static Boolean isSpecialInvoice(String specialInvoiceFlagValue) {
        Optional<String> invoiceStyleTypeOption = TaxWareInvoiceStyleType.getValueBySpecialInvoiceFlagValue(specialInvoiceFlagValue);
        if (invoiceStyleTypeOption.isPresent()) {
            return true;
        }
        return false;
    }

    private TaxWareInvoiceStyleType(String value, String description, SpecialInvoiceFlagEnum specialInvoiceFlag) {
        this.value = value;
        this.description = description;
        this.specialInvoiceFlag = specialInvoiceFlag;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public SpecialInvoiceFlagEnum getSpecialInvoiceFlag() {
        return this.specialInvoiceFlag;
    }
}

