/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.constant.enums;

import com.xforceplus.seller.invoice.constant.enums.ValueEnum;
import java.util.Optional;
import org.apache.commons.lang3.EnumUtils;

public enum VehicleCredentialType implements ValueEnum<Integer>
{
    TAX_NO_OR_ID(0, "\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7/\u8eab\u4efd\u8bc1\u53f7\u7801", "01"),
    OTHER(1, "\u5176\u4ed6\u8bc1\u4ef6\u53f7\u7801", "02");

    private final Integer value;
    private final String description;
    private final String taxWareValue;

    public static Optional<VehicleCredentialType> getEnumByTaxWareValue(String taxWareValue) {
        return EnumUtils.getEnumList(VehicleCredentialType.class).stream().filter(r -> r.getTaxWareValue().equals(taxWareValue)).findFirst();
    }

    private VehicleCredentialType(Integer value, String description, String taxWareValue) {
        this.value = value;
        this.description = description;
        this.taxWareValue = taxWareValue;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTaxWareValue() {
        return this.taxWareValue;
    }
}

