/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.models;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class SplitRequestDelay
implements Delayed {
    private long time;
    private Long batchNo;

    public SplitRequestDelay(Long batchNo, long time, TimeUnit unit) {
        this.batchNo = batchNo;
        this.time = System.currentTimeMillis() + (time > 0L ? unit.toMillis(time) : 0L);
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Long getBatchNo() {
        return this.batchNo;
    }

    public void setBatchNo(Long batchNo) {
        this.batchNo = batchNo;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.time - System.currentTimeMillis();
    }

    @Override
    public int compareTo(Delayed o) {
        SplitRequestDelay item = (SplitRequestDelay)o;
        long diff = this.time - item.time;
        if (diff <= 0L) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return "SplitRequestDelay{time=" + this.time + ", batchNo=" + this.batchNo + '}';
    }
}

