/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.common.util;

import com.google.common.collect.Maps;
import com.xforceplus.seller.invoice.dto.LoginRequest;
import com.xforceplus.seller.invoice.dto.LoginResponse;
import com.xforceplus.xplatframework.utils.JsonUtils;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateTools {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplateTools.class);
    @Autowired
    private RestTemplate restTemplate;
    private final RestTemplate redditFeignRestTemplate;
    @Value(value="${invoice.makeout.client.clientId:tg_ge-sit}")
    private String clientId;
    @Value(value="${invoice.makeout.client.secret:mnbvcxcvjyt}")
    private String secret;
    @Value(value="${invoice.makeout.login.url:http://paas-s.xforceplus.com/api/client/login}")
    private String loginUrl;

    public RestTemplateTools() {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setConnectTimeout(2000);
        requestFactory.setReadTimeout(180000);
        requestFactory.setBufferRequestBody(false);
        this.redditFeignRestTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        List list = this.redditFeignRestTemplate.getMessageConverters();
        for (HttpMessageConverter httpMessageConverter : list) {
            if (!(httpMessageConverter instanceof StringHttpMessageConverter)) continue;
            ((StringHttpMessageConverter)httpMessageConverter).setDefaultCharset(Charset.forName("UTF8"));
            break;
        }
    }

    public String getAcessToken() {
        LoginRequest loginRequest = new LoginRequest(this.clientId, this.secret);
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.add("Content-Type", "application/json");
        HttpEntity requestEntity = new HttpEntity((Object)loginRequest, (MultiValueMap)requestHeaders);
        ResponseEntity response = this.restTemplate.postForEntity(this.loginUrl, (Object)requestEntity, LoginResponse.class, new Object[0]);
        logger.info("\u83b7\u53d6token\u7ed3\u679c {}", (Object)JsonUtils.writeObjectToFastJson((Object)response));
        if (null == response || null == response.getBody()) {
            throw new RuntimeException("\u5f53\u524d\u83b7\u53d6token\u51fa\u73b0\u5f02\u5e38");
        }
        LoginResponse body = (LoginResponse)response.getBody();
        if (body.getCode() == 1) {
            return body.getData();
        }
        throw new RuntimeException("\u83b7\u53d6token\u51fa\u73b0\u5f02\u5e38");
    }

    public Map<String, String> getHeader() {
        String token = this.getAcessToken();
        logger.info("\u83b7\u53d6token\u5f00\u59cb");
        HashMap headers = Maps.newHashMap();
        headers.put("Content-Type", "application/json");
        headers.put("x-app-token", token);
        return headers;
    }
}

