/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.service;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multiset;
import com.xforceplus.seller.invoice.client.model.PreInvoiceDetail;
import com.xforceplus.seller.invoice.client.model.PreInvoicePolling;
import com.xforceplus.seller.invoice.service.SellerPreInvoiceConvertService;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SellerPreInvoiceConvertService {
    private static final String TAX_RATE_FIELD_NAME = "taxRate";
    private static final String TAX_AMOUNT_FIELD_NAME = "taxAmount";
    private static final String SALE_LIST_FILE_FLAG_FIELD_NAME = "saleListFileFlag";
    private static final String TAX_PRE_FIELD_NAME = "taxPre";
    private static final String TAX_PRE_CON_FIELD_NAME = "taxPreCon";
    private static final String ZERO_TAX_FIELD_NAME = "zeroTax";
    private static final String GOODS_TAX_NO_FIELD_NAME = "goodsTaxNo";
    private static final String DEDUCTION_FIELD_NAME = "deduction";
    private static final String TAX_RATE_STR_FIELD_NAME = "taxRateStr";
    private static final String TAX_AMOUNT_STR_FIELD_NAME = "taxAmountStr";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final List<String> SPECIAL_TAX_NO = ImmutableList.of((Object)"6010000000000000000", (Object)"6020000000000000000", (Object)"6030000000000000000", (Object)"6040000000000000000", (Object)"6050000000000000000", (Object)"6060000000000000000", (Object)"6070000000000000000", (Object)"6080000000000000000", (Object)"6090000000000000000", (Object)"6100000000000000000", (Object)"6110000000000000000", (Object)"6120000000000000000", (Object[])new String[0]);
    @Deprecated
    public static final String[] SPECIAL_TAX_RATES = new String[]{"6010000000000000000", "6020000000000000000", "6030000000000000000", "6040000000000000000", "6050000000000000000", "6060000000000000000", "6070000000000000000", "6080000000000000000", "6090000000000000000", "6100000000000000000", "6110000000000000000", "6120000000000000000"};

    public void setTaxRateAndTaxAmountStr(Object preInvoiceObj, List<?> preInvoiceItems) {
        String taxAmountStr;
        if (preInvoiceObj == null || CollectionUtils.isEmpty(preInvoiceItems)) {
            throw new IllegalArgumentException("preInvoiceObj or preInvoiceItems must be not null");
        }
        HashMultiset taxTypeCount = HashMultiset.create();
        BigDecimal firstTaxRate = (BigDecimal)this.getValue(preInvoiceItems.get(0), TAX_RATE_FIELD_NAME, BigDecimal.class);
        boolean taxRateSame = true;
        for (Object preInvoiceItem : preInvoiceItems) {
            taxTypeCount.add((Object)this.setPreInvoiceItemTaxRateAndTaxAmountStr(preInvoiceItem));
            if (!taxRateSame) continue;
            BigDecimal taxRate = (BigDecimal)this.getValue(preInvoiceItem, TAX_RATE_FIELD_NAME, BigDecimal.class);
            taxRateSame = Objects.compare(firstTaxRate, taxRate, BigDecimal::compareTo) == 0;
        }
        this.logger.info("\u7edf\u8ba1\u540e\u660e\u7ec6\u6761\u6570\u4e3a\uff1a{}\uff0c\u666e\u901a\u7a0e\u7387\u6570\u4e3a\uff1a{}\uff0c\u4e0d\u5f81\u7a0e\u6570\u4e3a\uff1a{}\uff0c\u514d\u7a0e\u6570\u4e3a\uff1a{}\uff0c\u5dee\u989d\u5f81\u7a0e\u6570\u4e3a\uff1a{}\uff0c\u96f6\u7a0e\u6570\u4e3a{}", new Object[]{preInvoiceItems.size(), taxTypeCount.count((Object)TaxType.NORMAL_TAX), taxTypeCount.count((Object)TaxType.NOT_TAX), taxTypeCount.count((Object)TaxType.FREE_TAX), taxTypeCount.count((Object)TaxType.MUCH_TAX), taxTypeCount.count((Object)ZERO_TAX_FIELD_NAME)});
        String taxRateStr = "";
        BigDecimal taxAmount = (BigDecimal)this.getValue(preInvoiceObj, TAX_AMOUNT_FIELD_NAME, BigDecimal.class);
        String string = taxAmountStr = taxAmount == null ? null : taxAmount.setScale(2, 4).toString();
        if (this.allFreeTax((Multiset)taxTypeCount, preInvoiceItems)) {
            taxRateStr = "\u514d\u7a0e";
            taxAmountStr = "***";
        } else if (this.allFreeAndNotTax((Multiset)taxTypeCount, preInvoiceItems)) {
            taxRateStr = "0%";
            taxAmountStr = "***";
        } else if (this.hasNormalAndFreeOrNotTax((Multiset)taxTypeCount)) {
            taxAmountStr = taxAmount == null ? null : taxAmount.setScale(2, 4).toString();
        } else if (this.hasMuchTax((Multiset)taxTypeCount)) {
            taxRateStr = "***";
        } else if (taxRateSame) {
            taxRateStr = firstTaxRate == null ? null : firstTaxRate.toString();
        }
        this.setValue(preInvoiceObj, TAX_RATE_STR_FIELD_NAME, (Object)taxRateStr);
        this.setValue(preInvoiceObj, TAX_AMOUNT_STR_FIELD_NAME, (Object)taxAmountStr);
    }

    private TaxType setPreInvoiceItemTaxRateAndTaxAmountStr(Object preInvoiceItem) {
        String taxPre = (String)this.getValue(preInvoiceItem, TAX_PRE_FIELD_NAME, String.class);
        String taxPreCon = (String)this.getValue(preInvoiceItem, TAX_PRE_CON_FIELD_NAME, String.class);
        String zeroTax = (String)this.getValue(preInvoiceItem, ZERO_TAX_FIELD_NAME, String.class);
        String goodsTaxNo = (String)this.getValue(preInvoiceItem, GOODS_TAX_NO_FIELD_NAME, String.class);
        BigDecimal taxRate = (BigDecimal)this.getValue(preInvoiceItem, TAX_RATE_FIELD_NAME, BigDecimal.class);
        BigDecimal taxAmount = (BigDecimal)this.getValue(preInvoiceItem, TAX_AMOUNT_FIELD_NAME, BigDecimal.class);
        BigDecimal deduction = (BigDecimal)this.getValue(preInvoiceItem, DEDUCTION_FIELD_NAME, BigDecimal.class);
        this.logger.info("taxPre = {}, taxPreCon = {}, zeroTax = {}, goodsTaxNo = {}, taxRate ={}, taxAmount = {}, deduction = {}", new Object[]{taxPre, taxPreCon, zeroTax, goodsTaxNo, taxRate, taxAmount, deduction});
        String taxRateStr = taxRate == null ? "" : String.format("%d", taxRate.multiply(BigDecimal.valueOf(100L)).intValue()) + "%";
        String taxAmountStr = taxAmount == null ? "" : taxAmount.setScale(2, 4).toString();
        TaxType taxType = TaxType.NORMAL_TAX;
        if (this.normalTax(taxPre, zeroTax)) {
            taxRateStr = "0%";
            taxType = TaxType.NORMAL_TAX;
        } else if (this.notTax(taxPre, taxPreCon, zeroTax, goodsTaxNo)) {
            taxRateStr = "\u4e0d\u5f81\u7a0e";
            taxAmountStr = "***";
            taxType = TaxType.NOT_TAX;
        } else if (this.freeTax(taxPre, taxPreCon, zeroTax)) {
            taxRateStr = "\u514d\u7a0e";
            taxAmountStr = "***";
            taxType = TaxType.FREE_TAX;
        } else if (this.muchTax(deduction)) {
            taxRateStr = "***";
            taxType = TaxType.MUCH_TAX;
        }
        this.setValue(preInvoiceItem, TAX_RATE_STR_FIELD_NAME, (Object)taxRateStr);
        this.setValue(preInvoiceItem, TAX_AMOUNT_STR_FIELD_NAME, (Object)taxAmountStr);
        return taxType;
    }

    private boolean freeTax(String taxPre, String taxPreCon, String zeroTax) {
        return "1".equals(taxPre) && "1".equals(zeroTax) && "\u514d\u7a0e".equals(taxPreCon);
    }

    private boolean muchTax(BigDecimal deduction) {
        return deduction != null && deduction.compareTo(BigDecimal.ZERO) > 0;
    }

    private boolean notTax(String taxPre, String taxPreCon, String zeroTax, String goodsTaxNo) {
        return "1".equals(taxPre) && "2".equals(zeroTax) && "\u4e0d\u5f81\u7a0e".equals(taxPreCon) || SPECIAL_TAX_NO.contains(goodsTaxNo);
    }

    private boolean normalTax(String taxPre, String zeroTax) {
        return "0".equals(taxPre) && "3".equals(zeroTax);
    }

    private boolean hasMuchTax(Multiset<TaxType> taxTypeCount) {
        return taxTypeCount.count((Object)TaxType.MUCH_TAX) > 0;
    }

    private boolean hasNormalAndFreeOrNotTax(Multiset<TaxType> taxTypeCount) {
        return taxTypeCount.count((Object)TaxType.NORMAL_TAX) > 0 && (taxTypeCount.count((Object)TaxType.FREE_TAX) > 0 || taxTypeCount.count((Object)TaxType.NOT_TAX) > 0);
    }

    private boolean allFreeAndNotTax(Multiset<TaxType> taxTypeCount, List<?> preInvoiceItems) {
        return taxTypeCount.count((Object)TaxType.FREE_TAX) + taxTypeCount.count((Object)TaxType.NOT_TAX) == preInvoiceItems.size();
    }

    private boolean allFreeTax(Multiset<TaxType> taxTypeCount, List<?> preInvoiceItems) {
        return preInvoiceItems.size() == taxTypeCount.count((Object)TaxType.FREE_TAX);
    }

    private <T> T getValue(Object preInvoiceItem, String fieldName, Class<T> clazz) {
        Object value;
        try {
            Object result = PropertyUtils.getProperty((Object)preInvoiceItem, (String)fieldName);
            if (result == null) {
                return null;
            }
            if (!clazz.isAssignableFrom(result.getClass())) {
                throw new IllegalArgumentException(String.format("get value from Object class = [%s] fail!", preInvoiceItem.getClass().getName()));
            }
            value = result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchElementException(String.format("Object class = [%s] not field = [%s]", preInvoiceItem.getClass().getName(), fieldName));
        }
        return (T)value;
    }

    private void setValue(Object preInvoiceItem, String fieldName, Object value) {
        try {
            PropertyUtils.setProperty((Object)preInvoiceItem, (String)fieldName, (Object)value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchElementException(String.format("Object class = [%s] not field = [%s]", preInvoiceItem.getClass().getName(), fieldName));
        }
    }

    @Deprecated
    public void convertTaxRateAndTaxAmount(PreInvoicePolling polling, List<PreInvoiceDetail> details) {
        int not_tax = 0;
        int free_tax = 0;
        int normal_tax = 0;
        int much_tax = 0;
        boolean hasSameTaxRate = true;
        String defaultTaxRate = details.get(0).getTaxRate().toString();
        ArrayList<String> specialTaxList = new ArrayList<String>(Arrays.asList(SPECIAL_TAX_RATES));
        for (PreInvoiceDetail detail : details) {
            BigDecimal taxRate = detail.getTaxRate();
            String taxRateStr = "";
            String taxAmountStr = "";
            String taxPre = detail.getTaxPre();
            String taxPreCon = detail.getTaxPreCon();
            String zeroTax = detail.getZeroTax();
            if (hasSameTaxRate) {
                boolean bl = hasSameTaxRate = StringUtils.equals((CharSequence)taxRate.toString(), (CharSequence)defaultTaxRate);
            }
            if (null != taxRate) {
                taxRateStr = taxRate.toString();
                taxAmountStr = detail.getTaxAmount().toString();
            }
            if ("0".equals(taxPre) && "3".equals(zeroTax)) {
                taxRateStr = "0";
                ++normal_tax;
            } else if ("1".equals(taxPre) && "2".equals(zeroTax) && "\u4e0d\u5f81\u7a0e".equals(taxPreCon) || StringUtils.isNotBlank((CharSequence)detail.getGoodsTaxNo()) && specialTaxList.contains(detail.getGoodsTaxNo())) {
                taxRateStr = "\u4e0d\u5f81\u7a0e";
                taxAmountStr = "***";
                ++not_tax;
            } else if ("1".equals(taxPre) && "1".equals(zeroTax) && "\u514d\u7a0e".equals(taxPreCon)) {
                taxRateStr = "\u514d\u7a0e";
                taxAmountStr = "***";
                ++free_tax;
            } else if (null != detail.getDeduction() && detail.getDeduction().compareTo(BigDecimal.ZERO) > 0) {
                taxRateStr = "***";
                ++much_tax;
            } else {
                ++normal_tax;
            }
            detail.setTaxRateStr(taxRateStr);
            detail.setTaxAmountStr(taxAmountStr);
        }
        this.logger.info("\u7edf\u8ba1\u540e\u660e\u7ec6\u6761\u6570\u4e3a\uff1a{}\uff0c\u666e\u901a\u7a0e\u7387\u6570\u4e3a\uff1a{}\uff0c\u4e0d\u5f81\u7a0e\u6570\u4e3a\uff1a{}\uff0c\u514d\u7a0e\u6570\u4e3a\uff1a{}\uff0c\u5dee\u989d\u5f81\u7a0e\u6570\u4e3a\uff1a{}", new Object[]{org.apache.commons.collections.CollectionUtils.size(details), normal_tax, not_tax, free_tax, much_tax});
        if (null != polling.getSaleListFileFlag() && polling.getSaleListFileFlag() == 1) {
            if (details.size() == free_tax) {
                polling.setTaxRateStr("\u514d\u7a0e");
                polling.setTaxAmountStr("***");
            } else if (details.size() == free_tax + not_tax && normal_tax == 0) {
                polling.setTaxRateStr("0");
                polling.setTaxAmountStr("***");
            } else if (normal_tax > 0 && (free_tax > 0 || not_tax > 0)) {
                polling.setTaxRateStr("");
                polling.setTaxAmountStr(polling.getTaxAmount().toString());
            } else if (much_tax > 0) {
                polling.setTaxRateStr("***");
                polling.setTaxAmountStr(polling.getTaxAmount().toString());
            } else {
                if (hasSameTaxRate) {
                    polling.setTaxRateStr(defaultTaxRate);
                } else {
                    polling.setTaxRateStr("");
                }
                polling.setTaxAmountStr(polling.getTaxAmount().toString());
            }
        }
    }
}

