/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.service.maintenace.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.maintenance.model.FiltersConditionRequest;
import com.xforceplus.maintenance.model.RequestField;
import com.xforceplus.phoenix.generator.IDGenerator;
import com.xforceplus.seller.invoice.client.model.MakeOutFailInfo;
import com.xforceplus.seller.invoice.client.model.QueryMakeOutFailResponse;
import com.xforceplus.seller.invoice.repository.dao.InvSellerMakeOutRequestDao;
import com.xforceplus.seller.invoice.repository.dao.InvSellerPreBillDetailDao;
import com.xforceplus.seller.invoice.repository.dao.InvSellerPreInvoiceDao;
import com.xforceplus.seller.invoice.repository.daoext.InvAutoMakeOutExtDao;
import com.xforceplus.seller.invoice.repository.model.InvSellerMakeOutRequestEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerMakeOutRequestExample;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreBillDetailEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreBillDetailExample;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceExample;
import com.xforceplus.seller.invoice.service.maintenace.AutoMakeOutFailService;
import com.xforceplus.seller.invoice.service.split.AutoInvoiceService;
import com.xforceplus.xplatframework.common.util.BeanUtils;
import com.xforceplus.xplatframework.model.Response;
import com.xforceplus.xplatframework.utils.JsonUtils;
import com.xforceplus.xplatframework.utils.date.DateUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AutoMakeOutFailServiceImpl
implements AutoMakeOutFailService {
    private static final Logger logger = LoggerFactory.getLogger(AutoMakeOutFailServiceImpl.class);
    @Autowired
    private InvSellerPreInvoiceDao preInvoiceDao;
    @Autowired
    private InvAutoMakeOutExtDao makeOutExtDao;
    @Autowired
    private InvSellerPreBillDetailDao preBillDetailDao;
    @Autowired
    private InvSellerMakeOutRequestDao makeOutRequestDao;
    @Autowired
    private AutoInvoiceService autoInvoiceService;
    @Autowired
    private IDGenerator idGenerator;

    public Response resendMakeOutRequest(List<Long> requestIdList) {
        logger.info("\u91cd\u65b0\u5f00\u5177\u53c2\u6570:{}", requestIdList);
        if (CollectionUtils.isEmpty(requestIdList)) {
            return Response.failed((String)"\u8bf7\u9009\u62e9\u9700\u8981\u91cd\u65b0\u5f00\u5177\u7684\u9884\u5236\u53d1\u7968");
        }
        InvSellerMakeOutRequestExample example = new InvSellerMakeOutRequestExample();
        example.createCriteria().andIdIn(requestIdList);
        List entityList = this.makeOutRequestDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Response.failed((String)"\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        Map<String, List<InvSellerMakeOutRequestEntity>> map = entityList.stream().collect(Collectors.groupingBy(InvSellerMakeOutRequestEntity::getTerminalCode));
        map.forEach((terminalCode, requestList) -> {
            List preInvoiceIdList = requestList.stream().map(InvSellerMakeOutRequestEntity::getPreInvoiceId).collect(Collectors.toList());
            this.autoInvoiceService.autoInvoice(terminalCode, preInvoiceIdList, Long.valueOf(this.idGenerator.nextId()));
        });
        return Response.ok((String)"\u91cd\u65b0\u53d1\u8d77\u6210\u529f");
    }

    public QueryMakeOutFailResponse queryFailList(FiltersConditionRequest request) {
        logger.info("\u67e5\u8be2\u8bf7\u6c42:{}", (Object)JsonUtils.writeObjectToJson((Object)request));
        QueryMakeOutFailResponse response = new QueryMakeOutFailResponse();
        if (request == null || CollectionUtils.isEmpty((Collection)request.getFilters())) {
            return response.fail("\u8bf7\u8f93\u5165\u67e5\u8be2\u6761\u4ef6");
        }
        HashMap map = Maps.newHashMap();
        boolean hasGroup = false;
        ArrayList preInvoiceIdList = Lists.newArrayList();
        for (RequestField filter : request.getFilters()) {
            if ("sellerGroupId".equals(filter.getFieldName())) {
                hasGroup = true;
            }
            if ("createTime".equals(filter.getFieldName())) {
                map.put("startTime", filter.getValue().get(0));
                map.put("endTime", filter.getValue().get(1));
                continue;
            }
            if ("salesbillNo".equalsIgnoreCase(filter.getFieldName())) {
                List tmpList = this.queryPreInvoiceIdBySalesBillNo((String)filter.getValue().get(0));
                if (CollectionUtils.isEmpty((Collection)preInvoiceIdList)) {
                    return response.ok((List)Lists.newArrayList(), 0, "\u672a\u67e5\u8be2\u5230\u6570\u636e");
                }
                preInvoiceIdList.addAll(tmpList);
                continue;
            }
            if ("preInvoiceId".equalsIgnoreCase(filter.getFieldName())) {
                preInvoiceIdList.add(Long.valueOf((String)filter.getValue().get(0)));
                continue;
            }
            map.put(filter.getFieldName(), filter.getValue().get(0));
        }
        if (!CollectionUtils.isEmpty((Collection)preInvoiceIdList)) {
            map.put("preInvoiceIdList", preInvoiceIdList);
        }
        if (!hasGroup) {
            logger.warn("\u9500\u65b9\u96c6\u56e2id\u5fc5\u586b");
            return response.fail("\u8bf7\u9009\u62e9\u9500\u65b9\u96c6\u56e2");
        }
        int pageNo = request.getPageNo() == null ? 1 : request.getPageNo();
        int pageSize = request.getPageSize() == null ? 20 : request.getPageSize();
        int total = this.makeOutExtDao.queryMakeOutFailCount((Map)map);
        map.put("start", (pageNo - 1) * pageSize);
        map.put("pageSize", pageSize);
        if (total == 0) {
            return response.ok((List)Lists.newArrayList(), total, "\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        List entityList = this.makeOutExtDao.queryMakeOutFailList((Map)map);
        HashMap idMap = Maps.newHashMap();
        ArrayList idList = Lists.newArrayList();
        ArrayList preInvoiceIds = Lists.newArrayList();
        entityList.forEach(entity -> {
            idMap.put(entity.getPreInvoiceId(), entity);
            idList.add(entity.getPreInvoiceId());
            preInvoiceIds.add(entity.getPreInvoiceId());
        });
        ArrayList list = Lists.newArrayList();
        Map salesBillNoMap = this.querySalesBillNoByPreInvoiceId((List)preInvoiceIds);
        this.queryPreInvoiceByIdList((List)idList).forEach(preInvoice -> {
            MakeOutFailInfo makeOutFailInfo = new MakeOutFailInfo();
            InvSellerMakeOutRequestEntity requestEntity = (InvSellerMakeOutRequestEntity)idMap.get(preInvoice.getId());
            BeanUtils.copyProperties((Object)requestEntity, (Object)makeOutFailInfo);
            BeanUtils.copyProperties((Object)preInvoice, (Object)makeOutFailInfo);
            if (salesBillNoMap.containsKey(preInvoice.getId())) {
                makeOutFailInfo.setSalesbillNo((String)salesBillNoMap.get(preInvoice.getId()));
            }
            makeOutFailInfo.setId(requestEntity.getId());
            makeOutFailInfo.setUpdateTime(DateUtil.formatDateToString((Date)requestEntity.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            list.add(makeOutFailInfo);
        });
        return response.ok((List)list, total, "\u67e5\u8be2\u6210\u529f");
    }

    private Map<Long, String> querySalesBillNoByPreInvoiceId(List<Long> preInvoiceIdList) {
        InvSellerPreBillDetailExample example = new InvSellerPreBillDetailExample();
        example.createCriteria().andPreInvoiceIdIn(preInvoiceIdList);
        List entityList = this.preBillDetailDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Maps.newHashMap();
        }
        Map<Long, List<InvSellerPreBillDetailEntity>> tmpMap = entityList.stream().collect(Collectors.groupingBy(InvSellerPreBillDetailEntity::getPreInvoiceId));
        HashMap resultMap = Maps.newHashMap();
        tmpMap.forEach((preInvoiceId, list) -> {
            List salesBillNoList = list.stream().map(InvSellerPreBillDetailEntity::getSalesbillNo).distinct().collect(Collectors.toList());
            resultMap.put(preInvoiceId, String.join((CharSequence)",", salesBillNoList));
        });
        return resultMap;
    }

    private List<InvSellerPreInvoiceEntity> queryPreInvoiceByIdList(List<Long> preInvoiceIdList) {
        if (CollectionUtils.isEmpty(preInvoiceIdList)) {
            return Lists.newArrayList();
        }
        InvSellerPreInvoiceExample example = new InvSellerPreInvoiceExample();
        example.createCriteria().andIdIn(preInvoiceIdList);
        return this.preInvoiceDao.selectByExample(example);
    }

    private List<Long> queryPreInvoiceIdBySalesBillNo(String salesBillNo) {
        if (StringUtils.isBlank((CharSequence)salesBillNo)) {
            return Lists.newArrayList();
        }
        InvSellerPreBillDetailExample example = new InvSellerPreBillDetailExample();
        example.createCriteria().andSalesbillNoEqualTo(salesBillNo);
        List entityList = this.preBillDetailDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Lists.newArrayList();
        }
        return entityList.stream().map(InvSellerPreBillDetailEntity::getPreInvoiceId).collect(Collectors.toList());
    }
}

