/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.seller.invoice.service.pre.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.seller.invoice.client.model.MsPollingSplitAndMakeOutRequest;
import com.xforceplus.seller.invoice.client.model.MsPollingSplitAndMakeOutResponse;
import com.xforceplus.seller.invoice.client.model.MsPollingSplitAndMakeOutResult;
import com.xforceplus.seller.invoice.client.model.PreInvoiceDetail;
import com.xforceplus.seller.invoice.client.model.PreInvoiceInfoPolling;
import com.xforceplus.seller.invoice.client.model.PreInvoicePolling;
import com.xforceplus.seller.invoice.constants.enums.InvoiceHCFlag;
import com.xforceplus.seller.invoice.constants.enums.PreInvoiceStatus;
import com.xforceplus.seller.invoice.constants.enums.SplitResult;
import com.xforceplus.seller.invoice.repository.dao.InvSellerPreInvoiceDao;
import com.xforceplus.seller.invoice.repository.dao.InvSellerPreInvoiceItemDao;
import com.xforceplus.seller.invoice.repository.dao.InvSellerSplitRequestLogDao;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceExample;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceItemEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerPreInvoiceItemExample;
import com.xforceplus.seller.invoice.repository.model.InvSellerSplitRequestLogEntity;
import com.xforceplus.seller.invoice.repository.model.InvSellerSplitRequestLogExample;
import com.xforceplus.seller.invoice.service.SellerPreInvoiceConvertService;
import com.xforceplus.seller.invoice.service.pre.PreInvoiceService;
import com.xforceplus.xplatdata.base.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PreInvoiceServiceImpl
implements PreInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(PreInvoiceServiceImpl.class);
    @Autowired
    private InvSellerSplitRequestLogDao splitRequestLogDao;
    @Autowired
    private InvSellerPreInvoiceDao preInvoiceDao;
    @Autowired
    private InvSellerPreInvoiceItemDao preInvoiceItemDao;
    @Autowired
    private SellerPreInvoiceConvertService sellerPreInvoiceConvertService;

    public MsPollingSplitAndMakeOutResponse querySplitResult(MsPollingSplitAndMakeOutRequest request) {
        logger.info("taskId:{}\u67e5\u8be2\u62c6\u7968\u7ed3\u679c", (Object)request.getTaskId());
        MsPollingSplitAndMakeOutResponse response = new MsPollingSplitAndMakeOutResponse();
        MsPollingSplitAndMakeOutResult result = new MsPollingSplitAndMakeOutResult();
        InvSellerSplitRequestLogExample example = new InvSellerSplitRequestLogExample();
        example.createCriteria().andTaskIdEqualTo(Long.valueOf(request.getTaskId()));
        List requestList = this.splitRequestLogDao.selectByExample(example);
        if (CollectionUtils.isEmpty((Collection)requestList)) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u62c6\u7968\u8bb0\u5f55!");
        }
        for (InvSellerSplitRequestLogEntity entity2 : requestList) {
            if (entity2.getResult().intValue() != SplitResult.PROCESSING.value()) continue;
            result.setIsDone(0);
            response.setResult(result);
            return response;
        }
        ArrayList preInvoiceList = new ArrayList();
        ArrayList batchNos = new ArrayList(requestList.size());
        ArrayList empList = Lists.newArrayList();
        ArrayList failBatchNoList = Lists.newArrayList();
        requestList.forEach(entity -> {
            if (SplitResult.FAIL.value() == entity.getResult().intValue()) {
                failBatchNoList.add(entity.getBatchNo());
            } else {
                List pollingList = this.queryPreInvoicesByBatchNo(entity.getBatchNo());
                if (pollingList.isEmpty()) {
                    empList.add(1);
                }
                pollingList.forEach(polling -> {
                    if (StringUtils.isBlank((CharSequence)polling.getPreInvoiceInfo().getInvoicerName())) {
                        polling.getPreInvoiceInfo().setInvoicerName(request.getBackupDrawer());
                    }
                    preInvoiceList.add(polling);
                });
            }
            batchNos.add(entity.getBatchNo().toString());
        });
        if (!CollectionUtils.isEmpty((Collection)empList)) {
            result.setIsDone(0);
            response.setResult(result);
            preInvoiceList.clear();
            requestList.clear();
            return response;
        }
        if (CollectionUtils.isEmpty(preInvoiceList)) {
            result.setIsDone(1);
            result.setFailBatchNoList((List)failBatchNoList);
            response.setResult(result);
            requestList.clear();
            return response;
        }
        try {
            PreInvoicePolling firstPreInvoice = ((PreInvoiceInfoPolling)preInvoiceList.get(0)).getPreInvoiceInfo();
            result.setIsDone(1);
            result.setBatchNo(firstPreInvoice.getBatchNo());
            result.setBatchNos(batchNos);
            result.setPreInvoiceType(firstPreInvoice.getInvoiceType());
            result.setPreInvoiceList(preInvoiceList);
            response.setResult(result);
            logger.info("taskId polling result taskId\u4e3a{} \u7ed3\u679c\u4e3a\u6570\u91cf:{}", (Object)request.getTaskId(), (Object)preInvoiceList.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setIsDone(0);
            response.setResult(result);
            response.setMessage("\u6570\u636e\u7ec4\u88c5\u5f02\u5e38.");
        }
        return response;
    }

    private List<PreInvoiceInfoPolling> queryPreInvoicesByBatchNo(Long batchNo) {
        InvSellerPreInvoiceExample example = new InvSellerPreInvoiceExample();
        example.createCriteria().andBatchNoEqualTo(batchNo).andStatusEqualTo(Integer.valueOf(PreInvoiceStatus.PENDING_INVOICE.value()));
        example.setOrderByClause("id desc");
        List<Object> preInvoiceList = Lists.newArrayList();
        List preInvoiceEntityList = this.preInvoiceDao.selectByExample(example);
        if (CollectionUtils.isNotEmpty((Collection)preInvoiceEntityList)) {
            List preInvoiceIds = preInvoiceEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            InvSellerPreInvoiceItemExample preItemExample = new InvSellerPreInvoiceItemExample();
            preItemExample.createCriteria().andPreInvoiceIdIn(preInvoiceIds);
            List itemList = this.preInvoiceItemDao.selectByExample(preItemExample);
            List detailList = this.generatePreInvoiceDetail(itemList);
            Map<Long, List<PreInvoiceDetail>> map = detailList.stream().collect(Collectors.groupingBy(PreInvoiceDetail::getPreInvoiceId));
            preInvoiceList = preInvoiceEntityList.stream().map(e -> this.generatePreInvoice(e, map)).collect(Collectors.toList());
        }
        return preInvoiceList;
    }

    private List<PreInvoiceDetail> generatePreInvoiceDetail(List<InvSellerPreInvoiceItemEntity> itemList) {
        ArrayList detailList = Lists.newArrayList();
        itemList.forEach(e -> {
            PreInvoiceDetail detail = (PreInvoiceDetail)JSON.parseObject((String)JSON.toJSONString((Object)e), PreInvoiceDetail.class);
            detailList.add(detail);
            if (null != detail.getDiscountWithoutTax() && detail.getDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0) {
                PreInvoiceDetail discountDetail = new PreInvoiceDetail();
                discountDetail.setPreInvoiceId(detail.getPreInvoiceId());
                discountDetail.setAmountWithoutTax(detail.getDiscountWithoutTax().multiply(new BigDecimal(-1)));
                discountDetail.setTaxRate(detail.getTaxRate());
                discountDetail.setTaxAmount(detail.getDiscountTax().multiply(new BigDecimal(-1)));
                discountDetail.setDeduction(BigDecimal.ZERO);
                detailList.add(discountDetail);
            }
        });
        return detailList;
    }

    private PreInvoiceInfoPolling generatePreInvoice(InvSellerPreInvoiceEntity preEntity, Map<Long, List<PreInvoiceDetail>> map) {
        PreInvoiceInfoPolling preInvoice = new PreInvoiceInfoPolling();
        PreInvoicePolling preInvoicePolling = (PreInvoicePolling)JSON.parseObject((String)JSON.toJSONString((Object)preEntity), PreInvoicePolling.class);
        preInvoice.setPreInvoiceInfo(preInvoicePolling);
        List<PreInvoiceDetail> details = map.get(preInvoicePolling.getId());
        preInvoice.setPreInvoiceDetails(details);
        BigDecimal totalDeduction = details.stream().map(PreInvoiceDetail::getDeduction).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (null != totalDeduction && totalDeduction.compareTo(BigDecimal.ZERO) > 0) {
            preInvoicePolling.setRemark("\u5dee\u989d\u5f81\u7a0e\uff1a" + totalDeduction + " " + preInvoicePolling.getRemark());
        }
        preInvoicePolling.setSaleListFileFlag(preEntity.getSaleListFileFlag());
        preInvoicePolling.setSpecialInvoiceFlag(String.valueOf(preEntity.getSpecialInvoiceFlag()));
        this.sellerPreInvoiceConvertService.setTaxRateAndTaxAmountStr((Object)preInvoicePolling, details);
        return preInvoice;
    }

    public long queryPreInvoiceCount(Long batchNo) {
        InvSellerPreInvoiceExample example = new InvSellerPreInvoiceExample();
        example.createCriteria().andBatchNoEqualTo(batchNo).andStatusNotEqualTo(Integer.valueOf(PreInvoiceStatus.DELETE.value()));
        return this.preInvoiceDao.countByExample(example);
    }

    public int updatePreInvoice(Long batchNo) {
        InvSellerPreInvoiceExample invSellerPreInvoiceExample = new InvSellerPreInvoiceExample();
        invSellerPreInvoiceExample.createCriteria().andBatchNoEqualTo(batchNo).andStatusEqualTo(Integer.valueOf(PreInvoiceStatus.PENDING_INVOICE.value()));
        InvSellerPreInvoiceEntity invSellerPreInvoiceEntity = new InvSellerPreInvoiceEntity();
        invSellerPreInvoiceEntity.setStatus(Integer.valueOf(PreInvoiceStatus.DELETE.value()));
        int pendingCount = 0;
        pendingCount = this.preInvoiceDao.updateByExampleSelective(invSellerPreInvoiceEntity, invSellerPreInvoiceExample);
        ArrayList statusList = Lists.newArrayList();
        statusList.add(InvoiceHCFlag.ALREADY_ALL_HC.value());
        statusList.add(InvoiceHCFlag.HC_INVOICE.value());
        InvSellerPreInvoiceExample invSellerPreInvoiceExample2 = new InvSellerPreInvoiceExample();
        invSellerPreInvoiceExample2.createCriteria().andBatchNoEqualTo(batchNo).andStatusEqualTo(Integer.valueOf(PreInvoiceStatus.INVOICED.value())).andRedFlagIn((List)statusList);
        InvSellerPreInvoiceEntity invSellerPreInvoiceEntity2 = new InvSellerPreInvoiceEntity();
        invSellerPreInvoiceEntity2.setStatus(Integer.valueOf(PreInvoiceStatus.DELETE.value()));
        int hcCount = 0;
        hcCount = this.preInvoiceDao.updateByExampleSelective(invSellerPreInvoiceEntity2, invSellerPreInvoiceExample2);
        return pendingCount + hcCount;
    }

    public long delPreInvoice(Long batchNo) {
        long count = this.queryPreInvoiceCount(batchNo);
        if ((long)this.updatePreInvoice(batchNo) != count) {
            throw new RuntimeException("\u6279\u6b21\u53f7" + batchNo + "\u6b63\u5728\u6267\u884c\u5176\u5b83\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5.");
        }
        return count;
    }
}

